/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class TocData
extends RequestData {
    private String tocHref;
    private String topicHref;
    private String topicHelpHref;
    private int selectedToc;
    private IToc[] tocs;
    private String imagesDirectory;

    public TocData(ServletContext context, HttpServletRequest request) {
        super(context, request);
        this.tocHref = request.getParameter("toc");
        this.topicHref = request.getParameter("topic");
        if (this.tocHref != null && this.tocHref.length() == 0) {
            this.tocHref = null;
        }
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        this.imagesDirectory = this.preferences.getImagesDirectory();
        this.loadTocs();
    }

    public int getTocCount() {
        return this.tocs.length;
    }

    public String getTocLabel(int i) {
        return this.tocs[i].getLabel();
    }

    public String getTocHref(int i) {
        return this.tocs[i].getHref();
    }

    public String getTocDescriptionTopic(int i) {
        return UrlUtil.getHelpURL(this.tocs[i].getTopic(null).getHref());
    }

    public int getSelectedToc() {
        return this.selectedToc;
    }

    public String getSelectedTopic() {
        if (this.topicHref != null && this.topicHref.length() > 0) {
            return UrlUtil.getHelpURL(this.topicHref);
        }
        if (this.selectedToc == -1) {
            return null;
        }
        IToc toc = this.tocs[this.selectedToc];
        ITopic tocDescription = toc.getTopic(null);
        if (tocDescription != null) {
            return UrlUtil.getHelpURL(tocDescription.getHref());
        }
        return UrlUtil.getHelpURL(null);
    }

    public IToc[] getTocs() {
        return this.tocs;
    }

    private void loadTocs() {
        this.tocs = HelpSystem.getTocManager().getTocs(this.getLocale());
        this.selectedToc = -1;
        if (this.tocHref != null && this.tocHref.length() > 0) {
            this.tocs = this.getTocs();
            int i = 0;
            while (this.selectedToc == -1 && i < this.tocs.length) {
                if (this.tocHref.equals(this.tocs[i].getHref())) {
                    this.selectedToc = i;
                }
                ++i;
            }
        } else {
            this.selectedToc = this.findTocContainingTopic(this.topicHref);
        }
    }

    private int findTocContainingTopic(String topic) {
        if (topic == null || topic.equals("")) {
            return -1;
        }
        int index = topic.indexOf("/topic/");
        if (index != -1) {
            topic = topic.substring(index + 6);
        }
        if ((index = topic.indexOf(63)) != -1) {
            topic = topic.substring(0, index);
        }
        if (topic == null || topic.equals("")) {
            return -1;
        }
        this.tocs = this.getTocs();
        int i = 0;
        while (i < this.tocs.length) {
            if (this.tocs[i].getTopic(topic) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void generateToc(int toc, Writer out) throws IOException {
        ITopic[] topics = this.tocs[toc].getTopics();
        int i = 0;
        while (i < topics.length) {
            this.generateTopic(topics[i], out);
            ++i;
        }
    }

    private void generateTopic(ITopic topic, Writer out) throws IOException {
        boolean hasNodes;
        out.write("<li>");
        boolean bl = hasNodes = topic.getSubtopics().length > 0;
        if (hasNodes) {
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/plus.gif' class='collapsed' >");
            out.write("<a href='" + UrlUtil.getHelpURL(topic.getHref()) + "'>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/container_obj.gif'>");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("<ul class='collapsed'>");
            ITopic[] topics = topic.getSubtopics();
            int i = 0;
            while (i < topics.length) {
                this.generateTopic(topics[i], out);
                ++i;
            }
            out.write("</ul>");
        } else {
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/plus.gif' class='h'>");
            out.write("<a href='" + UrlUtil.getHelpURL(topic.getHref()) + "'>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/topic.gif'>");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
        }
        out.write("</li>");
    }

    public void generateBasicToc(int toc, Writer out) throws IOException {
        ITopic[] topics = this.tocs[toc].getTopics();
        int i = 0;
        while (i < topics.length) {
            this.generateBasicTopic(topics[i], out);
            ++i;
        }
    }

    private void generateBasicTopic(ITopic topic, Writer out) throws IOException {
        boolean hasNodes;
        out.write("<li>");
        boolean bl = hasNodes = topic.getSubtopics().length > 0;
        if (hasNodes) {
            out.write("<nobr>");
            out.write("<a ");
            if (this.getSelectedTopicHelpHref().equals(topic.getHref())) {
                out.write("name=\"selectedItem\" ");
            }
            out.write("href='" + UrlUtil.getHelpURL(topic.getHref()) + "'>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/container_obj.gif' border=0>&nbsp;");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("</nobr>");
            out.write("<ul>");
            ITopic[] topics = topic.getSubtopics();
            int i = 0;
            while (i < topics.length) {
                this.generateBasicTopic(topics[i], out);
                ++i;
            }
            out.write("</ul>");
        } else {
            out.write("<nobr>");
            out.write("<a ");
            if (this.getSelectedTopicHelpHref().equals(topic.getHref())) {
                out.write("name=\"selectedItem\" ");
            }
            out.write("href='" + UrlUtil.getHelpURL(topic.getHref()) + "'>");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/topic.gif' border=0>&nbsp;");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("</nobr>");
        }
        out.write("</li>");
    }

    private String getSelectedTopicHelpHref() {
        if (this.topicHelpHref == null) {
            String topic = this.getSelectedTopic();
            if (topic == null || topic.length() == 0) {
                this.topicHelpHref = "";
                return this.topicHelpHref;
            }
            int index = topic.indexOf("/topic/");
            if (index != -1) {
                topic = topic.substring(index + 6);
            }
            if ((index = topic.indexOf(63)) != -1) {
                topic = topic.substring(0, index);
            }
            this.topicHelpHref = topic;
            if (topic == null) {
                this.topicHelpHref = "";
            }
        }
        return this.topicHelpHref;
    }
}

