/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.util.TString;

public class UrlUtil {
    private static final String[] invalidXML = new String[]{"&", ">", "<", "\""};
    private static final String[] escapedXML = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
    private static String defaultLocale;
    private static Collection locales;

    public static String unescape(String encodedURL) {
        if (encodedURL == null) {
            return null;
        }
        int len = encodedURL.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            switch (encodedURL.charAt(i)) {
                case '%': {
                    ByteArrayOutputStream tempOs;
                    if (len > i + 1 && encodedURL.charAt(i + 1) != 'u') {
                        if (len >= i + 3) {
                            tempOs = new ByteArrayOutputStream(1);
                            tempOs.write(Integer.parseInt(encodedURL.substring(i + 1, i + 3), 16));
                            try {
                                buf.append(new String(tempOs.toByteArray(), "ISO8859_1"));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                return null;
                            }
                        }
                        i += 3;
                        break;
                    }
                    if (len >= i + 6) {
                        tempOs = new ByteArrayOutputStream(2);
                        tempOs.write(Integer.parseInt(encodedURL.substring(i + 2, i + 4), 16));
                        tempOs.write(Integer.parseInt(encodedURL.substring(i + 4, i + 6), 16));
                        try {
                            buf.append(new String(tempOs.toByteArray(), "UnicodeBigUnmarked"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            return null;
                        }
                    }
                    i += 6;
                    break;
                }
                case '+': {
                    buf.append(' ');
                    ++i;
                    break;
                }
                default: {
                    ByteArrayOutputStream tempOs = new ByteArrayOutputStream(1);
                    tempOs.write(encodedURL.charAt(i++));
                    try {
                        buf.append(new String(tempOs.toByteArray(), "UTF8"));
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return null;
                    }
                }
            }
        }
        return buf.toString();
    }

    public static String getRawRequestParameter(HttpServletRequest request, String parameterName) {
        String[] values = UrlUtil.getRawRequestParameters(request, parameterName);
        if (values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static String[] getRawRequestParameters(HttpServletRequest request, String parameterName) {
        String query = request.getQueryString();
        if (query == null || "".equals(query)) {
            return new String[0];
        }
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer stok = new StringTokenizer(query, "&");
        while (stok.hasMoreTokens()) {
            String nameEqValue = stok.nextToken();
            int equalsPosition = nameEqValue.indexOf("=");
            if (equalsPosition < 0 || !parameterName.equals(nameEqValue.substring(0, equalsPosition))) continue;
            String val = nameEqValue.substring(equalsPosition + 1);
            values.add(val);
        }
        return values.toArray(new String[values.size()]);
    }

    public static String JavaScriptEncode(String str) {
        char[] wordChars = new char[str.length()];
        str.getChars(0, str.length(), wordChars, 0);
        StringBuffer jsEncoded = new StringBuffer();
        int j = 0;
        while (j < wordChars.length) {
            char unicode = wordChars[j];
            if ('A' <= unicode && unicode <= 'Z' || 'a' <= unicode && unicode <= 'z') {
                jsEncoded.append(wordChars[j]);
            } else {
                String charInHex = Integer.toString(unicode, 16).toUpperCase();
                switch (charInHex.length()) {
                    case 1: {
                        jsEncoded.append("\\u000").append(charInHex);
                        break;
                    }
                    case 2: {
                        jsEncoded.append("\\u00").append(charInHex);
                        break;
                    }
                    case 3: {
                        jsEncoded.append("\\u0").append(charInHex);
                        break;
                    }
                    default: {
                        jsEncoded.append("\\u").append(charInHex);
                    }
                }
            }
            ++j;
        }
        return jsEncoded.toString();
    }

    public static String htmlEncode(String str) {
        int i = 0;
        while (i < invalidXML.length) {
            str = TString.change((String)str, (String)invalidXML[i], (String)escapedXML[i]);
            ++i;
        }
        return str;
    }

    public static boolean isLocalRequest(HttpServletRequest request) {
        String reqIP = request.getRemoteAddr();
        if ("127.0.0.1".equals(reqIP)) {
            return true;
        }
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            InetAddress[] addr = InetAddress.getAllByName(hostname);
            int i = 0;
            while (i < addr.length) {
                if (addr[i].getHostAddress().equals(reqIP)) {
                    return true;
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public static String getHelpURL(String url) {
        if (url == null || url.length() == 0) {
            url = "about:blank";
        } else if (!url.startsWith("http:/")) {
            url = url.startsWith("file:/") ? "../topic/" + url : "../topic" + url;
        }
        return url;
    }

    public static boolean isGecko(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent").toLowerCase();
        return agent.indexOf("gecko") >= 0;
    }

    public static boolean isIE(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent").toLowerCase();
        return agent.indexOf("msie") >= 0;
    }

    public static boolean isKonqueror(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent").toLowerCase();
        return agent.indexOf("konqueror") >= 0;
    }

    public static boolean isMozilla(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent").toLowerCase();
        return agent.indexOf("mozilla/5") >= 0;
    }

    public static String getMozillaVersion(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent").toLowerCase();
        if (agent.indexOf("mozilla/5") < 0) {
            return "0";
        }
        int start = agent.indexOf("rv:") + "rv:".length();
        if (start < "rv:".length() || start >= agent.length()) {
            return "0";
        }
        int end = agent.indexOf(")", start);
        if (end <= start) {
            return "0";
        }
        return agent.substring(start, end);
    }

    public static boolean isOpera(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent").toLowerCase();
        return agent.indexOf("opera") >= 0;
    }

    public static Locale getLocaleObj(HttpServletRequest request) {
        String localeStr = UrlUtil.getLocale(request);
        if (localeStr.length() >= 5) {
            return new Locale(localeStr.substring(0, 2), localeStr.substring(3, 5));
        }
        if (localeStr.length() >= 2) {
            return new Locale(localeStr.substring(0, 2), "");
        }
        return Locale.getDefault();
    }

    public static String getLocale(HttpServletRequest request) {
        if (defaultLocale == null) {
            UrlUtil.initializeLocales();
        }
        if (HelpSystem.getMode() != 1 || request == null) {
            return defaultLocale;
        }
        if (locales == null) {
            return request.getLocale().toString();
        }
        Enumeration e = request.getLocales();
        while (e.hasMoreElements()) {
            String ll;
            String ll_CC;
            String locale = ((Locale)e.nextElement()).toString();
            if (locale.length() >= 5 && locales.contains(ll_CC = locale.substring(0, 5))) {
                return ll_CC;
            }
            if (locale.length() < 2 || !locales.contains(ll = locale.substring(0, 2))) continue;
            return ll;
        }
        return defaultLocale;
    }

    private static synchronized void initializeLocales() {
        if (defaultLocale != null) {
            return;
        }
        defaultLocale = BootLoader.getNL();
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault().toString();
        }
        if (HelpSystem.getMode() != 1) {
            return;
        }
        ArrayList<String> infocenterLocales = null;
        String[] args = BootLoader.getCommandLineArgs();
        boolean localeOption = false;
        int i = 0;
        while (i < args.length) {
            if ("-locales".equalsIgnoreCase(args[i])) {
                localeOption = true;
                infocenterLocales = new ArrayList<String>();
            } else if (args[i].startsWith("-")) {
                localeOption = false;
            } else if (localeOption) {
                infocenterLocales.add(args[i]);
            }
            ++i;
        }
        if (infocenterLocales == null) {
            StringTokenizer tokenizer = new StringTokenizer(HelpPlugin.getDefault().getPluginPreferences().getString("locales"), " ,\t");
            while (tokenizer.hasMoreTokens()) {
                if (infocenterLocales == null) {
                    infocenterLocales = new ArrayList();
                }
                infocenterLocales.add(tokenizer.nextToken());
            }
        }
        if (infocenterLocales != null) {
            locales = new HashSet(10, 0.4f);
            Iterator it = infocenterLocales.iterator();
            while (it.hasNext()) {
                String locale = (String)it.next();
                if (locale.length() >= 5) {
                    locales.add(String.valueOf(locale.substring(0, 2).toLowerCase()) + "_" + locale.substring(3, 5).toUpperCase());
                    continue;
                }
                if (locale.length() < 2) continue;
                locales.add(locale.substring(0, 2).toLowerCase());
            }
        }
    }
}

