/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class WebappPreferences {
    Preferences prefs = HelpPlugin.getDefault().getPluginPreferences();

    public String getBanner() {
        return this.prefs.getString("banner");
    }

    public String getBannerHeight() {
        return this.prefs.getString("banner_height");
    }

    public String getHelpHome() {
        return this.prefs.getString("help_home");
    }

    public boolean isBookmarksView() {
        return HelpSystem.getMode() != 1 && "true".equals(this.prefs.getString("bookmarksView"));
    }

    public boolean isLinksView() {
        return HelpSystem.getMode() != 1 && "true".equals(this.prefs.getString("linksView"));
    }

    public String getImagesDirectory() {
        String imagesDirectory = this.prefs.getString("imagesDirectory");
        if (imagesDirectory != null && imagesDirectory.startsWith("/")) {
            imagesDirectory = UrlUtil.getHelpURL(imagesDirectory);
        }
        return imagesDirectory;
    }

    public String getToolbarBackground() {
        return this.prefs.getString("advanced.toolbarBackground");
    }

    public String getBasicToolbarBackground() {
        return this.prefs.getString("basic.toolbarBackground");
    }

    public String getToolbarFont() {
        return this.prefs.getString("advanced.toolbarFont");
    }

    public String getViewBackground() {
        return this.prefs.getString("advanced.viewBackground");
    }

    public String getBasicViewBackground() {
        return this.prefs.getString("basic.viewBackground");
    }

    public String getViewFont() {
        return this.prefs.getString("advanced.viewFont");
    }
}

