/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetManager;

public class WorkingSetManagerData
extends RequestData {
    private static final int NONE = 0;
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final int EDIT = 3;
    private static boolean workingSetsSynchronized = false;
    private String name;
    private WorkingSetManager wsmgr = HelpSystem.getWorkingSetManager((String)this.getLocale());

    public WorkingSetManagerData(ServletContext context, HttpServletRequest request) {
        super(context, request);
        this.name = this.getDBCSParameter("workingSet");
        if (!workingSetsSynchronized && this.getMode() == 0) {
            workingSetsSynchronized = true;
            this.wsmgr.synchronizeWorkingSets();
        }
        switch (this.getOperation()) {
            case 1: {
                this.addWorkingSet();
                break;
            }
            case 2: {
                this.removeWorkingSet();
                break;
            }
            case 3: {
                this.editWorkingSet();
                break;
            }
        }
    }

    public void addWorkingSet() {
        if (HelpSystem.getMode() == 1) {
            return;
        }
        if (this.name != null && this.name.length() > 0) {
            String[] hrefs = this.request.getParameterValues("hrefs");
            if (hrefs == null) {
                hrefs = new String[]{};
            }
            ArrayList<AdaptableHelpResource> selectedElements = new ArrayList<AdaptableHelpResource>(hrefs.length);
            int i = 0;
            while (i < hrefs.length) {
                AdaptableHelpResource res = this.getAdaptableHelpResource(hrefs[i]);
                if (res != null) {
                    selectedElements.add(res);
                }
                ++i;
            }
            AdaptableHelpResource[] elements = new AdaptableHelpResource[selectedElements.size()];
            selectedElements.toArray(elements);
            WorkingSet ws = this.wsmgr.createWorkingSet(this.name, elements);
            this.wsmgr.addWorkingSet(ws);
        }
    }

    public void removeWorkingSet() {
        WorkingSet ws;
        if (HelpSystem.getMode() == 1) {
            return;
        }
        if (this.name != null && this.name.length() > 0 && (ws = this.wsmgr.getWorkingSet(this.name)) != null) {
            this.wsmgr.removeWorkingSet(ws);
        }
    }

    public void editWorkingSet() {
        if (HelpSystem.getMode() == 1) {
            return;
        }
        if (this.name != null && this.name.length() > 0) {
            WorkingSet ws;
            String oldName = this.getDBCSParameter("oldName");
            if (oldName == null || oldName.length() == 0) {
                oldName = this.name;
            }
            if ((ws = this.wsmgr.getWorkingSet(oldName)) != null) {
                String[] hrefs = this.request.getParameterValues("hrefs");
                if (hrefs == null) {
                    hrefs = new String[]{};
                }
                ArrayList<AdaptableHelpResource> selectedElements = new ArrayList<AdaptableHelpResource>(hrefs.length);
                int i = 0;
                while (i < hrefs.length) {
                    AdaptableHelpResource res = this.getAdaptableHelpResource(hrefs[i]);
                    if (res != null) {
                        selectedElements.add(res);
                    }
                    ++i;
                }
                AdaptableHelpResource[] elements = new AdaptableHelpResource[selectedElements.size()];
                selectedElements.toArray(elements);
                ws.setElements(elements);
                ws.setName(this.name);
                this.wsmgr.workingSetChanged(ws);
            }
        }
    }

    public String[] getWorkingSets() {
        if (HelpSystem.getMode() == 1) {
            return new String[0];
        }
        WorkingSet[] workingSets = this.wsmgr.getWorkingSets();
        String[] sets = new String[workingSets.length];
        int i = 0;
        while (i < workingSets.length) {
            sets[i] = workingSets[i].getName();
            ++i;
        }
        return sets;
    }

    public String getWorkingSetName() {
        if (this.name == null || this.name.length() == 0) {
            this.name = HelpPlugin.getDefault().getPluginPreferences().getString("workingSet");
            if (this.name == null || this.name.length() == 0 || this.wsmgr.getWorkingSet(this.name) == null) {
                this.name = ServletResources.getString("All", this.request);
            }
        }
        return this.name;
    }

    public WorkingSet getWorkingSet() {
        if (this.name != null && this.name.length() > 0) {
            return this.wsmgr.getWorkingSet(this.name);
        }
        return null;
    }

    public boolean isCurrentWorkingSet(int i) {
        WorkingSet[] workingSets = this.wsmgr.getWorkingSets();
        return workingSets[i].getName().equals(this.name);
    }

    private int getOperation() {
        String op = this.request.getParameter("operation");
        if ("add".equals(op)) {
            return 1;
        }
        if ("remove".equals(op)) {
            return 2;
        }
        if ("edit".equals(op)) {
            return 3;
        }
        return 0;
    }

    private AdaptableHelpResource getAdaptableHelpResource(String internalId) {
        AdaptableToc res = this.wsmgr.getAdaptableToc(internalId);
        if (res == null) {
            res = this.wsmgr.getAdaptableTopic(internalId);
        }
        return res;
    }
}

