/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FramesetFilter;
import org.eclipse.help.internal.webapp.servlet.HighlightFilter;
import org.eclipse.help.internal.webapp.servlet.IFilter;

public class EclipseConnector {
    private ServletContext context;
    private static final String errorPageBegin = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html><head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n</head>\n<body><p>\n";
    private static final String errorPageEnd = "</p></body></html>";
    private static final IFilter[] filters = new IFilter[]{new FramesetFilter(), new HighlightFilter()};

    public EclipseConnector(ServletContext context) {
        this.context = context;
    }

    public InputStream openStream(String url, HttpServletRequest request) {
        try {
            URLConnection con = this.openConnection(url, request);
            return con.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void transfer(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            InputStream is;
            String url = this.getURL(req);
            if (url == null) {
                return;
            }
            if (url.toLowerCase().startsWith("file:/")) {
                int i = url.indexOf(63);
                if (i != -1) {
                    url = url.substring(0, i);
                }
                if (HelpSystem.getMode() == 1 || !UrlUtil.isLocalRequest(req)) {
                    return;
                }
            } else {
                url = "help:" + url;
            }
            URLConnection con = this.openConnection(url, req);
            resp.setContentType(con.getContentType());
            resp.setHeader("Cache-Control", "max-age=" + (con.getExpiration() - System.currentTimeMillis()));
            try {
                is = con.getInputStream();
            }
            catch (IOException iOException) {
                if (url.toLowerCase().endsWith("htm") || url.toLowerCase().endsWith("html")) {
                    String error = errorPageBegin + ServletResources.getString("noTopic", req) + errorPageEnd;
                    is = new ByteArrayInputStream(error.getBytes("UTF8"));
                }
                return;
            }
            Object out = resp.getOutputStream();
            int i = 0;
            while (i < filters.length) {
                out = filters[i].filter(req, (OutputStream)out);
                ++i;
            }
            this.transferContent(is, (OutputStream)out);
            out.flush();
            is.close();
        }
        catch (Exception exception) {}
    }

    private void transferContent(InputStream inputStream, OutputStream out) throws IOException {
        try {
            BufferedInputStream dataStream = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = dataStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception exception) {}
    }

    private URLConnection openConnection(String url, HttpServletRequest request) throws Exception {
        URL helpURL;
        String protocol;
        URLConnection con = null;
        if (HelpSystem.getMode() == 1) {
            String locale = UrlUtil.getLocale(request);
            url = url.indexOf(63) >= 0 ? String.valueOf(url) + "&lang=" + locale : String.valueOf(url) + "?lang=" + locale;
        }
        if (!"help".equals(protocol = (helpURL = new URL(url)).getProtocol()) && !"file".equals(protocol)) {
            throw new IOException();
        }
        con = helpURL.openConnection();
        con.setAllowUserInteraction(false);
        con.setDoInput(true);
        con.connect();
        return con;
    }

    private String getURL(HttpServletRequest req) {
        String query = "";
        boolean firstParam = true;
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            String[] values = req.getParameterValues(param);
            if (values == null) continue;
            int i = 0;
            while (i < values.length) {
                if (firstParam) {
                    query = String.valueOf(query) + "?" + param + "=" + values[i];
                    firstParam = false;
                } else {
                    query = String.valueOf(query) + "&" + param + "=" + values[i];
                }
                ++i;
            }
        }
        String url = String.valueOf(req.getPathInfo()) + query;
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        return url;
    }
}

