/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;

public class CTypeObject {
    DvAddress targetAddr;
    DvAddressSpace addrSpace;
    long value;
    boolean valueRead;
    byte[] data;
    CType type;
    public static final int spacesPerTab = 2;

    public CType getType() {
        return this.type;
    }

    public long getAddr() {
        return this.targetAddr.getAddressAsLong();
    }

    public long getValue() throws DvAddressException {
        if (this.type.getSize() > 8) {
            throw new NumberFormatException();
        }
        if (this.valueRead) {
            return this.value;
        }
        this.value = this.readValue(this.targetAddr, this.type.getSize());
        this.valueRead = true;
        return this.value;
    }

    private long readValue(DvAddress dvAddress, int n) throws DvAddressException {
        long l = n == 1 ? (long)this.addrSpace.readByte(dvAddress) : (n == 2 ? (long)this.addrSpace.readShort(dvAddress) : (n == 4 ? (long)this.addrSpace.readInt(dvAddress) : (n == 8 ? this.addrSpace.readLong(dvAddress) : 0L)));
        return l;
    }

    public CTypeObject(CType cType, DvAddress dvAddress, DvAddressSpace dvAddressSpace) {
        this.type = cType.getType();
        this.targetAddr = dvAddress;
        this.addrSpace = dvAddressSpace;
        this.valueRead = false;
    }

    public CTypeObject(String string, DvAddress dvAddress, DvAddressSpace dvAddressSpace) {
        this.type = CType.find(string).getType();
        this.targetAddr = dvAddress;
        this.addrSpace = dvAddressSpace;
        this.valueRead = false;
    }

    public CTypeObject(CType cType, long l, DvAddressSpace dvAddressSpace) {
        this.type = cType.getType();
        this.targetAddr = new DvAddress(l);
        this.addrSpace = dvAddressSpace;
        this.valueRead = false;
    }

    public CTypeObject(String string, long l, DvAddressSpace dvAddressSpace) {
        this.type = CType.find(string).getType();
        this.targetAddr = new DvAddress(l);
        this.addrSpace = dvAddressSpace;
        this.valueRead = false;
    }

    public CTypeObject(CType cType, long l) {
        this.type = cType.getType();
        if (this.type.baseType != 1) {
            throw new NumberFormatException();
        }
        this.valueRead = true;
        this.value = l;
    }

    public CTypeObject cast(CType cType) {
        this.type = cType.getType();
        return this;
    }

    public CTypeObject getField(int n) {
        try {
            if (n < this.type.numFields) {
                CType cType = this.type.getFieldType(n).getType();
                DvAddress dvAddress = new DvAddress(this.targetAddr.getAddressAsLong());
                dvAddress.offsetBy(this.type.getFieldOffset(n));
                CTypeObject cTypeObject = new CTypeObject(cType, dvAddress, this.addrSpace);
                return cTypeObject;
            }
        }
        catch (DvAddressException dvAddressException) {
            // empty catch block
        }
        return null;
    }

    private DvAddress getFieldAddr(String string) {
        try {
            DvAddress dvAddress = new DvAddress(this.targetAddr.getAddressAsLong());
            int n = this.type.getFieldOffset(string);
            if (n == -1) {
                return null;
            }
            dvAddress.offsetBy(n);
            return dvAddress;
        }
        catch (DvAddressException dvAddressException) {
            return null;
        }
    }

    public CTypeObject getField(String string) {
        CType cType = this.type.getType();
        if (cType.baseType != 2 && cType.baseType != 3) {
            return null;
        }
        int n = string.indexOf(46);
        int n2 = string.indexOf(45);
        if (n2 == 0) {
            return this.deReference().getField(string.substring(2, string.length()));
        }
        if (n == 0) {
            return this.getField(string.substring(1, string.length()));
        }
        if (n2 > 0 && (n <= 0 || n2 < n)) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 2);
            try {
                DvAddress dvAddress = this.addrSpace.readPointer(this.getFieldAddr(string2));
                CTypeObject cTypeObject = new CTypeObject(cType.getFieldType(string2), dvAddress, this.addrSpace).deReference();
                return cTypeObject.getField(string3);
            }
            catch (DvAddressException dvAddressException) {
                return null;
            }
        }
        if (n > 0) {
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1);
            DvAddress dvAddress = this.getFieldAddr(string4);
            CTypeObject cTypeObject = new CTypeObject(cType.getFieldType(string4), dvAddress, this.addrSpace);
            return cTypeObject.getField(string5);
        }
        DvAddress dvAddress = this.getFieldAddr(string);
        if (dvAddress == null) {
            return null;
        }
        return new CTypeObject(cType.getFieldType(string), dvAddress, this.addrSpace);
    }

    public CTypeObject getElement(int n) throws DvAddressException {
        DvAddress dvAddress = new DvAddress(this.targetAddr.getAddressAsLong());
        dvAddress.offsetBy(this.type.arrayInfo.type.getSize() * n);
        return new CTypeObject(this.type.arrayInfo.type, dvAddress, this.addrSpace);
    }

    public CTypeObject deReference() {
        if (this.type.derefType != null) {
            try {
                DvAddress dvAddress = this.addrSpace.readPointer(this.targetAddr);
                if (dvAddress.getAddressAsLong() == 0L) {
                    return null;
                }
                return new CTypeObject(this.type.derefType, dvAddress, this.addrSpace);
            }
            catch (DvAddressException dvAddressException) {
                return null;
            }
        }
        return null;
    }

    public CTypeObject deReference(CType cType) {
        if (this.type.derefType != null) {
            try {
                DvAddress dvAddress = this.addrSpace.readPointer(this.targetAddr);
                if (dvAddress.getAddressAsLong() == 0L) {
                    return null;
                }
                return new CTypeObject(cType, dvAddress, this.addrSpace);
            }
            catch (DvAddressException dvAddressException) {
                return null;
            }
        }
        return null;
    }

    public CTypeObject deReference(String string) {
        if (this.type.derefType != null) {
            try {
                DvAddress dvAddress = this.addrSpace.readPointer(this.targetAddr);
                if (dvAddress.getAddressAsLong() == 0L) {
                    return null;
                }
                CType cType = CType.find(string);
                if (cType == null) {
                    return null;
                }
                return new CTypeObject(cType, dvAddress, this.addrSpace);
            }
            catch (DvAddressException dvAddressException) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception exception) {
            return "Cannot print object";
        }
    }

    private String addTabs(String string, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 2; ++j) {
                string = string + " ";
            }
        }
        return string;
    }

    private String cstring(DvAddress dvAddress) throws DvAddressException {
        byte[] byArray;
        StringBuffer stringBuffer = new StringBuffer();
        DvAddress dvAddress2 = this.addrSpace.readPointer(dvAddress);
        while ((byArray = this.addrSpace.readBytes(dvAddress2, 1L)) != null && byArray[0] != 0) {
            stringBuffer.append((char)byArray[0]);
            dvAddress2.offsetBy(1L);
        }
        return new String(stringBuffer);
    }

    private String addressString(DvAddress dvAddress) {
        if (this.addrSpace.pointerSize() == 4) {
            return Integer.toHexString((int)dvAddress.getAddressAsLong());
        }
        return Long.toHexString(dvAddress.getAddressAsLong());
    }

    private String toString(int n) throws DvAddressException {
        if (this.data == null) {
            this.data = this.addrSpace.readBytes(this.targetAddr, (long)this.type.getSize());
        }
        CType cType = this.type;
        String string = "";
        cType = cType.getType();
        string = this.addTabs(string, n);
        if (n == 0) {
            string = string + cType.getName();
        }
        string = string + " @ 0x" + this.addressString(this.targetAddr) + "\n";
        ++n;
        if (cType.baseType < 0) {
            string = this.addTabs(string, n);
            this.getValue();
            string = "value = " + this.value;
            return string;
        }
        if (cType.baseType != 6 && cType.baseType != 5 && cType.baseType != 7 && (cType.baseType == 2 || cType.baseType == 3)) {
            for (int i = 0; i < cType.numFields; ++i) {
                Object object;
                long l = 0L;
                CType cType2 = cType.getFieldType(i).getType();
                DvAddress dvAddress = this.getFieldAddr(cType.getFieldName(i));
                if (cType2.baseType == 2 || cType2.baseType == 3) {
                    object = new CTypeObject(cType.getFieldType(i), dvAddress, this.addrSpace);
                    string = this.addTabs(string, n);
                    string = string + cType.getFieldName(i) + " : ";
                    string = string + super.toString(n);
                    continue;
                }
                if (cType2.baseType == 6) {
                    string = this.addTabs(string, n);
                    string = string + cType.getFieldName(i) + " @ ";
                    string = string + "0x" + this.addressString(dvAddress);
                    string = string + " (array)\n";
                    continue;
                }
                if (cType.getFieldSize(i) <= 8) {
                    object = cType.getFieldType(i).getType();
                    string = this.addTabs(string, n);
                    string = string + cType.getFieldName(i) + " = ";
                    try {
                        if (((CType)object).baseType == 5 && cType2.derefType.name != null && ((CType)object).derefType.name.equals("char")) {
                            string = string + this.cstring(dvAddress);
                        } else {
                            int n2 = cType.getFieldOffset(i);
                            l = this.readValue(dvAddress, cType.getFieldSize(i));
                            string = 8 == cType.getFieldSize(i) ? string + "0x" + Long.toHexString(l) : string + "0x" + this.addressString(new DvAddress(l));
                        }
                    }
                    catch (Exception exception) {
                        string = string + "Invalid address " + this.addressString(dvAddress);
                    }
                    string = string + "\n";
                    continue;
                }
                System.out.println("not printing " + cType.getFieldName(i) + " type " + cType2.baseType + " index " + cType.getFieldType((int)i).typeNum);
            }
        }
        return string;
    }
}

