/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvMonitorsRepository;
import com.ibm.jvm.dump.format.DvThreadDetails;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvGeneralSov;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.util.Vector;

public class DvMonitor {
    private String category;
    private long monAddr = 0L;
    private long sysMon = 0L;
    private long ownerAddr = 0L;
    private long waitQ1 = 0L;
    private long waitQ2 = 0L;
    private String ownerThreadID = null;
    private String ownerName = null;
    private Vector waiterAddr = new Vector();
    private Vector waiterThreadID = new Vector();
    private Vector waiterName = new Vector();
    private Vector enterAddr = new Vector();
    private Vector enterThreadID = new Vector();
    private Vector enterName = new Vector();
    private long objectAddr = 0L;
    private String nameTag = null;
    int ptrLength = 4;
    private DvAddressSpace as;
    private DvThreadDetails dvThreadDetails;

    public DvMonitor(long l, boolean bl, DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("DvMonitor constructor (long " + l + ")");
        this.ptrLength = DvUtils.pointerLength();
        long l2 = 0L;
        this.as = dvAddressSpace;
        DvMonitor dvMonitor = this;
        dvMonitor.dvThreadDetails.processThreads();
        this.monAddr = l;
        if (bl) {
            this.sysMon = DvUtils.getControlBlockField("infl_mon", "_sysmon", l, this.as);
            this.objectAddr = DvUtils.getControlBlockField("infl_mon", "object", l, this.as);
            if (DvObjectsCommands.checkForKnownObject(this.objectAddr - (long)this.ptrLength)) {
                this.nameTag = DvGeneralSov.processObjectName(this.objectAddr, this.as, null);
            } else {
                DvUtils.writetoTrace("DvMonitor warning: unknown object at: 0x" + Long.toHexString(this.objectAddr - (long)this.ptrLength));
            }
        } else {
            this.sysMon = DvUtils.getControlBlockField("reg_mon", "mid", l, this.as);
            l2 = DvUtils.getControlBlockField("reg_mon", "name", l, this.as);
            try {
                this.nameTag = DvUtils.getStringFromBytes(this.as.readBytes(this.as.createAddress(l2), 256L));
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.writetoTrace("DvMonitor warning: DvAddressException nameTag");
            }
        }
        DvMonitorsRepository.monitorsByAddr.put(Long.toHexString(l), this);
        if (this.sysMon == 0L) {
            return;
        }
        int n = DvConsole.theDump.getSystemType();
        switch (DvConsole.theDump.getSystemType()) {
            case -1: {
                DvUtils.writetoTrace("DvMonitor warning:  Error SYSTEM IS UNKNOWN (" + n + ")");
                break;
            }
            case 1: {
                this.ownerAddr = DvUtils.getControlBlockField("sys_mon", "monitor_owner", this.sysMon, this.as);
                this.waitQ1 = DvUtils.getControlBlockField("sys_mon", "monitor_waiter", this.sysMon, this.as);
                break;
            }
            case 4: {
                this.ownerAddr = DvUtils.getControlBlockField("sys_mon", "monitor_owner", this.sysMon, this.as);
                this.waitQ1 = DvUtils.getControlBlockField("sys_mon", "enter_waitq", "queue", this.sysMon, this.as);
                this.waitQ2 = DvUtils.getControlBlockField("sys_mon", "sleep_waitq", "queue", this.sysMon, this.as);
                break;
            }
            case 2: 
            case 3: {
                this.ownerAddr = DvUtils.getControlBlockField("sys_mon", "monitor_owner", this.sysMon, this.as);
                this.waitQ1 = DvUtils.getControlBlockField("sys_mon", "mwait_queue", "head", this.sysMon, this.as);
                break;
            }
            default: {
                DvUtils.writetoTrace("DvMonitor warning: Error SYSTEM IS UNKNOWN (" + n + ")");
            }
        }
        if (this.ownerAddr != 0L) {
            for (int i = 0; i < DvThreadDetails.getThreadCount(); ++i) {
                Object object = DvThreadDetails.getThreadDetailsByPosition(i);
                if (this.ownerAddr == DvThreadDetails.getSysThr(object)) {
                    this.ownerName = DvThreadDetails.getThreadName(object);
                    this.ownerThreadID = DvThreadDetails.getThreadID(object);
                }
                if (DvThreadDetails.getEnterMon(object) != this.sysMon) continue;
                this.addEnter(DvThreadDetails.getSysThr(object));
            }
        }
        DvMonitorsRepository.monitorsBySysmon.put(Long.toHexString(this.sysMon), this);
    }

    public boolean isOwnedOrWaitedOn() {
        return (this.ownerAddr | this.waitQ1 | this.waitQ2) != 0L;
    }

    public long getAddress() {
        return this.monAddr;
    }

    public void addName(String string) {
        this.nameTag = string;
    }

    public String getName() {
        return this.nameTag;
    }

    public void addSysMon(long l) {
        this.sysMon = l;
    }

    public long getSysMon() {
        return this.sysMon;
    }

    public long getWaitQ(int n) {
        return n == 0 ? this.waitQ1 : this.waitQ2;
    }

    public long getNextWaitQ(long l) {
        switch (DvConsole.theDump.getSystemType()) {
            case 1: {
                return DvUtils.getControlBlockField("sys_thread", "next_waiter", l, this.as);
            }
            case 4: {
                return DvUtils.getControlBlockField("condq", "Next", l, this.as);
            }
            case 2: 
            case 3: {
                return DvUtils.getControlBlockField("monitor_waiter", "next", l, this.as);
            }
        }
        return 0L;
    }

    public long getWaitQThread(long l) {
        switch (DvConsole.theDump.getSystemType()) {
            case 1: {
                return l;
            }
            case 4: {
                return DvUtils.getControlBlockField("condq", "thread", l, this.as);
            }
            case 2: 
            case 3: {
                return DvUtils.getControlBlockField("monitor_waiter", "waiting_thread", l, this.as);
            }
        }
        return 0L;
    }

    public void addObject(long l, String string) {
        this.objectAddr = l;
        this.nameTag = string;
    }

    public long getObjectAddress() {
        return this.objectAddr;
    }

    public String getObjectName() {
        return this.nameTag;
    }

    public void addOwner(String string, String string2) {
        this.ownerName = string;
        this.ownerThreadID = string2;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerThreadID() {
        if (null == this.ownerThreadID) {
            return "";
        }
        return this.ownerThreadID;
    }

    public long getOwnerAddress() {
        return this.ownerAddr;
    }

    public void addWaiter(long l) {
        Object object = DvThreadDetails.getThreadDetailsBySysthr(Long.toHexString(l));
        if (object != null) {
            this.waiterAddr.add(new Long(l));
            this.waiterName.add(DvThreadDetails.getThreadName(object));
            this.waiterThreadID.add(DvThreadDetails.getThreadID(object));
        }
    }

    public long getWaiterAddress(int n) {
        if (n >= this.waiterAddr.size()) {
            return 0L;
        }
        return (Long)this.waiterAddr.elementAt(n);
    }

    public String getWaiterName(int n) {
        return (String)this.waiterName.elementAt(n);
    }

    public String getWaiterThreadID(int n) {
        if (null == this.waiterThreadID.elementAt(n)) {
            return "";
        }
        return (String)this.waiterThreadID.elementAt(n);
    }

    public long getWaiterSize() {
        return this.waiterAddr.size();
    }

    public void addEnter(long l) {
        Object object = DvThreadDetails.getThreadDetailsBySysthr(Long.toHexString(l));
        if (object != null) {
            this.enterAddr.add(new Long(l));
            this.enterName.add(DvThreadDetails.getThreadName(object));
            this.enterThreadID.add(DvThreadDetails.getThreadID(object));
        }
    }

    public long getEnterAddress(int n) {
        if (n >= this.enterAddr.size()) {
            return 0L;
        }
        return (Long)this.enterAddr.elementAt(n);
    }

    public String getEnterName(int n) {
        return (String)this.enterName.elementAt(n);
    }

    public String getEnterThreadID(int n) {
        if (null == this.enterThreadID.elementAt(n)) {
            return "";
        }
        return (String)this.enterThreadID.elementAt(n);
    }

    public long getEnterSize() {
        return this.enterAddr.size();
    }

    public String toString() {
        return "inflMonAddr " + Long.toHexString(this.monAddr) + "\nsysMon " + Long.toHexString(this.sysMon) + "\nwaitQ1 " + Long.toHexString(this.waitQ1) + "\nwaitQ2 " + Long.toHexString(this.waitQ2) + "\nownerAddr " + Long.toHexString(this.ownerAddr) + "\nownerName " + this.ownerName + "\nwaiterAddr " + this.waiterAddr + "\nwaiterName " + this.waiterName + "\nobjectAddress " + Long.toHexString(this.objectAddr) + "\nobjectName " + this.nameTag + "\n\n";
    }
}

