/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.extract.Extract;
import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.frame.LoadMap;
import com.ibm.jvm.dump.frame.ThreadContext;
import java.io.File;

class DumpContext {
    DumpContext() {
    }

    static File getJvmMapFile(LoadMap[] loadMapArray) {
        String string = null;
        for (int i = 0; loadMapArray != null && i < loadMapArray.length; ++i) {
            String string2 = loadMapArray[i].getPathName();
            if ((string2 = string2.trim().toLowerCase()).lastIndexOf(92) <= 0 || !string2.endsWith("java.dll") && !string2.endsWith("java_g.dll") && !string2.endsWith("java_d.dll")) continue;
            string = string2;
        }
        return Extract.getJvmMapFile(string);
    }

    static ThreadContext getHpiContext(DvThread dvThread, DvAddressSpace dvAddressSpace) {
        if (dvThread.eeAddress() == null) {
            return null;
        }
        try {
            CTypeObject cTypeObject;
            CTypeObject cTypeObject2 = new CTypeObject(CType.find("execenv"), dvThread.eeAddress(), dvAddressSpace);
            CTypeObject cTypeObject3 = cTypeObject2.getField("sys_thr").cast(CType.find("sys_thread"));
            CTypeObject cTypeObject4 = cTypeObject3.getField("signal_context");
            CTypeObject cTypeObject5 = cTypeObject3.getField("suspend_context");
            if (cTypeObject4.getField("is_set").getValue() != 0L) {
                cTypeObject = cTypeObject4;
            } else if (cTypeObject5.getField("is_set").getValue() != 0L) {
                cTypeObject = cTypeObject5;
            } else {
                return null;
            }
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            l = dvThread.eeAddress().getAddressAsLong();
            l2 = cTypeObject.getField("mc.x.eip").getValue();
            l4 = cTypeObject.getField("mc.x.esp").getValue();
            l5 = cTypeObject.getField("mc.x.ebp").getValue();
            return new ThreadContext(l, l2, l3, l4, l5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static ThreadContext getDumpContext(DvThread dvThread) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        DvRegister[] dvRegisterArray = dvThread.getRegisters();
        if (dvThread.eeAddress() != null) {
            l = dvThread.eeAddress().getAddressAsLong();
        }
        if (dvRegisterArray != null && dvRegisterArray.length > 0) {
            int n = 0;
            while ((long)n < dvRegisterArray[0].getCount()) {
                if (dvRegisterArray[0].getName(n).startsWith("esp", 0)) {
                    l4 = dvRegisterArray[0].getValue(n);
                } else if (dvRegisterArray[0].getName(n).startsWith("ebp", 0)) {
                    l5 = dvRegisterArray[0].getValue(n);
                } else if (dvRegisterArray[0].getName(n).startsWith("eip", 0)) {
                    l2 = dvRegisterArray[0].getValue(n);
                }
                ++n;
            }
        }
        return new ThreadContext(l, l2, l3, l4, l5);
    }
}

