/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvEnvData;
import com.ibm.jvm.dump.format.DvLoaded;
import com.ibm.jvm.dump.format.DvModule;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import com.ibm.jvm.dump.plugins.DvJavacorePlugin;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DvJavacoreSov
extends DvJavacorePlugin {
    private static DvThread myThread = null;
    private static boolean verbose = false;
    private static boolean DEBUG = false;
    private static boolean staticsInitialised = false;
    private static CTypeObject ee = null;
    private static CTypeObject jvm = null;
    private static CTypeObject dgData = null;
    private static CTypeObject xeData = null;
    private static CTypeObject stData = null;
    private static DvJavacoreSov selfRef;
    private static int ptrLength;
    private static String[] commandsSupported;
    private static String[] mySuffixes;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final long DG_TRC_BUFFER_ACTIVE = 0x80000000L;

    public DvJavacoreSov() {
        selfRef = this;
        ptrLength = DvUtils.pointerLength();
    }

    public String[] getSuffixes() {
        return mySuffixes;
    }

    public String pluginName() {
        return "General plugin supporting Javacore commands (for sov)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public static void doTITLESection() {
        if (!staticsInitialised) {
            DvJavacoreSov.initStatics();
        }
        try {
            DvJavacoreSov.newSection("TITLE");
            String string = null;
            try {
                int n = DvJavacoreSov.readAnInt(dgData.getField("signalNumber"));
                string = "signal " + n + " received";
                if (n == 0) {
                    string = "signal received not available in dump";
                }
            }
            catch (Exception exception) {
                string = "signal received not available in dump";
            }
            DvJavacoreSov.printWithTag("1TISIGINFO", string);
            String string2 = null;
            try {
                CTypeObject cTypeObject = dgData.getField("signalTime");
                string2 = DvJavacoreSov.getCStringFromPtr(cTypeObject);
                if (string2.equals("")) {
                    string2 = "<not available in dump>";
                }
            }
            catch (Exception exception) {
                string2 = "<not available in dump>";
            }
            DvJavacoreSov.printWithTag("1TIDATETIME", "Date:                 " + string2);
            DvJavacoreSov.printWithTag("1TIFILENAME", "Javacore filename:    <simulated javadump>");
        }
        catch (Exception exception) {
            DvJavacoreSov.outputAdd("*** Unexpected exception received in doTITLESection ");
            DvJavacoreSov.outputAdd("    " + exception.getMessage());
            DvJavacoreSov.outputFlush();
            exception.printStackTrace();
        }
        DvJavacoreSov.outputFlush();
    }

    public static void doXHPISection() {
        DvJavacoreSov.newSection("XHPI");
        DvJavacoreSov.printWithTag("NULL", " ");
        DvJavacoreSov.printWithTag("2HXENVVARS", "Environment Variables");
        DvJavacoreSov.printWithTag("NULL", "---------------------");
        String[] stringArray = DvJavacoreSov.getEnvVarsFromDump();
        if (stringArray == null) {
            DvJavacoreSov.printWithTag("3HXNOENVVARS", "UNSUPPORTED: No environment variables in this dump");
        } else if (stringArray[0].indexOf("No loaded information for this process") != -1) {
            DvJavacoreSov.printWithTag("3HXNOENVVARS", "UNSUPPORTED: No environment variables in this dump");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                DvJavacoreSov.printWithTag("3HXENVVAR", stringArray[i]);
            }
        }
        DvJavacoreSov.printWithTag("NULL", " ");
        DvJavacoreSov.printWithTag("1XHLOADEDLIBS", "Loaded Libraries (sizes in bytes)");
        DvJavacoreSov.printWithTag("NULL", "----------------");
        DvLoaded dvLoaded = null;
        DvProcess[] dvProcessArray = as.getProcesses();
        for (int i = 0; i < dvProcessArray.length; ++i) {
            try {
                boolean bl = false;
                try {
                    dvLoaded = dvProcessArray[i].getLoaded();
                }
                catch (Error error) {
                    bl = true;
                }
                if (bl) {
                    DvJavacoreSov.printWithTag("2XHNOLIBS", "UNSUPPORTED: Unsupported function DvProcess.getLoaded()");
                    continue;
                }
                if (dvLoaded == null) {
                    DvJavacoreSov.printWithTag("2XHNOLIBS", "No loaded information for process " + dvProcessArray[i].id());
                    continue;
                }
                DvModule[] dvModuleArray = dvLoaded.getModules();
                for (int j = 0; j < dvModuleArray.length; ++j) {
                    String string = DvJavacoreSov.truncateAtIllegalChar(dvModuleArray[j].name());
                    DvJavacoreSov.printWithTag("2XHLIBNAME", string);
                    if (dvModuleArray[j].moduleSize == 0L) {
                        DvJavacoreSov.printWithTag("3XHNOLIBINFO", "    filesize    : unknown");
                    } else {
                        DvJavacoreSov.printWithTag("3XHLIBSIZE", "    filesize    : " + dvModuleArray[j].size());
                    }
                    DvJavacoreSov.printWithTag("3XHLIBSTART", "    start addr  : 0x" + Long.toHexString(dvModuleArray[j].address().getAddressAsLong()));
                }
                continue;
            }
            catch (Exception exception) {
                output.add("*** Error: Unexpected exception in doXHPISection()");
                DvJavacoreSov.outputFlush();
                exception.printStackTrace();
            }
        }
        DvJavacoreSov.printWithTag("NULL", " ");
        DvJavacoreSov.outputFlush();
    }

    public static void doCISection() {
        DvJavacorePlugin.newSection("CI");
        DvEnvData dvEnvData = null;
        DvProcess dvProcess = null;
        DvDump dvDump = DvConsole.theDump;
        try {
            dvProcess = as.getCurrentProcess();
        }
        catch (Error error) {
            DvJavacoreSov.printWithTag("NULL", "UNSUPPORTED: Unsupported function DvAddressSpace.getCurrentProcess()");
            DvJavacoreSov.outputFlush();
            dvProcess = null;
        }
        try {
            String string;
            String string2;
            String[] stringArray;
            block31: {
                if (dvProcess != null) {
                    dvEnvData = dvProcess.getEnvData();
                }
                stringArray = DvJavacoreSov.getEnvVarsFromDump();
                CTypeObject cTypeObject = jvm.getField("fullVersion");
                string2 = null;
                try {
                    string2 = DvJavacoreSov.getCStringFromPtr(cTypeObject);
                }
                catch (DvAddressException dvAddressException) {
                    string2 = "<version not available>";
                    if (dvEnvData == null || (string2 = dvEnvData.javaVersion().trim()) != null && !string2.equals("")) break block31;
                    string2 = "<version not available>";
                }
            }
            DvJavacoreSov.printWithTag("1CIJAVAVERSION", string2);
            String string3 = "";
            int n = 0;
            int n2 = 1;
            int n3 = 2;
            int n4 = DvJavacoreSov.readAnInt(jvm.getField("mode"));
            if (n4 == n) {
                string3 = "standalone";
            } else if (n4 == n2) {
                string3 = "master";
            } else if (n4 == n3) {
                string3 = "worker";
            }
            DvJavacoreSov.printWithTag("1CIRUNNINGAS", "Running as a " + string3 + " JVM");
            if (dvProcess != null) {
                if (stringArray != null) {
                    string = null;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].startsWith("IBM_JAVA_COMMAND_LINE=")) continue;
                        string = stringArray[i].substring(22);
                    }
                    if (string != null) {
                        DvJavacoreSov.printWithTag("1CICMDLINE", string);
                    } else {
                        DvJavacoreSov.printWithTag("1CICMDLINE", "<not present in dump>");
                    }
                } else {
                    DvJavacoreSov.printWithTag("1CICMDLINE", "<not supported in dump>");
                }
            } else {
                DvJavacoreSov.printWithTag("NULL", "UNSUPPORTED: Unable to display Java commandline");
            }
            if (dvProcess != null && dvEnvData != null) {
                string = dvEnvData.javaHomeDir().trim();
                DvJavacoreSov.outputFlush();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    DvJavacoreSov.printWithTag("1CIJAVAHOMEDIR", "Java Home Dir:   <not present in dump>");
                } else {
                    DvJavacoreSov.printWithTag("1CIJAVAHOMEDIR", "Java Home Dir:   " + string);
                }
            } else {
                DvJavacoreSov.printWithTag("NULL", "UNSUPPORTED: Unable to display Java Home");
            }
            if (dvProcess != null && dvEnvData != null) {
                string = dvEnvData.javaDllDir().trim();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    DvJavacoreSov.printWithTag("1CIJAVADLLDIR", "Java DLL Dir:    <not present in dump>");
                } else {
                    DvJavacoreSov.printWithTag("1CIJAVADLLDIR", "Java DLL Dir:    " + string);
                }
            } else {
                DvJavacoreSov.printWithTag("1CIJAVADLLDIR", "UNSUPPORTED: Unable to display Java DLL directory");
            }
            DvJavacoreSov.printWithTag("1CISYSCP", "Sys Classpath:   <not yet available>");
            if (dvProcess != null && dvEnvData != null) {
                string = dvEnvData.classpath().trim();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    DvJavacoreSov.printWithTag("1CIUSRCP", "User Classpath:  <not present in dump>");
                } else {
                    DvJavacoreSov.printWithTag("1CIUSRCP", "User Classpath:  " + string);
                }
            } else {
                DvJavacoreSov.printWithTag("1CIUSRCP", "UNSUPPORTED: Unable to display User Classpath");
            }
            DvJavacoreSov.printWithTag("1CIUSERARGS", "UserArgs:");
            DvJavacoreSov.printWithTag("2CIUSERARG", "          <not yet available>");
            DvJavacoreSov.printWithTag("NULL", "");
            DvJavacoreSov.printWithTag("1CIJVMMI", "JVM Monitoring Interface (JVMMI)");
            DvJavacoreSov.printWithTag("NULL", "------------------------");
            DvJavacoreSov.printWithTag("NULL", "<not yet available>");
            DvJavacoreSov.printWithTag("NULL", "");
            DvJavacoreSov.outputFlush();
        }
        catch (Exception exception) {
            DvJavacoreSov.outputAdd("*** Error: unexpected exception received in doCISection");
            DvJavacoreSov.outputFlush();
            exception.printStackTrace();
        }
    }

    public static void doDCSection() {
        DvDump dvDump = DvConsole.theDump;
        DvJavacoreSov.newSection("DC");
        CTypeObject cTypeObject = jvm.getField("facade.dc");
        CTypeObject cTypeObject2 = cTypeObject.getField("header");
        CTypeObject cTypeObject3 = cTypeObject2.getField("length");
        boolean bl = DvUtils.is64BitSystem(dvDump.getArchitecture());
        int n = 0;
        n = bl ? 8 : 4;
        long l = cTypeObject.getAddr();
        int n2 = DvJavacoreSov.readAnInt(cTypeObject3);
        try {
            long l2 = l + (long)n2 - (long)n;
            DvAddress dvAddress = as.readPointer(as.createAddress(l2));
            long l3 = dvAddress.getAddressAsLong();
            CTypeObject cTypeObject4 = new CTypeObject("JvmDataHeader", as.createAddress(l3), as);
            CTypeObject cTypeObject5 = cTypeObject4.getField("eyecatcher");
            CTypeObject cTypeObject6 = cTypeObject4.getField("length");
            CTypeObject cTypeObject7 = cTypeObject4.getField("version");
            CTypeObject cTypeObject8 = cTypeObject4.getField("modification");
            int n3 = DvJavacoreSov.readAnInt(cTypeObject5);
            int n4 = DvJavacoreSov.readAnInt(cTypeObject6);
            int n5 = DvJavacoreSov.readAnInt(cTypeObject7);
            int n6 = DvJavacoreSov.readAnInt(cTypeObject8);
            byte[] byArray = new byte[]{(byte)(n3 & 0xFF), (byte)((n3 & 0xFF00) >> 8), (byte)((n3 & 0xFF0000) >> 16), (byte)((n3 & 0xFF000000) >> 24), 0};
            if (DvUtils.isBigEndian(dvDump.getArchitecture())) {
                byte by = byArray[0];
                byArray[0] = byArray[3];
                byArray[3] = by;
                by = byArray[1];
                byArray[1] = byArray[2];
                byArray[2] = by;
            }
            String string = new String(byArray, "US-ASCII");
            DvJavacoreSov.printWithTag("1DCHEADEREYE", "Header eye catcher  " + string);
            DvJavacoreSov.printWithTag("1DCHEADERLEN", "Header length       " + n4);
            DvJavacoreSov.printWithTag("1DCHEADERVER", "Header version      " + n5);
            DvJavacoreSov.printWithTag("1DCHEADERMOD", "Header modification " + n6);
            DvJavacoreSov.printWithTag("1DCINTERFACE", "<not yet available>");
            DvJavacoreSov.printWithTag("1DCARRAYINFO", "<not yet available>");
        }
        catch (Exception exception) {
            DvJavacoreSov.outputFlush();
            System.out.println("*** Unxpected Exception in doDCSection()");
            exception.printStackTrace();
        }
        DvJavacoreSov.outputFlush();
    }

    public static void doDGSection() {
        DvJavacoreSov.newSection("DG");
        boolean bl = verbose;
        boolean bl2 = false;
        try {
            Object object;
            String string;
            Object object2;
            Object object3;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7 = "Trace Enabled: " + DvJavacoreSov.boolFieldToString(dgData.getField("traceEnabled"), "Yes", "No");
            DvJavacoreSov.printWithTag("1DGTRCENABLED", string7);
            if (string7.equals("Yes")) {
                bl2 = true;
            }
            if ((string6 = "  " + DvJavacoreSov.boolFieldToString(dgData.getField("traceActive"), "Trace activated", "[Trace NOT activated]")).indexOf("[") == -1 || bl) {
                DvJavacoreSov.printWithTag("2DGTRCACTIVATE", string6);
            }
            if (string6.indexOf("[") == -1) {
                bl2 = true;
            }
            if ((string5 = "  " + DvJavacoreSov.boolFieldToString(dgData.getField("traceTerminate"), "Trace terminated", "[Trace NOT terminated]")).indexOf("[") == -1 || bl) {
                DvJavacoreSov.printWithTag("2DGTRCTERMINATE", string5);
            }
            int n = DvJavacoreSov.readAnInt(dgData.getField("traceSuspend"));
            String string8 = null;
            if (n == -1) {
                DvJavacoreSov.printWithTag("2DGTRCSUSPEND", "  ***Error reading Trace suspend flags***");
            } else if (n == 0 && bl) {
                string8 = "  Trace suspend flags:0x" + Long.toHexString(n);
                DvJavacoreSov.printWithTag("2DGTRCSUSPEND", string8);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCSUSPEND", "  [Trace suspend flags: ZERO]");
            }
            String string9 = "  " + DvJavacoreSov.boolFieldToString(dgData.getField("traceInitSpec"), "Initialization traced", "[Initialization NOT traced]");
            if (string9.indexOf("[") == -1 || bl) {
                DvJavacoreSov.printWithTag("2DGTRCJVMINIT", string9);
            }
            if (bl2 || bl) {
                string4 = "  Trace: " + DvJavacoreSov.boolFieldToString(dgData.getField("externalTrace"), "Ex", "In") + "ternal";
                DvJavacoreSov.printWithTag("2DGTRCTYPE", string4);
            }
            if (DvJavacoreSov.getCStringFromPtr(dgData.getField("traceFilename")) != null) {
                string4 = "  Filename: " + DvJavacoreSov.getCStringFromPtr(dgData.getField("traceFilename"));
                DvJavacoreSov.printWithTag("2DGTRCFILE", string4);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCFILE", "  [Filename: null]");
            }
            int n2 = DvJavacoreSov.readAnInt(dgData.getField("lostRecords"));
            if (n2 != 0) {
                String string10 = "  Number of lost trace records: " + n2;
                DvJavacoreSov.printWithTag("2DGTRCLOST", string10);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCLOST", "  [Number of lost trace records: 0]");
            }
            int n3 = DvJavacoreSov.readAnInt(dgData.getField("traceWrap"));
            if (n3 != 0) {
                string3 = "  Maximum file size: " + n3;
                DvJavacoreSov.printWithTag("2DGTRCFILEWRAP", string3);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCFILEWRAP", "  [Maximum file size: 0]");
            }
            string3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            int n4 = DvJavacoreSov.readAnInt(dgData.getField("traceGenerations"));
            int n5 = DvJavacoreSov.readAnInt(dgData.getField("nextGeneration"));
            String string11 = string3.substring(n5, n5 + 1);
            if (n4 != 0) {
                string2 = "  Number of trace generations: " + n4;
                DvJavacoreSov.printWithTag("2DGTRCGENERATE", string2);
                String string12 = "  Next trace generation: " + string11;
                DvJavacoreSov.printWithTag("2DGTRCNEXTGEN", string12);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCGENERATE", "  [Number of trace generations: 0]");
                DvJavacoreSov.printWithTag("2DGTRCNEXTGEN", "  [Next trace generation: " + string11 + "]");
            }
            if (DvJavacoreSov.getCStringFromPtr(dgData.getField("traceFileSpec")) != null) {
                string2 = DvJavacoreSov.getCStringFromPtr(dgData.getField("traceFileSpec"));
                string2 = "  Property filename: " + string2;
                DvJavacoreSov.printWithTag("2DGTRCPROPS", string2);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCPROPS", "  [Property filename: null]");
            }
            long l = DvJavacoreSov.readPtrAsLong(dgData.getField("traceBufferSpec"));
            if (l != 0L) {
                object3 = "  Buffer specification: " + DvJavacoreSov.getCStringFromPtr(dgData.getField("traceBufferSpec"));
                DvJavacoreSov.printWithTag("2DGTRCBUFFERS", (String)object3);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCBUFFERS", "  [Buffer specification: null]");
            }
            object3 = dgData.getField("traceGlobal");
            if (DvJavacoreSov.readPtrAsLong((CTypeObject)object3) != 0L) {
                int n6 = 0;
                int n7 = 0;
                while (DvJavacoreSov.readPtrAsLong((CTypeObject)object3) != 0L) {
                    ++n6;
                    object2 = ((CTypeObject)object3).deReference("DgTraceBuffer").getField("flags");
                    long l2 = DvJavacoreSov.readAnInt((CTypeObject)object2);
                    if ((l2 & 0x80000000L) != 0L) {
                        ++n7;
                    }
                    object3 = ((CTypeObject)object3).deReference("DgTraceBuffer").getField("globalNext");
                }
                object2 = "  Buffers allocated: " + n6;
                DvJavacoreSov.printWithTag("2DGTRCBUFALLOC", (String)object2);
                string = "  Buffers in use:    " + n7;
                DvJavacoreSov.printWithTag("2DGTRCBUFUSED", string);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCBUFALLOC", "  [Buffers allocated: 0]");
                DvJavacoreSov.printWithTag("2DGTRCBUFUSED", "  [Buffers in use:    0]");
            }
            if (DvJavacoreSov.getCStringFromPtr(dgData.getField("exceptFilename")) != null) {
                String string13 = "  Exception filename: " + DvJavacoreSov.getCStringFromPtr(dgData.getField("exceptFilename"));
                DvJavacoreSov.printWithTag("2DGTRCEXCEPTFN", string13);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCEXCEPTFN", "  [Exception filename: null]");
            }
            int n8 = DvJavacoreSov.readAnInt(dgData.getField("exceptTraceWrap"));
            if (n8 != 0) {
                String string14 = "  Maximum exception file size: " + n8;
                DvJavacoreSov.printWithTag("2DGTRCEXCPTMAX", string14);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCEXCPTMAX", "  [Maximum exception file size: 0]");
            }
            if (DvJavacoreSov.getCStringFromPtr(dgData.getField("stateFilename")) != null) {
                String string15 = "  State filename: " + DvJavacoreSov.getCStringFromPtr(dgData.getField("stateFilename"));
                DvJavacoreSov.printWithTag("2DGTRCSTATEFN", string15);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCSTATEFN", "  [State filename: null]");
            }
            int n9 = DvJavacoreSov.readAnInt(dgData.getField("stateTraceWrap"));
            if (n9 != 0) {
                object2 = "  Maximum state file size: " + n9;
                DvJavacoreSov.printWithTag("2DGTRCSTATEMAX", (String)object2);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCSTATEMAX", "  [Maximum state file size: 0]");
            }
            object2 = dgData.getField("traceApplids");
            if (DvJavacoreSov.readPtrAsLong((CTypeObject)object2) != 0L) {
                DvJavacoreSov.printWithTag("2DGTRCAPPLTRC", "  Application trace enabled");
                DvJavacoreSov.printWithTag("3DGTRCAPPLID", "    ***IBM.WRITEME***");
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCAPPLTRC", "  [Application trace NOT enabled]");
                DvJavacoreSov.printWithTag("3DGTRCAPPLID", "    [***IBM.WRITEME***]");
            }
            if (DvJavacoreSov.getCStringFromPtr(dgData.getField("traceMethodSpec")) != null) {
                string = "  Method trace specification: " + DvJavacoreSov.getCStringFromPtr(dgData.getField("traceMethodSpec"));
                DvJavacoreSov.printWithTag("2DGTRCMETHODS", string);
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCMETHODS", "  [Method trace specification: n/a]");
            }
            if (DvJavacoreSov.readPtrAsLong(dgData.getField("traceListeners")) != 0L) {
                string = "  Trace listener routines:";
                DvJavacoreSov.printWithTag("2DGTRCLISTEN", string);
                boolean bl3 = false;
                CTypeObject cTypeObject = null;
                if (DvJavacoreSov.readPtrAsLong(dgData.getField("traceListeners")) == 0L) {
                    bl3 = true;
                } else {
                    cTypeObject = dgData.getField("traceListeners").deReference("DgTraceListener");
                }
                while (!bl3) {
                    object = Long.toHexString(DvJavacoreSov.readPtrAsLong(cTypeObject.getField("Trace")));
                    DvJavacoreSov.printWithTag("3DGTRCLISTENR", "    Listener: 0x" + (String)object);
                    if (DvJavacoreSov.readPtrAsLong(cTypeObject.getField("next")) == 0L) {
                        bl3 = true;
                        continue;
                    }
                    cTypeObject = cTypeObject.getField("next").deReference("DgTraceListener");
                }
            } else if (bl) {
                DvJavacoreSov.printWithTag("2DGTRCLISTEN", "  Trace listener routines: NONE");
            }
            if ((string = DvJavacoreSov.boolFieldToString(dgData.getField("check_ras_plugin"), "RAS plug-in is in control", "[RAS plug-in is NOT in control]")).indexOf("[") == -1 || bl) {
                DvJavacoreSov.printWithTag("1DGRASPLUGINACT", string);
            }
            if (DvJavacoreSov.readPtrAsLong(dgData.getField("dumpExits")) != 0L) {
                String string16 = "Dump exit routines:";
                DvJavacoreSov.printWithTag("1DGDMPEXIT", string16);
                boolean bl4 = false;
                object = null;
                if (DvJavacoreSov.readPtrAsLong(dgData.getField("dumpExits")) == 0L) {
                    bl4 = true;
                } else {
                    object = dgData.getField("dumpExits").deReference("DgDumpExit");
                }
                while (!bl4) {
                    String string17 = Long.toHexString(DvJavacoreSov.readPtrAsLong(((CTypeObject)object).getField("exit")));
                    DvJavacoreSov.printWithTag("2DGTRCLISTENR", "  Exit: 0x" + string17);
                    if (DvJavacoreSov.readPtrAsLong(((CTypeObject)object).getField("next")) == 0L) {
                        bl4 = true;
                        continue;
                    }
                    object = ((CTypeObject)object).getField("next").deReference("DgDumpExit");
                }
            } else if (bl) {
                DvJavacoreSov.printWithTag("1DGDMPEXIT", "[Dump exit routines: NONE]");
            }
            String string18 = "Javadump buffer size (allocated): " + DvJavacoreSov.readAnInt(dgData.getField("printBufferSize"));
            DvJavacoreSov.printWithTag("1DGJDUMPBUFF", string18);
        }
        catch (Exception exception) {
            output.add("*** Exception thrown in doDGSection while processing DG Dump Rotuine.");
            output.add("    " + exception.getMessage());
            DvJavacoreSov.outputFlush();
            exception.printStackTrace();
        }
        DvJavacoreSov.outputFlush();
    }

    public static void doSTSection() {
        DvJavacoreSov.newSection("ST");
        String string = "<dummy>";
        try {
            int n;
            CTypeObject cTypeObject;
            long l;
            CTypeObject cTypeObject2;
            CTypeObject cTypeObject3 = stData.getField("st_jab").deReference("StorageJab");
            if (cTypeObject3 == null) {
                System.out.println("*** Error: storage JAB is null!");
                throw new RuntimeException("Storage JAB is null");
            }
            CTypeObject cTypeObject4 = jvm.getField("jab").deReference("JvmSetAnchorBlock");
            CTypeObject cTypeObject5 = cTypeObject4.getField("xm.resettable");
            String string2 = DvJavacoreSov.boolFieldToString(cTypeObject5, "Yes", "No");
            DvJavacoreSov.printWithTag("1STGCMODES", "Resettable GC: " + string2);
            CTypeObject cTypeObject6 = stData.getField("concurrent_execution_mode");
            int n2 = DvJavacoreSov.readAnInt(cTypeObject6);
            int n3 = 1;
            String string3 = null;
            string3 = n2 != n3 ? "Yes" : "No";
            DvJavacoreSov.printWithTag("1STGCMODES", "Concurrent GC: " + string3);
            CTypeObject cTypeObject7 = stData.getField("curHeapMin");
            long l2 = DvJavacoreSov.readPtrAsLong(cTypeObject7);
            DvJavacoreSov.printWithTag("1STCURHBASE", "Current Heap Base: " + Long.toHexString(l2));
            CTypeObject cTypeObject8 = stData.getField("curHeapMax");
            long l3 = DvJavacoreSov.readPtrAsLong(cTypeObject8);
            DvJavacoreSov.printWithTag("1STCURHLIM", "Current Heap Limit: " + Long.toHexString(l3));
            CTypeObject cTypeObject9 = stData.getField("MH_heapbase");
            long l4 = DvJavacoreSov.readPtrAsLong(cTypeObject9);
            DvJavacoreSov.printWithTag("1STMWHBASE", "Middleware Heap Base: " + Long.toHexString(l4));
            CTypeObject cTypeObject10 = stData.getField("MH_heaplimit");
            long l5 = DvJavacoreSov.readPtrAsLong(cTypeObject10);
            DvJavacoreSov.printWithTag("1STMWHLIM", "Middleware Heap Limit: " + Long.toHexString(l5));
            if (string2.equals("Yes")) {
                cTypeObject2 = stData.getField("TH_heapbase");
                l = DvJavacoreSov.readPtrAsLong(cTypeObject2);
                DvJavacoreSov.printWithTag("1STTHBASE", "Transient Heap Base: " + Long.toHexString(l));
            }
            if (string2.equals("Yes")) {
                cTypeObject2 = stData.getField("TH_heaplimit");
                l = DvJavacoreSov.readPtrAsLong(cTypeObject2);
                DvJavacoreSov.printWithTag("1STTHLIM", "Transient Heap Limit: " + Long.toHexString(l));
            }
            cTypeObject2 = stData.getField("gcHelpersTarget");
            int n4 = DvJavacoreSov.readAnInt(cTypeObject2);
            DvJavacoreSov.printWithTag("1STGCHELPERS", "Number of GC Helper Threads: " + n4);
            CTypeObject cTypeObject11 = cTypeObject3.getField("alloc_2_trace_rate");
            int n5 = DvJavacoreSov.readAnInt(cTypeObject11);
            DvJavacoreSov.printWithTag("1STJVMOPTS", "-Xconcurrentlevel: " + n5);
            CTypeObject cTypeObject12 = cTypeObject3.getField("gcConcurrentBKHelpers");
            int n6 = DvJavacoreSov.readAnInt(cTypeObject12);
            DvJavacoreSov.printWithTag("1STJVMOPTS", "-Xconcurrentbackground: " + n6);
            if (string3.equals("Yes")) {
                cTypeObject = stData.getField("conctr");
                n = DvJavacoreSov.readAnInt(cTypeObject);
                DvJavacoreSov.printWithTag("1STCONCTR", "Concurrent Counter: " + n);
            }
            cTypeObject = stData.getField("gcctr");
            n = DvJavacoreSov.readAnInt(cTypeObject);
            DvJavacoreSov.printWithTag("1STGCCTR", "GC Counter: " + n);
            CTypeObject cTypeObject13 = stData.getField("afctr");
            int n7 = DvJavacoreSov.readAnInt(cTypeObject13);
            DvJavacoreSov.printWithTag("1STAFCTR", "AF Counter: " + n7);
            CTypeObject cTypeObject14 = stData.getField("FreeObjectCtr");
            int n8 = DvJavacoreSov.readAnInt(cTypeObject14);
            DvJavacoreSov.printWithTag("1STHEAPFREE", "Bytes of Heap Space Free: " + n8);
            CTypeObject cTypeObject15 = stData.getField("TotalObjectCtr");
            int n9 = DvJavacoreSov.readAnInt(cTypeObject15);
            DvJavacoreSov.printWithTag("1STHEAPALLOC", "Bytes of Heap Space Allocated: " + n9);
            CTypeObject cTypeObject16 = cTypeObject3.getField("SM_base");
            long l6 = DvJavacoreSov.readPtrAsLong(cTypeObject16);
            DvJavacoreSov.printWithTag("1STSMBASE", "SM Base: " + Long.toHexString(l6));
            CTypeObject cTypeObject17 = cTypeObject3.getField("SM_end");
            long l7 = DvJavacoreSov.readPtrAsLong(cTypeObject17);
            DvJavacoreSov.printWithTag("1STSMEND", "SM End: " + Long.toHexString(l7));
            CTypeObject cTypeObject18 = cTypeObject3.getField("PAM_start");
            long l8 = DvJavacoreSov.readPtrAsLong(cTypeObject18);
            DvJavacoreSov.printWithTag("1STSMEND", "PAM Start: " + Long.toHexString(l8));
            CTypeObject cTypeObject19 = cTypeObject3.getField("PAM_end");
            long l9 = DvJavacoreSov.readPtrAsLong(cTypeObject19);
            DvJavacoreSov.printWithTag("1STSMEND", "PAM End: " + Long.toHexString(l9));
            CTypeObject cTypeObject20 = stData.getField("compact_action");
            int n10 = DvJavacoreSov.readAnInt(cTypeObject20);
            DvJavacoreSov.printWithTag("1STCOMACTION", "Compact Action: " + n10);
        }
        catch (Exception exception) {
            output.add("*** Unexpected exception recived during stDumpRoutine processing.");
            output.add(exception.getMessage());
            DvJavacoreSov.outputFlush();
            exception.printStackTrace();
        }
        DvJavacoreSov.outputFlush();
    }

    public static void doXESection() {
        DvJavacoreSov.newSection("XE");
        try {
            CTypeObject cTypeObject = xeData.getField("common");
            CTypeObject cTypeObject2 = cTypeObject.getField("before_compile_java");
            int n = DvJavacoreSov.readAnInt(cTypeObject2);
            DvJavacoreSov.printWithTag("1XETHRESHOLD", "MMI threshold for java methods is set to " + n);
            CTypeObject cTypeObject3 = cTypeObject.getField("compiler_initialized");
            String string = DvJavacoreSov.boolFieldToString(cTypeObject3, "Yes", "No");
            if (string.equals("Yes")) {
                DvJavacoreSov.printWithTag("1XEJITINIT", "JIT is initialized");
            } else {
                DvJavacoreSov.printWithTag("1XEJITNINIT", "JIT is not initialized");
            }
            CTypeObject cTypeObject4 = cTypeObject.getField("do_jvmpi_instruction_events");
            String string2 = DvJavacoreSov.boolFieldToString(cTypeObject4, "Yes", "No");
            if (string2.equals("Yes")) {
                DvJavacoreSov.printWithTag("1XEJVMPION", "JVMPI is activated");
            } else {
                DvJavacoreSov.printWithTag("1XEJVMPIOFF", "JVMPI is not activated");
            }
            CTypeObject cTypeObject5 = xeData.getField("mmi");
            CTypeObject cTypeObject6 = cTypeObject5.getField("before_compile_jni");
            int n2 = DvJavacoreSov.readAnInt(cTypeObject6);
            DvJavacoreSov.printWithTag("1XEJNITHRESH", "MMI threshold for JNI methods is set to " + n2);
            CTypeObject cTypeObject7 = cTypeObject5.getField("history_length");
            int n3 = DvJavacoreSov.readAnInt(cTypeObject7);
            DvJavacoreSov.printWithTag("1XETRCHIS", "Trace history length is set to " + n3);
            DvJavacoreSov.printWithTag("1XEJITDUMP", "JIT dump routine is not yet implemented.");
        }
        catch (Exception exception) {
            DvJavacoreSov.outputFlush();
            System.out.println("*** unexpected Exception received in doXESection()");
            System.out.println("    " + exception.getMessage());
            exception.printStackTrace();
        }
        DvJavacoreSov.outputFlush();
    }

    public static void doLKSection() {
        DvJavacoreSov.newSection("LK");
        Vector vector = DvObjectsCommands.lkDumpRoutine();
        for (int i = 0; i < vector.size(); i += 2) {
            try {
                DvJavacoreSov.printWithTag((String)vector.elementAt(i), (String)vector.elementAt(i + 1));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                DvJavacoreSov.printWithTag(" error !!!", "ArrayIndexOutOfBoundsException in DvJavaCorePlugin");
                String string = "\n*******************\n";
                string = string + " ArrayIndexOutOfBoundsException produced in  in DvJavaCorePlugin\n" + "*******************\n";
                DvUtils.trace(string, 0, true);
                Dumpviewer.showMessage(string, false);
            }
        }
        DvJavacoreSov.outputFlush();
    }

    public static void doXMSection() {
        DvProcess[] dvProcessArray;
        DvDump dvDump = DvConsole.theDump;
        DvJavacoreSov.newSection("XM");
        DvJavacoreSov.printWithTag("NULL", " ");
        DvJavacoreSov.printWithTag("1XMEXCPINFO", "Exception Info");
        DvJavacoreSov.printWithTag("NULL", "--------------");
        DvJavacoreSov.printWithTag("2XMDUMPINFONA", "Not available");
        DvJavacoreSov.printWithTag("NULL", " ");
        DvJavacoreSov.printWithTag("1XMTHDINFO", "Thread Info");
        DvJavacoreSov.printWithTag("NULL", "-----------");
        DvJavacoreSov.printWithTag("NULL", " ");
        DvProcess dvProcess = null;
        DvEnvData dvEnvData = null;
        try {
            dvProcess = as.getCurrentProcess();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (dvProcess == null) {
            DvJavacoreSov.printWithTag("2XMFULLTHDDUMP", "Full thread dump Classic VM (<UNSUPPORTED>, native threads)");
        } else {
            String string;
            block26: {
                dvEnvData = dvProcess.getEnvData();
                dvProcessArray = jvm.getField("fullVersion");
                string = null;
                try {
                    string = DvJavacoreSov.getCStringFromPtr((CTypeObject)dvProcessArray);
                }
                catch (DvAddressException dvAddressException) {
                    if (dvEnvData != null) {
                        string = dvEnvData.javaVersion().trim();
                    }
                    if (string != null && !string.equals("")) break block26;
                    string = "<version not available>";
                }
            }
            DvJavacoreSov.printWithTag("2XMFULLTHDDUMP", "Full thread dump Classic VM (" + string + ", native threads)");
        }
        DvJavacoreSov.outputFlush();
        try {
            dvProcessArray = as.getProcesses();
            for (int i = 0; i < dvProcessArray.length; ++i) {
                DvThread[] dvThreadArray = dvProcessArray[i].getThreads();
                for (int j = dvThreadArray.length - 1; j >= 0; --j) {
                    try {
                        Object object;
                        int n;
                        Object object2;
                        DvThread dvThread = dvThreadArray[j];
                        CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), as);
                        long l = -1L;
                        try {
                            object2 = cTypeObject.getField("thread_priority");
                            l = DvJavacoreSov.readPtrAsLong((CTypeObject)object2);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        object2 = "<unknown>";
                        if (l != -1L) {
                            object2 = new Long(l).toString();
                        }
                        int n2 = -1;
                        n2 = Integer.parseInt(dvThread.id(), 16);
                        if (cTypeObject.getAddr() == 0L || cTypeObject.getAddr() == -1L) continue;
                        long l2 = DvJavacoreSov.readPtrAsLong(cTypeObject.getField("thread"));
                        CTypeObject cTypeObject2 = cTypeObject.getField("sys_thr");
                        long l3 = cTypeObject2.getAddr();
                        String string = dvThread.getThreadName(as);
                        CTypeObject cTypeObject3 = new CTypeObject("sys_thread", l3, as);
                        CTypeObject cTypeObject4 = cTypeObject3.getField("state");
                        int n3 = DvJavacoreSov.readAnInt(cTypeObject4);
                        String string2 = new String("<" + n3 + ">");
                        DvJavacoreSov.printWithTag("3XMTHREADINFO", "    \"" + string + "\"" + " (TID:0x" + Long.toHexString(l2) + ", sys_thread_t:0x" + Long.toHexString(l3) + ", state:" + string2 + ", native ID:0x" + Long.toHexString(n2) + ") prio=" + (String)object2);
                        DvJavacoreSov.outputFlush();
                        try {
                            if (dvThread != null && dvThread.getJavaStack() != null) {
                                n = 0;
                                while ((long)n < dvThread.getJavaStack().getNumFrames()) {
                                    object = dvThread.getJavaStack().getFrame(n).toString();
                                    if (!((String)object).startsWith("pseudo frame")) {
                                        DvJavacoreSov.printWithTag("4XESTACKTRACE", "        at " + (String)object);
                                    }
                                    ++n;
                                }
                            }
                        }
                        catch (Exception exception) {
                            DvJavacoreSov.printWithTag("4XMJAVASTCKEX", "**** Exception <?> received when dumping Java stack.");
                            DvJavacoreSov.outputFlush();
                            exception.printStackTrace();
                        }
                        try {
                            if (dvThread == null || dvThread.getNativeStack() == null || dvThread.getNativeStack().getNumFrames() <= 0L) continue;
                            DvJavacoreSov.printWithTag("3HPNATIVESTACK", "        Native Stack");
                            DvJavacoreSov.printWithTag("NULL", "        ------------");
                            n = 0;
                            while ((long)n < dvThread.getNativeStack().getNumFrames()) {
                                object = dvThread.getNativeStack().getFrame(n);
                                if (as.pointerSize() == 4) {
                                    DvJavacoreSov.printWithTag("4HPTRACEBACK", "        at " + Integer.toHexString((int)((DvNativeFrame)object).getPc()) + " in " + ((DvNativeFrame)object).toString());
                                } else {
                                    DvJavacoreSov.printWithTag("4HPTRACEBACK", "        at " + Long.toHexString(((DvNativeFrame)object).getPc()) + " in " + ((DvNativeFrame)object).toString());
                                }
                                ++n;
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            DvJavacoreSov.printWithTag("4XMNATIVESTCKEX", "**** Exception <?> received when dumping native stack.");
                            DvJavacoreSov.outputFlush();
                            exception.printStackTrace();
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        output.add("*** Exception received processing a thread\n" + exception.getMessage());
                        DvJavacoreSov.outputFlush();
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            output.add("*** Exception received while traversing Thread Stacks\n" + exception.getMessage());
            DvJavacoreSov.outputFlush();
            exception.printStackTrace();
        }
    }

    public static void doCLSection() {
        Object object;
        Enumeration enumeration;
        String string;
        String string2;
        long l;
        int n;
        String string3;
        int n2;
        DvJavacoreSov.newSection("CL");
        Properties properties = new Properties();
        Hashtable hashtable = new Hashtable();
        Properties properties2 = new Properties();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        DvObjectsCommands dvObjectsCommands = DvObjectsCommands.getCurrentInstance();
        DvJavacoreSov.printWithTag("1CLFLAGOLDJAVA", "Oldjava mode <n/a>");
        DvJavacoreSov.printWithTag("1CLFLAGBOOTSTRP", "Bootstrapping <n/a>");
        DvJavacoreSov.printWithTag("1CLFLAGVERBOSE", "Verbose class dependencies <n/a>");
        DvJavacoreSov.printWithTag("1CLENUMVERIFY", "Class verification <n/a>");
        DvJavacoreSov.printWithTag("1CLPNTRNAMECLLO", "Namespace to classloader <n/a>");
        DvJavacoreSov.printWithTag("1CLPNTRCHAINLO", "Start of cache entry pool <n/a>");
        DvJavacoreSov.printWithTag("1CLPNTRCHFREE", "Start of free cache entries <n/a>");
        DvJavacoreSov.printWithTag("1CLPNTRMETHODTB", "Location of method table <n/a>");
        DvJavacoreSov.printWithTag("1CLPNTRANCHRGLN", "Global namespace anchor <n/a>");
        DvJavacoreSov.printWithTag("1CLPNTRCLSLOADS", "System classloader shadow <n/a>");
        DvJavacoreSov.printWithTag("1CLPNTRSYSLOADS", "Classloader shadows <n/a>");
        DvJavacoreSov.printWithTag("1CLPNTRCLSEXT", "Extension loader <n/a>");
        DvJavacoreSov.outputFlush();
        String[] stringArray = DvClassCommands.classAddressList();
        try {
            DvJavacoreSov.outputFlush();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string3 = stringArray[n2];
                if (string3 == null) continue;
                n = string3.indexOf("0x");
                if (-1 != n) {
                    string3 = string3.substring(n + 2);
                }
                if ((l = DvJavacoreSov.getLoaderFromClass(Long.parseLong(string3, 16))) == -1L) {
                    throw new RuntimeException("getLoaderFromClass returned -1!");
                }
                string2 = "0x" + Long.toHexString(l);
                if (properties.getProperty(string2) == null) {
                    try {
                        string = "<UNKNOWN>";
                        string = string2.equals("0x0") ? "*SYSTEM*" : dvObjectsCommands.getObjectNameAtAddress(l);
                        properties.setProperty(string2, string);
                        properties2.setProperty(string, string2);
                        hashtable.put(string2, new Vector());
                        hashtable2.put(string2, new Integer(0));
                    }
                    catch (Exception exception) {
                        output.add("*** Unexpected exception received in new ClassLoader section");
                        DvJavacoreSov.outputFlush();
                        exception.printStackTrace();
                    }
                }
                DvJavacoreSov.outputFlush();
            }
        }
        catch (Exception exception) {
            DvJavacoreSov.outputFlush();
            System.out.println("*** Error: unexpected exception received in doCLSection()");
            exception.printStackTrace();
        }
        try {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string3 = stringArray[n2];
                if (string3 == null) continue;
                n = string3.indexOf("0x");
                if (-1 != n) {
                    string3 = string3.substring(n + 2);
                }
                if ((l = DvJavacoreSov.getLoaderFromClass(Long.parseLong(string3, 16))) == -1L) {
                    throw new RuntimeException("getLoaderFromClass returned -1!");
                }
                string2 = "0x" + Long.toHexString(l);
                string = "<NOT A VALID CLASS>";
                long l2 = Long.parseLong(string3, 16);
                if (dvObjectsCommands.getObjectNameAtAddress(l2).equals("java/lang/Class")) {
                    string = dvObjectsCommands.getClassNameAtAddress(l2) + "(0x" + string3 + ")";
                } else {
                    output.add("*** Error: address 0x" + string3 + " is not the address of a class!!");
                }
                Vector vector = (Vector)hashtable.get(string2);
                vector.add(string);
                Integer n3 = (Integer)hashtable2.get(string2);
                n3 = new Integer(n3 + 1);
                hashtable2.put(string2, n3);
                DvJavacoreSov.outputFlush();
            }
        }
        catch (Exception exception) {
            DvJavacoreSov.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 3");
            exception.printStackTrace();
        }
        try {
            DvJavacoreSov.printWithTag("1CLTEXTCLLOS", "Classloader summaries");
            DvJavacoreSov.printWithTag("1CLTEXTCLLSS", "        12345678: 1=primordial,2=extension,3=shareable,4=middleware,5=system,6=trusted,7=application,8=delegating");
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                String string5 = properties2.getProperty(string4);
                object = (Integer)hashtable2.get(string5);
                if (string4.equals("*SYSTEM*")) {
                    DvJavacoreSov.printWithTag("2CLTEXTCLLOADER", "        -------- Loader " + string4 + " (" + string5 + ")" + ", Shadow 0x00000000");
                } else {
                    DvJavacoreSov.printWithTag("2CLTEXTCLLOADER", "        -------- Loader " + string4 + " (" + string5 + ")" + ", Shadow 0x<n/a>, " + "[Parent <n/a>(0x<n/a>)]");
                }
                DvJavacoreSov.printWithTag("3CLNMBRLOADEDCL", "                Number of loaded classes " + object);
                DvJavacoreSov.printWithTag("3CLNMBRCACHECLS", "                Number of cached classes <n/a>");
                DvJavacoreSov.printWithTag("3CLHEXDALLOCTIO", "                Allocation used for loaded classes <n/a>");
                if (string4.equals("*SYSTEM*")) {
                    DvJavacoreSov.printWithTag("3CLHEXDPCKGEOWN", "                Package owner 0x00000000");
                } else {
                    DvJavacoreSov.printWithTag("3CLHEXDPCKGEOWN", "                Package owner 0x<n/a>");
                }
                DvJavacoreSov.outputFlush();
            }
        }
        catch (Exception exception) {
            DvJavacoreSov.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 4");
            exception.printStackTrace();
        }
        try {
            DvJavacoreSov.printWithTag("1CLTEXTCLLOD", "ClassLoader loaded classes");
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                String string6 = properties.getProperty(string3);
                DvJavacoreSov.printWithTag("2CLTEXTCLLOAD", "        Loader " + string6 + "(" + string3 + ")");
                Vector vector = (Vector)hashtable.get(string3);
                object = vector.elements();
                while (object.hasMoreElements()) {
                    string2 = (String)object.nextElement();
                    DvJavacoreSov.printWithTag("3CLTEXTCLASS", "                " + string2);
                }
            }
        }
        catch (Exception exception) {
            DvJavacoreSov.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 5");
            exception.printStackTrace();
        }
        DvJavacoreSov.outputFlush();
    }

    public static void doENDSection() {
        DvJavacoreSov.printWithTag("NULL", "---------------------------------------------------------------");
        DvJavacoreSov.printWithTag("0SECTION", "Javadump End section");
        DvJavacoreSov.printWithTag("1DGJDUMP", "Javadump Buffer Usage Information");
        DvJavacoreSov.printWithTag("NULL", "=================================");
        CTypeObject cTypeObject = dgData.getField("printBufferSize");
        if (cTypeObject != null) {
            int n = DvJavacoreSov.readAnInt(cTypeObject);
            if (n != -1) {
                DvJavacoreSov.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): " + n);
            } else {
                DvJavacoreSov.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): <ERROR2>");
            }
        } else {
            DvJavacoreSov.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): <ERROR1>");
        }
        CTypeObject cTypeObject2 = dgData.getField("printBufferP");
        CTypeObject cTypeObject3 = dgData.getField("printBuffer");
        if (cTypeObject2 == null || cTypeObject3 == null) {
            DvJavacoreSov.printWithTag("2DGJDUMPUSED", "Javadump buffer size (used)     : <ERROR3>");
        } else {
            long l = DvJavacoreSov.readPtrAsLong(cTypeObject2);
            long l2 = DvJavacoreSov.readPtrAsLong(cTypeObject3);
            long l3 = l - l2;
            DvJavacoreSov.printWithTag("2DGJDUMPUSED", "Javadump buffer size (used)     : " + l3);
        }
        DvJavacoreSov.printWithTag("NULL", "------------------ END OF DUMP --------------------------------");
        DvJavacoreSov.outputFlush();
    }

    protected static void initStatics() {
        if (DvJavacoreSov.noDumpAccessed()) {
            return;
        }
        DvDump dvDump = DvConsole.theDump;
        staticsInitialised = true;
        myThread = (DvThread)DvUtils.getAPT(dvDump, "T");
        ee = new CTypeObject("execenv", myThread.eeAddress(), as);
        jvm = ee.getField("jvmP").deReference();
        dgData = jvm.getField("facade.dg.dataP").deReference("DgData");
        xeData = jvm.getField("facade.xe.dataP").deReference("XeData");
        stData = jvm.getField("facade.st.dataP").deReference("STGlobal");
        if (dgData == null) {
            DvJavacoreSov.outputAdd("*** dgData is NULL ***");
        }
        if (xeData == null) {
            DvJavacoreSov.outputAdd("*** xeData is NULL ***");
        }
        if (stData == null) {
            DvJavacoreSov.outputAdd("*** stData is NULL ***");
        }
        DvJavacoreSov.outputFlush();
    }

    private static long getLoaderFromClass(long l) {
        CTypeObject cTypeObject;
        long l2 = -1L;
        CTypeObject cTypeObject2 = null;
        DvAddress dvAddress = as.createAddress(l);
        String string = "Hjava_lang_Class";
        if (DvUtils.checkAddressInDump(dvAddress, as) && (cTypeObject2 = DvUtils.formatAddrAsType(as, dvAddress, string)) != null && (cTypeObject = cTypeObject2.getField("obj.mirrored_data.loader")) != null) {
            l2 = DvJavacoreSov.readPtrAsLong(cTypeObject);
        }
        return l2;
    }

    static {
        ptrLength = 4;
        commandsSupported = new String[0];
        mySuffixes = new String[]{"sov"};
    }
}

