/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvHeap;
import com.ibm.jvm.dump.format.DvMonitor;
import com.ibm.jvm.dump.format.DvMonitorsRepository;
import com.ibm.jvm.dump.format.DvNamesIndexFile;
import com.ibm.jvm.dump.format.DvObject;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvThreadDetails;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import com.ibm.jvm.dump.plugins.DvGeneralSov;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvObjectsCommands
extends CommandPlugin {
    protected static String objSummary;
    private static CommandPlugin golCP;
    private static Method golMethod;
    private static CommandPlugin ckoCP;
    private static Method ckoMethod;
    private static CommandPlugin postDisOsCP;
    private static Method postDisOsMethod;
    private static DvMonitorsRepository monitorsRepository;
    private static String thisName;
    private static Vector theOutput;
    private static final String oSeperator = "\n============================================";
    public static boolean heapsTraversed;
    private static boolean unknownSystem;
    private static long[] storedObjAddresses;
    private static int soaPosition;
    private static int ptrLength;
    private static boolean is64bit;
    private static boolean isBigEndian;
    private static boolean verboseTLH;
    public static DvNamesIndexFile namesIndexFile;
    private static boolean address_index_built;
    public static boolean names_index_built;
    public static DvHeap scanner;
    private static byte[] lockedAllocBits;
    private static long startOfMHeap;
    private static long endOfMHeap;
    private static long startOfTransHeap;
    private static long endOfTransHeap;
    public static DvObjectsCommands that;
    private static String[] commandsSupported;
    private static DvThreadDetails dvThreadDetails;
    private static DvAddressSpace as;

    public DvObjectsCommands() {
        ptrLength = DvUtils.pointerLength();
        that = this;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String pluginName() {
        return "Object commands Plugin";
    }

    public void reset() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.reset");
        this.cpr.output(theOutput);
        theOutput.clear();
        heapsTraversed = false;
        unknownSystem = false;
        lockedAllocBits = null;
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        ptrLength = 0;
        names_index_built = false;
        address_index_built = false;
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.reset");
    }

    public void displayObjects() {
        String string;
        Object object;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObjects");
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        DvDump dvDump = DvConsole.theDump;
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null == this.paramString) {
            theOutput.add("\"dis obj\" without parameters is invalid ... did you mean \"dis os\"?");
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayObjects");
            return;
        }
        if (null != this.paramString) {
            try {
                if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                    long l = Long.parseLong(this.paramString.substring(2), 16);
                    if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                        theOutput.add("Not a valid address");
                        this.returnControl();
                        DvUtils.writetoTrace("Exit: 3 DvObjectsCommands.displayObjects");
                        return;
                    }
                    if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
                        DvObject dvObject = scanner.getObjectDetails(l - (long)ptrLength);
                        this.showObjects(dvObject);
                    } else {
                        theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                    }
                    this.returnControl();
                    DvUtils.writetoTrace("Exit:4 DvObjectsCommands.displayObjects");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.returnControl();
                DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displayObjects The address is not valid hex");
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.returnControl();
                DvUtils.writetoTrace("Exit:6 DvObjectsCommands.displayObjects noStringIndexOutOfBoundsException:The address is not valid");
                return;
            }
            if (Character.isDigit(this.paramString.charAt(0))) {
                this.returnControl();
                DvUtils.writetoTrace("Exit:7 DvObjectsCommands.displayObjects Object names must start with letter");
                return;
            }
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken().trim();
                if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                    bl = true;
                }
                vector.add(string);
            }
        }
        if (vector.size() > 0 && !bl) {
            for (int i = 0; i < vector.size(); ++i) {
                int n;
                string = (String)vector.get(i);
                long[] lArray = namesIndexFile.getInstancesForClass(string);
                if (null == lArray) continue;
                if (!string.startsWith("+")) {
                    for (n = 0; n < lArray.length; ++n) {
                        DvObject dvObject = scanner.getObjectDetails(lArray[n]);
                        this.showObjects(dvObject);
                    }
                    continue;
                }
                for (n = 0; n < lArray.length; ++n) {
                    theOutput.add(string + " : 0x" + Long.toHexString(lArray[n]));
                }
            }
        } else {
            object = namesIndexFile.getAllClassNames();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                long[] lArray;
                String string2 = (String)((Vector)object).get(i);
                boolean bl2 = true;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(string2, vector);
                }
                if (!bl2 || null == (lArray = namesIndexFile.getInstancesForClass(string2))) continue;
                for (int j = 0; j < lArray.length; ++j) {
                    DvObject dvObject = scanner.getObjectDetails(lArray[j]);
                    this.showObjects(dvObject);
                }
            }
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:8 DvObjectsCommands.displayObjects");
    }

    public void displayObjectSummary() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObjectSummary (nongui) ");
        boolean bl = false;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvObjectsCommands.displayObjectSummary(vector2, null);
        if (0 != vector2.size()) {
            for (int i = 0; i < vector2.size(); ++i) {
                theOutput.add(vector2.get(i));
            }
        }
        theOutput.add("Finished..");
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayObjectSummary (nongui)");
    }

    public static boolean displayObjectSummary(Vector vector, Object object) {
        String string;
        Object object2;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObjectSummary (joint) ");
        int n = 1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector vector2 = new Vector();
        vector.clear();
        if (null == object) {
            if (null == DvObjectsCommands.that.enhancers && null != DvObjectsCommands.that.paramString) {
                DvObjectsCommands.that.enhancers = DvUtils.splitIntoPieces(DvObjectsCommands.that.paramString, " ");
            }
            if (null != DvObjectsCommands.that.enhancers) {
                boolean bl4 = false;
                object2 = new String[]{"i", "t", "n", "a", "d"};
                if (that.enhancersCheck((String[])object2)) {
                    if (that.enhancerIsPresent("i")) {
                        n = 1;
                    } else if (that.enhancerIsPresent("t")) {
                        n = 2;
                    } else if (that.enhancerIsPresent("n")) {
                        n = 0;
                    }
                    if (that.enhancerIsPresent("a")) {
                        bl = true;
                    } else if (that.enhancerIsPresent("d")) {
                        bl = false;
                    }
                }
            }
        }
        if (DvMonitorsRepository.that == null) {
            monitorsRepository = new DvMonitorsRepository();
        } else {
            DvMonitorsRepository.reset();
        }
        if (null == dvThreadDetails) {
            dvThreadDetails = new DvThreadDetails();
        }
        is64bit = DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(DvConsole.theDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (!heapsTraversed) {
            objSummary = null;
            DvObjectsCommands.traverseAllHeaps(object);
        }
        if (null == (string = DvMonitorsRepository.checkLockingData())) {
            DvMonitorsRepository.processMonitors(vector);
        } else if (null != string) {
            vector.add("\n" + string + "\n");
        }
        dvThreadDetails.processThreads();
        vector.add(scanner.getObjectSummary());
        if (null == postDisOsCP) {
            object2 = DvUtils.findMethodForCurrentSuffix("postDisOsInfo", new Class[0]);
            postDisOsCP = (CommandPlugin)((Vector)object2).get(0);
            postDisOsMethod = (Method)((Vector)object2).get(1);
        }
        try {
            object2 = (Vector)postDisOsMethod.invoke((Object)postDisOsCP, new Object[0]);
            vector.add(object2);
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception trying to find postDisOsInfo supporting " + DvUtils.getSuffix(), 0, true);
            vector.add("*** Exception trying to find postDisOsInfo supporting ");
            String string2 = exception.toString();
            vector.add(string2);
            DvUtils.trace(string2, 0, true);
        }
        vector.add(namesIndexFile.summary(n, bl));
        DvUtils.writetoTrace("Exit:DvObjectsCommands.displayObjectSummary (joint) ");
        return true;
    }

    public void displayLocks() {
        String string;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayLocks");
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        DvDump dvDump = DvConsole.theDump;
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null == this.paramString) {
            theOutput.add("This commands needs a parameter\n");
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayLocks");
            return;
        }
        try {
            if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                long l = Long.parseLong(this.paramString.substring(2), 16);
                if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                    theOutput.add("Not a valid address");
                    this.returnControl();
                    DvUtils.writetoTrace("Exit:3 DvObjectsCommands.displayLocks");
                    return;
                }
                if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
                    DvObject dvObject = scanner.getObjectDetails(l - (long)ptrLength);
                    this.showObjects(dvObject);
                } else {
                    theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                }
                this.returnControl();
                DvUtils.writetoTrace("Exit:4 DvObjectsCommands.displayLocks");
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displayLocks The address is not valid hex");
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:6 DvObjectsCommands.displayLocks StringIndexOutOfBoundsException:The address is not valid");
            return;
        }
        if (Character.isDigit(this.paramString.charAt(0))) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:7 DvObjectsCommands.displayLocks Object names must start with letter");
            return;
        }
        Object object = new StringTokenizer(this.paramString, ",");
        while (((StringTokenizer)object).hasMoreTokens()) {
            string = ((StringTokenizer)object).nextToken().trim();
            if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                bl = true;
            }
            vector.add(string);
        }
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (vector.size() > 0 && !bl) {
            for (int i = 0; i < vector.size(); ++i) {
                string = (String)vector.get(i);
                long[] lArray = namesIndexFile.getInstancesForClass(string);
                if (null == lArray) continue;
                for (int j = 0; j < lArray.length; ++j) {
                    DvObject dvObject = scanner.getObjectDetails(lArray[j]);
                    this.showLocks(dvObject);
                }
            }
        } else {
            object = namesIndexFile.getAllClassNames();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                long[] lArray;
                String string2 = (String)((Vector)object).get(i);
                boolean bl2 = true;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(string2, vector);
                }
                if (!bl2 || null == (lArray = namesIndexFile.getInstancesForClass(string2))) continue;
                for (int j = 0; j < lArray.length; ++j) {
                    DvObject dvObject = scanner.getObjectDetails(lArray[j]);
                    this.showLocks(dvObject);
                }
            }
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:8 DvObjectsCommands.displayLocks");
    }

    public void displayLockSummary() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayLockSummary");
        DvDump dvDump = DvConsole.theDump;
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        theOutput.add("");
        theOutput.add("");
        theOutput.add("LOCKING INFORMATION:");
        theOutput.add("");
        String string = DvMonitorsRepository.checkLockingData();
        if (null == string) {
            theOutput.addAll(DvMonitorsRepository.displayMonitorPoolDump("dis ls", null));
            theOutput.addAll(DvMonitorsRepository.displaySysMonitorDump("dis ls"));
        } else {
            theOutput.add("\n" + string + "\n");
            DvUtils.writetoTrace("Continue:1 DvObjectsCommands.displayLockSummary No locking global pointer displayMonitorPoolDump(\"dis ls\")");
        }
        theOutput.addAll(this.displayThreadIdent("dis ls"));
        theOutput.addAll(DvMonitorsRepository.displayJavaObjMonDump("dis ls"));
        this.findDeadlock();
        theOutput.add("Finished..");
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayLockSummary");
    }

    private DvThread getDvThread(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getDvThread");
        DvProcess dvProcess = (DvProcess)DvUtils.getAPT(DvConsole.theDump, "P");
        DvThread[] dvThreadArray = dvProcess.getThreads();
        for (int i = 0; i < dvThreadArray.length; ++i) {
            if (!dvThreadArray[i].isJava() || string != dvThreadArray[i].id()) continue;
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getDvThread");
            return dvThreadArray[i];
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.getDvThread");
        return null;
    }

    private Vector displayThreadIdent(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayThreadIdent");
        dvThreadDetails.processThreads();
        Vector<String> vector = new Vector<String>();
        if (string.equals(new String("javacore"))) {
            vector.add("1LKFLATMONDUMP");
            vector.add("Thread identifiers (as used in flat monitors)");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
            vector.add("Thread Identifiers:");
            vector.add("");
        }
        for (int i = 0; i < DvThreadDetails.getThreadCount(); ++i) {
            Object object = DvThreadDetails.getThreadDetailsByPosition(i);
            if (string.equals(new String("javacore"))) {
                vector.add("2LKFLATMON");
                vector.add("    ident 0x" + Long.toHexString(DvThreadDetails.getThreadIdent(object)) + " \"" + DvThreadDetails.getThreadName(object) + "\" (0x" + Long.toHexString(DvThreadDetails.getSysThr(object)) + ") " + "ee 0x" + Long.toHexString(DvThreadDetails.getEE(object)));
            }
            if (!string.equals(new String("dis ls"))) continue;
            vector.add(DvThreadDetails.getThreadID(object) + " " + " \"" + DvThreadDetails.getThreadName(object) + "\"");
            vector.add("");
        }
        if (string.equals(new String("javacore"))) {
            vector.add("NULL");
            vector.add("");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
        }
        DvUtils.writetoTrace("Exit:3 DvObjectsCommands.displayThreadIdent unexpected exception");
        return vector;
    }

    public boolean displayObject(long l) throws DvAddressException {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObject(long)");
        DvDump dvDump = DvConsole.theDump;
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayObject(long) throw(Unable to comply as not a valid address)");
            throw new DvAddressException("Unable to comply as not a valid address");
        }
        if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
            DvObject dvObject = scanner.getObjectDetails(l - (long)ptrLength);
            this.showObjects(dvObject);
        } else {
            theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
        }
        DvUtils.writetoTrace("Exit:3 DvObjectsCommands.displayObject(long)");
        return false;
    }

    public boolean displayObject(String string) throws DvAddressException {
        int n;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObject(String)");
        DvDump dvDump = DvConsole.theDump;
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        long[] lArray = namesIndexFile.getInstancesForClass(string);
        if (null != lArray && (n = 0) < lArray.length) {
            DvObject dvObject = scanner.getObjectDetails(lArray[n]);
            this.showObjects(dvObject);
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayObject(String)");
            return true;
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayObject(String)");
        return false;
    }

    public void displayLockedObjects() {
        String string;
        Object object;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayLockedObjects()");
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        DvDump dvDump = DvConsole.theDump;
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null == this.paramString) {
            this.paramString = "*";
        }
        if (null != this.paramString) {
            try {
                if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                    long l = Long.parseLong(this.paramString.substring(2), 16);
                    if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                        theOutput.add("Not a valid address");
                        this.returnControl();
                        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayLockedObjects()");
                        return;
                    }
                    if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
                        DvObject dvObject = scanner.getObjectDetails(l - (long)ptrLength);
                        if (dvObject.lock) {
                            this.showLocks(dvObject);
                        } else {
                            theOutput.add("Object is not locked");
                        }
                    } else {
                        theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                    }
                    this.returnControl();
                    DvUtils.writetoTrace("Exit:3 DvObjectsCommands.displayLockedObjects()");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                theOutput.add("The address is not valid hex");
                this.returnControl();
                DvUtils.writetoTrace("Exit:4 DvObjectsCommands.displayLockedObjects() the address is not valid hex");
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                theOutput.add("The address is not valid     StringIndexOutOfBoundsException:");
                this.returnControl();
                DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displayLockedObjects() StringIndexOutOfBoundsException: The address is not valid");
                return;
            }
            if (Character.isDigit(this.paramString.charAt(0))) {
                theOutput.add("Object names must start with letter");
                this.returnControl();
                DvUtils.writetoTrace("Exit:6 DvObjectsCommands.displayLockedObjects() Object names must start with letter");
                return;
            }
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken().trim();
                if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                    bl = true;
                }
                vector.add(string);
            }
        }
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (vector.size() > 0 && !bl) {
            for (int i = 0; i < vector.size(); ++i) {
                string = (String)vector.get(i);
                Vector vector2 = DvGeneralSov.getLockedObjectsVector();
                for (int j = 0; j < vector2.size(); ++j) {
                    long l = (Long)vector2.get(j);
                    DvObject dvObject = scanner.getObjectDetails(l);
                    if (!string.equals(dvObject.objectName)) continue;
                    this.showLocks(dvObject);
                }
            }
        } else {
            object = DvGeneralSov.getLockedObjectsVector();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                long l = (Long)((Vector)object).get(i);
                DvObject dvObject = scanner.getObjectDetails(l);
                boolean bl2 = false;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(dvObject.objectName, vector);
                }
                if (!bl2) continue;
                this.showLocks(dvObject);
            }
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:7 DvObjectsCommands.displayLockedObjects()");
    }

    public void displayThreads() {
        Object object;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayThreads");
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>();
        DvDump dvDump = DvConsole.theDump;
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null == this.paramString) {
            dvThreadDetails.processThreads();
            for (int i = 0; i < DvThreadDetails.getThreadCount(); ++i) {
                Object object2 = DvThreadDetails.getThreadDetailsByPosition(i);
                this.showThread(object2);
            }
            theOutput.add("Finished..");
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayThreads");
            return;
        }
        if (null != this.paramString) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (((String)object).startsWith("*") || ((String)object).endsWith("*") || ((String)object).startsWith("!")) {
                    bl = true;
                }
                vector.add(object);
            }
        }
        dvThreadDetails.processThreads();
        if (vector.size() > 0) {
            for (int i = 0; i < DvThreadDetails.getThreadCount(); ++i) {
                object = DvThreadDetails.getThreadDetailsByPosition(i);
                String string = DvThreadDetails.getThreadName(object);
                String string2 = DvThreadDetails.getThreadID(object);
                boolean bl2 = true;
                if (0 != vector.size()) {
                    boolean bl3 = bl2 = DvUtils.filtrate(string, vector) || DvUtils.filtrate(string2, vector);
                }
                if (!bl2) continue;
                this.showThread(object);
            }
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:8 DvObjectsCommands.displayThreads");
    }

    public void displayLockedReg() {
        Object object;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayReg");
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        if (null == DvConsole.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayReg");
            return;
        }
        is64bit = DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(DvConsole.theDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (null == this.paramString) {
            DvMonitorsRepository.processMonitors(theOutput);
            Vector vector2 = DvMonitorsRepository.getRegMonListVector();
            for (int i = 0; i < vector2.size(); ++i) {
                Object e = vector2.elementAt(i);
                theOutput.add(DvMonitorsRepository.showReg(e));
                theOutput.add("");
            }
            theOutput.add("Finished..");
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayReg");
            return;
        }
        if (null != this.paramString) {
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                    bl = true;
                }
                vector.add(string);
            }
        }
        DvMonitorsRepository.processMonitors(theOutput);
        if (vector.size() > 0) {
            object = DvMonitorsRepository.getRegMonListVector();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                DvMonitor dvMonitor = (DvMonitor)((Vector)object).elementAt(i);
                String string = dvMonitor.getName();
                String string2 = "0x" + Long.toHexString(dvMonitor.getAddress());
                boolean bl2 = true;
                if (0 != vector.size()) {
                    boolean bl3 = bl2 = DvUtils.filtrate(string, vector) || DvUtils.filtrate(string2, vector);
                }
                if (!bl2) continue;
                theOutput.add(DvMonitorsRepository.showReg(dvMonitor));
                theOutput.add("");
            }
        }
        theOutput.add("Finished..");
        this.returnControl();
        DvUtils.writetoTrace("Exit:8 DvObjectsCommands.displayReg");
    }

    public void findDeadlockVerbose() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.findDeadlockVerbose");
        this.findDeadlock(true);
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.findDeadlockVerbose");
    }

    public void findDeadlock() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.findDeadlock");
        this.findDeadlock(false);
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.findDeadlock");
    }

    public void findDeadlock(boolean bl) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.findDeadlock");
        if (null == DvConsole.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.findDeadlock");
            return;
        }
        DvMonitorsRepository.processMonitors(theOutput);
        Vector vector = DvMonitorsRepository.getDeadlocksVector();
        if (vector.size() != 0) {
            theOutput.add("\n\nDeadlock(s) detected !!!\n");
            DvMonitorsRepository.displayDeadlockChain(bl, theOutput);
        } else {
            theOutput.add("\nNo deadlocks detected\n");
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.findDeadlock");
    }

    public static Vector lkDumpRoutine() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.lkDumpRoutine()");
        Vector<String> vector = new Vector<String>();
        DvObjectsCommands dvObjectsCommands = DvObjectsCommands.getCurrentInstance();
        vector.addAll(DvMonitorsRepository.displayMonitorPoolInfo("javacore"));
        String string = DvMonitorsRepository.checkLockingData();
        if (null == string) {
            vector.addAll(DvMonitorsRepository.displayMonitorPoolDump("javacore", null));
            vector.addAll(DvMonitorsRepository.displaySysMonitorDump("javacore"));
        } else {
            vector.add("\n" + string + "\n");
            DvUtils.writetoTrace("Continue:1 DvObjectsCommands.lkDumpRoutine() No locking global pointer displayMonitorPoolDump(\"dis ls\",null)");
        }
        vector.addAll(dvObjectsCommands.displayThreadIdent("javacore"));
        vector.addAll(DvMonitorsRepository.displayJavaObjMonDump("javacore"));
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.lkDumpRoutine()");
        return vector;
    }

    private void showObjects(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.showObjects(ObjectDetails)");
        theOutput.add(oSeperator);
        theOutput.add(dvObject);
        if (null != dvObject) {
            theOutput.add(DvClassCommands.getInstanceValues(dvObject.address, dvObject.objectName, DvConsole.theDump, theOutput));
        } else {
            theOutput.add(" ---- Null or invalid object ---- ");
        }
        this.cpr.output(theOutput);
        theOutput.clear();
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.showObjects(ObjectDetails)");
    }

    private void showLocks(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.showLocks(ObjectDetails)");
        String string = "";
        if (null != dvObject.className) {
            string = dvObject.className;
        }
        if (dvObject.lock) {
            if (0L == dvObject.shapeBit) {
                dvThreadDetails.processThreads();
                Object object = DvThreadDetails.getThreadDetailsById(Long.toHexString(dvObject.threadId));
                if (object != null) {
                    theOutput.add("");
                    theOutput.add("    (0x" + Long.toHexString(dvObject.address) + ") " + dvObject.objectName + " ");
                    theOutput.add("        flat locked by " + DvThreadDetails.getThreadID(object) + " \"" + DvThreadDetails.getThreadName(object) + "\", entry count " + dvObject.entryCount + " " + string);
                }
                DvMonitorsRepository.processMonitors(theOutput);
                Vector vector = DvMonitorsRepository.getInflMonListVector();
                for (int i = 0; i < vector.size(); ++i) {
                    DvMonitor dvMonitor = (DvMonitor)vector.elementAt(i);
                    long l = dvMonitor.getObjectAddress();
                    if (l != dvObject.address || 0L >= dvMonitor.getWaiterSize()) continue;
                    theOutput.add("            Waiting to be notified:");
                    int n = 0;
                    while ((long)n < dvMonitor.getWaiterSize()) {
                        theOutput.add("               " + DvUtils.rJustify("0x" + dvMonitor.getWaiterThreadID(n), 10) + " \"" + dvMonitor.getWaiterName(n) + "\" ");
                        ++n;
                    }
                }
            } else {
                theOutput.add("");
                theOutput.addAll(DvMonitorsRepository.displayMonitorPoolDump("dis lo", dvObject));
            }
        } else {
            theOutput.add("@ 0x" + Long.toHexString(dvObject.address) + " (" + dvObject.objectName + ") " + string + "          type:" + dvObject.type);
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.showLocks(ObjectDetails)");
    }

    private void showThread(Object object) {
        int n;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.showThread(ThreadDetails)");
        theOutput.add(DvThreadDetails.getThreadID(object) + " \"" + DvThreadDetails.getThreadName(object) + "\"");
        DvMonitorsRepository.processMonitors(theOutput);
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        boolean bl = false;
        long l = DvThreadDetails.getSysThr(object);
        Vector vector = DvMonitorsRepository.getInflMonListVector();
        for (n = 0; n < vector.size(); ++n) {
            DvMonitor dvMonitor = (DvMonitor)vector.elementAt(n);
            if (0L >= dvMonitor.getWaiterSize()) continue;
            int n2 = 0;
            while ((long)n2 < dvMonitor.getWaiterSize()) {
                if (dvMonitor.getWaiterAddress(n2) == l) {
                    theOutput.add("    waiting on: (0x" + Long.toHexString(dvMonitor.getObjectAddress()) + ") " + dvMonitor.getObjectName());
                    bl = true;
                }
                ++n2;
            }
        }
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            DvMonitor dvMonitor = (DvMonitor)vector.elementAt(i);
            if (dvMonitor.getOwnerAddress() != l) continue;
            long l2 = 4 == DvConsole.theDump.getSystemType() ? DvUtils.getControlBlockFieldInt("sys_mon", "monitor_usecount", dvMonitor.getSysMon(), as) : DvUtils.getControlBlockFieldInt("sys_mon", "entry_count", dvMonitor.getSysMon(), as);
            if (n == 0) {
                theOutput.add("        Owns Objects:");
                n = 1;
            }
            theOutput.add("                infl lock on (0x" + Long.toHexString(dvMonitor.getObjectAddress()) + ") " + dvMonitor.getObjectName() + " " + ", entry count " + l2);
            bl = true;
        }
        long l3 = DvThreadDetails.getThreadIdent(object);
        Hashtable<Long, DvObject> hashtable = DvMonitorsRepository.getLockedObjectsByAddrHashTable();
        Vector vector2 = DvGeneralSov.getLockedObjectsVector();
        boolean bl2 = false;
        if (null == hashtable) {
            bl2 = true;
            hashtable = new Hashtable<Long, DvObject>();
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Long l4 = (Long)vector2.get(i);
            long l5 = l4;
            DvObject dvObject = null;
            if (bl2) {
                dvObject = scanner.getObjectDetails(l5);
                hashtable.put(l4, dvObject);
            } else {
                dvObject = (DvObject)hashtable.get(l4);
            }
            if (!dvObject.lock || 0L != dvObject.shapeBit || dvObject.threadId != l3) continue;
            if (n == 0) {
                theOutput.add("        Owns Objects:");
                n = 1;
            }
            theOutput.add("          flat lock on (0x" + Long.toHexString(dvObject.address) + ") " + dvObject.objectName + " " + ", entry count " + dvObject.entryCount + " ");
            bl = true;
        }
        n = 0;
        Vector vector3 = DvMonitorsRepository.getRegMonListVector();
        for (int i = 0; i < vector3.size(); ++i) {
            DvMonitor dvMonitor = (DvMonitor)vector3.elementAt(i);
            if (dvMonitor.getOwnerAddress() != l) continue;
            long l6 = 4 == DvConsole.theDump.getSystemType() ? DvUtils.getControlBlockFieldInt("sys_mon", "monitor_usecount", dvMonitor.getSysMon(), as) : DvUtils.getControlBlockFieldInt("sys_mon", "entry_count", dvMonitor.getSysMon(), as);
            if (bl) {
                theOutput.add("");
                bl = false;
            }
            if (n == 0) {
                theOutput.add("        Owns Registered Monitors:");
                n = 1;
            }
            theOutput.add("                lock on (0x" + Long.toHexString(dvMonitor.getAddress()) + ") " + dvMonitor.getName() + " " + ", entry count " + l6);
        }
        theOutput.add("");
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.showThread(ThreadDetails)");
    }

    public static void traverseAllHeaps(Object object) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseAllHeaps()");
        if (null == namesIndexFile) {
            DvObjectsCommands.openNamesIndexFile();
        }
        DvConsole.bHeapTraversalInprogress = true;
        boolean bl = false;
        if (null == scanner) {
            scanner = new DvHeap();
        }
        if (null != scanner) {
            bl = scanner.doScan(DvObjectsCommands.that.cpr);
        }
        if (bl) {
            heapsTraversed = true;
            namesIndexFile.commit();
            names_index_built = true;
            address_index_built = true;
        } else {
            theOutput.add("\n********\nScan of the heap(s) failed!\n*********\n");
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.traverseAllHeaps()");
    }

    private static long processMonitorIndex(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processMonitorIndex(ObjectDetails)");
        long l = dvObject.locknflags >> 8 & 0x7FFFFFL;
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processMonitorIndex(ObjectDetails)");
        return l;
    }

    private static long processInflMon(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processInflMon(ObjectDetails)");
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        long l = 0L;
        long l2 = 0L;
        l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
        l2 = Long.parseLong(DvUtils.getJVMHint(as, "DGGLOBALPTR"), 16);
        if (l == l2) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processInflMon(ObjectDetails) lk:dataP==dg:dataP");
            return 0L;
        }
        long l3 = dvObject.address;
        long l4 = 0L;
        try {
            long l5 = DvUtils.getControlBlockField("_lkgldata", "micb", l, as);
            long l6 = DvUtils.getControlBlockFieldInt("monitor_index_cb_t", "count", l5, as);
            long l7 = DvUtils.getControlBlockFieldInt("monitor_index_cb_t", "size", l5, as);
            long l8 = DvUtils.getControlBlockField("monitor_index_cb_t", "table", l5, as);
            long l9 = l8 + (long)ptrLength * dvObject.monitorIndex;
            DvAddress dvAddress = as.createAddress(l9);
            dvAddress = as.readPointer(dvAddress);
            if (dvAddress != null) {
                l4 = dvAddress.getAddressAsLong();
            }
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in processInflMon");
            DvUtils.writetoTrace("Contine:1 DvObjectsCommands.processInflMon(ObjectDetails) DvAddressException");
        }
        catch (NumberFormatException numberFormatException) {
            theOutput.add("DvNumberFormatException in processInflMon");
            theOutput.add("Possible cause by not having hints setup properly");
            DvUtils.writetoTrace("Contine:2 DvObjectsCommands.processInflMon(ObjectDetails) NumberFormatException");
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processInflMon(ObjectDetails)");
        return l4;
    }

    private static boolean processLock(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processLocks(ObjectDetails)");
        if (0L != dvObject.threadId || 0L != dvObject.entryCount || 0L != dvObject.monitorIndex) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processLocks(ObjectDetails)");
            return true;
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processLocks(ObjectDetails)");
        return false;
    }

    protected static DvObjectsCommands getCurrentInstance() {
        DvUtils.writetoTrace("Entry/Exit:DvObjectsCommands.getCurrentInstance()");
        return that;
    }

    public static boolean heapsAlreadyTraversed() {
        return heapsTraversed;
    }

    public static void heapsNeedRetraversal() {
        DvUtils.writetoTrace("Entry: DvObjectsCommands.heapsNeedRetraversal()");
        DvConsole.bHeapTraversalInprogress = false;
        heapsTraversed = false;
        namesIndexFile = null;
        lockedAllocBits = null;
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        DvUtils.writetoTrace("Exit: DvObjectsCommands.heapsNeedRetraversal()");
    }

    protected String getObjectNameAtAddress(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getObjectNameAtAddress(long)");
        if (!heapsTraversed) {
            theOutput.add("Traversing Heaps!");
            this.cpr.output(theOutput);
            theOutput.clear();
            DvObjectsCommands.traverseAllHeaps(null);
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getObjectNameAtAddress(long)");
        return DvGeneralSov.processObjectName(l, as, null);
    }

    protected String getClassNameAtAddress(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getClassNameAtAddress(long)");
        if (!heapsTraversed) {
            theOutput.add("Traversing Heaps!");
            this.cpr.output(theOutput);
            theOutput.clear();
            DvObjectsCommands.traverseAllHeaps(null);
        }
        DvObject dvObject = new DvObject();
        dvObject.address = l;
        dvObject.objectName = "java/lang/Class";
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getClassNameAtAddress(long)");
        return DvGeneralSov.processClassName(dvObject);
    }

    private void returnControl() {
        this.cpr.output(theOutput);
        theOutput.clear();
        unknownSystem = false;
        this.forcedEnd = true;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public static Object getGenericHelp() {
        DvUtils.writetoTrace("Entry:DvObjectCommands.getGenericHelp");
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvObjectsCommands.properties");
        DvUtils.writetoTrace("Exit:1 DvObjectCommands.getGenericHelp");
        return vector;
    }

    public void doObjectHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("OBJHelp", "DvObjectsCommands.properties");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public static void openNamesIndexFile() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.openNamesIndexFile()");
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l = DvUtils.jvmFromThreadId(dvThread.id());
        String string = DvUtils.getJVMHint(l, "JVM");
        String string2 = DvUtils.getValue("Dump") + string;
        String string3 = DvUtils.getValue("WorkDir");
        if (null != string3) {
            string2 = DvUtils.stripToFileName(string2);
            string2 = string3 + string2;
        }
        try {
            int n = 0;
            namesIndexFile = new DvNamesIndexFile(string2, n);
            names_index_built = DvObjectsCommands.namesIndexFile.isComplete;
        }
        catch (IOException iOException) {
            System.err.println("JFOR003: Error creating NamesIndex");
            iOException.printStackTrace();
        }
        if (!names_index_built) {
            theOutput.add("Invalid or non-existent class names index file - scanning the dump");
            DvObjectsCommands.that.cpr.output(theOutput);
            theOutput.clear();
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.openNamesIndexFile()");
    }

    public void objectAnalyze() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.objectAnalyze()");
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.objectAnalyze()");
    }

    public static boolean checkForKnownObject(long l) {
        Serializable serializable;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.checkForKnownObject(long)");
        boolean bl = false;
        if (null == ckoCP) {
            serializable = DvUtils.findMethodForCurrentSuffix("checkForKnownObject", new Class[]{Long.class});
            ckoCP = (CommandPlugin)((Vector)serializable).get(0);
            ckoMethod = (Method)((Vector)serializable).get(1);
        }
        try {
            serializable = new Long(l);
            Boolean bl2 = (Boolean)ckoMethod.invoke((Object)ckoCP, serializable);
            bl = bl2;
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception using checkForKnownObject supporting " + DvUtils.getSuffix(), 0, true);
            String string = exception.toString();
            DvUtils.trace(string, 0, true);
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.checkForKnownObject(long)");
        return bl;
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.whatIs(DvAddress, String, DvDump)");
        String string2 = null;
        if (null != dvAddress) {
            if (!heapsTraversed) {
                string2 = "  DvObjectsCommands: Unable to establish if " + string + " is an object in a heap ...\n" + "    as heaps not yet traversed (run \"dis os\" and retry)";
            } else {
                Vector vector;
                Vector vector2;
                int n;
                int n2;
                boolean bl = false;
                string2 = "";
                long l = dvAddress.getAddressAsLong();
                String string3 = scanner.establishHeapName(l);
                if (null != string3) {
                    string2 = string2 + "  \"" + string + "\" is in heap \"" + string3 + "\"";
                    bl = true;
                } else {
                    string2 = string2 + "  \"" + string + "\" is not within a heap ";
                }
                if (bl) {
                    boolean bl2 = false;
                    n2 = 0;
                    n = 0;
                    if (0L == l % 8L) {
                        if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
                            string2 = string2 + "\n Its a known object (use \"dis obj ";
                            if (!string.startsWith("0x")) {
                                string2 = string2 + "0x";
                            }
                            string2 = string2 + string + "\" to view it)";
                            bl2 = true;
                        }
                        if (DvObjectsCommands.checkForKnownObject(l)) {
                            string2 = string2 + "\n It addresses length field of known object (use \"dis obj " + string + ptrLength + "\" to view it)";
                            n2 = 1;
                        }
                    } else if (0L == l % 4L && !DvUtils.is64BitSystem(dvDump.getArchitecture()) && DvObjectsCommands.checkForKnownObject(l + 4L - (long)ptrLength)) {
                        string2 = string2 + "\n It addresses length field of known object (use \"dis obj  0x" + Long.toHexString(l + 4L) + "\" to view it)";
                        n2 = 1;
                    }
                    if (0 == n2 && !bl2) {
                        long l2 = l - l % 8L;
                        boolean bl3 = false;
                        for (int i = 0; i < 4096 && !bl3; ++i) {
                            if (DvObjectsCommands.checkForKnownObject(l2 - (long)ptrLength)) {
                                bl3 = true;
                                continue;
                            }
                            l2 -= 8L;
                        }
                        if (bl3) {
                            DvObject dvObject = scanner.getObjectDetails(l2 - (long)ptrLength);
                            string2 = l2 - (long)ptrLength + dvObject.length > l ? string2 + "\n found object (" + dvObject.objectName + ") at " + Long.toHexString(l2) + " (length:" + dvObject.length + ")" + "\n\t....that covers this address (offset 0x" + Long.toHexString(l - l2) + ")" : string2 + "\n nearest object (" + dvObject.objectName + ") at " + Long.toHexString(l2) + " (length:" + dvObject.length + ")" + "\n\t....but it does not cover this address";
                        } else {
                            string2 = string2 + "\n Couldn't find an object covering \"" + string + "\"";
                        }
                    }
                }
                if (0 != (vector2 = DvMonitorsRepository.getRegMonListVector()).size()) {
                    for (n2 = 0; n2 < vector2.size(); ++n2) {
                        DvMonitor dvMonitor = (DvMonitor)vector2.elementAt(n2);
                        if (dvAddress.getAddressAsLong() != dvMonitor.getAddress()) continue;
                        string2 = string2 + "\n Its an registered Monitor\n";
                        string2 = string2 + "    name    " + dvMonitor.getName() + "\n";
                        string2 = string2 + "    to view registered monitor use \"dis lr 0x" + Long.toHexString(dvMonitor.getAddress()) + "\"\n";
                        string2 = string2 + "    to view sys_mon use \"for 0x" + Long.toHexString(dvMonitor.getSysMon()) + " as sys_mon\"\n";
                        if (0L != dvMonitor.getOwnerAddress()) {
                            string2 = string2 + "    locked by thread \"" + dvMonitor.getOwnerName() + "\"\n";
                        }
                        if (0L >= dvMonitor.getWaiterSize()) continue;
                        string2 = string2 + "    Waiting to be notified:\n";
                        int n3 = 0;
                        while ((long)n3 < dvMonitor.getWaiterSize()) {
                            string2 = string2 + "         \"" + dvMonitor.getWaiterName(n3) + "\"\n";
                            ++n3;
                        }
                    }
                }
                if (0 != (vector = DvMonitorsRepository.getInflMonListVector()).size()) {
                    for (n = 0; n < vector.size(); ++n) {
                        DvMonitor dvMonitor = (DvMonitor)vector.elementAt(n);
                        if (dvAddress.getAddressAsLong() != dvMonitor.getAddress()) continue;
                        string2 = string2 + "\n Its an inflated Monitor\n";
                        string2 = string2 + "    object    " + dvMonitor.getObjectName() + "\n";
                        string2 = string2 + "    to view infl_mon use \"for 0x" + Long.toHexString(dvMonitor.getAddress()) + " as infl_mon\"\n";
                        string2 = string2 + "    to view sys_mon use \"for 0x" + Long.toHexString(dvMonitor.getSysMon()) + " as sys_mon\"\n";
                        string2 = 0L != dvMonitor.getOwnerAddress() ? string2 + "    inflated locked by thread \"" + dvMonitor.getOwnerName() + "\"\n" : string2 + "    WARNING will not show flat locks!! because it is a inflated monitor\n";
                        if (0L >= dvMonitor.getWaiterSize()) continue;
                        string2 = string2 + "    Waiting to be notified:\n";
                        int n4 = 0;
                        while ((long)n4 < dvMonitor.getWaiterSize()) {
                            string2 = string2 + "         \"" + dvMonitor.getWaiterName(n4) + "\"\n";
                            ++n4;
                        }
                    }
                }
                if (0 != (n = DvThreadDetails.getThreadCount())) {
                    for (int i = 0; i < n; ++i) {
                        Object object = DvThreadDetails.getThreadDetailsByPosition(i);
                        if (!DvThreadDetails.getThreadID(object).equals(Long.toHexString(dvAddress.getAddressAsLong()))) continue;
                        string2 = string2 + "\n Its a thread\n";
                        string2 = string2 + "    name    " + DvThreadDetails.getThreadName(object) + "\n";
                        string2 = string2 + "    to view thread use \"dis thread " + DvThreadDetails.getThreadID(object) + "\"\n";
                    }
                }
            }
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.whatIs(DvAddress, String, DvDump)");
        return string2;
    }

    public static String getObjectDetailsAsString(long l) {
        DvObject dvObject = scanner.getObjectDetails(l);
        StringBuffer stringBuffer = new StringBuffer(dvObject.toString());
        stringBuffer.append(DvClassCommands.getInstanceValues(dvObject.address, dvObject.objectName, DvConsole.theDump, null));
        return stringBuffer.toString();
    }

    public static long getObjectLength(long l) {
        Serializable serializable;
        long l2 = 0L;
        if (null == golCP) {
            serializable = DvUtils.findMethodForCurrentSuffix("getObjectLength", new Class[]{Long.class});
            golCP = (CommandPlugin)((Vector)serializable).get(0);
            golMethod = (Method)((Vector)serializable).get(1);
        }
        try {
            serializable = new Long(l);
            Long l3 = (Long)golMethod.invoke((Object)golCP, serializable);
            l2 = l3;
        }
        catch (Exception exception) {
            DvUtils.trace("*** Exception trying to find getObjectLength supporting " + DvUtils.getSuffix(), 0, true);
            String string = exception.toString();
            DvUtils.trace(string, 0, true);
        }
        return l2;
    }

    static {
        monitorsRepository = null;
        thisName = "com.ibm.jvm.dump.plugins.DvObjectsCommands";
        theOutput = new Vector();
        heapsTraversed = false;
        unknownSystem = false;
        storedObjAddresses = new long[]{0L, 0L, 0L, 0L, 0L};
        soaPosition = 0;
        verboseTLH = false;
        address_index_built = false;
        names_index_built = false;
        scanner = null;
        lockedAllocBits = null;
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        commandsSupported = new String[]{"DISPLAY,DIS,OBJECT,obj,displayObjects,Y,Y", "DISP,D,OBJECT,obj,displayObjects,Y,Y", "DISPLAY,DIS,OB,o,displayObjects,Y,Y", "DISP,D,OB,o,displayObjects,Y,Y", "DISPLAY,DIS,OBJECTSUMMARY,os,displayObjectSummary,Y,N", "DISP,D,OBJECTSUMMARY,os,displayObjectSummary,Y,N", "DISPLAY,DIS,LOCK,loc,displayLocks,Y,Y", "DISP,D,LOCK,loc,displayLocks,Y,Y", "DISPLAY,DIS,LOCKSUMMARY,ls,displayLockSummary,Y,Y", "DISP,D,LOCKSUMMARY,ls,displayLockSummary,Y,Y", "DISPLAY,DIS,LOCKEDOBJECTS,lo,displayLockedObjects,Y,Y", "DISP,D,LOCKEDOBJECTS,lo,displayLockedObjects,Y,Y", "DISPLAY,DIS,THREADLOCKS,lt,displayThreads,Y,Y", "DISP,D,THREADLOCKS,lt,displayThreads,Y,Y", "DISPLAY,DIS,LOCKEDREGISTERS,lr,displayLockedReg,Y,Y", "DISP,D,LOCKEDREGISTERS,lr,displayLockedReg,Y,Y", "DEADLOCK,DL,VERBOSE,v,findDeadlockVerbose,Y,Y", "DEADLOCK,DL,*,*,findDeadlock,Y,Y", "HELP,?,DISOS,OS,doObjectHelp,N,N", "HELP,?,DISOBJ,OBJ,doObjectHelp,N,N", "HELP,?,LOCKS,LO,doObjectHelp,N,N", "HELP,?,OBJ,OBJECTS,doObjectHelp,N,N", "LOCKS,LOCK,?,HELP,doObjectHelp,N,N", "OBJECTS,OBJ,?,HELP,doObjectHelp,N,N"};
        dvThreadDetails = null;
    }
}

