/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.SubPool;
import com.ibm.jvm.dump.plugins.CpuDetails;
import com.ibm.jvm.dump.plugins.GcHelperDetails;
import com.ibm.jvm.dump.plugins.MarkStackDetails;
import com.ibm.jvm.dump.plugins.OutputStrategy;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;

public class STGlobalData {
    private static final int INT = 1;
    private static final int LONG = 2;
    private static final int POINTER = 3;
    private Map allItemGroups;
    private static final int INTSIZE = 4;
    static STGlobalData theSTGlobalData = null;
    private WeakHashMap cachedItems = new WeakHashMap(100);
    private DvAddressSpace currentAddressSpace = null;
    private int ptrSize = 0;
    private DvProcess currentProcess = null;
    private DvThread currentThread;
    private CTypeObject stGlobal = null;
    private boolean gcThreadsChangeable;
    private MarkStackDetails markStackDetails;
    private CpuDetails cpuDetails;
    private GcHelperDetails gcHelperDetails;
    private boolean subPoolsActive = false;
    private int lastSubPoolIndex;
    private SubPool[] subPools;
    private long startOfMHeap = 0L;
    private long endOfMHeap = 0L;

    public static STGlobalData getSTGlobalData() {
        if (theSTGlobalData == null) {
            theSTGlobalData = new STGlobalData();
            STGlobalData.theSTGlobalData.cpuDetails = new CpuDetails(theSTGlobalData);
            STGlobalData.theSTGlobalData.gcHelperDetails = new GcHelperDetails(theSTGlobalData);
            STGlobalData.theSTGlobalData.markStackDetails = new MarkStackDetails(theSTGlobalData);
            theSTGlobalData.getSubPoolData();
        }
        return theSTGlobalData;
    }

    private void getSubPoolData() {
        DvAddress dvAddress;
        int n = 0;
        try {
            long l = theSTGlobalData.getAddressOf("poolSizes");
            if (l == 0L) {
                this.subPoolsActive = false;
                return;
            }
            dvAddress = this.currentAddressSpace.createAddress(l);
            n = this.currentAddressSpace.readInt(dvAddress);
        }
        catch (DvAddressException dvAddressException) {
            dvAddressException.printStackTrace();
            return;
        }
        if (n == 0) {
            this.subPoolsActive = false;
            return;
        }
        this.subPoolsActive = true;
        this.subPools = new SubPool[33];
        DvAddress dvAddress2 = this.currentAddressSpace.createAddress(this.getAddressOf("pools"));
        DvAddress dvAddress3 = this.currentAddressSpace.createAddress(this.getAddressOf("poolHits"));
        dvAddress = this.currentAddressSpace.createAddress(this.getAddressOf("smoothedPoolHits"));
        long l = this.getAddressItemAsLong("lastPool");
        long l2 = this.getAddressItemAsLong("TLHstealPool");
        long l3 = this.getAddressItemAsLong("minTLHstealPool");
        DvAddress dvAddress4 = this.currentAddressSpace.createAddress(this.getAddressOf("poolSizes"));
        int n2 = this.getIntItem("largePoolsize");
        this.lastSubPoolIndex = 0;
        while (true) {
            int n3 = 0;
            long l4 = 0L;
            int n4 = 0;
            int n5 = 0;
            try {
                n3 = this.currentAddressSpace.readInt(dvAddress4);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
                break;
            }
            try {
                l4 = this.currentAddressSpace.readPointer(dvAddress2).getAddressAsLong();
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
                break;
            }
            try {
                n4 = this.currentAddressSpace.readInt(dvAddress3);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
                break;
            }
            try {
                n5 = this.currentAddressSpace.readInt(dvAddress);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
                break;
            }
            this.subPools[this.lastSubPoolIndex] = new SubPool(this.lastSubPoolIndex, dvAddress2.getAddressAsLong(), l4, n3, n4, n5);
            ++this.lastSubPoolIndex;
            if (dvAddress2.getAddressAsLong() == l) break;
            try {
                dvAddress2.offsetBy(this.ptrSize);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
                break;
            }
            try {
                dvAddress4.offsetBy(4L);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
                break;
            }
            try {
                dvAddress3.offsetBy(4L);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
                break;
            }
            try {
                dvAddress.offsetBy(4L);
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
                break;
            }
        }
        this.subPools[this.lastSubPoolIndex] = new SubPool(this.lastSubPoolIndex, 0L, this.getAddressItemAsLong("TLHpool"), 0, 0, 0);
    }

    public static void reset() {
        theSTGlobalData = null;
    }

    private STGlobalData() {
        this.allItemGroups = new TreeMap();
        this.currentAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        this.ptrSize = this.currentAddressSpace.pointerSize();
        this.currentProcess = (DvProcess)DvUtils.getAPT(DvConsole.theDump, "P");
        this.currentThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        CTypeObject cTypeObject = new CTypeObject("execenv", this.currentThread.eeAddress(), this.currentAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField("jvmP").deReference();
        this.stGlobal = cTypeObject2.getField("facade.st.dataP").deReference("STGlobal");
        this.gcThreadsChangeable = this.getIntItem("gcThreadsChangeable") == 1;
        this.startOfMHeap = Long.parseLong(DvUtils.getJVMHint(this.currentAddressSpace, "CURHEAPMIN"), 16);
        this.endOfMHeap = Long.parseLong(DvUtils.getJVMHint(this.currentAddressSpace, "CURHEAPMAX"), 16);
        this.allItemGroups.put("Counters", new ItemGroup(new String[]{"gcctr", "INT", "afctr", "INT", "overflowctr", "INT"}));
        this.allItemGroups.put("HeapLimits", new ItemGroup(new String[]{"MH_expansion_limit", "POINTER", "real_heapbase", "POINTER", "real_heaptop", "POINTER", "real_MH_limit", "POINTER", "real_TH_limit", "POINTER", "init_heap_size", "INT", "max_heap_size", "INT", "MH_heapbase", "POINTER", "MH_heaplimit", "POINTER", "TH_heapbase", "POINTER", "TH_heaplimit", "POINTER"}));
    }

    public long getAddressOf(String string) {
        long l = 0L;
        try {
            CTypeObject cTypeObject = this.stGlobal.getField(string);
            l = cTypeObject.getAddr();
        }
        catch (Exception exception) {
            l = 0L;
        }
        return l;
    }

    public DvAddress getAddressItem(String string) {
        DvAddress dvAddress = (DvAddress)this.cachedItems.get(string);
        if (dvAddress != null) {
            return dvAddress;
        }
        try {
            DvAddress dvAddress2 = this.currentAddressSpace.createAddress(this.getAddressOf(string));
            if (dvAddress2.getAddressAsLong() != 0L) {
                dvAddress = this.currentAddressSpace.readPointer(dvAddress2);
                this.cachedItems.put(string, dvAddress);
            }
        }
        catch (Exception exception) {
            dvAddress = null;
        }
        return dvAddress;
    }

    public long getAddressItemAsLong(String string) {
        return this.getAddressItem(string).getAddressAsLong();
    }

    public int getIntItem(String string) {
        Integer n = (Integer)this.cachedItems.get(string);
        if (n != null) {
            return n;
        }
        int n2 = 0;
        try {
            DvAddress dvAddress = this.currentAddressSpace.createAddress(this.getAddressOf(string));
            if (dvAddress.getAddressAsLong() != 0L) {
                n2 = this.currentAddressSpace.readInt(dvAddress);
                this.cachedItems.put(string, new Integer(n2));
            }
        }
        catch (Exception exception) {
            n2 = 0;
        }
        return n2;
    }

    public long getLongItem(String string) {
        Long l = (Long)this.cachedItems.get(string);
        if (l != null) {
            return l;
        }
        long l2 = 0L;
        try {
            DvAddress dvAddress = this.currentAddressSpace.createAddress(this.getAddressOf(string));
            if (dvAddress.getAddressAsLong() != 0L) {
                l2 = this.currentAddressSpace.readLong(dvAddress);
                this.cachedItems.put(string, new Long(l2));
            }
        }
        catch (Exception exception) {
            l2 = 0L;
        }
        return l2;
    }

    public boolean isGcThreadsChangeable() {
        return this.gcThreadsChangeable;
    }

    public DvProcess getCurrentProcess() {
        return this.currentProcess;
    }

    public MarkStackDetails getMarkStackDetails() {
        return this.markStackDetails;
    }

    public CpuDetails getCpuDetails() {
        return this.cpuDetails;
    }

    public GcHelperDetails getGcHelperDetails() {
        return this.gcHelperDetails;
    }

    public DvAddressSpace getCurrentAddressSpace() {
        return this.currentAddressSpace;
    }

    public int getPtrSize() {
        return this.ptrSize;
    }

    public int getLastSubPoolIndex() {
        return this.lastSubPoolIndex;
    }

    public SubPool getSubPool(int n) {
        if (n >= 0 && n <= this.lastSubPoolIndex) {
            return this.subPools[n];
        }
        return null;
    }

    public boolean subPoolsActive() {
        return this.subPoolsActive;
    }

    public void showItemgroup(String string, OutputStrategy outputStrategy) {
        if (this.allItemGroups.containsKey(string)) {
            ((ItemGroup)this.allItemGroups.get(string)).reportItems(outputStrategy);
        } else {
            outputStrategy.output("The ItemGroup " + string + " does not exist");
            outputStrategy.output("Try using the list option ...");
        }
    }

    public void listItemGroups(OutputStrategy outputStrategy) {
        Iterator iterator = this.allItemGroups.keySet().iterator();
        while (iterator.hasNext()) {
            outputStrategy.output((String)iterator.next());
        }
    }

    public Iterator itemGroupsIterator() {
        return this.allItemGroups.keySet().iterator();
    }

    private class ItemGroup {
        private Vector items;

        ItemGroup(String[] stringArray) {
            int n = stringArray.length;
            if (n % 2 != 0) {
                throw new RuntimeException("must be even number of strings");
            }
            this.items = new Vector(n / 2);
            for (int i = 0; i < n; i += 2) {
                int n2;
                if (stringArray[i + 1].equalsIgnoreCase("INT")) {
                    n2 = 1;
                } else if (stringArray[i + 1].equalsIgnoreCase("LONG")) {
                    n2 = 2;
                } else if (stringArray[i + 1].equalsIgnoreCase("POINTER")) {
                    n2 = 3;
                } else {
                    throw new RuntimeException("data type must be INT, LONG or POINTER");
                }
                this.items.add(new Item(stringArray[i], n2));
            }
        }

        void reportItems(OutputStrategy outputStrategy) {
            Iterator iterator = this.items.iterator();
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                outputStrategy.output(item.getName() + " : " + item.getValue());
            }
        }
    }

    private class Item {
        private String name;
        private int type;

        Item(String string, int n) {
            this.name = string;
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    this.type = n;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type");
                }
            }
        }

        String getValue() {
            switch (this.type) {
                case 1: {
                    return Integer.toString(STGlobalData.this.getIntItem(this.name));
                }
                case 2: {
                    return Long.toString(STGlobalData.this.getLongItem(this.name));
                }
                case 3: {
                    return "0x" + DvUtils.rJustifyZ(Long.toHexString(STGlobalData.this.getAddressItemAsLong(this.name)), 0);
                }
            }
            return null;
        }

        String getName() {
            return this.name;
        }
    }
}

