/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvTraceFmtPlugin;

public class SovTraceObject {
    CTypeObject traceData;
    CTypeObject traceFileHeader;
    String traceBufferName;

    SovTraceObject(DvAddressSpace dvAddressSpace) {
        DvDump dvDump = DvConsole.getCurrentDump();
        DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
        CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField("jvmP").deReference();
        CTypeObject cTypeObject3 = cTypeObject2.getField("facade.dg.dataP").deReference("DgData");
        this.traceData = cTypeObject3.getField("utGlobalDataP");
        if (this.traceData != null) {
            this.traceData = this.traceData.deReference();
            this.traceFileHeader = this.traceData.getField("traceHeader").deReference("utTraceFileHdr");
            this.traceBufferName = "utTraceBuffer";
        } else {
            this.traceData = cTypeObject3;
            this.traceFileHeader = this.traceData.getField("traceHeader").deReference("TraceFileHeader");
            this.traceBufferName = "DgTraceBuffer";
        }
    }

    public boolean isEnabled() {
        try {
            CTypeObject cTypeObject = this.traceData.getField("traceGlobal");
            return DvTraceFmtPlugin.readPtrAsLong(cTypeObject) != 0L;
        }
        catch (Exception exception) {
            DvTraceFmtPlugin.outputAndFlush(exception.toString());
            DvTraceFmtPlugin.outputAndFlush("*** Unexpected exception received in isTraceEnabled() ***\nIf there are any dump buffers present, they cannot be formatted.");
            exception.printStackTrace();
            return false;
        }
    }
}

