/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.LittleEnd;
import com.ibm.jvm.dump.sdff.SDFFAddressSpace;
import com.ibm.jvm.dump.sdff.SDFFRas;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import com.ibm.jvm.dump.sdff.SdffStd;
import com.ibm.jvm.dump.sdff.WordLength;
import com.ibm.jvm.dump.sdff.WordType;
import com.ibm.jvm.dump.sdffArchive.SdffArchiveInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class SDFFDump
extends DvDump {
    public static RandomAccessFile sdffRaf;
    public static RandomAccessFile dumpRaf;
    public static long prthOffset;
    public static long prthLength;
    public static long mmapOffset;
    public static long mmapLength;
    public static long memOffset;
    public static long memLength;
    public static long rasOffset;
    public static long rasLength;
    public static long sizeOfFile;
    public static String nameOfFile;
    public Vector as_offsets = new Vector();
    public SDFFAddressSpace[] theASArray;
    public SDFFRas ras;
    public static int system;
    public static int architecture;
    public static int subsystem;
    public static int processor;
    public static int processorSubtype;
    public static int numProcessors;
    public static int currentProcessor;
    private static long provider;
    private static String suffix;

    public DvRas getRas() {
        if (this.ras == null) {
            if (rasOffset == -1L) {
                return null;
            }
            this.ras = SDFFRas.loadFromFile(rasOffset, rasLength, sdffRaf);
        }
        this.ras.dump();
        return this.ras;
    }

    public byte[] getCTypedefs() {
        if (this.ras == null) {
            this.getRas();
        }
        if (this.ras == null) {
            return null;
        }
        if (this.theASArray == null || this.theASArray.length == 0) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = this.theASArray[0].readBytes(new DvAddress(this.ras.typedefs), this.ras.typedefsLen);
            if (byArray[0] != 80 || byArray[1] != 75) {
                System.err.println("*** WARNING: Location for jvmdcf appears suspect -- searching backwards");
                boolean bl = false;
                int n = -1;
                byte[] byArray2 = this.theASArray[0].readBytes(new DvAddress(this.ras.typedefs - 512L), 512L);
                if (null != byArray2) {
                    int n2;
                    for (n2 = 503; n2 >= 256 && -1 == n; --n2) {
                        byte[] byArray3 = new byte[]{byArray2[n2], byArray2[n2 + 1], byArray2[n2 + 2], byArray2[n2 + 3], byArray2[n2 + 4], byArray2[n2 + 5], byArray2[n2 + 6], byArray2[n2 + 7]};
                        String string = new String(byArray3);
                        if (!string.equals("jvmdcf.X")) continue;
                        n = n2;
                    }
                    if (-1 != n) {
                        for (n2 = n; n2 >= 0; --n2) {
                            if (byArray2[n2] != 80 || byArray2[n2 + 1] != 75) continue;
                            System.err.println("*** WARNING: Location for jvmdcf found using backward search");
                            n = n2;
                            n2 = 0;
                        }
                    }
                }
                if (-1 == n) {
                    return null;
                }
                byArray = this.theASArray[0].readBytes(new DvAddress(this.ras.typedefs - 512L + (long)n), this.ras.typedefsLen);
            }
        }
        catch (DvAddressException dvAddressException) {
            System.err.println("Unable to read typedef data from the dump for address 0x" + Long.toHexString(this.ras.typedefs));
        }
        return byArray;
    }

    public DvAddressSpace[] getAddressSpaces() {
        if (null == this.theASArray) {
            if (prthOffset == -1L) {
                return null;
            }
            int n = SDFFAddressSpace.countThem(prthOffset, sdffRaf);
            if (0 == n) {
                return null;
            }
            this.theASArray = new SDFFAddressSpace[n];
            for (int i = 0; i < n; ++i) {
                this.theASArray = SDFFAddressSpace.loadFromFile(prthOffset, prthLength, mmapOffset, mmapLength, sdffRaf, dumpRaf);
            }
        }
        return this.theASArray;
    }

    public int getArchitecture() {
        return architecture;
    }

    public void setArchitecture(WordLength wordLength, WordType wordType) {
        architecture = 0;
        if (wordLength.size == 4) {
            ++architecture;
        } else if (wordLength.size == 8) {
            architecture += 2;
        }
        architecture = wordType instanceof LittleEnd ? (architecture += 8) : (architecture += 4);
    }

    public int getSystemType() {
        return system;
    }

    public int getSubSystemType() {
        return subsystem;
    }

    public int getProcessor() {
        return processor;
    }

    public long getProvider() {
        return provider;
    }

    public static Boolean isSupportedSource(String string) {
        Boolean bl = Boolean.FALSE;
        DvUtils.writetoTrace("Entry to SDFFDump:isSupportedSource(" + string + ")");
        if (SDFFDump.looksLikeAJarFile(string)) {
            SdffArchiveInputStream sdffArchiveInputStream;
            DvUtils.writetoTrace("SDFFDump:isSupportedSource opening NewSDFFInputStream(" + string + ")");
            try {
                sdffArchiveInputStream = new SdffArchiveInputStream(string);
            }
            catch (IOException iOException) {
                DvUtils.writetoTrace("SDFFDump:isSupportedSource Exception " + iOException + " opening NewSDFFInputStream(" + string + ")");
                return Boolean.FALSE;
            }
            String string2 = DvUtils.getValue("SdffDir");
            String string3 = DvUtils.getValue("DumpDir");
            String string4 = sdffArchiveInputStream.getExtractSdffHeaderName();
            String string5 = sdffArchiveInputStream.getExtractOriginalDumpName();
            if (string2 != null) {
                string4 = string2 + File.separator + string4;
            }
            if (string3 != null) {
                string5 = string3 + File.separator + string5;
            }
            try {
                sdffArchiveInputStream.extractHeader(true);
            }
            catch (IOException iOException) {
                DvUtils.writetoTrace("SDFFDump:isSupportedSource Exception " + iOException + " extracting from NewSDFFInputStream(" + string + ")");
                return Boolean.FALSE;
            }
            if (SDFFDump.isValidSdffHeader(string4, false)) {
                try {
                    dumpRaf = new RandomAccessFile(string5, "r");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DvUtils.writetoTrace("SDFFDump:isSupportedSource Exception " + fileNotFoundException + " opening NewSDFFInputStream(" + string + ") original dump (" + string5 + ")");
                    return Boolean.FALSE;
                }
                DvUtils.writetoTrace("Exit from SDFFDump:isSupportedSource(true - jar)");
                return Boolean.TRUE;
            }
            DvUtils.writetoTrace("Exit from SDFFDump:isSupportedSource(false - jar)");
            return Boolean.FALSE;
        }
        if (SDFFDump.isValidSdffHeader(string, true)) {
            dumpRaf = sdffRaf;
            DvUtils.writetoTrace("Exit from SDFFDump:isSupportedSource(true - flat file)");
            return Boolean.TRUE;
        }
        DvUtils.writetoTrace("Exit from SDFFDump:isSupportedSource(false - flat file)");
        return Boolean.FALSE;
    }

    private static boolean looksLikeAJarFile(String string) {
        try {
            DvUtils.writetoTrace("SDFFDump:looksLikeAJarFile - opening DataInputStream for (" + string + ")");
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            DvUtils.writetoTrace("SDFFDump:looksLikeAJarFile reading 2 bytes from (" + string + ")");
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            dataInputStream.close();
            if (by == 80 && by2 == 75) {
                return true;
            }
        }
        catch (IOException iOException) {
            DvUtils.writetoTrace("SDFFDump:looksLikeAJarFile IOException " + iOException + " accessing (" + string + ")");
            return false;
        }
        return false;
    }

    private static boolean isValidSdffHeader(String string, boolean bl) {
        int n;
        SdffStd sdffStd;
        DvUtils.writetoTrace("Entry to SDFFDump:isValidSdffHeader(" + string + ")");
        File file = null;
        try {
            file = new File(string);
            sdffRaf = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[32];
            sdffRaf.read(byArray, 0, 32);
            sdffStd = new SdffStd(byArray);
            String string2 = new String(sdffStd.sectionEye);
            if (!string2.equals(SdffConstants.SEGMENT_Eye_SdffHead)) {
                DvUtils.writetoTrace("  SDFFHEAD eyecatcher not detected");
                DvUtils.writetoTrace("Exit from SDFFDump:isValidSdffHeader(false)");
                return false;
            }
            DvUtils.writetoTrace("  SDFFHEAD eyecatcher detected - its an SDFF dump");
            sdffRaf.seek(32L);
            system = sdffRaf.readInt();
            architecture = sdffRaf.readInt();
            subsystem = sdffRaf.readInt();
            processor = sdffRaf.readInt();
            int n2 = sdffRaf.readInt();
            int n3 = sdffRaf.readInt();
            n = sdffRaf.readInt();
            int n4 = sdffRaf.readInt();
            provider = sdffStd.sectionLen < 60L ? 0L : sdffRaf.readLong();
            if (!sdffStd.checkMatch()) {
                DvUtils.output("Looks like SDFF format Error");
                DvUtils.writetoTrace("Exit from SDFFDump:isValidSdffHeader(false)");
                return false;
            }
        }
        catch (IOException iOException) {
            DvUtils.writetoTrace("Exit from SDFFDump:isValidSdffHeader(false)");
            return false;
        }
        DvUtils.output("Dump recognised as " + (bl ? "an old " : "a new ") + "format " + "SDFF dump");
        SDFFDump.reset();
        sizeOfFile = file.length();
        nameOfFile = string;
        boolean bl2 = false;
        long l = sdffStd.sectionLen;
        while (!bl2) {
            try {
                sdffRaf.seek(l);
                byte[] byArray = new byte[32];
                n = sdffRaf.read(byArray, 0, 32);
                sdffStd = new SdffStd(byArray);
                if (!sdffStd.checkMatch()) {
                    bl2 = true;
                    continue;
                }
                if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_SdffHead) {
                    DvUtils.output("Two Sdffheads - not nice");
                    bl2 = true;
                } else if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_SdffRas) {
                    if (rasOffset == -1L) {
                        rasOffset = l;
                        rasLength = sdffStd.sectionLen;
                    } else {
                        DvUtils.output("Two SdffRas sections - not nice");
                        bl2 = true;
                    }
                } else if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_Sdffprth) {
                    if (prthOffset == -1L) {
                        prthOffset = l;
                        prthLength = sdffStd.sectionLen;
                    } else {
                        DvUtils.output("Two Sdffprths - not nice");
                        bl2 = true;
                    }
                } else if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_Sdffmmap) {
                    if (mmapOffset == -1L) {
                        mmapOffset = l;
                        mmapLength = sdffStd.sectionLen;
                    } else {
                        DvUtils.output("Two Sdffmmaps - not nice");
                        bl2 = true;
                    }
                } else if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_Sdffmem) {
                    if (memOffset == -1L) {
                        memOffset = l;
                        memLength = sdffStd.sectionLen;
                    } else {
                        DvUtils.output("Two Sdffmems - not nice");
                        bl2 = true;
                    }
                }
                l += sdffStd.sectionLen;
            }
            catch (IOException iOException) {
                bl2 = true;
            }
        }
        String string3 = "\n ... Possibe cause: lack of space during SDFF file creation.";
        if (-1L == prthOffset) {
            DvUtils.trace("\n*** Error in dump format\nPrth offset/length is " + prthOffset + ":" + prthLength + string3, 2, true);
        }
        if (-1L == mmapOffset) {
            DvUtils.trace("\n*** Error in dump format\nMmap offset/length is " + mmapOffset + ":" + mmapLength + string3, 2, true);
        }
        if (bl && -1L == memOffset) {
            DvUtils.trace("\n*** Error in dump format\nMem  offset/length is " + memOffset + ":" + memLength + string3, 2, true);
        }
        if (-1L == rasOffset) {
            DvUtils.trace("\n*** Error in dump format\nRas  offset/length is " + rasOffset + ":" + rasLength + string3, 2, true);
        }
        DvUtils.writetoTrace("Exit from SDFFDump:isValidSdffHeader(true)");
        return true;
    }

    public int getProcessorSubType() {
        return processorSubtype;
    }

    public int getCurrentProcessor() {
        return currentProcessor;
    }

    public int getProcessorCount() {
        return numProcessors;
    }

    public DvAddressSpace getCurrentAddressSpace() {
        int n = DvConsole.getCurrentAsIndex();
        SDFFAddressSpace sDFFAddressSpace = this.theASArray[n];
        return sDFFAddressSpace;
    }

    public String getSuffix() {
        String string = null;
        if (-1L == provider) {
            string = new String("sov");
        }
        if (0x7F7F7F7F7F7F7F7FL == provider) {
            string = new String("sov");
        }
        if (0L == provider || -4294967296L == provider) {
            string = new String("sov");
        }
        if (1L == provider) {
            string = new String("j9");
        }
        return string;
    }

    public static void reset() {
        prthOffset = -1L;
        prthLength = -1L;
        mmapOffset = -1L;
        mmapLength = -1L;
        memOffset = -1L;
        memLength = -1L;
        rasOffset = -1L;
        rasLength = -1L;
        sizeOfFile = -1L;
    }

    public void printSdff(Sdff sdff) throws IOException {
        long l = sdff.getFilePointer();
        SdffStd sdffStd = new SdffStd(SdffConstants.SEGMENT_SdffHead, SdffConstants.VERSION1_0_0);
        sdffStd.printSdff(sdff);
        sdff.writeInt(system);
        sdff.writeInt(architecture);
        sdff.writeInt(subsystem);
        sdff.writeInt(processor);
        sdff.writeInt(processorSubtype);
        sdff.writeInt(numProcessors);
        sdff.writeInt(currentProcessor);
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }

    static {
        prthOffset = -1L;
        prthLength = -1L;
        mmapOffset = -1L;
        mmapLength = -1L;
        memOffset = -1L;
        memLength = -1L;
        rasOffset = -1L;
        rasLength = -1L;
        sizeOfFile = -1L;
        system = -1;
        architecture = -1;
        subsystem = -1;
        processor = -1;
        processorSubtype = -1;
        numProcessors = -1;
        currentProcessor = -1;
        provider = -1L;
    }
}

