/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvJavaStack;
import com.ibm.jvm.dump.format.DvUtils;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SDFFJavaStack
extends DvJavaStack {
    private long length = 64L;
    private byte[] eyecatcher = new byte[]{74, 83, 84, 65, 67, 75, 84, 82};
    private byte[] spare = new byte[32];
    private long nullMetaData = -1L;
    private byte[] metadata;
    private DvJavaFrame[] javaFrames;

    public SDFFJavaStack() {
    }

    public SDFFJavaStack(DvJavaFrame[] dvJavaFrameArray) {
        super(dvJavaFrameArray);
        int n;
        this.javaFrames = dvJavaFrameArray;
        for (n = 0; n < this.spare.length; ++n) {
            this.spare[n] = 127;
        }
        if (this.javaFrames != null) {
            for (n = 0; n < this.javaFrames.length; ++n) {
                this.length += 56L;
                if (this.javaFrames[n].getName() == null) continue;
                this.length += (long)this.javaFrames[n].getName().length;
            }
        }
    }

    public long getLength() {
        return this.length;
    }

    public void printSdff(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.writeLong(this.length);
            randomAccessFile.write(this.eyecatcher);
            randomAccessFile.writeLong(this.javaFrames == null ? 0L : (long)this.javaFrames.length);
            if (this.javaFrames != null) {
                for (int i = 0; i < this.javaFrames.length; ++i) {
                    randomAccessFile.writeLong(this.javaFrames[i].getMb());
                    randomAccessFile.writeLong(this.javaFrames[i].getPc());
                    randomAccessFile.writeLong(this.javaFrames[i].getSp());
                    randomAccessFile.writeLong(this.javaFrames[i].getArgs());
                    randomAccessFile.writeLong(this.javaFrames[i].getVars());
                    randomAccessFile.writeLong(this.javaFrames[i].getFrameType());
                    randomAccessFile.writeLong(this.javaFrames[i].getName().length);
                    if (this.javaFrames[i].getName() != null) {
                        randomAccessFile.write(this.javaFrames[i].getName());
                        continue;
                    }
                    randomAccessFile.writeLong(0L);
                }
            }
            randomAccessFile.write(this.spare);
            randomAccessFile.writeLong(this.nullMetaData);
        }
        catch (Exception exception) {
            System.out.println("Error dumping JSTACKTR section");
            return;
        }
    }

    public static SDFFJavaStack loadFromFile(long l, RandomAccessFile randomAccessFile) {
        DvUtils.writetoTrace("Entry to SDFFJavaStack:loadFromFile...");
        long l2 = l;
        DvUtils.writetoTrace("  .... Loading SDFFRegister object from file :" + l);
        SDFFJavaStack sDFFJavaStack = new SDFFJavaStack();
        try {
            randomAccessFile.seek(l2);
            long l3 = randomAccessFile.readLong();
            randomAccessFile.skipBytes(8);
            randomAccessFile.seek(l2 + l3 - 8L);
            long l4 = randomAccessFile.readLong();
            if (l4 != -1L) {
                sDFFJavaStack.metadata = new byte[(int)l4];
                randomAccessFile.seek(l2 + l3 - 8L - l4);
                randomAccessFile.read(sDFFJavaStack.metadata);
                String string = new String(sDFFJavaStack.metadata);
                System.out.println("jstackmd:" + string);
            }
            randomAccessFile.seek(l2 + 16L);
            int n = (int)randomAccessFile.readLong();
            if (n == 0) {
                return sDFFJavaStack;
            }
            DvJavaFrame[] dvJavaFrameArray = new DvJavaFrame[n];
            if (dvJavaFrameArray == null) {
                return sDFFJavaStack;
            }
            for (int i = 0; i < n; ++i) {
                dvJavaFrameArray[i] = new DvJavaFrame();
                dvJavaFrameArray[i].setMb(randomAccessFile.readLong());
                dvJavaFrameArray[i].setPc(randomAccessFile.readLong());
                dvJavaFrameArray[i].setSp(randomAccessFile.readLong());
                dvJavaFrameArray[i].setArgs(randomAccessFile.readLong());
                dvJavaFrameArray[i].setVars(randomAccessFile.readLong());
                dvJavaFrameArray[i].setFrameType((int)randomAccessFile.readLong());
                int n2 = (int)randomAccessFile.readLong();
                if (n2 <= 0) continue;
                byte[] byArray = new byte[n2];
                if (byArray != null) {
                    randomAccessFile.read(byArray);
                }
                dvJavaFrameArray[i].setName(byArray);
            }
            sDFFJavaStack.setFrames(dvJavaFrameArray);
        }
        catch (IOException iOException) {
            DvUtils.errorMsg("IOException in SDFFJavaStack: loadFromFile", 0);
        }
        DvUtils.writetoTrace("Exit from SDFFJavaStack:loadFromFile");
        return sDFFJavaStack;
    }
}

