/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.util.BitSetArray;
import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntPairEnumeration;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.IntegerStack;
import com.ibm.jvm.util.Interval;
import com.ibm.jvm.util.SvcdumpProperties;
import java.util.BitSet;
import java.util.Stack;
import sun.misc.SoftCache;

public final class StrongComponentsGraph
extends SimpleGraph {
    IntegerArray dagSizes = new IntegerArray();
    int[] reach;
    PrintClient client;
    BitSet isNotRoot = new BitSet();
    static int logFreq = 4096;
    static final int maxmedium = SvcdumpProperties.getIntProperty("findroots.maxmedium", 1024);
    int childId;

    public StrongComponentsGraph() {
        if (this.usecomplex) {
            this.setRecordParents(true);
        }
    }

    String className() {
        return "StrongComponentsGraph";
    }

    void createSlot() {
        super.createSlot();
        this.dagSizes.add(0);
    }

    boolean ignoreNode(int n) {
        return false;
    }

    void transitiveClosureFast() {
        Visitor visitor = new Visitor(){
            BitSetArray tc;
            int done;
            {
                this.tc = new BitSetArray(StrongComponentsGraph.this.size, "transitiveClosure", true, maxmedium);
            }

            public void enterNode(int n, int n2) {
                if (this.done++ % logFreq == 0) {
                    StrongComponentsGraph.this.log("done " + this.done + " at depth " + n2 + " memory usage " + this.tc.totalMemory());
                }
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                this.tc.set(n, n2);
            }

            public void visitChildAtExit(int n, int n2, boolean bl) {
                this.tc.or(n, n2);
            }

            public Object result() {
                return this.tc;
            }
        };
        BitSet bitSet = new BitSet();
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        for (int i = 0; i < this.size; ++i) {
            this.dfs(visitor, stack, integerStack, bitSet, i);
        }
        BitSetArray bitSetArray = (BitSetArray)visitor.result();
        this.log("calculate reachability");
        this.reach = new int[this.size];
        SoftCache softCache = new SoftCache();
        for (int i = 0; i < this.size; ++i) {
            if (this.ignoreNode(i)) continue;
            if (this.exact || this.sizeMatters) {
                this.reach[i] = this.vertexSizes.get(i);
            }
            int n = i;
            this.reach[n] = this.reach[n] + this.calculateReach(i, bitSetArray, softCache, this.vertexSizes);
            if (i % logFreq != 0) continue;
            this.log("done " + i);
        }
    }

    void transitiveClosureOnlyMedium() {
        this.log("set up parent counts");
        final int[] nArray = new int[this.size];
        this.reach = new int[this.size];
        final SoftCache softCache = new SoftCache();
        for (int i = 0; i < this.size; ++i) {
            nArray[i] = this.parents.numberOfElements(i);
        }
        this.log("calculate reachability");
        this.dfs(new Visitor(){
            BitSetArray tc;
            int done;
            {
                this.tc = new BitSetArray(StrongComponentsGraph.this.size, "transitiveClosure", true, maxmedium);
            }

            int size() {
                return (nArray.length << 2) + this.tc.totalMemory();
            }

            public void enterNode(int n, int n2) {
                if (this.done++ % logFreq == 0) {
                    StrongComponentsGraph.this.log("done " + this.done + " at depth " + n2 + " memory usage " + this.size());
                }
            }

            boolean ignoreDownEdges() {
                return true;
            }

            public void visitChildAtExit(int n, int n2, boolean bl) {
                this.tc.set(n, n2);
                if (!bl) {
                    this.tc.or(n, n2);
                }
                int n3 = n2;
                nArray[n3] = nArray[n3] - 1;
                if (nArray[n3] == 0) {
                    this.tc.clearAll(n2);
                }
                Base.Assert(nArray[n2] >= 0);
            }

            public void exitNode(int n) {
                if (StrongComponentsGraph.this.exact || StrongComponentsGraph.this.sizeMatters) {
                    StrongComponentsGraph.this.reach[n] = StrongComponentsGraph.this.vertexSizes.get(n);
                }
                int n2 = n;
                StrongComponentsGraph.this.reach[n2] = StrongComponentsGraph.this.reach[n2] + StrongComponentsGraph.this.calculateReach(n, this.tc, softCache, StrongComponentsGraph.this.vertexSizes);
            }
        }, 0);
        this.log("finished!");
    }

    int calculateReach(int n, BitSetArray bitSetArray, SoftCache softCache, IntegerArray integerArray) {
        int n2 = 0;
        if (!bitSetArray.isEmpty(n)) {
            if (this.exact || this.sizeMatters) {
                IntPairEnumeration intPairEnumeration = bitSetArray.intPairs(n);
                while (intPairEnumeration.hasMoreElements()) {
                    int n3;
                    long l = intPairEnumeration.nextIntPair();
                    int n4 = (int)l;
                    StrongComponentsGraph.Assert(n4 >= (n3 = (int)(l >> 32)));
                    if (n4 < n3 + pairlimit) {
                        int n5 = 0;
                        for (int i = n3; i <= n4; ++i) {
                            n5 += integerArray.get(i);
                        }
                        n2 += n5;
                        continue;
                    }
                    Interval interval = new Interval(n3, n4);
                    Integer n6 = (Integer)softCache.get((Object)interval);
                    if (n6 == null) {
                        int n7 = 0;
                        for (int i = n3; i <= n4; ++i) {
                            n7 += integerArray.get(i);
                        }
                        n6 = new Integer(n7);
                        softCache.put((Object)interval, (Object)n6);
                    }
                    n2 += n6.intValue();
                }
            } else {
                n2 = bitSetArray.numberOfElements(n);
            }
        }
        return n2;
    }

    void transitiveClosureSlow() {
        this.reach = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (this.ignoreNode(i)) continue;
            Integer n = (Integer)this.dfs(new Visitor(){
                int r;

                public void enterNode(int n, int n2) {
                    this.r = StrongComponentsGraph.this.exact || StrongComponentsGraph.this.sizeMatters ? (this.r += StrongComponentsGraph.this.vertexSizes.get(n)) : ++this.r;
                }

                public Object result() {
                    return new Integer(this.r);
                }
            }, i);
            this.reach[i] = n;
            if (i % logFreq != 0) continue;
            this.log("done " + i);
        }
    }

    void transitiveClosureSlowish() {
        final int[] nArray = new int[this.size];
        this.log("done before alloc");
        final int[] nArray2 = new int[this.size];
        final int[] nArray3 = new int[this.size];
        this.log("done after alloc");
        final int[] nArray4 = new int[this.size];
        this.log("done count alloc");
        final boolean[] blArray = new boolean[this.size];
        this.log("done allocs");
        this.dfs(new Visitor(){
            int cnt = 0;

            public void enterNode(int n, int n2) {
                nArray[n] = ++this.cnt;
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                nArray3[n2] = ++this.cnt;
            }

            public void exitNode(int n) {
                nArray2[n] = ++this.cnt;
            }
        }, 0);
        this.log("done first dfs");
        this.dfs(new Visitor(){
            int[] enterCount;
            int cnt;
            {
                this.enterCount = new int[StrongComponentsGraph.this.size];
                this.cnt = 0;
            }

            public void enterNode(int n, int n2) {
                block0: {
                    this.enterCount[n] = this.cnt++;
                    if (!StrongComponentsGraph.this.exact && !StrongComponentsGraph.this.sizeMatters) break block0;
                    this.cnt += StrongComponentsGraph.this.vertexSizes.get(n);
                }
            }

            void visitChild(int n, int n2) {
                if (nArray[n2] < nArray[n]) {
                    blArray[n] = true;
                    nArray[n] = nArray[n2];
                }
                if (nArray3[n2] > nArray2[n]) {
                    blArray[n] = true;
                    nArray3[n] = nArray3[n2];
                }
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                this.visitChild(n, n2);
            }

            public void visitChildAtExit(int n, int n2, boolean bl) {
                this.visitChild(n, n2);
            }

            public void exitNode(int n) {
                if (!blArray[n]) {
                    nArray4[n] = this.cnt - this.enterCount[n];
                }
            }
        }, 0);
        this.log("done second dfs");
        this.reach = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (this.ignoreNode(i)) continue;
            Integer n = (Integer)this.dfs(new Visitor(){
                int r = 0;

                public void enterNode(int n, int n2) {
                    this.r = !blArray[n] ? (this.r += nArray4[n]) : (StrongComponentsGraph.this.exact || StrongComponentsGraph.this.sizeMatters ? (this.r += StrongComponentsGraph.this.vertexSizes.get(n)) : ++this.r);
                }

                public boolean continueSearch(int n, int n2) {
                    return blArray[n];
                }

                public Object result() {
                    return new Integer(this.r);
                }

                public void exitNode(int n) {
                }
            }, i);
            this.reach[i] = n;
            if (i % logFreq != 0) continue;
            this.log("done " + i);
        }
    }

    void transitiveClosureReallyFast() {
        final BitSet bitSet = new BitSet();
        final IntegerStack integerStack = new IntegerStack();
        final IntegerArray integerArray = new IntegerArray();
        final IntegerStack integerStack2 = new IntegerStack();
        final SoftCache softCache = new SoftCache();
        final BitSetArray bitSetArray = new BitSetArray(this.size, "transitiveClosure", true, maxmedium);
        final IntegerStack integerStack3 = new IntegerStack();
        final int[] nArray = new int[this.size];
        this.reach = new int[this.size];
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.parents.numberOfElements(i) == 1) continue;
            bitSet.set(i);
            ++n;
        }
        this.log("total nodes " + this.size + " of which " + n + " are complex");
        BitSet bitSet2 = new BitSet();
        this.childId = this.size - 1;
        for (int i = 0; i < this.size; ++i) {
            if (i != 0 && this.isNotRoot.get(i) || bitSet2.get(i)) continue;
            this.dfs(new Visitor(){
                int lastComplex;
                int done;

                int size() {
                    return (integerStack2.size() + nArray.length + integerArray.size() + integerStack3.size() + integerStack.size() << 2) + bitSetArray.totalMemory();
                }

                public void enterNode(int n, int n2) {
                    if (this.done++ % logFreq == 0) {
                        StrongComponentsGraph.this.log("done " + this.done + " at depth " + n2 + " memory usage " + this.size());
                    }
                    if (bitSet.get(n)) {
                        nArray[n] = integerArray.size();
                        integerArray.add(0);
                        integerStack2.push(nArray[n]);
                        integerStack.push(0);
                    } else {
                        --StrongComponentsGraph.this.childId;
                    }
                    if (integerStack.size() == 0) {
                        System.out.println("warning: bad complex count at depth " + n2);
                    }
                    int n3 = integerStack.peek();
                    int n4 = StrongComponentsGraph.this.exact || StrongComponentsGraph.this.sizeMatters ? StrongComponentsGraph.this.vertexSizes.get(n) : 1;
                    integerStack.put(n3 + n4);
                    integerStack3.push(n3);
                }

                public void visitChildAtExit(int n, int n2, boolean bl) {
                    if (bitSet.get(n2)) {
                        bitSetArray.set(integerStack2.peek(), nArray[n2]);
                        bitSetArray.or(integerStack2.peek(), nArray[n2]);
                        if (!bitSet.get(n)) {
                            bitSetArray.set(nArray[n], nArray[n2]);
                            bitSetArray.or(nArray[n], nArray[n2]);
                        }
                    } else {
                        if (!bitSet.get(n)) {
                            bitSetArray.or(nArray[n], nArray[n2]);
                        }
                        bitSetArray.clearAll(nArray[n2]);
                    }
                }

                public void exitNode(int n) {
                    int n2 = integerStack.peek() - integerStack3.pop();
                    if (bitSet.get(n)) {
                        integerStack2.pop();
                        integerStack.pop();
                        this.lastComplex = n;
                        integerArray.put(nArray[n], n2);
                    }
                    StrongComponentsGraph.this.reach[n] = n2;
                    int n3 = n;
                    StrongComponentsGraph.this.reach[n3] = StrongComponentsGraph.this.reach[n3] + StrongComponentsGraph.this.calculateReach(nArray[n], bitSetArray, softCache, integerArray);
                }
            }, i, bitSet2);
        }
    }

    void oldtransitiveClosureReallyFast() {
        final BitSet bitSet = new BitSet();
        final IntegerStack integerStack = new IntegerStack();
        final IntegerStack integerStack2 = new IntegerStack();
        final BitSetArray bitSetArray = new BitSetArray(this.size, "complexChildren", true, maxmedium);
        final BitSetArray bitSetArray2 = new BitSetArray(this.size, "transitiveClosure", true, maxmedium);
        final int[] nArray = new int[this.size];
        final int[] nArray2 = new int[1];
        final int[] nArray3 = new int[2];
        final int[] nArray4 = new int[3];
        final int[] nArray5 = new int[1];
        final int[] nArray6 = new int[1];
        final int[] nArray7 = new int[1];
        this.reach = new int[this.size];
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.parents.numberOfElements(i) == 1) continue;
            bitSet.set(i);
            ++n;
        }
        this.log("total nodes " + this.size + " of which " + n + " are complex");
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.size; ++i) {
            if (i != 0 && this.isNotRoot.get(i)) continue;
            this.dfs(new Visitor(){
                int lastComplex;
                int done;

                int size() {
                    return (nArray.length + integerStack.size() + integerStack2.size() << 2) + bitSetArray.totalMemory() + bitSetArray2.totalMemory();
                }

                public void enterNode(int n, int n2) {
                    if (this.done++ % logFreq == 0) {
                        StrongComponentsGraph.this.log("done " + this.done + " at depth " + n2 + " memory usage " + this.size());
                    }
                    if (bitSet.get(n)) {
                        integerStack.push(n);
                        integerStack2.push(0);
                    }
                    int n3 = integerStack2.peek();
                    int n4 = StrongComponentsGraph.this.exact || StrongComponentsGraph.this.sizeMatters ? StrongComponentsGraph.this.vertexSizes.get(n) : 1;
                    integerStack2.put(n3 + n4);
                    nArray[n] = n3;
                }

                public void visitChildAtExit(int n, int n2, boolean bl) {
                    if (bitSet.get(n2)) {
                        bitSetArray2.set(integerStack.peek(), n2);
                        bitSetArray2.or(integerStack.peek(), n2);
                        bitSetArray.set(n, n2);
                    } else {
                        bitSetArray.or(n, n2);
                    }
                    bitSetArray.clearAll(n2);
                }

                public void exitNode(int n) {
                    nArray[n] = integerStack2.peek() - nArray[n];
                    if (bitSet.get(n)) {
                        integerStack.pop();
                        integerStack2.pop();
                        this.lastComplex = n;
                        bitSetArray.clearAll(n);
                    }
                    if (!bitSet.get(n)) {
                        int n2;
                        StrongComponentsGraph.this.reach[n] = nArray[n];
                        int n3 = bitSetArray.cappedNumberOfElements(n);
                        int n4 = -1;
                        int n5 = -1;
                        int n6 = -1;
                        switch (n3) {
                            case 0: {
                                return;
                            }
                            case 1: {
                                n4 = bitSetArray.elementAt(n, 0);
                                if (n4 != nArray2[0]) break;
                                int n7 = n;
                                StrongComponentsGraph.this.reach[n7] = StrongComponentsGraph.this.reach[n7] + nArray5[0];
                                return;
                            }
                            case 2: {
                                n4 = bitSetArray.elementAt(n, 0);
                                n5 = bitSetArray.elementAt(n, 1);
                                if (n4 != nArray3[0] || n5 != nArray3[1]) break;
                                int n8 = n;
                                StrongComponentsGraph.this.reach[n8] = StrongComponentsGraph.this.reach[n8] + nArray6[0];
                                return;
                            }
                            case 3: {
                                n4 = bitSetArray.elementAt(n, 0);
                                n5 = bitSetArray.elementAt(n, 1);
                                n6 = bitSetArray.elementAt(n, 2);
                                if (n4 != nArray4[0] || n5 != nArray4[1] || n6 != nArray4[2]) break;
                                int n9 = n;
                                StrongComponentsGraph.this.reach[n9] = StrongComponentsGraph.this.reach[n9] + nArray7[0];
                                return;
                            }
                        }
                        IntEnumeration intEnumeration = bitSetArray.elements(n);
                        while (intEnumeration.hasMoreElements()) {
                            n2 = intEnumeration.nextInt();
                            bitSetArray2.set(n, n2);
                            bitSetArray2.or(n, n2);
                        }
                        intEnumeration = bitSetArray2.elements(n);
                        while (intEnumeration.hasMoreElements()) {
                            n2 = intEnumeration.nextInt();
                            int n10 = n;
                            StrongComponentsGraph.this.reach[n10] = StrongComponentsGraph.this.reach[n10] + nArray[n2];
                        }
                        switch (n3) {
                            case 1: {
                                nArray2[0] = n4;
                                nArray5[0] = StrongComponentsGraph.this.reach[n] - nArray[n];
                                break;
                            }
                            case 2: {
                                nArray3[0] = n4;
                                nArray3[1] = n5;
                                nArray6[0] = StrongComponentsGraph.this.reach[n] - nArray[n];
                                break;
                            }
                            case 3: {
                                nArray4[0] = n4;
                                nArray4[1] = n5;
                                nArray4[2] = n6;
                                nArray7[0] = StrongComponentsGraph.this.reach[n] - nArray[n];
                            }
                        }
                        bitSetArray2.clearAll(n);
                    } else {
                        StrongComponentsGraph.this.reach[n] = nArray[n];
                        IntEnumeration intEnumeration = bitSetArray2.elements(n);
                        while (intEnumeration.hasMoreElements()) {
                            int n11 = intEnumeration.nextInt();
                            int n12 = n;
                            StrongComponentsGraph.this.reach[n12] = StrongComponentsGraph.this.reach[n12] + nArray[n11];
                        }
                    }
                }
            }, i, bitSet2);
        }
    }

    void transitiveClosureInterval() {
        int n;
        final BitSetArray bitSetArray = new BitSetArray(this.size, "transitiveClosure", true, maxmedium);
        final int[] nArray = new int[this.size];
        final int[] nArray2 = new int[this.size];
        this.reach = new int[this.size];
        BitSet bitSet = new BitSet();
        for (n = 0; n < this.size; ++n) {
            if (n != 0 && this.isNotRoot.get(n)) continue;
            this.dfs(new Visitor(){
                int done;
                int p;

                int size() {
                    return (nArray.length + nArray2.length << 2) + bitSetArray.totalMemory();
                }

                public void enterNode(int n, int n2) {
                    nArray2[n] = Integer.MAX_VALUE;
                }

                public void visitChild(int n, int n2, boolean bl, int n3) {
                    if (!bl) {
                        return;
                    }
                    if (nArray2[n2] < nArray2[n]) {
                        nArray2[n] = nArray2[n2];
                    }
                }

                public void exitNode(int n) {
                    nArray[n] = ++this.p;
                    if (nArray[n] < nArray2[n]) {
                        nArray2[n] = nArray[n];
                    }
                }
            }, n, bitSet);
        }
        this.log("done first phase");
        bitSet = new BitSet();
        for (n = 0; n < this.size; ++n) {
            if (n != 0 && this.isNotRoot.get(n)) continue;
            this.dfs(new Visitor(){
                int done;
                int p;

                int size() {
                    return (nArray.length + nArray2.length << 2) + bitSetArray.totalMemory();
                }

                public void enterNode(int n, int n2) {
                    if (this.done++ % logFreq == 0) {
                        StrongComponentsGraph.this.log("done " + this.done + " at depth " + n2 + " memory usage " + this.size());
                    }
                    bitSetArray.set(n, nArray2[n], nArray[n]);
                }

                public void visitChildAtExit(int n, int n2, boolean bl) {
                    if (nArray2[n2] >= nArray2[n] && nArray[n2] <= nArray[n]) {
                        return;
                    }
                    bitSetArray.set(n, nArray2[n2], nArray[n2]);
                }
            }, n, bitSet);
        }
        this.log("finished second phase");
    }

    void transitiveClosure() {
        this.log("begin transitiveClosure");
        if (this.onlymedium) {
            this.transitiveClosureOnlyMedium();
        } else if (this.useinterval) {
            this.transitiveClosureInterval();
        } else if (this.usecomplex) {
            this.transitiveClosureReallyFast();
        } else if (this.usebranches) {
            this.transitiveClosureSlowish();
        } else if (this.uselessmemory) {
            this.transitiveClosureSlow();
        } else {
            this.transitiveClosureFast();
        }
        this.log("end transitiveClosure");
    }
}

