/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.DurableSubscription;
import com.ibm.ejs.jms.DurableSubscriptionLog;
import com.ibm.ejs.jms.DurableSubscriptionManager;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedSession;
import com.ibm.ejs.jms.JMSManagedSessionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.TopicSession;
import javax.resource.ResourceException;

public class DurableSubscriptionManagerImpl
implements DurableSubscriptionManager,
DeployedObjectListener {
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$DurableSubscriptionManagerImpl == null ? (class$com$ibm$ejs$jms$DurableSubscriptionManagerImpl = DurableSubscriptionManagerImpl.class$("com.ibm.ejs.jms.DurableSubscriptionManagerImpl")) : class$com$ibm$ejs$jms$DurableSubscriptionManagerImpl), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    private static final int MAX_RETRIES = 5;
    List installedApps = null;
    String durableSubDataFile = null;
    Hashtable moduleSubscriptions = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ejs$jms$DurableSubscriptionManagerImpl;

    public DurableSubscriptionManagerImpl() {
        Tr.entry((TraceComponent)tc, (String)"DurableSubscriptionManagerImpl");
        Tr.exit((TraceComponent)tc, (String)"DurableSubscriptionManagerImpl");
    }

    public void initialize(List list, String string) {
        Tr.entry((TraceComponent)tc, (String)"initialize");
        this.installedApps = list;
        this.durableSubDataFile = string == null || string.length() == 0 ? ServerName.getDisplayName() + "-durableSubscriptions.ser" : string + File.separator + ServerName.getDisplayName() + "-durableSubscriptions.ser";
        Tr.event((TraceComponent)tc, (String)"Durable subscription log file name: ", (Object)this.durableSubDataFile);
        Tr.exit((TraceComponent)tc, (String)"initialize");
    }

    public synchronized void checkDurableSubscriptions() {
        Tr.entry((TraceComponent)tc, (String)"checkDurableSubscriptions");
        try {
            List list = this.readDurableSubscriptionFile();
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DurableSubscriptionLog durableSubscriptionLog = (DurableSubscriptionLog)iterator.next();
                if (this.installedApps.contains(durableSubscriptionLog.getApplicationName())) continue;
                Tr.event((TraceComponent)tc, (String)"unsubscribing durable subscription log entry for deleted application", (Object)durableSubscriptionLog);
                if (!this.cleanUpDurableSubscription(durableSubscriptionLog) && durableSubscriptionLog.getUnsubscribeCount() < 5) {
                    durableSubscriptionLog.incrementUnsubscribeCount();
                } else {
                    iterator.remove();
                }
                bl = true;
            }
            if (bl) {
                this.writeDurableSubscriptionFile(list);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.checkDurableSubscriptions", "109", this);
            Tr.warning((TraceComponent)tc, (String)"CheckDurableSubscriptionException", (Object)exception);
        }
        Tr.exit((TraceComponent)tc, (String)"checkDurableSubscriptions");
    }

    private synchronized void validateSubscriptionsForApp(String string) {
        Tr.entry((TraceComponent)tc, (String)"validateSubscriptionsForApp", (Object)string);
        try {
            List list = this.readDurableSubscriptionFile();
            Hashtable hashtable = (Hashtable)this.moduleSubscriptions.get(string);
            int n = DurableSubscriptionManager.subscriptionTypes.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                int n2 = DurableSubscriptionManager.subscriptionTypes[i];
                if (tc.isEntryEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Validating durable subscriptions of type: ", (Object)new Integer(n2));
                }
                Hashtable<String, DurableSubscription> hashtable2 = new Hashtable<String, DurableSubscription>();
                if (hashtable != null && (object2 = (List)hashtable.get(new Integer(n2))) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        DurableSubscription durableSubscription = (DurableSubscription)object.next();
                        hashtable2.put(durableSubscription.getName(), durableSubscription);
                    }
                }
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (DurableSubscriptionLog)object2.next();
                    if (!((DurableSubscriptionLog)object).getApplicationName().equals(string) || ((DurableSubscriptionLog)object).getType() != n2 || hashtable2.containsKey(((DurableSubscriptionLog)object).getName())) continue;
                    Tr.event((TraceComponent)tc, (String)"unsubscribing durable subscription log entry for redundent subscription", (Object)object);
                    if (!this.cleanUpDurableSubscription((DurableSubscriptionLog)object) && ((DurableSubscriptionLog)object).getUnsubscribeCount() < 5) {
                        ((DurableSubscriptionLog)object).incrementUnsubscribeCount();
                        continue;
                    }
                    object2.remove();
                }
            }
            this.writeDurableSubscriptionFile(list);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.setCurrentSubscriptionsForApp", "178", this);
            Tr.warning((TraceComponent)tc, (String)"SetCurrentSubscriptionsForAppException", (Object)exception);
        }
        Tr.exit((TraceComponent)tc, (String)"validateSubscriptionsForApp");
    }

    public synchronized void setCurrentSubscriptionsForModule(String string, int n, List list) {
        Vector<DurableSubscription> vector;
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCurrentSubscriptionsForModule", (Object)new Object[]{string, new Integer(n), list});
        }
        if ((hashtable = (Hashtable)this.moduleSubscriptions.get(string)) == null) {
            hashtable = new Hashtable();
            this.moduleSubscriptions.put(string, hashtable);
        }
        if ((vector = (Vector<DurableSubscription>)hashtable.get(new Integer(n))) == null) {
            vector = new Vector<DurableSubscription>();
            hashtable.put(new Integer(n), vector);
        }
        try {
            List list2 = this.readDurableSubscriptionFile();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DurableSubscription durableSubscription = (DurableSubscription)iterator.next();
                vector.add(durableSubscription);
                JMSManagedSessionFactory jMSManagedSessionFactory = (JMSManagedSessionFactory)durableSubscription.getJMSManagedSessionFactory();
                DurableSubscriptionLog durableSubscriptionLog = new DurableSubscriptionLog(durableSubscription.getName(), string, n, jMSManagedSessionFactory);
                int n2 = list2.indexOf(durableSubscriptionLog);
                if (n2 > -1) {
                    ((DurableSubscriptionLog)list2.get(n2)).setManagedSessionFactory(jMSManagedSessionFactory);
                    Tr.event((TraceComponent)tc, (String)"updated MSF for existing durable subscription log entry", (Object)durableSubscriptionLog);
                    continue;
                }
                list2.add(durableSubscriptionLog);
                Tr.event((TraceComponent)tc, (String)"added new durable subscription log entry", (Object)durableSubscriptionLog);
            }
            this.writeDurableSubscriptionFile(list2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.setCurrentSubscriptionsForModule", "296", this);
            Tr.warning((TraceComponent)tc, (String)"SetCurrentSubscriptionsForAppException", (Object)exception);
        }
        Tr.exit((TraceComponent)tc, (String)"setCurrentSubscriptionsForModule");
    }

    private boolean cleanUpDurableSubscription(DurableSubscriptionLog durableSubscriptionLog) {
        boolean bl;
        block10: {
            Tr.entry((TraceComponent)tc, (String)"cleanUpDurableSubscription", (Object)durableSubscriptionLog);
            bl = false;
            TopicSession topicSession = null;
            try {
                JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = new JMSListenerSessionRequestInfo(1, false);
                JMSManagedSessionFactory jMSManagedSessionFactory = durableSubscriptionLog.getManagedSessionFactory();
                if (jMSManagedSessionFactory != null) {
                    JMSManagedSession jMSManagedSession = (JMSManagedSession)jMSManagedSessionFactory.createManagedConnection(null, jMSListenerSessionRequestInfo);
                    topicSession = (TopicSession)jMSManagedSession.getConnection(null, jMSListenerSessionRequestInfo);
                    topicSession.unsubscribe(durableSubscriptionLog.getName());
                    topicSession.close();
                } else {
                    Tr.event((TraceComponent)tc, (String)"JMSManagedSessionFactory is null");
                }
                bl = true;
                Tr.audit((TraceComponent)tc, (String)"CleanedUpDurableSubscription", (Object)durableSubscriptionLog.getName());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.cleanUpDurableSubscription", "207", this);
                if (durableSubscriptionLog.getUnsubscribeCount() == 5) {
                    String string = throwable.toString();
                    if (throwable instanceof ResourceException) {
                        string = ((ResourceException)throwable).getLinkedException().toString();
                    } else if (throwable instanceof JMSException) {
                        string = ((JMSException)throwable).getLinkedException().toString();
                    }
                    Tr.warning((TraceComponent)tc, (String)"CleanupDurableSubscriptionException", (Object)new Object[]{durableSubscriptionLog.getName(), string});
                }
                Tr.debug((TraceComponent)tc, (String)"Exception:", (Object)throwable);
                if (topicSession == null) break block10;
                try {
                    topicSession.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException(throwable2, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.cleanUpDurableSubscription", "210", this);
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"cleanUpDurableSubscription", (Object)new Boolean(bl));
        return bl;
    }

    private List readDurableSubscriptionFile() throws Exception {
        Tr.entry((TraceComponent)tc, (String)"readDurableSubscriptionFile");
        Vector vector = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.durableSubDataFile);
            objectInputStream = new ObjectInputStream(fileInputStream);
            vector = (Vector)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.readDurableSubscriptionFile", "236", this);
            Tr.event((TraceComponent)tc, (String)"Durable subscription data file does not exist", (Object)this.durableSubDataFile);
            vector = new Vector();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.readDurableSubscriptionFile", "242", this);
            Tr.event((TraceComponent)tc, (String)"Exception reading durable subscription data file", (Object)new Object[]{this.durableSubDataFile, exception});
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            vector = new Vector();
        }
        Tr.exit((TraceComponent)tc, (String)"readDurableSubscriptionFile", vector);
        return vector;
    }

    private void writeDurableSubscriptionFile(List list) throws Exception {
        Tr.entry((TraceComponent)tc, (String)"writeDurableSubscriptionFile", (Object)list);
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.durableSubDataFile);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(list);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.DurableSubscriptionManagerImpl.writeDurableSubscriptionFile", "272", this);
            Tr.event((TraceComponent)tc, (String)"Exception writing durable subscription data file", (Object)new Object[]{this.durableSubDataFile, exception});
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            Tr.exit((TraceComponent)tc, (String)"writeDurableSubscriptionFile");
            throw exception;
        }
        Tr.exit((TraceComponent)tc, (String)"writeDurableSubscriptionFile");
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject;
        Tr.entry((TraceComponent)tc, (String)"stateChanged", (Object)deployedObjectEvent);
        if (deployedObjectEvent.getNewValue() == "STARTING") {
            DeployedObject deployedObject2 = (DeployedObject)deployedObjectEvent.getSource();
            if (deployedObject2.getModuleFile().isEARFile()) {
                this.applicationStarting(deployedObject2.getName());
            }
        } else if (deployedObjectEvent.getNewValue() == "STARTED" && (deployedObject = (DeployedObject)deployedObjectEvent.getSource()).getModuleFile().isEARFile()) {
            this.applicationStarted(deployedObject.getName());
        }
        Tr.exit((TraceComponent)tc, (String)"stateChanged");
    }

    private synchronized void applicationStarting(String string) {
        Tr.entry((TraceComponent)tc, (String)"applicationStarting", (Object)string);
        this.moduleSubscriptions.remove(string);
        Tr.exit((TraceComponent)tc, (String)"applicationStarting");
    }

    private synchronized void applicationStarted(String string) {
        Tr.entry((TraceComponent)tc, (String)"applicationStarted", (Object)string);
        this.moduleSubscriptions.remove(string);
        Tr.exit((TraceComponent)tc, (String)"applicationStarted");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

