/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.jms.mq.JMSWrapXAQueueConnectionFactory;
import com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.rmi.PortableRemoteObject;

public abstract class GenericJMSManagedConnectionFactory
extends JMSManagedConnectionFactory {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$GenericJMSManagedConnectionFactory == null ? (class$com$ibm$ejs$jms$GenericJMSManagedConnectionFactory = GenericJMSManagedConnectionFactory.class$("com.ibm.ejs.jms.GenericJMSManagedConnectionFactory")) : class$com$ibm$ejs$jms$GenericJMSManagedConnectionFactory), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private String providerURL = null;
    private String contextFactoryClassname = null;
    private String jndiPath = null;
    private Properties customProperties = null;
    private static final long serialVersionUID = -538947506115951420L;
    static /* synthetic */ Class class$com$ibm$ejs$jms$GenericJMSManagedConnectionFactory;
    static /* synthetic */ Class class$javax$jms$ConnectionFactory;

    public final void setContextFactoryClassname(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ContextFactoryClassname set", (Object)string);
        }
        this.contextFactoryClassname = string;
    }

    public final void setJNDIPath(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JNDIPath set", (Object)string);
        }
        this.jndiPath = string;
    }

    public final void setProviderURL(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ProviderURL set", (Object)string);
        }
        this.providerURL = string;
    }

    public void setDataSourceProperties(Properties properties) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DataSourceProperties set", (Object)properties);
        }
        this.customProperties = properties;
    }

    public Properties getDataSourceProperties() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DataSourceProperties get", (Object)this.customProperties);
        }
        return this.customProperties;
    }

    public final String getContextFactoryClassname() {
        return this.contextFactoryClassname;
    }

    public final String getJNDIPath() {
        return this.jndiPath;
    }

    public final String getProviderURL() {
        return this.providerURL;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GenericJMSManagedConnectionFactory genericJMSManagedConnectionFactory = (GenericJMSManagedConnectionFactory)object;
        if (!JMSCMUtils.objectsEqual(this.providerURL, genericJMSManagedConnectionFactory.providerURL)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.contextFactoryClassname, genericJMSManagedConnectionFactory.contextFactoryClassname)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.jndiPath, genericJMSManagedConnectionFactory.jndiPath)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.customProperties, genericJMSManagedConnectionFactory.customProperties);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.providerURL);
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.contextFactoryClassname);
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.jndiPath);
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.customProperties);
        return n;
    }

    protected void setupForRecovery() {
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "provider URL = " + this.providerURL);
        stringBuffer.append(string + "context factory classname = " + this.contextFactoryClassname);
        stringBuffer.append(string + "JNDI path = " + this.jndiPath);
        stringBuffer.append(string + "custom properties = " + this.customProperties);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ConnectionFactory getConnectionFactory() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnectionFactory");
        }
        try {
            block10: {
                try {
                    if (this.connectionFactory != null) break block10;
                    Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                    if (this.providerURL != null) {
                        hashtable.put("java.naming.provider.url", this.providerURL);
                    }
                    if (this.contextFactoryClassname != null) {
                        hashtable.put("java.naming.factory.initial", this.contextFactoryClassname);
                    }
                    if (this.customProperties != null) {
                        hashtable.putAll(JMSResourceRefBuilderFactory.getNamingProperties((Properties)this.customProperties));
                    }
                    InitialContext initialContext = new InitialContext(hashtable);
                    Object object = initialContext.lookup(this.jndiPath);
                    this.connectionFactory = (ConnectionFactory)PortableRemoteObject.narrow((Object)object, (Class)(class$javax$jms$ConnectionFactory == null ? (class$javax$jms$ConnectionFactory = GenericJMSManagedConnectionFactory.class$("javax.jms.ConnectionFactory")) : class$javax$jms$ConnectionFactory));
                    if (this.connectionFactory instanceof JMSWrapXAQueueConnectionFactory) {
                        JMSWrapXAQueueConnectionFactory jMSWrapXAQueueConnectionFactory = (JMSWrapXAQueueConnectionFactory)this.connectionFactory;
                        this.connectionFactory = jMSWrapXAQueueConnectionFactory.getWrappedFactory();
                        break block10;
                    }
                    if (!(this.connectionFactory instanceof JMSWrapXATopicConnectionFactory)) break block10;
                    JMSWrapXATopicConnectionFactory jMSWrapXATopicConnectionFactory = (JMSWrapXATopicConnectionFactory)this.connectionFactory;
                    this.connectionFactory = jMSWrapXATopicConnectionFactory.getWrappedFactory();
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.GenericJMSManagedConnectionFactory.getConnectionFactory", "258", this);
                    throw JMSCMUtils.mapToResourceException(classCastException, tc, "Expected to find JMS ConnectionFactory in JNDI");
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, "com.ibm.ejs.jms.GenericJMSManagedConnectionFactory.getConnectionFactory", "263", this);
                    throw JMSCMUtils.mapToResourceException(namingException, tc, "ConnectionFactory not found in JNDI");
                }
            }
            Object var6_8 = null;
            if (!tc.isEntryEnabled()) return this.connectionFactory;
            Tr.exit((TraceComponent)tc, (String)"getConnectionFactory", (Object)this.connectionFactory);
            return this.connectionFactory;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getConnectionFactory", (Object)this.connectionFactory);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

