/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;

public final class JMSCMUtils {
    static int HASH_CODE_PRIME = 1000003;
    static String MSG_BUNDLE = "com.ibm.ejs.jms.messaging";

    private JMSCMUtils() {
    }

    static boolean inGlobalTransaction() {
        return TransactionManagerFactory.getUOWCurrent().getUOWType() == 2;
    }

    static JMSException mapToJMSException(ResourceException resourceException, TraceComponent traceComponent, String string) {
        if (traceComponent.isEventEnabled()) {
            Tr.event((TraceComponent)traceComponent, (String)"Caught exception:", (Object)resourceException);
        }
        JMSException jMSException = null;
        Exception exception = resourceException.getLinkedException();
        while (exception != null) {
            if (exception instanceof JMSException) {
                jMSException = (JMSException)exception;
                break;
            }
            if (!(exception instanceof ResourceException)) break;
            exception = ((ResourceException)exception).getLinkedException();
        }
        if (jMSException == null) {
            jMSException = new JMSException(string);
            jMSException.setLinkedException((Exception)resourceException);
        }
        if (traceComponent.isEventEnabled()) {
            Tr.event((TraceComponent)traceComponent, (String)"Mapping to JMSException:", (Object)resourceException);
            Exception exception2 = resourceException.getLinkedException();
            if (exception2 != null) {
                Tr.event((TraceComponent)traceComponent, (String)"Linked exception", (Object)exception2);
            }
        }
        return jMSException;
    }

    static ResourceException mapToResourceException(Exception exception, TraceComponent traceComponent, String string) {
        if (traceComponent.isEventEnabled()) {
            Tr.event((TraceComponent)traceComponent, (String)"Caught exception:", (Object)exception);
        }
        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(string);
        resourceAdapterInternalException.setLinkedException(exception);
        if (traceComponent.isEventEnabled()) {
            Tr.event((TraceComponent)traceComponent, (String)"Mapping to ResourceException:", (Object)exception);
        }
        return resourceAdapterInternalException;
    }

    static int objectHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    static String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    static boolean objectsEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    static IllegalStateException methodNotPermittedException(TraceComponent traceComponent, String string) {
        IllegalStateException illegalStateException = new IllegalStateException("Method " + string + " not permitted");
        if (traceComponent.isEventEnabled()) {
            Tr.event((TraceComponent)traceComponent, (String)("Method " + string + " not permitted"), (Object)illegalStateException);
        }
        return illegalStateException;
    }

    static void trace(TraceComponent traceComponent, String string, JMSException jMSException) {
        if (traceComponent.isEventEnabled()) {
            Tr.event((TraceComponent)traceComponent, (String)("Caught JMSException in " + string), (Object)jMSException);
            Exception exception = jMSException.getLinkedException();
            if (exception != null) {
                Tr.event((TraceComponent)traceComponent, (String)"Linked exception", (Object)exception);
            }
        }
    }

    static String subjectToString(Subject subject) {
        String string = null;
        if (subject != null) {
            final Subject subject2 = subject;
            string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return subject2.toString();
                }
            });
        }
        return string;
    }
}

