/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionFactoryHandle;
import com.ibm.ejs.jms.JMSManagedConnection;
import com.ibm.ejs.jms.JMSManagedSessionFactory;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.resource.spi.ConnectionManager;

public abstract class JMSConnectionHandle
implements Connection,
Serializable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSConnectionHandle == null ? (class$com$ibm$ejs$jms$JMSConnectionHandle = JMSConnectionHandle.class$("com.ibm.ejs.jms.JMSConnectionHandle")) : class$com$ibm$ejs$jms$JMSConnectionHandle), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private boolean closed = false;
    private boolean invalid = false;
    private List openSessionHandles = Collections.synchronizedList(new ArrayList());
    private boolean restrictedMethodsEnabled = false;
    protected Connection connection;
    private JMSManagedConnection managedConnection;
    protected final ConnectionManager sessionManager;
    protected final JMSManagedSessionFactory factory;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSConnectionHandle;

    JMSConnectionHandle(JMSManagedSessionFactory jMSManagedSessionFactory, ConnectionManager connectionManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSConnectionHandle", (Object)new Object[]{jMSManagedSessionFactory, connectionManager});
        }
        this.sessionManager = connectionManager;
        this.factory = jMSManagedSessionFactory;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JMSConnectionHandle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void setClientID(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setClientID", (Object)string);
        }
        try {
            try {
                this.checkRestrictedMethod("setClientID");
                this.checkOpen();
                this.checkValid();
                try {
                    this.connection.setClientID(string);
                }
                catch (InvalidClientIDException invalidClientIDException) {
                    throw invalidClientIDException;
                }
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (JMSException jMSException) {
                    this.markManagedConnectionAsStale(jMSException);
                    throw jMSException;
                }
                Object var4_6 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.setClientID", "159", this);
                JMSCMUtils.trace(tc, "setClientID", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"setClientID");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setClientID");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setExceptionListener", (Object)exceptionListener);
        }
        try {
            try {
                this.checkRestrictedMethod("setExceptionListener");
                this.checkOpen();
                this.checkValid();
                this.managedConnection.setExceptionListener(exceptionListener);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.setExceptionListener", "185", this);
                JMSCMUtils.trace(tc, "setExceptionListener", jMSException);
                throw jMSException;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"setExceptionListener");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setExceptionListener");
    }

    public final synchronized String getClientID() throws JMSException {
        this.checkOpen();
        this.checkValid();
        try {
            return this.connection.getClientID();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.getClientID", "218", this);
            JMSCMUtils.trace(tc, "getClientID", jMSException);
            this.markManagedConnectionAsStale(jMSException);
            throw jMSException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized ExceptionListener getExceptionListener() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getExceptionListener");
        }
        ExceptionListener exceptionListener = null;
        try {
            try {
                this.checkOpen();
                this.checkValid();
                exceptionListener = this.managedConnection.getExceptionListener();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.getExceptionListener", "250", this);
                JMSCMUtils.trace(tc, "getExceptionListener", jMSException);
                throw jMSException;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getExceptionListener", (Object)exceptionListener);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return exceptionListener;
        Tr.exit((TraceComponent)tc, (String)"getExceptionListener", (Object)exceptionListener);
        return exceptionListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized ConnectionMetaData getMetaData() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMetaData");
        }
        ConnectionMetaData connectionMetaData = null;
        try {
            try {
                this.checkOpen();
                this.checkValid();
                try {
                    connectionMetaData = this.connection.getMetaData();
                }
                catch (JMSException jMSException) {
                    this.markManagedConnectionAsStale(jMSException);
                    throw jMSException;
                }
                Object var4_4 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.getMetaData", "291", this);
                JMSCMUtils.trace(tc, "getMetaData", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)connectionMetaData);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return connectionMetaData;
        Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)connectionMetaData);
        return connectionMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        try {
            block9: {
                try {
                    this.checkValid();
                    if (!this.openSessionHandles.isEmpty()) {
                        ArrayList arrayList = new ArrayList(this.openSessionHandles);
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            Session session = (Session)iterator.next();
                            try {
                                session.close();
                            }
                            catch (JMSException jMSException) {
                                this.markManagedConnectionAsStale(jMSException);
                                throw jMSException;
                            }
                        }
                    }
                    this.deleteTemporaryDestinations();
                    if (this.closed) break block9;
                    this.closed = true;
                    if (this.managedConnection == null) break block9;
                    this.managedConnection.handleClosed(this);
                    this.managedConnection = null;
                    this.connection = null;
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.close", "345", this);
                    JMSCMUtils.trace(tc, "close", jMSException);
                    throw jMSException;
                }
            }
            Object var6_6 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"close");
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"close");
            throw throwable;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSConnectionHandle jMSConnectionHandle = (JMSConnectionHandle)object;
        if (this.closed != jMSConnectionHandle.closed) {
            return false;
        }
        if (this.invalid != jMSConnectionHandle.invalid) {
            return false;
        }
        if (this.restrictedMethodsEnabled != jMSConnectionHandle.restrictedMethodsEnabled) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.managedConnection, jMSConnectionHandle.managedConnection);
    }

    public int hashCode() {
        return JMSCMUtils.objectHashCode(this.managedConnection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void start() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            try {
                this.checkOpen();
                this.checkValid();
                try {
                    this.connection.start();
                }
                catch (JMSException jMSException) {
                    this.markManagedConnectionAsStale(jMSException);
                    throw jMSException;
                }
                Object var3_3 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.start", "438", this);
                JMSCMUtils.trace(tc, "start", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"start");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"start");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void stop() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        try {
            try {
                this.checkRestrictedMethod("stop");
                this.checkOpen();
                this.checkValid();
                try {
                    this.connection.stop();
                }
                catch (JMSException jMSException) {
                    this.markManagedConnectionAsStale(jMSException);
                    throw jMSException;
                }
                Object var3_3 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSConnectionHandle.stop", "477", this);
                JMSCMUtils.trace(tc, "stop", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"stop");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"stop");
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "managed connection = " + JMSCMUtils.objectToString(this.managedConnection));
        stringBuffer.append(string + "physical connection = " + this.connection);
        stringBuffer.append(string + "closed = " + this.closed);
        stringBuffer.append(string + "invalid = " + this.invalid);
        stringBuffer.append(string + "restricted methods enabled = " + this.restrictedMethodsEnabled);
        stringBuffer.append(string + "open session handles = [");
        Iterator iterator = this.openSessionHandles.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected final void checkOpen() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Connection closed");
        }
    }

    protected final void checkRestrictedMethod(String string) throws JMSException {
        if (!this.restrictedMethodsEnabled) {
            throw JMSCMUtils.methodNotPermittedException(tc, string);
        }
    }

    protected final void checkValid() throws IllegalStateException {
        if (this.invalid) {
            throw new IllegalStateException("Connection invalidated");
        }
    }

    final void setManagedConnection(JMSManagedConnection jMSManagedConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setManagedConnection", (Object)jMSManagedConnection);
        }
        this.managedConnection = jMSManagedConnection;
        this.connection = jMSManagedConnection.getPhysicalConnection();
        this.factory.setManagedConnection(jMSManagedConnection);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setManagedConnection");
        }
    }

    final JMSManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    final synchronized void markManagedConnectionAsStale(JMSException jMSException) {
        if (this.managedConnection != null) {
            this.managedConnection.connectionErrorOccurred((Exception)((Object)jMSException));
        }
    }

    final boolean getRestrictedMethodsEnabled() {
        return this.restrictedMethodsEnabled;
    }

    final synchronized void invalidate() {
        this.invalid = true;
        this.managedConnection = null;
        this.connection = null;
    }

    final void addSessionHandle(JMSSessionHandle jMSSessionHandle) {
        this.openSessionHandles.add(jMSSessionHandle);
    }

    final void removeSessionHandle(JMSSessionHandle jMSSessionHandle) {
        this.openSessionHandles.remove(jMSSessionHandle);
    }

    final void setConnectionFactoryHandle(JMSConnectionFactoryHandle jMSConnectionFactoryHandle) {
        this.restrictedMethodsEnabled = jMSConnectionFactoryHandle.getRestrictedMethodsEnabled();
    }

    final JMSManagedSessionFactory getManagedSessionFactory() {
        return this.factory;
    }

    final ConnectionManager getSessionManager() {
        return this.sessionManager;
    }

    abstract void deleteTemporaryDestinations() throws JMSException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

