/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.j2c.ConnectionFactoryBuilder;
import com.ibm.ejs.j2c.ConnectionFactoryBuilderFactory;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.jms.GenericJMSManagedConnectionFactory;
import com.ibm.ejs.jms.GenericJMSManagedQueueConnectionFactory;
import com.ibm.ejs.jms.GenericJMSManagedTopicConnectionFactory;
import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSConnectionRequestInfo;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.jms.WSJMSManagedConnectionFactory;
import com.ibm.ejs.jms.WSJMSManagedQueueConnectionFactory;
import com.ibm.ejs.jms.WSJMSManagedTopicConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.jca.TransactionSupportKind;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.security.util.PasswordUtil;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

abstract class JMSManagedConnection
implements ManagedConnection,
ExceptionListener,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSManagedConnection == null ? (class$com$ibm$ejs$jms$JMSManagedConnection = JMSManagedConnection.class$("com.ibm.ejs.jms.JMSManagedConnection")) : class$com$ibm$ejs$jms$JMSManagedConnection), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private final Set connectionEventListeners = Collections.synchronizedSet(new HashSet());
    private ExceptionListener exceptionListener = null;
    private ExceptionListener connectionExceptionListener = null;
    private JMSException jmsException = null;
    private final Set openConnectionHandles = Collections.synchronizedSet(new HashSet());
    private final Connection connection;
    private PrintWriter logWriter;
    protected boolean xaCapable;
    private final PasswordCredential credential;
    private final ConnectionFactory connectionFactory;
    private final JMSManagedConnectionFactory managedConnectionFactory;
    private final Set sessionSharingScopes = new HashSet();
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSManagedConnection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JMSManagedConnection(JMSManagedConnectionFactory jMSManagedConnectionFactory, PasswordCredential passwordCredential) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSManagedConnection", (Object)new Object[]{jMSManagedConnectionFactory, passwordCredential});
        }
        try {
            try {
                this.credential = passwordCredential;
                this.logWriter = jMSManagedConnectionFactory.getLogWriter();
                this.connectionFactory = jMSManagedConnectionFactory.getConnectionFactory();
                this.managedConnectionFactory = jMSManagedConnectionFactory;
                if (passwordCredential == null || this.managedConnectionFactory.getServerRecoveryNoCredentials()) {
                    this.connection = this.createConnection(this.connectionFactory);
                } else {
                    String string = passwordCredential.getUserName();
                    String string2 = new String(passwordCredential.getPassword());
                    this.connection = this.createConnection(this.connectionFactory, string, string2);
                }
                this.connection.setExceptionListener((ExceptionListener)this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.JMSManagedConnection", "168", this);
                throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to create connection");
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedConnection.JMSManagedConnection", "173", this);
                Tr.event((TraceComponent)tc, (String)"Caught ResourceException when attempting to create physical connection factory:", (Object)((Object)resourceException));
                throw resourceException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"JMSManagedConnection");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"JMSManagedConnection");
    }

    public String[] introspectSelf() {
        String[] stringArray = new String[12];
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer();
        stringArray[0] = JMSCMUtils.objectToString(this);
        stringArray[1] = string + "tc = " + tc;
        stringArray[2] = string + "connectionEventListeners = " + this.connectionEventListeners;
        stringArray[3] = string + "exceptionListener = " + this.exceptionListener;
        stringArray[4] = string + "openConnectionHandles = " + this.openConnectionHandles;
        stringArray[5] = string + "connection = " + this.connection;
        stringArray[6] = string + "logWriter = " + this.logWriter;
        stringArray[7] = string + "xaCapable = " + this.xaCapable;
        if (this.credential == null) {
            stringArray[8] = string + "credential = null";
        } else {
            stringBuffer.append(string + "credential = ");
            stringBuffer.append(string + string + "UserName = " + this.credential.getUserName());
            stringBuffer.append(string + string + "Password not dumped");
            stringArray[8] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        stringArray[9] = string + "connectionFactory = " + this.connectionFactory;
        if (this.managedConnectionFactory == null) {
            stringArray[10] = string + "managedConnectionFactory = null";
        } else {
            String[] stringArray2 = this.managedConnectionFactory.introspectSelf();
            stringBuffer.append(string + "managedConnectionFactory = ");
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuffer.append(string + stringArray2[i]);
            }
            stringArray[10] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        stringArray[11] = string + "sessionSharingScopes = " + this.sessionSharingScopes;
        return stringArray;
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Log writer set", (Object)printWriter);
        }
        this.logWriter = printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        JMSConnectionHandle jMSConnectionHandle = null;
        try {
            try {
                Properties properties = new Properties();
                String string = this.managedConnectionFactory.getConnectorName() + "$JMSManagedConnection@" + System.identityHashCode(this);
                properties.setProperty("name", string);
                String string2 = this.getManagedSessionFactoryClassName();
                properties.setProperty("managedConnectionFactoryClass", string2);
                properties.putAll((Map<?, ?>)this.managedConnectionFactory.getSessionPoolProperties());
                ConnectorProperties connectorProperties = new ConnectorProperties();
                ConnectorProperty connectorProperty = new ConnectorProperty("TransactionResourceRegistration", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), "dynamic");
                connectorProperties.add((Object)connectorProperty);
                ConnectorProperty connectorProperty2 = new ConnectorProperty("InactiveConnectionSupport", (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JMSManagedConnection.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), Boolean.TRUE.toString());
                connectorProperties.add((Object)connectorProperty2);
                String string3 = this.xaCapable ? TransactionSupportKind.XA_TRANSACTION_LITERAL.getName() : TransactionSupportKind.LOCAL_TRANSACTION_LITERAL.getName();
                properties.setProperty("transactionSupport", string3);
                Properties properties2 = this.getMCFProperties(connectorProperties);
                JMSConnectionRequestInfo jMSConnectionRequestInfo = (JMSConnectionRequestInfo)connectionRequestInfo;
                int n = jMSConnectionRequestInfo.getSessionSharing() ? 0 : 1;
                ConnectionFactoryBuilder connectionFactoryBuilder = ConnectionFactoryBuilderFactory.create();
                jMSConnectionHandle = (JMSConnectionHandle)connectionFactoryBuilder.getConnectionFactory(properties, properties2, connectorProperties, n, 0, 1);
                this.sessionSharingScopes.add(new Integer(n));
                jMSConnectionHandle.setManagedConnection(this);
                Set set = this.openConnectionHandles;
                synchronized (set) {
                    this.openConnectionHandles.add(jMSConnectionHandle);
                }
                Object var20_19 = null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedConnection.getConnection", "274", this);
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to create JMSManagedSessionFactory");
                resourceAdapterInternalException.setLinkedException(exception);
                if (!tc.isDebugEnabled()) throw resourceAdapterInternalException;
                Tr.debug((TraceComponent)tc, (String)"Failed to create JMSManagedSessionFactory", (Object)resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getConnection", jMSConnectionHandle);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return jMSConnectionHandle;
        Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)jMSConnectionHandle);
        return jMSConnectionHandle;
    }

    public final Properties getMCFProperties(ConnectorProperties connectorProperties) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMCFProperties", (Object)connectorProperties);
        }
        boolean bl = true;
        Properties properties = null;
        if (this.managedConnectionFactory instanceof WSJMSManagedQueueConnectionFactory) {
            connectorProperties.add((Object)new ConnectorProperty("mcfClassname", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), "com.ibm.ejs.jms.WSJMSManagedQueueConnectionFactory"));
            properties = ((WSJMSManagedQueueConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = true;
        }
        if (this.managedConnectionFactory instanceof WSJMSManagedTopicConnectionFactory) {
            connectorProperties.add((Object)new ConnectorProperty("mcfClassname", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), "com.ibm.ejs.jms.WSJMSManagedTopicConnectionFactory"));
            properties = ((WSJMSManagedTopicConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = true;
        }
        if (this.managedConnectionFactory instanceof GenericJMSManagedQueueConnectionFactory) {
            connectorProperties.add((Object)new ConnectorProperty("mcfClassname", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), "com.ibm.ejs.jms.GenericJMSManagedQueueConnectionFactory"));
            properties = ((GenericJMSManagedQueueConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = false;
        }
        if (this.managedConnectionFactory instanceof GenericJMSManagedTopicConnectionFactory) {
            connectorProperties.add((Object)new ConnectorProperty("mcfClassname", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), "com.ibm.ejs.jms.GenericJMSManagedTopicConnectionFactory"));
            properties = ((GenericJMSManagedTopicConnectionFactory)this.managedConnectionFactory).getDataSourceProperties();
            bl = false;
        }
        if (this.credential != null) {
            connectorProperties.add((Object)new ConnectorProperty("mcfUserName", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), this.credential.getUserName()));
            if (this.credential.getPassword() != null) {
                String string = null;
                try {
                    string = PasswordUtil.encode((String)String.valueOf(this.credential.getPassword()));
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedConnection.getMCFProperties", "373", this);
                    ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to encode MCF password");
                    resourceAdapterInternalException.setLinkedException(exception);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to encode MCF password", (Object)resourceAdapterInternalException);
                    }
                    throw resourceAdapterInternalException;
                }
                connectorProperties.add((Object)new ConnectorProperty("mcfPassword", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), string));
            }
        }
        connectorProperties.add((Object)new ConnectorProperty("mcfConnectorName", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), this.managedConnectionFactory.getConnectorName()));
        if (bl) {
            connectorProperties.add((Object)new ConnectorProperty("mcfObjectType", (class$java$lang$Integer == null ? (class$java$lang$Integer = JMSManagedConnection.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), String.valueOf(((WSJMSManagedConnectionFactory)this.managedConnectionFactory).getObjectType())));
        } else {
            connectorProperties.add((Object)new ConnectorProperty("mcfProviderURL", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), ((GenericJMSManagedConnectionFactory)this.managedConnectionFactory).getProviderURL()));
            connectorProperties.add((Object)new ConnectorProperty("mcfContextFactoryClassname", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), ((GenericJMSManagedConnectionFactory)this.managedConnectionFactory).getContextFactoryClassname()));
            connectorProperties.add((Object)new ConnectorProperty("mcfJndiPath", (class$java$lang$String == null ? (class$java$lang$String = JMSManagedConnection.class$("java.lang.String")) : class$java$lang$String).getName(), ((GenericJMSManagedConnectionFactory)this.managedConnectionFactory).getJNDIPath()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMCFProperties", (Object)properties);
        }
        return properties;
    }

    public final ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        NotSupportedException notSupportedException = new NotSupportedException("Does not support LocalTransaction at connection level");
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Does not support LocalTransaction at connection level", (Object)notSupportedException);
        }
        throw notSupportedException;
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new JMSManagedConnectionMetaData();
    }

    public final XAResource getXAResource() throws ResourceException {
        NotSupportedException notSupportedException = new NotSupportedException("Does not support XA resource at connection level");
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Does not support XA resource at connection level", (Object)notSupportedException);
        }
        throw notSupportedException;
    }

    public final void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Adding connection event listener", (Object)connectionEventListener);
        }
        this.connectionEventListeners.add(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object object) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associateConnection", (Object)object);
        }
        try {
            JMSConnectionHandle jMSConnectionHandle;
            if (object instanceof JMSConnectionHandle) {
                jMSConnectionHandle = (JMSConnectionHandle)object;
                JMSManagedConnection jMSManagedConnection = jMSConnectionHandle.getManagedConnection();
                Set set = this.openConnectionHandles;
                synchronized (set) {
                    if (jMSManagedConnection.openConnectionHandles.remove(jMSConnectionHandle)) {
                        this.openConnectionHandles.add(jMSConnectionHandle);
                    }
                }
            } else {
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Can't associate non-JMSConnectionHandle");
                Tr.event((TraceComponent)tc, (String)"Can't associate non-JMSConnectionHandle", (Object)resourceAdapterInternalException);
                throw resourceAdapterInternalException;
            }
            jMSConnectionHandle.setManagedConnection(this);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associateConnection");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associateConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cleanup() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup");
        }
        Object object = this.openConnectionHandles;
        synchronized (object) {
            Iterator iterator = this.openConnectionHandles.iterator();
            while (iterator.hasNext()) {
                JMSConnectionHandle jMSConnectionHandle = (JMSConnectionHandle)iterator.next();
                jMSConnectionHandle.invalidate();
            }
        }
        try {
            block9: {
                try {
                    this.connection.stop();
                    if (this.jmsException == null) break block9;
                    this.connectionExceptionListener = this.connection.getExceptionListener();
                    if (this.connectionExceptionListener == null) break block9;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"About to spawn seperate thread to notify exception listener that an error has occurred");
                    }
                    object = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            if (tc.isEntryEnabled()) {
                                Tr.entry((TraceComponent)tc, (String)"run");
                            }
                            try {
                                try {
                                    JMSManagedConnection.this.connectionExceptionListener.onException(JMSManagedConnection.this.jmsException);
                                }
                                catch (Throwable throwable) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Exception notifying MDBExceptionListener", (Object)throwable);
                                    }
                                    Object var3_2 = null;
                                    if (!tc.isEntryEnabled()) return;
                                    Tr.exit((TraceComponent)tc, (String)"run");
                                    return;
                                }
                                Object var3_1 = null;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                if (!tc.isEntryEnabled()) throw throwable;
                                Tr.exit((TraceComponent)tc, (String)"run");
                                throw throwable;
                            }
                            if (!tc.isEntryEnabled()) return;
                            Tr.exit((TraceComponent)tc, (String)"run");
                        }
                    };
                    ((Thread)object).setDaemon(true);
                    ((Thread)object).start();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.cleanup", "466", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to stop connection on cleanup");
                }
            }
            Object var6_5 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"cleanup");
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"cleanup");
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public final void destroy() throws ResourceException {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"destroy");
            }
            this.connection.close();
            Object var3_1 = null;
            try {
                if (!this.sessionSharingScopes.isEmpty()) {
                    Properties properties = new Properties();
                    String string = this.managedConnectionFactory.getConnectorName() + "$JMSManagedConnection@" + System.identityHashCode(this);
                    properties.setProperty("name", string);
                    ConnectionFactoryBuilder connectionFactoryBuilder = ConnectionFactoryBuilderFactory.create();
                    Iterator iterator = this.sessionSharingScopes.iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        connectionFactoryBuilder.freeConnectionFactory(properties, n.intValue(), 0, 1);
                    }
                }
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"destroy");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"destroy");
            }
            break block21;
            {
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedConnection.destroy", "535", this);
                    ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to free session factories");
                    resourceAdapterInternalException.setLinkedException(exception);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to free session factories", (Object)resourceAdapterInternalException);
                    }
                    throw resourceAdapterInternalException;
                }
            }
            {
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.destroy", "498", this);
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to close connection");
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Object var3_2 = null;
                    try {
                        if (!this.sessionSharingScopes.isEmpty()) {
                            Properties properties = new Properties();
                            String string = this.managedConnectionFactory.getConnectorName() + "$JMSManagedConnection@" + System.identityHashCode(this);
                            properties.setProperty("name", string);
                            ConnectionFactoryBuilder connectionFactoryBuilder = ConnectionFactoryBuilderFactory.create();
                            Iterator iterator = this.sessionSharingScopes.iterator();
                            while (iterator.hasNext()) {
                                Integer n = (Integer)iterator.next();
                                connectionFactoryBuilder.freeConnectionFactory(properties, n.intValue(), 0, 1);
                            }
                        }
                        Object var12_19 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var12_20 = null;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"destroy");
                        }
                        throw throwable2;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"destroy");
                    }
                    break block22;
                    {
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedConnection.destroy", "535", this);
                            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Failed to free session factories");
                            resourceAdapterInternalException.setLinkedException(exception);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Failed to free session factories", (Object)resourceAdapterInternalException);
                            }
                            throw resourceAdapterInternalException;
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSManagedConnection jMSManagedConnection = (JMSManagedConnection)object;
        if (!JMSCMUtils.objectsEqual(this.credential, jMSManagedConnection.credential)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.exceptionListener, jMSManagedConnection.exceptionListener)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.logWriter, jMSManagedConnection.logWriter)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.managedConnectionFactory, jMSManagedConnection.managedConnectionFactory)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.connection, jMSManagedConnection.connection);
    }

    public int hashCode() {
        int n = JMSCMUtils.objectHashCode(this.credential);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.exceptionListener);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.logWriter);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.managedConnectionFactory);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.connection);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "managed connection factory = " + JMSCMUtils.objectToString(this.managedConnectionFactory));
        stringBuffer.append(string + "physical connection = " + this.connection);
        stringBuffer.append(string + "credential = " + this.credential);
        stringBuffer.append(string + "open connection handles = [");
        Set set = this.openConnectionHandles;
        synchronized (set) {
            Iterator iterator = this.openConnectionHandles.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final void onException(JMSException jMSException) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onException", (Object)((Object)jMSException));
        }
        if (this.exceptionListener != null) {
            try {
                this.exceptionListener.onException(jMSException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.JMSManagedConnection.onException", "631", this);
                Tr.event((TraceComponent)tc, (String)"Ignoring exception thrown by application exception listener", (Object)throwable);
            }
        }
        this.connectionErrorOccurred((Exception)((Object)jMSException));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectionErrorOccurred(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectionErrorOccurred", (Object)exception);
        }
        if (exception instanceof JMSException) {
            this.jmsException = (JMSException)((Object)exception);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5, exception);
        Set set = this.connectionEventListeners;
        synchronized (set) {
            Iterator iterator = this.connectionEventListeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectionErrorOccurred");
        }
    }

    public final void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Remove connection event listener", (Object)connectionEventListener);
        }
        this.connectionEventListeners.remove(connectionEventListener);
    }

    protected abstract Connection createConnection(ConnectionFactory var1) throws ResourceException;

    protected abstract Connection createConnection(ConnectionFactory var1, String var2, String var3) throws ResourceException;

    protected abstract String getManagedSessionFactoryClassName();

    final void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    final PasswordCredential getPasswordCredential() {
        return this.credential;
    }

    final Connection getPhysicalConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleClosed(JMSConnectionHandle jMSConnectionHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleClosed", (Object)jMSConnectionHandle);
        }
        Set set = this.openConnectionHandles;
        synchronized (set) {
            this.openConnectionHandles.remove(jMSConnectionHandle);
        }
        set = new ConnectionEvent((ManagedConnection)this, 1);
        set.setConnectionHandle(jMSConnectionHandle);
        Set set2 = this.connectionEventListeners;
        synchronized (set2) {
            Iterator iterator = this.connectionEventListeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                connectionEventListener.connectionClosed((ConnectionEvent)set);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleClosed");
        }
    }

    final boolean getXACapable() {
        return this.xaCapable;
    }

    final JMSManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class JMSManagedConnectionMetaData
    implements ManagedConnectionMetaData {
        private JMSManagedConnectionMetaData() {
        }

        public String getEISProductName() throws ResourceException {
            try {
                return JMSManagedConnection.this.connection.getMetaData().getJMSProviderName();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.getEISProductName", "848", this);
                throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to get JMS provider name");
            }
        }

        public String getEISProductVersion() throws ResourceException {
            try {
                return JMSManagedConnection.this.connection.getMetaData().getProviderVersion();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedConnection.getEISProductVersion", "870", this);
                throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to get JMS provider version");
            }
        }

        public int getMaxConnections() throws ResourceException {
            return 0;
        }

        public String getUserName() throws ResourceException {
            return JMSManagedConnection.this.credential.getUserName();
        }
    }
}

