/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionFactoryHandle;
import com.ibm.ejs.jms.JMSConnectionRequestInfo;
import com.ibm.ejs.jms.JMSDefaultConnectionManager;
import com.ibm.ejs.jms.JMSManagedConnection;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.PasswordUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public abstract class JMSManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSManagedConnectionFactory == null ? (class$com$ibm$ejs$jms$JMSManagedConnectionFactory = JMSManagedConnectionFactory.class$("com.ibm.ejs.jms.JMSManagedConnectionFactory")) : class$com$ibm$ejs$jms$JMSManagedConnectionFactory), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    protected transient ConnectionFactory connectionFactory = null;
    protected boolean serverRecoveryNoCredentials = false;
    private transient PrintWriter logWriter = null;
    private String userName = null;
    private transient String password = null;
    private String connectorName = null;
    final Properties sessionPoolProperties = new Properties();
    private String mappingConfigAlias = null;
    private String authDataAlias = null;
    private static final long serialVersionUID = 6163116077001529572L;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSManagedConnectionFactory;
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public JMSManagedConnectionFactory() {
        this.sessionPoolProperties.setProperty("maxConnections", String.valueOf(0));
    }

    public String[] introspectSelf() {
        String string = System.getProperty("line.separator") + "\t";
        String[] stringArray = new String[]{JMSCMUtils.objectToString(this), string + "tc = " + tc, string + "connectionFactory = " + this.connectionFactory, string + "serverRecoveryNoCredentials = " + this.serverRecoveryNoCredentials, string + "logWriter = " + this.logWriter, string + "userName = " + this.userName, string + "password not dumped", string + "connectorName = " + this.connectorName, string + "sessionPoolProperties = " + this.sessionPoolProperties, string + "mappingConfigAlias = " + this.mappingConfigAlias, string + "authDataAlias = " + this.authDataAlias, string + "serialVersionUID = " + 6163116077001529572L};
        return stringArray;
    }

    public final void setMappingConfigAlias(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"MappingConfigAlias set", (Object)string);
        }
        this.mappingConfigAlias = string;
    }

    public final String getMappingConfigAlias() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"MappingConfigAlias get", (Object)this.mappingConfigAlias);
        }
        return this.mappingConfigAlias;
    }

    public final void setAuthDataAlias(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AuthDataAlias set", (Object)string);
        }
        this.authDataAlias = string;
    }

    public final String getAuthDataAlias() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AuthDataAlias get", (Object)this.authDataAlias);
        }
        return this.authDataAlias;
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Log writer set", (Object)printWriter);
        }
        this.logWriter = printWriter;
    }

    public final void setPassword(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Password set", (Object)"password not traced");
        }
        this.password = string;
    }

    public final void setUserName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"UserName set", (Object)string);
        }
        this.userName = string;
    }

    public final void setConnectorName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConnectorName set", (Object)string);
        }
        this.connectorName = string;
    }

    public final void setSessionPoolMaxConnections(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionPoolMaxConnections set", (Object)string);
        }
        this.sessionPoolProperties.setProperty("maxConnections", string);
    }

    public final String getSessionPoolMaxConnections() {
        String string = this.sessionPoolProperties.getProperty("maxConnections", String.valueOf(10));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionPoolMaxConnections get", (Object)string);
        }
        return string;
    }

    public final void setSessionPoolMinConnections(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionPoolMinConnections set", (Object)string);
        }
        this.sessionPoolProperties.setProperty("minConnections", string);
    }

    public final void setSessionPoolConnectionTimeout(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionPoolConnectionTimeout set", (Object)string);
        }
        this.sessionPoolProperties.setProperty("connectionTimeout", string);
    }

    public final void setSessionPoolReapTime(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionPoolReapTime set", (Object)string);
        }
        this.sessionPoolProperties.setProperty("reapTime", string);
    }

    public final void setSessionPoolAgedTimeout(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionPoolAgedTimeout set", (Object)string);
        }
        this.sessionPoolProperties.setProperty("agedTimeout", string);
    }

    public final void setSessionPoolUnusedTimeout(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionPoolUnusedTimeout set", (Object)string);
        }
        this.sessionPoolProperties.setProperty("unusedTimeout", string);
    }

    public final void setSessionPoolPurgePolicy(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionPoolPurgePolicy set", (Object)string);
        }
        this.sessionPoolProperties.setProperty("purgePolicy", string);
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object createConnectionFactory() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConnectionFactory");
        }
        Object object = null;
        try {
            object = this.createConnectionFactory(new JMSDefaultConnectionManager());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createConnectionFactory", (Object)object);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConnectionFactory", (Object)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConnectionFactory", (Object)connectionManager);
        }
        JMSConnectionFactoryHandle jMSConnectionFactoryHandle = null;
        try {
            jMSConnectionFactoryHandle = this.createConnectionFactoryHandle(connectionManager);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createConnectionFactory", (Object)jMSConnectionFactoryHandle);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConnectionFactory", (Object)jMSConnectionFactoryHandle);
        }
        return jMSConnectionFactoryHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createManagedConnection", (Object)new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        JMSManagedConnection jMSManagedConnection = null;
        try {
            JMSConnectionRequestInfo jMSConnectionRequestInfo = (JMSConnectionRequestInfo)connectionRequestInfo;
            PasswordCredential passwordCredential = this.getPasswordCredential(subject, jMSConnectionRequestInfo);
            jMSManagedConnection = this.createManagedConnection(passwordCredential);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createManagedConnection", (Object)jMSManagedConnection);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createManagedConnection", (Object)jMSManagedConnection);
        }
        return jMSManagedConnection;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSManagedConnectionFactory jMSManagedConnectionFactory = (JMSManagedConnectionFactory)object;
        if (!JMSCMUtils.objectsEqual(this.mappingConfigAlias, jMSManagedConnectionFactory.mappingConfigAlias)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.authDataAlias, jMSManagedConnectionFactory.authDataAlias)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.userName, jMSManagedConnectionFactory.userName)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.password, jMSManagedConnectionFactory.password)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.connectorName, jMSManagedConnectionFactory.connectorName)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.sessionPoolProperties, jMSManagedConnectionFactory.sessionPoolProperties)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.logWriter, jMSManagedConnectionFactory.logWriter)) {
            return false;
        }
        try {
            if (!JMSCMUtils.objectsEqual(this.getConnectionFactory(), jMSManagedConnectionFactory.getConnectionFactory())) {
                return false;
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedConnectionFactory.equals", "313", this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught ResourceException when comparing connection factories", (Object)((Object)resourceException));
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        block2: {
            n = JMSCMUtils.objectHashCode(this.userName);
            n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.password);
            n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.connectorName);
            n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.mappingConfigAlias);
            n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.authDataAlias);
            try {
                n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.getConnectionFactory());
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedConnectionFactory.hashCode", "345", this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Caught ResourceException when creating hash code", (Object)((Object)resourceException));
            }
        }
        return n;
    }

    public final ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"matchManagedConnections", (Object)new Object[]{set, JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        PasswordCredential passwordCredential = this.getPasswordCredential(subject, connectionRequestInfo);
        JMSManagedConnection jMSManagedConnection = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && jMSManagedConnection == null) {
            JMSManagedConnection jMSManagedConnection2;
            Object e = iterator.next();
            if (!(e instanceof JMSManagedConnection) || !JMSCMUtils.objectsEqual(passwordCredential, (jMSManagedConnection2 = (JMSManagedConnection)e).getPasswordCredential())) continue;
            jMSManagedConnection = jMSManagedConnection2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"matchManagedConnections", jMSManagedConnection);
        }
        return jMSManagedConnection;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "physical connection factory = " + this.connectionFactory);
        stringBuffer.append(string + "default user name = " + this.userName);
        return stringBuffer.toString();
    }

    final String getConnectorName() {
        return this.connectorName;
    }

    final Properties getSessionPoolProperties() {
        return this.sessionPoolProperties;
    }

    protected abstract ConnectionFactory getConnectionFactory() throws ResourceException;

    protected abstract JMSConnectionFactoryHandle createConnectionFactoryHandle(ConnectionManager var1) throws ResourceException;

    protected abstract JMSManagedConnection createManagedConnection(PasswordCredential var1) throws ResourceException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws SecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPasswordCredential", (Object)new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        PasswordCredential passwordCredential = null;
        try {
            block13: {
                try {
                    if (subject != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Using credentials from Subject");
                        }
                        passwordCredential = this.getPasswordCredential(subject);
                        break block13;
                    }
                    if (!(connectionRequestInfo instanceof JMSConnectionRequestInfo)) break block13;
                    JMSConnectionRequestInfo jMSConnectionRequestInfo = (JMSConnectionRequestInfo)connectionRequestInfo;
                    passwordCredential = jMSConnectionRequestInfo.getPasswordCredential();
                    if (passwordCredential != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Using credentials passed on createXXXConnection");
                        }
                        break block13;
                    }
                    if (this.userName != null && this.password != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Using default credentials from ConnectionFactory");
                        }
                        String string = this.userName == null ? "" : this.userName;
                        char[] cArray = this.password == null ? new char[]{} : this.password.toCharArray();
                        passwordCredential = new PasswordCredential(string, cArray);
                        break block13;
                    }
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)"No default credentials on ConnectionFactory");
                }
                catch (SecurityException securityException) {
                    FFDCFilter.processException((Throwable)securityException, "com.ibm.ejs.jms.JMSManagedConnectionFactory.getPasswordCredential", "546", this);
                    if (!tc.isEventEnabled()) throw securityException;
                    Tr.event((TraceComponent)tc, (String)"Caught SecurityException in getPasswordCredential", (Object)((Object)securityException));
                    throw securityException;
                }
            }
            Object var8_8 = null;
            if (tc.isDebugEnabled() && passwordCredential != null) {
                Tr.debug((TraceComponent)tc, (String)"Credential contains userName", (Object)passwordCredential.getUserName());
            }
            if (!tc.isEntryEnabled()) return passwordCredential;
            Tr.exit((TraceComponent)tc, (String)"getPasswordCredential", (Object)passwordCredential);
            return passwordCredential;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (tc.isDebugEnabled() && passwordCredential != null) {
                Tr.debug((TraceComponent)tc, (String)"Credential contains userName", (Object)passwordCredential.getUserName());
            }
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getPasswordCredential", (Object)passwordCredential);
            throw throwable;
        }
    }

    private final PasswordCredential getPasswordCredential(Subject subject) throws SecurityException {
        PasswordCredential passwordCredential;
        final Subject subject2 = subject;
        PasswordCredential passwordCredential2 = (PasswordCredential)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Set set = subject2.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = JMSManagedConnectionFactory.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    PasswordCredential passwordCredential;
                    Object t = iterator.next();
                    if (!(t instanceof PasswordCredential) || !(passwordCredential = (PasswordCredential)t).getManagedConnectionFactory().equals(JMSManagedConnectionFactory.this)) continue;
                    return passwordCredential;
                }
                return null;
            }
        });
        if (passwordCredential2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No PasswordCredential in Subject");
            }
            passwordCredential = null;
        } else {
            passwordCredential = new PasswordCredential(passwordCredential2.getUserName(), passwordCredential2.getPassword());
        }
        return passwordCredential;
    }

    protected abstract void setupForRecovery();

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.password == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            String string = "";
            try {
                string = PasswordUtil.encode((String)this.password);
            }
            catch (Exception exception) {
                throw new IOException();
            }
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeUTF(string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream.readBoolean()) {
            String string = objectInputStream.readUTF();
            try {
                this.password = PasswordUtil.decode((String)string);
            }
            catch (Exception exception) {
                throw new IOException();
            }
        }
    }

    protected final boolean getServerRecoveryNoCredentials() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"serverRecoveryNoCredentials get", (Object)new Boolean(this.serverRecoveryNoCredentials));
        }
        return this.serverRecoveryNoCredentials;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

