/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedSessionFactory;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

abstract class JMSManagedSession
implements ManagedConnection {
    static final int NON_TRANSACTED_SESSION = 0;
    static final int TRANSACTED_SESSION = 1;
    static final int XA_SESSION = 2;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSManagedSession == null ? (class$com$ibm$ejs$jms$JMSManagedSession = JMSManagedSession.class$("com.ibm.ejs.jms.JMSManagedSession")) : class$com$ibm$ejs$jms$JMSManagedSession), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private static final TraceComponent lttc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSManagedSession$JMSLocalTransaction == null ? (class$com$ibm$ejs$jms$JMSManagedSession$JMSLocalTransaction = JMSManagedSession.class$("com.ibm.ejs.jms.JMSManagedSession$JMSLocalTransaction")) : class$com$ibm$ejs$jms$JMSManagedSession$JMSLocalTransaction), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private static final TraceComponent xatc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSManagedSession$JMSXAResource == null ? (class$com$ibm$ejs$jms$JMSManagedSession$JMSXAResource = JMSManagedSession.class$("com.ibm.ejs.jms.JMSManagedSession$JMSXAResource")) : class$com$ibm$ejs$jms$JMSManagedSession$JMSXAResource), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private JMSManagedSessionFactory managedSessionFactory;
    private Session session;
    private JMSSessionRequestInfo sessionRequestInfo;
    private int sessionType;
    private int acknowledgeMode;
    private Set connectionEventListeners;
    private Set openSessionHandles;
    private PrintWriter logWriter;
    private boolean enlisted;
    private LocalTransaction localTransaction;
    private boolean localTranStarted;
    private XAResource xaResource;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSManagedSession;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSManagedSession$JMSLocalTransaction;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSManagedSession$JMSXAResource;

    /*
     * Loose catch block
     */
    JMSManagedSession(JMSManagedSessionFactory jMSManagedSessionFactory, JMSSessionRequestInfo jMSSessionRequestInfo) throws ResourceException {
        block14: {
            this.connectionEventListeners = Collections.synchronizedSet(new HashSet());
            this.openSessionHandles = Collections.synchronizedSet(new HashSet());
            this.logWriter = null;
            this.enlisted = false;
            this.localTransaction = null;
            this.localTranStarted = false;
            this.xaResource = null;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"JMSManagedSession", (Object)new Object[]{jMSManagedSessionFactory, jMSSessionRequestInfo});
            }
            this.managedSessionFactory = jMSManagedSessionFactory;
            this.sessionType = jMSManagedSessionFactory.getSessionTypeRequired(jMSSessionRequestInfo);
            this.sessionRequestInfo = jMSSessionRequestInfo;
            try {
                Connection connection = jMSManagedSessionFactory.getPhysicalConnection();
                switch (this.sessionType) {
                    case 2: {
                        this.session = this.createXASession((XAConnection)connection);
                        break;
                    }
                    case 1: {
                        this.acknowledgeMode = jMSSessionRequestInfo.getAcknowledgeMode();
                        this.session = this.createSession(connection, true, this.acknowledgeMode);
                        break;
                    }
                    case 0: {
                        this.acknowledgeMode = jMSSessionRequestInfo.getAcknowledgeMode();
                        this.session = this.createSession(connection, false, this.acknowledgeMode);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid session type");
                    }
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"JMSManagedSession");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"JMSManagedSession");
            }
            break block14;
            {
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedSession.JMSManagedSession", "172", this);
                    Exception exception = jMSException.getLinkedException();
                    while (exception != null) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.JMSManagedSession.JMSManagedSession", "175", this);
                        if (exception instanceof JMSException) {
                            exception = ((JMSException)((Object)exception)).getLinkedException();
                            continue;
                        }
                        exception = null;
                    }
                    throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to create session");
                }
            }
        }
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Log writer set", (Object)printWriter);
        }
        this.logWriter = printWriter;
    }

    public final Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)new Object[]{JMSCMUtils.subjectToString(subject), connectionRequestInfo});
        }
        JMSSessionHandle jMSSessionHandle = this.createSessionHandle(connectionRequestInfo);
        this.openSessionHandles.add(jMSSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)jMSSessionHandle);
        }
        return jMSSessionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LocalTransaction getLocalTransaction() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalTransaction");
        }
        try {
            if (this.sessionType == 2 && !(this.sessionRequestInfo instanceof JMSListenerSessionRequestInfo)) {
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("getLocalTransaction called on XA session");
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"XA session does not support getLocalTransaction", (Object)resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
            if (this.localTransaction == null) {
                this.localTransaction = new JMSLocalTransaction();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getLocalTransaction", (Object)this.localTransaction);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalTransaction", (Object)this.localTransaction);
        }
        return this.localTransaction;
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.managedSessionFactory.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XAResource getXAResource() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getXAResource");
        }
        try {
            if (this.xaResource == null) {
                switch (this.sessionType) {
                    case 2: {
                        XASession xASession = (XASession)this.session;
                        this.xaResource = new JMSXAResource(xASession.getXAResource());
                        break;
                    }
                    case 0: {
                        this.xaResource = new JMSXAResource(null);
                        break;
                    }
                    default: {
                        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("getXAResource called on non-XA managed sesssion");
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Non-XA managed session does not support getXAResource", (Object)resourceAdapterInternalException);
                        }
                        throw resourceAdapterInternalException;
                    }
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getXAResource", (Object)this.xaResource);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getXAResource", (Object)this.xaResource);
        }
        return this.xaResource;
    }

    public final void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Adding connection event listener", (Object)connectionEventListener);
        }
        this.connectionEventListeners.add(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void associateConnection(Object object) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associateConnection", (Object)object);
        }
        try {
            JMSSessionHandle jMSSessionHandle;
            if (object instanceof JMSSessionHandle) {
                jMSSessionHandle = (JMSSessionHandle)object;
                JMSManagedSession jMSManagedSession = jMSSessionHandle.getManagedSession();
                if (jMSManagedSession != null) {
                    jMSManagedSession.openSessionHandles.remove(jMSSessionHandle);
                }
            } else {
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Can't associate non-JMSSessionHandle");
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Can't associate non-JMSSessionHandle", (Object)resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
            jMSSessionHandle.activate(this);
            this.openSessionHandles.add(jMSSessionHandle);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associateConnection");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associateConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup");
        }
        Set set = this.openSessionHandles;
        synchronized (set) {
            Iterator iterator = this.openSessionHandles.iterator();
            while (iterator.hasNext()) {
                JMSSessionHandle jMSSessionHandle = (JMSSessionHandle)iterator.next();
                jMSSessionHandle.deactivate();
            }
            this.openSessionHandles.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void destroy() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        try {
            try {
                this.session.close();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedSession.destroy", "471", this);
                throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), tc, "Failed to close session");
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"destroy");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"destroy");
    }

    public final void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Remove connection event listener", (Object)connectionEventListener);
        }
        this.connectionEventListeners.remove(connectionEventListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSManagedSession jMSManagedSession = (JMSManagedSession)object;
        if (!JMSCMUtils.objectsEqual(this.logWriter, jMSManagedSession.logWriter)) {
            return false;
        }
        if (this.sessionType != jMSManagedSession.sessionType) {
            return false;
        }
        if (this.acknowledgeMode != jMSManagedSession.acknowledgeMode) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.session, jMSManagedSession.session);
    }

    public int hashCode() {
        int n = this.sessionType;
        n = n * JMSCMUtils.HASH_CODE_PRIME + this.acknowledgeMode;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.logWriter);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.session);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "physical session = " + JMSCMUtils.objectToString(this.session));
        stringBuffer.append(string + "session type = ");
        switch (this.sessionType) {
            case 0: {
                stringBuffer.append("NON_TRANSACTED_SESSION");
                break;
            }
            case 1: {
                stringBuffer.append("TRANSACTED_SESSION");
                break;
            }
            case 2: {
                stringBuffer.append("XA_SESSION");
                break;
            }
            default: {
                throw new RuntimeException("Invalid session type");
            }
        }
        if (this.sessionType != 2) {
            stringBuffer.append(string + "acknowledge mode = ");
            switch (this.acknowledgeMode) {
                case 2: {
                    stringBuffer.append("CLIENT_ACKNOWLEDGE");
                    break;
                }
                case 1: {
                    stringBuffer.append("AUTO_ACKNOWLEDGE");
                    break;
                }
                case 3: {
                    stringBuffer.append("DUPS_OK_ACKNOWLEDGE");
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid acknowledge mode");
                }
            }
        }
        stringBuffer.append(string + "enlisted = " + this.enlisted);
        stringBuffer.append(string + "open session handles = [");
        Iterator iterator = this.openSessionHandles.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        stringBuffer.append(string + "managed session factory = " + JMSCMUtils.objectToString(this.managedSessionFactory));
        return stringBuffer.toString();
    }

    protected abstract Session createSession(Connection var1, boolean var2, int var3) throws JMSException;

    protected abstract XASession createXASession(XAConnection var1) throws JMSException;

    protected abstract JMSSessionHandle createSessionHandle(ConnectionRequestInfo var1);

    final Session getPhysicalSession() {
        return this.session;
    }

    final int getSessionType() {
        return this.sessionType;
    }

    final JMSSessionRequestInfo getSessionRequestInfo() {
        return this.sessionRequestInfo;
    }

    final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleClosed(JMSSessionHandle jMSSessionHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleClosed", (Object)jMSSessionHandle);
        }
        this.openSessionHandles.remove(jMSSessionHandle);
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)jMSSessionHandle);
        Set set = this.connectionEventListeners;
        synchronized (set) {
            Iterator iterator = this.connectionEventListeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleClosed");
        }
    }

    /*
     * Loose catch block
     */
    final void enlist() throws JMSException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"enlist");
            }
            try {
                block12: {
                    if (this.enlisted) break block12;
                    switch (this.sessionType) {
                        case 2: {
                            this.interactionPending();
                            this.enlisted = true;
                            break;
                        }
                        case 1: {
                            this.localTransactionStarted();
                            this.enlisted = true;
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid session type");
                        }
                    }
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlist");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlist");
            }
            break block13;
            {
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedSession.enlist", "752", this);
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Enlist failed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void localTransactionStarted() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"localTransactionStarted");
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 2);
        Set set = this.connectionEventListeners;
        synchronized (set) {
            Iterator iterator = this.connectionEventListeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                connectionEventListener.localTransactionStarted(connectionEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"localTransactionStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionCommitted() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"localTransactionCommitted");
        }
        if (this.enlisted) {
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 3);
            Set set = this.connectionEventListeners;
            synchronized (set) {
                Iterator iterator = this.connectionEventListeners.iterator();
                while (iterator.hasNext()) {
                    ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                    connectionEventListener.localTransactionCommitted(connectionEvent);
                }
            }
            this.enlisted = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"localTransactionCommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionRolledback() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"localTransactionRolledback");
        }
        if (this.enlisted) {
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 4);
            Set set = this.connectionEventListeners;
            synchronized (set) {
                Iterator iterator = this.connectionEventListeners.iterator();
                while (iterator.hasNext()) {
                    ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                    connectionEventListener.localTransactionRolledback(connectionEvent);
                }
            }
            this.enlisted = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"localTransactionRolledback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void interactionPending() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"interactionPending");
        }
        try {
            try {
                ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 900);
                Set set = this.connectionEventListeners;
                synchronized (set) {
                    Iterator iterator = this.connectionEventListeners.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof com.ibm.websphere.j2c.ConnectionEventListener)) continue;
                        com.ibm.websphere.j2c.ConnectionEventListener connectionEventListener = (com.ibm.websphere.j2c.ConnectionEventListener)e;
                        connectionEventListener.interactionPending(connectionEvent);
                    }
                }
                Object var8_8 = null;
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSManagedSession.interactionPending", "909", this);
                if (!tc.isDebugEnabled()) throw resourceException;
                Tr.debug((TraceComponent)tc, (String)"Caught ResourceException in interactionPending", (Object)((Object)resourceException));
                throw resourceException;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"interactionPending");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"interactionPending");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectionErrorOccurred(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectionErrorOccurred");
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5, exception);
        Set set = this.connectionEventListeners;
        synchronized (set) {
            Iterator iterator = this.connectionEventListeners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectionErrorOccurred");
        }
    }

    final boolean inContainerLocalTran() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inContainerLocalTran");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"inContainerLocalTran", (Object)new Boolean(this.localTranStarted));
        }
        return this.localTranStarted;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class JMSXAResource
    implements XAResource {
        private final XAResource providerXAResource;

        JMSXAResource(XAResource xAResource) {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"JMSXAResource", (Object)xAResource);
            }
            this.providerXAResource = xAResource;
            if (xatc.isEntryEnabled()) {
                Tr.exit((TraceComponent)xatc, (String)"JMSXAResource");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void start(Xid xid, int n) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"start", (Object)new Object[]{xid, new Integer(n)});
            }
            try {
                try {
                    this.providerXAResource.start(xid, n);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.start", "1052", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in start", (Object)xAException);
                    throw xAException;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"start");
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)xatc, (String)"start");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean setTransactionTimeout(int n) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"setTransactionTimeout", (Object)new Integer(n));
            }
            boolean bl = false;
            try {
                try {
                    bl = this.providerXAResource.setTransactionTimeout(n);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.setTransactionTimeout", "1090", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in setTransactionTimeout", (Object)xAException);
                    throw xAException;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"setTransactionTimeout", (Object)new Boolean(bl));
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return bl;
            Tr.exit((TraceComponent)xatc, (String)"setTransactionTimeout", (Object)new Boolean(bl));
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void rollback(Xid xid) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"rollback", (Object)xid);
            }
            try {
                try {
                    JMSManagedSession.this.enlisted = false;
                    this.providerXAResource.rollback(xid);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.rollback", "1129", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in rollback", (Object)xAException);
                    throw xAException;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"rollback");
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)xatc, (String)"rollback");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Xid[] recover(int n) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"recover", (Object)new Integer(n));
            }
            Xid[] xidArray = null;
            try {
                try {
                    xidArray = this.providerXAResource.recover(n);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.recover", "1168", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in recover", (Object)xAException);
                    throw xAException;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"recover", (Object)xidArray);
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return xidArray;
            Tr.exit((TraceComponent)xatc, (String)"recover", (Object)xidArray);
            return xidArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int prepare(Xid xid) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"prepare", (Object)xid);
            }
            int n = 0;
            try {
                try {
                    n = this.providerXAResource.prepare(xid);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.prepare", "1209", this);
                    if (xatc.isEventEnabled()) {
                        Tr.event((TraceComponent)xatc, (String)"XAException in prepare", (Object)xAException);
                    }
                    throw xAException;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (xatc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)xatc, (String)"prepare", (Object)new Integer(n));
                }
                throw throwable;
            }
            if (xatc.isEntryEnabled()) {
                Tr.exit((TraceComponent)xatc, (String)"prepare", (Object)new Integer(n));
            }
            if (n == 3) {
                JMSManagedSession.this.enlisted = false;
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isSameRM(XAResource xAResource) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"isSameRM", (Object)xAResource);
            }
            boolean bl = false;
            try {
                try {
                    bl = this.providerXAResource.isSameRM(xAResource);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.isSameRM", "1254", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in isSameRM", (Object)xAException);
                    throw xAException;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"isSameRM", (Object)new Boolean(bl));
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return bl;
            Tr.exit((TraceComponent)xatc, (String)"isSameRM", (Object)new Boolean(bl));
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getTransactionTimeout() throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"getTransactionTimeout");
            }
            int n = 0;
            try {
                try {
                    n = this.providerXAResource.getTransactionTimeout();
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.getTransactionTimeout", "1292", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in getTransactionTimeout", (Object)xAException);
                    throw xAException;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"getTransactionTimeout", (Object)new Integer(n));
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return n;
            Tr.exit((TraceComponent)xatc, (String)"getTransactionTimeout", (Object)new Integer(n));
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void forget(Xid xid) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"forget", (Object)xid);
            }
            try {
                try {
                    this.providerXAResource.forget(xid);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.forget", "1330", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in forget", (Object)xAException);
                    throw xAException;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"forget");
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)xatc, (String)"forget");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void end(Xid xid, int n) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"end", (Object)new Object[]{xid, new Integer(n)});
            }
            try {
                try {
                    this.providerXAResource.end(xid, n);
                }
                catch (XAException xAException) {
                    if (n == 0x20000000 && xAException.errorCode >= 100 && xAException.errorCode <= 107) {
                        Object var5_4 = null;
                        if (!xatc.isEntryEnabled()) return;
                        Tr.exit((TraceComponent)xatc, (String)"end");
                        return;
                    }
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.end", "1367", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in end", (Object)xAException);
                    throw xAException;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"end");
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)xatc, (String)"end");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void commit(Xid xid, boolean bl) throws XAException {
            if (xatc.isEntryEnabled()) {
                Tr.entry((TraceComponent)xatc, (String)"commit", (Object)new Object[]{xid, new Boolean(bl)});
            }
            try {
                try {
                    JMSManagedSession.this.enlisted = false;
                    this.providerXAResource.commit(xid, bl);
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, "com.ibm.ejs.jms.JMSManagedSession.commit", "1406", this);
                    if (!xatc.isEventEnabled()) throw xAException;
                    Tr.event((TraceComponent)xatc, (String)"XAException in commit", (Object)xAException);
                    throw xAException;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (!xatc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)xatc, (String)"commit");
                throw throwable;
            }
            if (!xatc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)xatc, (String)"commit");
        }
    }

    private final class JMSLocalTransaction
    implements LocalTransaction {
        private JMSLocalTransaction() {
        }

        public void begin() throws ResourceException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)lttc, (String)"begin");
            }
            JMSManagedSession.this.localTranStarted = true;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)lttc, (String)"begin");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commit() throws ResourceException {
            if (lttc.isEntryEnabled()) {
                Tr.entry((TraceComponent)lttc, (String)"commit");
            }
            JMSManagedSession.this.localTranStarted = false;
            try {
                block5: {
                    try {
                        if (JMSManagedSession.this.sessionType != 1) break block5;
                        JMSManagedSession.this.enlisted = false;
                        JMSManagedSession.this.session.commit();
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedSession.commit", "945", this);
                        throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), lttc, "Failed to commit transaction");
                    }
                }
                Object var3_1 = null;
                if (!lttc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)lttc, (String)"commit");
                return;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (!lttc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)lttc, (String)"commit");
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rollback() throws ResourceException {
            if (lttc.isEntryEnabled()) {
                Tr.entry((TraceComponent)lttc, (String)"rollback");
            }
            JMSManagedSession.this.localTranStarted = false;
            try {
                block5: {
                    try {
                        if (JMSManagedSession.this.sessionType != 1) break block5;
                        JMSManagedSession.this.enlisted = false;
                        JMSManagedSession.this.session.rollback();
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSManagedSession.rollback", "983", this);
                        throw JMSCMUtils.mapToResourceException((Exception)((Object)jMSException), lttc, "Failed to rollback transaction");
                    }
                }
                Object var3_1 = null;
                if (!lttc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)lttc, (String)"rollback");
                return;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (!lttc.isEntryEnabled()) throw throwable;
                Tr.exit((TraceComponent)lttc, (String)"rollback");
                throw throwable;
            }
        }
    }
}

