/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSCloseable;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

abstract class JMSMessageConsumerHandle
implements MessageConsumer,
JMSCloseable,
Serializable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSMessageConsumerHandle == null ? (class$com$ibm$ejs$jms$JMSMessageConsumerHandle = JMSMessageConsumerHandle.class$("com.ibm.ejs.jms.JMSMessageConsumerHandle")) : class$com$ibm$ejs$jms$JMSMessageConsumerHandle), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private JMSSessionHandle sessionHandle;
    protected String messageSelector = null;
    private boolean closed = false;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSMessageConsumerHandle;

    JMSMessageConsumerHandle(JMSSessionHandle jMSSessionHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSMessageConsumerHandle", (Object)jMSSessionHandle);
        }
        this.sessionHandle = jMSSessionHandle;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JMSMessageConsumerHandle");
        }
    }

    JMSMessageConsumerHandle(JMSSessionHandle jMSSessionHandle, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSMessageConsumerHandle", (Object)new Object[]{jMSSessionHandle, string});
        }
        this.messageSelector = string;
        this.sessionHandle = jMSSessionHandle;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JMSMessageConsumerHandle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getMessageSelector() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessageSelector");
        }
        String string = null;
        try {
            try {
                MessageConsumer messageConsumer = this.getOpenMessageConsumer();
                string = messageConsumer.getMessageSelector();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.getMessageSelector", "125", this);
                JMSCMUtils.trace(tc, "getMessageSelector", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getMessageSelector", (Object)string);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return string;
        Tr.exit((TraceComponent)tc, (String)"getMessageSelector", (Object)string);
        return string;
    }

    public final MessageListener getMessageListener() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessageListener");
        }
        try {
            throw JMSCMUtils.methodNotPermittedException(tc, "getMessageListener");
        }
        catch (Throwable throwable) {
            block3: {
                Object var2_2 = null;
                if (!tc.isEntryEnabled()) break block3;
                Tr.exit((TraceComponent)tc, (String)"getMessageListener", null);
            }
            throw throwable;
        }
    }

    public final void setMessageListener(MessageListener messageListener) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMessageListener", (Object)messageListener);
        }
        try {
            throw JMSCMUtils.methodNotPermittedException(tc, "setMessageListener");
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block3;
                Tr.exit((TraceComponent)tc, (String)"setMessageListener");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Message receive() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"receive");
        }
        Message message = null;
        try {
            try {
                MessageConsumer messageConsumer = this.getOpenMessageConsumer();
                try {
                    this.enlist();
                    message = messageConsumer.receive();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.receive", "221", this);
                JMSCMUtils.trace(tc, "receive", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"receive", (Object)message);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return message;
        Tr.exit((TraceComponent)tc, (String)"receive", (Object)message);
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Message receive(long l) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"receive", (Object)new Long(l));
        }
        Message message = null;
        try {
            try {
                MessageConsumer messageConsumer = this.getOpenMessageConsumer();
                try {
                    this.enlist();
                    message = messageConsumer.receive(l);
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var7_6 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.receive", "264", this);
                JMSCMUtils.trace(tc, "receive", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"receive", (Object)message);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return message;
        Tr.exit((TraceComponent)tc, (String)"receive", (Object)message);
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Message receiveNoWait() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"receiveNoWait");
        }
        Message message = null;
        try {
            try {
                MessageConsumer messageConsumer = this.getOpenMessageConsumer();
                try {
                    this.enlist();
                    message = messageConsumer.receiveNoWait();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.receiveNoWait", "304", this);
                JMSCMUtils.trace(tc, "receiveNoWait", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"receiveNoWait", (Object)message);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return message;
        Tr.exit((TraceComponent)tc, (String)"receiveNoWait", (Object)message);
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        try {
            try {
                MessageConsumer messageConsumer = this.getMessageConsumer();
                if (messageConsumer != null) {
                    messageConsumer.close();
                }
                this.sessionHandle.removeChild(this);
                this.closed = true;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageConsumerHandle.close", "347", this);
                JMSCMUtils.trace(tc, "close", jMSException);
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"close");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"close");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSMessageConsumerHandle jMSMessageConsumerHandle = (JMSMessageConsumerHandle)object;
        if (!JMSCMUtils.objectsEqual(this.sessionHandle, jMSMessageConsumerHandle.sessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.messageSelector, jMSMessageConsumerHandle.messageSelector)) {
            return false;
        }
        return this.closed == jMSMessageConsumerHandle.closed;
    }

    public int hashCode() {
        int n = this.closed ? -1 : 1;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.sessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.messageSelector);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "session handle = " + JMSCMUtils.objectToString(this.sessionHandle));
        stringBuffer.append(string + "message selector = " + this.messageSelector);
        stringBuffer.append(string + "closed = " + this.closed);
        return stringBuffer.toString();
    }

    protected final void checkOpen() throws IllegalStateException {
        if (this.closed) {
            IllegalStateException illegalStateException = new IllegalStateException("Consumer closed");
            throw illegalStateException;
        }
    }

    protected final void enlist() throws JMSException {
        this.sessionHandle.getManagedSession().enlist();
    }

    protected abstract MessageConsumer getMessageConsumer();

    protected abstract MessageConsumer getOpenMessageConsumer() throws IllegalStateException, JMSException;

    final void markManagedObjectsAsStale(JMSException jMSException) {
        this.sessionHandle.markManagedObjectsAsStale(jMSException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

