/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSCloseable;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageProducer;

abstract class JMSMessageProducerHandle
implements MessageProducer,
JMSCloseable,
Serializable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSMessageProducerHandle == null ? (class$com$ibm$ejs$jms$JMSMessageProducerHandle = JMSMessageProducerHandle.class$("com.ibm.ejs.jms.JMSMessageProducerHandle")) : class$com$ibm$ejs$jms$JMSMessageProducerHandle), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private JMSSessionHandle sessionHandle;
    private Boolean disableMessageID = null;
    private Boolean disableMessageTimestamp = null;
    private Integer deliveryMode = null;
    private Integer priority = null;
    private Long timeToLive = null;
    private boolean closed = false;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSMessageProducerHandle;

    JMSMessageProducerHandle(JMSSessionHandle jMSSessionHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSMessageProducerHandle", (Object)jMSSessionHandle);
        }
        this.sessionHandle = jMSSessionHandle;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JMSMessageProducerHandle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDisableMessageID(boolean bl) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDisableMessageID", (Object)new Boolean(bl));
        }
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                messageProducer.setDisableMessageID(bl);
                this.disableMessageID = new Boolean(bl);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setDisableMessageID", "118", this);
                JMSCMUtils.trace(tc, "setDisableMessageID", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"setDisableMessageID");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setDisableMessageID");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getDisableMessageID() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDisableMessageID");
        }
        boolean bl = false;
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                bl = messageProducer.getDisableMessageID();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getDisableMessageID", "154", this);
                JMSCMUtils.trace(tc, "getDisableMessageID", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getDisableMessageID", (Object)new Boolean(bl));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return bl;
        Tr.exit((TraceComponent)tc, (String)"getDisableMessageID", (Object)new Boolean(bl));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDisableMessageTimestamp(boolean bl) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDisableMessageTimestamp", (Object)new Boolean(bl));
        }
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                messageProducer.setDisableMessageTimestamp(bl);
                this.disableMessageTimestamp = new Boolean(bl);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setDisableMessageTimestamp", "192", this);
                JMSCMUtils.trace(tc, "setDisableMessageTimestamp", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"setDisableMessageTimestamp");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setDisableMessageTimestamp");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getDisableMessageTimestamp() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDisableMessageTimestamp");
        }
        boolean bl = false;
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                bl = messageProducer.getDisableMessageTimestamp();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getDisableMessageTimestamp", "228", this);
                JMSCMUtils.trace(tc, "getDisableMessageTimestamp", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getDisableMessageTimestamp", (Object)new Boolean(bl));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return bl;
        Tr.exit((TraceComponent)tc, (String)"getDisableMessageTimestamp", (Object)new Boolean(bl));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDeliveryMode(int n) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDeliveryMode", (Object)new Integer(n));
        }
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                messageProducer.setDeliveryMode(n);
                this.deliveryMode = new Integer(n);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setDeliveryMode", "269", this);
                JMSCMUtils.trace(tc, "setDeliveryMode", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"setDeliveryMode");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setDeliveryMode");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDeliveryMode() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDeliveryMode");
        }
        int n = 0;
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                n = messageProducer.getDeliveryMode();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getDeliveryMode", "305", this);
                JMSCMUtils.trace(tc, "getDeliveryMode", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getDeliveryMode", (Object)new Integer(n));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return n;
        Tr.exit((TraceComponent)tc, (String)"getDeliveryMode", (Object)new Integer(n));
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPriority(int n) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPriority", (Object)new Integer(n));
        }
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                messageProducer.setPriority(n);
                this.priority = new Integer(n);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setPriority", "344", this);
                JMSCMUtils.trace(tc, "setPriority", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"setPriority");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setPriority");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPriority");
        }
        int n = 0;
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                n = messageProducer.getPriority();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getPriority", "380", this);
                JMSCMUtils.trace(tc, "getPriority", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(n));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return n;
        Tr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(n));
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTimeToLive(long l) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeToLive", (Object)new Long(l));
        }
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                messageProducer.setTimeToLive(l);
                this.timeToLive = new Long(l);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.setTimeToLive", "420", this);
                JMSCMUtils.trace(tc, "setTimeToLive", jMSException);
                throw jMSException;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"setTimeToLive");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setTimeToLive");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTimeToLive() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTimeToLive");
        }
        long l = 0L;
        try {
            try {
                MessageProducer messageProducer = this.getOpenMessageProducer();
                l = messageProducer.getTimeToLive();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.getTimeToLive", "457", this);
                JMSCMUtils.trace(tc, "getTimeToLive", jMSException);
                throw jMSException;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getTimeToLive", (Object)new Long(l));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return l;
        Tr.exit((TraceComponent)tc, (String)"getTimeToLive", (Object)new Long(l));
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        try {
            try {
                MessageProducer messageProducer = this.getMessageProducer();
                if (messageProducer != null) {
                    messageProducer.close();
                }
                this.sessionHandle.removeChild(this);
                this.closed = true;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSMessageProducerHandle.close", "500", this);
                JMSCMUtils.trace(tc, "close", jMSException);
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"close");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"close");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSMessageProducerHandle jMSMessageProducerHandle = (JMSMessageProducerHandle)object;
        if (!JMSCMUtils.objectsEqual(this.sessionHandle, jMSMessageProducerHandle.sessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.disableMessageID, jMSMessageProducerHandle.disableMessageID)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.disableMessageTimestamp, jMSMessageProducerHandle.disableMessageTimestamp)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.deliveryMode, jMSMessageProducerHandle.deliveryMode)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.priority, jMSMessageProducerHandle.priority)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.timeToLive, jMSMessageProducerHandle.timeToLive)) {
            return false;
        }
        return this.closed == jMSMessageProducerHandle.closed;
    }

    public int hashCode() {
        int n = this.closed ? -1 : 1;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.sessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.disableMessageID);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.disableMessageTimestamp);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.deliveryMode);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.priority);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.timeToLive);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "session handle = " + JMSCMUtils.objectToString(this.sessionHandle));
        stringBuffer.append(string + "message ID disabled = " + this.disableMessageID);
        stringBuffer.append(string + "message timestamp disabled = " + this.disableMessageTimestamp);
        stringBuffer.append(string + "delivery mode = ");
        if (this.deliveryMode == null) {
            stringBuffer.append("null");
        } else {
            switch (this.deliveryMode) {
                case 2: {
                    stringBuffer.append("PERSISTENT");
                    break;
                }
                case 1: {
                    stringBuffer.append("NON_PERSISTENT");
                }
            }
        }
        stringBuffer.append(string + "priority = " + this.priority);
        stringBuffer.append(string + "time to live = " + this.timeToLive);
        stringBuffer.append(string + "closed = " + this.closed);
        return stringBuffer.toString();
    }

    protected void checkOpen() throws IllegalStateException {
        if (this.closed) {
            IllegalStateException illegalStateException = new IllegalStateException("Producer closed");
            throw illegalStateException;
        }
    }

    protected void initialiseMessageProducer() throws JMSException {
        try {
            MessageProducer messageProducer = this.getMessageProducer();
            if (messageProducer != null) {
                if (this.disableMessageID != null) {
                    messageProducer.setDisableMessageID(this.disableMessageID.booleanValue());
                }
                if (this.disableMessageTimestamp != null) {
                    messageProducer.setDisableMessageTimestamp(this.disableMessageTimestamp.booleanValue());
                }
                if (this.deliveryMode != null) {
                    messageProducer.setDeliveryMode(this.deliveryMode.intValue());
                }
                if (this.priority != null) {
                    messageProducer.setPriority(this.priority.intValue());
                }
                if (this.timeToLive != null) {
                    messageProducer.setTimeToLive(this.timeToLive.longValue());
                }
            }
        }
        catch (JMSException jMSException) {
            this.markManagedObjectsAsStale(jMSException);
            throw jMSException;
        }
    }

    protected void enlist() throws JMSException {
        this.sessionHandle.getManagedSession().enlist();
    }

    protected abstract MessageProducer getMessageProducer();

    protected abstract MessageProducer getOpenMessageProducer() throws IllegalStateException, JMSException;

    final void markManagedObjectsAsStale(JMSException jMSException) {
        this.sessionHandle.markManagedObjectsAsStale(jMSException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

