/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSCloseable;
import com.ibm.ejs.jms.JMSQueueSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueSession;

public final class JMSQueueBrowserHandle
implements QueueBrowser,
JMSCloseable,
Serializable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSQueueBrowserHandle == null ? (class$com$ibm$ejs$jms$JMSQueueBrowserHandle = JMSQueueBrowserHandle.class$("com.ibm.ejs.jms.JMSQueueBrowserHandle")) : class$com$ibm$ejs$jms$JMSQueueBrowserHandle), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private final JMSQueueSessionHandle queueSessionHandle;
    private final Queue queue;
    private final String messageSelector;
    private QueueBrowser queueBrowser;
    private boolean closed = false;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSQueueBrowserHandle;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JMSQueueBrowserHandle(JMSQueueSessionHandle jMSQueueSessionHandle, Queue queue) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSQueueBrowserHandle", (Object)new Object[]{jMSQueueSessionHandle, queue});
        }
        try {
            try {
                this.queueSessionHandle = jMSQueueSessionHandle;
                this.queue = queue;
                this.messageSelector = null;
                QueueSession queueSession = jMSQueueSessionHandle.getOpenQueueSession();
                try {
                    this.queueBrowser = queueSession.createBrowser(queue);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                this.queueSessionHandle.addChild(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.JMSQueueBrowserHandle", "89", this);
                JMSCMUtils.trace(tc, "JMSQueueBrowserHandle", jMSException);
                throw jMSException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"JMSQueueBrowserHandle");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"JMSQueueBrowserHandle");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JMSQueueBrowserHandle(JMSQueueSessionHandle jMSQueueSessionHandle, Queue queue, String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSQueueBrowserHandle", (Object)new Object[]{jMSQueueSessionHandle, queue, string});
        }
        try {
            try {
                this.queueSessionHandle = jMSQueueSessionHandle;
                this.queue = queue;
                this.messageSelector = string;
                QueueSession queueSession = jMSQueueSessionHandle.getOpenQueueSession();
                try {
                    this.queueBrowser = queueSession.createBrowser(queue, string);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                this.queueSessionHandle.addChild(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.JMSQueueBrowserHandle", "133", this);
                JMSCMUtils.trace(tc, "JMSQueueBrowserHandle", jMSException);
                throw jMSException;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"JMSQueueBrowserHandle");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"JMSQueueBrowserHandle");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Queue getQueue() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getQueue");
        }
        Queue queue = null;
        try {
            try {
                QueueBrowser queueBrowser = this.getOpenQueueBrowser();
                try {
                    queue = queueBrowser.getQueue();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.getQueue", "168", this);
                JMSCMUtils.trace(tc, "getQueue", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getQueue", (Object)queue);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return queue;
        Tr.exit((TraceComponent)tc, (String)"getQueue", (Object)queue);
        return queue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMessageSelector() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessageSelector");
        }
        String string = null;
        try {
            try {
                QueueBrowser queueBrowser = this.getOpenQueueBrowser();
                try {
                    string = queueBrowser.getMessageSelector();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.getMessageSelector", "208", this);
                JMSCMUtils.trace(tc, "getMessageSelector", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getMessageSelector", (Object)string);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return string;
        Tr.exit((TraceComponent)tc, (String)"getMessageSelector", (Object)string);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration getEnumeration() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEnumeration");
        }
        Enumeration enumeration = null;
        try {
            try {
                QueueBrowser queueBrowser = this.getOpenQueueBrowser();
                try {
                    enumeration = queueBrowser.getEnumeration();
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_6 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.getEnumeration", "246", this);
                JMSCMUtils.trace(tc, "getEnumeration", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getEnumeration", (Object)enumeration);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return enumeration;
        Tr.exit((TraceComponent)tc, (String)"getEnumeration", (Object)enumeration);
        return enumeration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        try {
            try {
                if (this.queueBrowser != null) {
                    this.queueBrowser.close();
                }
                this.queueSessionHandle.removeChild(this);
                this.closed = true;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.close", "287", this);
                JMSCMUtils.trace(tc, "close", jMSException);
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"close");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset");
        }
        try {
            block6: {
                try {
                    if (this.queueBrowser == null) break block6;
                    this.queueBrowser.close();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueBrowserHandle.reset", "318", this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Failed to close QueueBrowser during reset", (Object)((Object)jMSException));
                    }
                    this.markManagedObjectsAsStale(jMSException);
                    Object var3_2 = null;
                    this.queueBrowser = null;
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit((TraceComponent)tc, (String)"reset");
                    return;
                }
            }
            Object var3_1 = null;
            this.queueBrowser = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"reset");
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.queueBrowser = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"reset");
            throw throwable;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSQueueBrowserHandle jMSQueueBrowserHandle = (JMSQueueBrowserHandle)object;
        if (!JMSCMUtils.objectsEqual(this.queueSessionHandle, jMSQueueBrowserHandle.queueSessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.queue, jMSQueueBrowserHandle.queue)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.messageSelector, jMSQueueBrowserHandle.messageSelector)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.queueBrowser, jMSQueueBrowserHandle.queueBrowser)) {
            return false;
        }
        return this.closed == jMSQueueBrowserHandle.closed;
    }

    public int hashCode() {
        int n = this.closed ? -1 : 1;
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queueSessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queue);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.messageSelector);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.queueBrowser);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "session handle = " + JMSCMUtils.objectToString(this.queueSessionHandle));
        stringBuffer.append(string + "message selector = " + this.messageSelector);
        stringBuffer.append(string + "closed = " + this.closed);
        stringBuffer.append(string + "queue = " + this.queue);
        stringBuffer.append(string + "physical queue browser = " + this.queueBrowser);
        return stringBuffer.toString();
    }

    protected void checkOpen() throws IllegalStateException {
        if (this.closed) {
            IllegalStateException illegalStateException = new IllegalStateException("Browser closed");
            throw illegalStateException;
        }
    }

    private QueueBrowser getOpenQueueBrowser() throws IllegalStateException, JMSException {
        this.checkOpen();
        if (this.queueBrowser == null) {
            QueueSession queueSession = this.queueSessionHandle.getOpenQueueSession();
            try {
                this.queueBrowser = this.messageSelector == null ? queueSession.createBrowser(this.queue) : queueSession.createBrowser(this.queue, this.messageSelector);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        return this.queueBrowser;
    }

    private final void markManagedObjectsAsStale(JMSException jMSException) {
        this.queueSessionHandle.markManagedObjectsAsStale(jMSException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

