/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedQueueSessionFactory;
import com.ibm.ejs.jms.JMSQueueSessionHandle;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.ConnectionConsumer;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.TemporaryQueue;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public final class JMSQueueConnectionHandle
extends JMSConnectionHandle
implements QueueConnection {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSQueueConnectionHandle == null ? (class$com$ibm$ejs$jms$JMSQueueConnectionHandle = JMSQueueConnectionHandle.class$("com.ibm.ejs.jms.JMSQueueConnectionHandle")) : class$com$ibm$ejs$jms$JMSQueueConnectionHandle), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private List temporaryQueues = new ArrayList();
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSQueueConnectionHandle;

    JMSQueueConnectionHandle(JMSManagedQueueSessionFactory jMSManagedQueueSessionFactory, ConnectionManager connectionManager) {
        super(jMSManagedQueueSessionFactory, connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSQueueConnectionHandle", (Object)new Object[]{jMSManagedQueueSessionFactory, connectionManager});
            Tr.exit((TraceComponent)tc, (String)"JMSQueueConnectionHandle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConnectionConsumer", (Object)new Object[]{queue, string, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        try {
            try {
                this.checkRestrictedMethod("createConnectionConsumer");
                this.checkOpen();
                this.checkValid();
                QueueConnection queueConnection = (QueueConnection)this.connection;
                try {
                    connectionConsumer = queueConnection.createConnectionConsumer(queue, string, serverSessionPool, n);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException) {
                    this.markManagedConnectionAsStale(jMSException);
                    throw jMSException;
                }
                Object var9_11 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createConnectionConsumer", "112", this);
                JMSCMUtils.trace(tc, "createConnectionConsumer", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createConnectionConsumer", connectionConsumer);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return connectionConsumer;
        Tr.exit((TraceComponent)tc, (String)"createConnectionConsumer", (Object)connectionConsumer);
        return connectionConsumer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createQueueSession", (Object)new Object[]{new Boolean(bl), new Integer(n)});
        }
        JMSQueueSessionHandle jMSQueueSessionHandle = null;
        try {
            try {
                this.checkOpen();
                this.checkValid();
                JMSSessionRequestInfo jMSSessionRequestInfo = new JMSSessionRequestInfo(bl, n);
                jMSQueueSessionHandle = (JMSQueueSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSSessionRequestInfo);
                jMSQueueSessionHandle.setQueueConnectionHandle(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createQueueSession", "159", this);
                JMSCMUtils.trace(tc, "createQueueSession", jMSException);
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createQueueSession", "165", this);
                if (!(resourceException.getLinkedException() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
                this.markManagedConnectionAsStale((JMSException)((Object)resourceException.getLinkedException()));
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createQueueSession", jMSQueueSessionHandle);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return jMSQueueSessionHandle;
        Tr.exit((TraceComponent)tc, (String)"createQueueSession", (Object)jMSQueueSessionHandle);
        return jMSQueueSessionHandle;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "temporary queues = [");
        Iterator iterator = this.temporaryQueues.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized QueueSession createListenerQueueSession(int n, boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createListenerQueueSession", (Object)new Object[]{new Integer(n), new Boolean(bl)});
        }
        JMSQueueSessionHandle jMSQueueSessionHandle = null;
        try {
            try {
                this.checkOpen();
                this.checkValid();
                JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = new JMSListenerSessionRequestInfo(n, bl);
                jMSQueueSessionHandle = (JMSQueueSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSListenerSessionRequestInfo);
                jMSQueueSessionHandle.setQueueConnectionHandle(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createListenerQueueSession", "284", this);
                JMSCMUtils.trace(tc, "createListenerQueueSession", jMSException);
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createListenerQueueSession", "290", this);
                if (!(resourceException.getLinkedException() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
                this.markManagedConnectionAsStale((JMSException)((Object)resourceException.getLinkedException()));
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create queue session");
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createListenerQueueSession", jMSQueueSessionHandle);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return jMSQueueSessionHandle;
        Tr.exit((TraceComponent)tc, (String)"createListenerQueueSession", (Object)jMSQueueSessionHandle);
        return jMSQueueSessionHandle;
    }

    void addTemporaryQueue(TemporaryQueue temporaryQueue) {
        this.temporaryQueues.add(temporaryQueue);
    }

    void deleteTemporaryDestinations() throws JMSException {
        Iterator iterator = this.temporaryQueues.iterator();
        while (iterator.hasNext()) {
            TemporaryQueue temporaryQueue = (TemporaryQueue)iterator.next();
            try {
                temporaryQueue.delete();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.close", "210", this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"JMSException deleting temporary queue", (Object)((Object)jMSException));
                }
                this.markManagedConnectionAsStale(jMSException);
            }
        }
        this.temporaryQueues.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

