/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.jms.JMSConnectionFactoryReferenceable;
import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.jca.TransactionSupportKind;
import com.ibm.mq.jms.admin.AdminObject;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.JMSClientInit;
import com.ibm.ws.messaging.JMSProviderUtils;
import com.ibm.ws.messaging.JMSQueueManagerName;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Referenceable;

public final class JMSResourceRefBuilderImpl
implements JMSResourceRefBuilder {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSResourceRefBuilderImpl == null ? (class$com$ibm$ejs$jms$JMSResourceRefBuilderImpl = JMSResourceRefBuilderImpl.class$("com.ibm.ejs.jms.JMSResourceRefBuilderImpl")) : class$com$ibm$ejs$jms$JMSResourceRefBuilderImpl), (String)"Messaging", (String)"com.ibm.ws.messaging.MSGSMessages");
    private static String jmsServerName = null;
    private static final String OBJECTTYPE = "ObjectType";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String STRING_TYPE = "java.lang.String";
    private static final int JMSTransportType_CLIENT = 1;
    private static final int JMSTransportType_BIND = 0;
    private static final int JMSTransportType_TCPIP = 2;
    private static final int JMSTransportType_MQJD = 3;
    private static final int JMSBrokerVersion_V2 = 1;
    private static final int JMSCloneSupport_TRUE = 1;
    private static final int JMSCloneSupport_FALSE = 0;
    private static final int JMSSubscriptionStore_BROKER = 1;
    private static final int JMSSubscriptionStore_QUEUE = 0;
    private static final int JMSMsgSelection_CLIENT = 0;
    private static final int JMSMsgSelection_BROKER = 1;
    private static final String JMS_PREFIX = "JMS$";
    private static final String CLIENT_CHANNEL = "WAS.JMS.SVRCONN";
    private static final String DATAFLOW_QUEUE = "SYSTEM.BROKER.DEFAULT.STREAM";
    private static final String CREDENTIAL_INTERFACE = "javax.resource.spi.security.PasswordCredential";
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSResourceRefBuilderImpl;

    public Referenceable createGenericQueueConnectionFactoryReferenceable(Properties properties, Properties properties2, Properties properties3, Properties properties4) throws ResourceBindingException {
        return this.createGenericConnectionFactoryReferenceable("GenericJMSManagedQueueConnectionFactory", properties, properties2, properties3, properties4);
    }

    public Referenceable createGenericTopicConnectionFactoryReferenceable(Properties properties, Properties properties2, Properties properties3, Properties properties4) throws ResourceBindingException {
        return this.createGenericConnectionFactoryReferenceable("GenericJMSManagedTopicConnectionFactory", properties, properties2, properties3, properties4);
    }

    private Referenceable createGenericConnectionFactoryReferenceable(String string, Properties properties, Properties properties2, Properties properties3, Properties properties4) throws ResourceBindingException {
        String string2 = JMSResourceRefBuilderImpl.getAdminObjectName(properties);
        Properties properties5 = this.createConnectionFactoryJ2CProperties(string2, string, properties, properties2);
        String string3 = JMSResourceRefBuilderImpl.getProperty(properties, "JNDIPath", true);
        String string4 = JMSResourceRefBuilderImpl.getProperty(properties, "ProviderURL", true);
        String string5 = JMSResourceRefBuilderImpl.getProperty(properties, "ContextFactoryClassname", true);
        ConnectorProperties connectorProperties = JMSResourceRefBuilderImpl.createConnectionFactoryConnectorProperties(string2, properties, properties3);
        connectorProperties.add((Object)new ConnectorProperty("ProviderURL", STRING_TYPE, string4));
        connectorProperties.add((Object)new ConnectorProperty("ContextFactoryClassname", STRING_TYPE, string5));
        connectorProperties.add((Object)new ConnectorProperty("JNDIPath", STRING_TYPE, string3));
        return new JMSConnectionFactoryReferenceable(properties5, connectorProperties, string3, string4, string5, properties4);
    }

    public Referenceable createEmbeddedQueueConnectionFactoryReferenceable(Properties properties, Properties properties2, Properties properties3) throws ResourceBindingException {
        String string = JMSQueueManagerName.getQueueManagerName((String)JMSResourceRefBuilderImpl.getProperty(properties, "CELL", true), (String)JMSResourceRefBuilderImpl.getProperty(properties, "NODE", true), (String)JMSResourceRefBuilderImpl.getJMSServerName());
        properties.put("QMGR", string);
        properties.put("TRAN", new Integer(JMSProviderUtils.isProviderMQJD() ? 3 : 1));
        properties.put("HOST", JMSResourceRefBuilderImpl.getProperty(properties, "NODH", true));
        properties.put("PORT", JMSResourceRefBuilderImpl.getPropertyAsInteger(properties, "QUEUEDPORT", true));
        properties.put("CHAN", CLIENT_CHANNEL);
        return this.createNonGenericQueueConnectionFactoryReferenceable(properties, properties2, properties3);
    }

    public Referenceable createMQQueueConnectionFactoryReferenceable(Properties properties, Properties properties2, Properties properties3) throws ResourceBindingException {
        JMSResourceRefBuilderImpl.convertMQCFProperties(properties);
        return this.createNonGenericQueueConnectionFactoryReferenceable(properties, properties2, properties3);
    }

    private Referenceable createNonGenericQueueConnectionFactoryReferenceable(Properties properties, Properties properties2, Properties properties3) throws ResourceBindingException {
        int n = JMSResourceRefBuilderImpl.getPropertyAsBoolean(properties, "XAEnabled", true) != false ? 4 : 0;
        return this.createNonGenericConnectionFactoryReferenceable(n, "WSJMSManagedQueueConnectionFactory", properties, properties2, properties3);
    }

    public Referenceable createEmbeddedTopicConnectionFactoryReferenceable(Properties properties, Properties properties2, Properties properties3) throws ResourceBindingException {
        int n;
        int n2 = JMSResourceRefBuilderImpl.getPropertyAsInteger(properties, "PORTTYPE", true);
        if (n2 == 1) {
            String string = JMSQueueManagerName.getQueueManagerName((String)JMSResourceRefBuilderImpl.getProperty(properties, "CELL", true), (String)JMSResourceRefBuilderImpl.getProperty(properties, "NODE", true), (String)JMSResourceRefBuilderImpl.getJMSServerName());
            properties.put("QMGR", string);
            properties.put("BQM", string);
            properties.put("TRAN", new Integer(JMSProviderUtils.isProviderMQJD() ? 3 : 1));
            properties.put("HOST", JMSResourceRefBuilderImpl.getProperty(properties, "NODH", true));
            properties.put("PORT", JMSResourceRefBuilderImpl.getPropertyAsInteger(properties, "QUEUEDPORT", true));
            properties.put("CHAN", CLIENT_CHANNEL);
            properties.put("BPUB", DATAFLOW_QUEUE);
            properties.put("SS", new Integer(JMSProviderUtils.isProviderMQJD() ? 0 : 1));
            properties.put("MSEL", new Integer(JMSProviderUtils.isProviderMQJD() ? 0 : 1));
            n = JMSResourceRefBuilderImpl.getPropertyAsBoolean(properties, "XAEnabled", true) != false ? 5 : 2;
        } else {
            properties.put("TRAN", new Integer(JMSProviderUtils.isProviderMQJD() ? 3 : 2));
            properties.put("HOST", JMSResourceRefBuilderImpl.getProperty(properties, "NODH", true));
            properties.put("PORT", JMSResourceRefBuilderImpl.getPropertyAsInteger(properties, "DIRECTPORT", true));
            n = 2;
        }
        properties.put("BVER", new Integer(1));
        return this.createNonGenericTopicConnectionFactoryReferenceable(n, properties, properties2, properties3);
    }

    public Referenceable createMQTopicConnectionFactoryReferenceable(Properties properties, Properties properties2, Properties properties3) throws ResourceBindingException {
        JMSResourceRefBuilderImpl.convertMQCFProperties(properties);
        int n = JMSResourceRefBuilderImpl.getPropertyAsBoolean(properties, "XAEnabled", true) != false ? 5 : 2;
        return this.createNonGenericTopicConnectionFactoryReferenceable(n, properties, properties2, properties3);
    }

    private Referenceable createNonGenericTopicConnectionFactoryReferenceable(int n, Properties properties, Properties properties2, Properties properties3) throws ResourceBindingException {
        if (JMSResourceRefBuilderImpl.getPropertyAsBoolean(properties, "CLONESUP", true).booleanValue()) {
            if (JMSResourceRefBuilderImpl.getProperty(properties, "CID", false) == null) {
                throw new ResourceBindingException("The JMS Resource " + JMSResourceRefBuilderImpl.getAdminObjectName(properties) + " has cloneSupport set to true but no clientID has been supplied");
            }
            properties.put("CLS", new Integer(1));
        }
        return this.createNonGenericConnectionFactoryReferenceable(n, "WSJMSManagedTopicConnectionFactory", properties, properties2, properties3);
    }

    private Referenceable createNonGenericConnectionFactoryReferenceable(int n, String string, Properties properties, Properties properties2, Properties properties3) throws ResourceBindingException {
        JMSConnectionFactoryReferenceable jMSConnectionFactoryReferenceable = null;
        String string2 = JMSResourceRefBuilderImpl.getAdminObjectName(properties);
        Properties properties4 = this.createConnectionFactoryJ2CProperties(string2, string, properties, properties2);
        ConnectorProperties connectorProperties = JMSResourceRefBuilderImpl.createConnectionFactoryConnectorProperties(string2, properties, properties3);
        ConnectorProperty connectorProperty = new ConnectorProperty(OBJECTTYPE, INTEGER_TYPE, String.valueOf(n));
        connectorProperties.add((Object)connectorProperty);
        JMSResourceRefBuilderImpl.clearNonAdminObjectProperties(properties);
        jMSConnectionFactoryReferenceable = new JMSConnectionFactoryReferenceable(properties4, connectorProperties, properties, n);
        return jMSConnectionFactoryReferenceable;
    }

    public Referenceable createEmbeddedQueueReferenceable(Properties properties) throws ResourceBindingException {
        String string = JMSProviderUtils.getRealQueueName((String)JMSResourceRefBuilderImpl.getAdminObjectName(properties));
        if (string == null) {
            throw new ResourceBindingException("The JMS Resource " + JMSResourceRefBuilderImpl.getAdminObjectName(properties) + " can not be defined as the queue name is too long");
        }
        properties.put("QU", string);
        return this.createDestinationReferenceable(1, properties, false);
    }

    public Referenceable createEmbeddedTopicReferenceable(Properties properties) throws ResourceBindingException {
        properties.put("BVER", new Integer(1));
        return this.createDestinationReferenceable(3, properties, false);
    }

    public Referenceable createMQQueueReferenceable(Properties properties) throws ResourceBindingException {
        return this.createDestinationReferenceable(1, properties, true);
    }

    public Referenceable createMQTopicReferenceable(Properties properties) throws ResourceBindingException {
        return this.createDestinationReferenceable(3, properties, true);
    }

    private Referenceable createDestinationReferenceable(int n, Properties properties, boolean bl) throws ResourceBindingException {
        Referenceable referenceable = null;
        JMSResourceRefBuilderImpl.clearNonAdminObjectProperties(properties);
        JMSResourceRefBuilderImpl.convertQueueAndTopicProperties(properties, bl);
        try {
            AdminObject adminObject;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating destination, type " + n + ", from properties"), (Object)properties);
            }
            if ((adminObject = new AdminObject(n, (Hashtable)properties, true)).errorRaised()) {
                Tr.error((TraceComponent)tc, (String)"ERROR_BUILDING_REFERENCE_MSGS0300", (Object)JMSResourceRefBuilderImpl.getAdminObjectName(properties));
                int n2 = adminObject.getErrorType();
                if (n2 == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Invalid property given to AdminObject, property name: " + adminObject.getErrorString1()));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unexpected AdminObject error " + n2 + " " + adminObject.getErrorString1() + " " + adminObject.getErrorString2()));
                }
                throw new ResourceBindingException("The JMS Resource " + JMSResourceRefBuilderImpl.getAdminObjectName(properties) + " could not be bound");
            }
            referenceable = (Referenceable)adminObject.getObject();
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.JMSResourceRefBuilderImpl.createReferenceableObject", "604", this);
            Tr.error((TraceComponent)tc, (String)"EXCEPTION_BUILDING_REFERENCE_MSGS0301", (Object)JMSResourceRefBuilderImpl.getAdminObjectName(properties));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An invalid property type was passed to AdminObject ");
            }
            throw new ResourceBindingException("The JMS Resource " + JMSResourceRefBuilderImpl.getAdminObjectName(properties) + " could not be bound");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            FFDCFilter.processException((Throwable)noClassDefFoundError, "com.ibm.ejs.jms.JMSResourceRefBuilderImpl.createReferenceableObject", "614", this);
            Tr.warning((TraceComponent)tc, (String)"IBM_JMS_NOT_AVAILABLE_MSGS0303", (Object)JMSResourceRefBuilderImpl.getAdminObjectName(properties));
            throw new ResourceBindingException("The JMS Resource " + JMSResourceRefBuilderImpl.getAdminObjectName(properties) + " could not be bound as neither WebSphere Embedded Messaging or MQSeries have been installed");
        }
        return referenceable;
    }

    private static void clearNonAdminObjectProperties(Properties properties) {
        properties.remove("NODH");
        properties.remove("QUEUEDPORT");
        properties.remove("DIRECTPORT");
        properties.remove("NAME");
        properties.remove("NODE");
        properties.remove("CELL");
        properties.remove("PORTTYPE");
        properties.remove("UserName");
        properties.remove("Password");
        properties.remove("CLONESUP");
        properties.remove("XAEnabled");
        properties.remove("OptionC_authDataAlias");
        properties.remove("mappingConfigAlias");
        properties.remove("authDataAlias");
        Integer n = (Integer)properties.get("TRAN");
        if (n != null && n == 0) {
            properties.remove("HOST");
            properties.remove("PORT");
            properties.remove("CCS");
            properties.remove("CHAN");
        }
    }

    private static void convertQueueAndTopicProperties(Properties properties, boolean bl) throws ResourceBindingException {
        JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "PER", true);
        JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "PRI", true);
        JMSResourceRefBuilderImpl.convertPropertyToLong(properties, "EXP", true);
        if (bl) {
            JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "CCS", false);
            JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "TC", false);
        }
    }

    private static void convertMQCFProperties(Properties properties) throws ResourceBindingException {
        Integer n;
        JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "TRAN", false);
        JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "PORT", false);
        JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "CCS", false);
        JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "MSEL", false);
        JMSResourceRefBuilderImpl.convertPropertyToInteger(properties, "SS", false);
        Boolean bl = JMSResourceRefBuilderImpl.getPropertyAsBoolean(properties, "MRET", false);
        if (bl != null) {
            if (bl.booleanValue()) {
                properties.put("MRET", new Integer(1));
            } else {
                properties.put("MRET", new Integer(0));
            }
        }
        if ((n = JMSResourceRefBuilderImpl.getPropertyAsInteger(properties, "BVER", false)) != null) {
            switch (n) {
                case 1: {
                    properties.put("BVER", new Integer(0));
                    break;
                }
                case 0: {
                    properties.put("BVER", new Integer(1));
                    break;
                }
                default: {
                    throw new ResourceBindingException("Invalid MQBrokerVersionType :" + n);
                }
            }
        }
    }

    private Properties createConnectionFactoryJ2CProperties(String string, String string2, Properties properties, Properties properties2) {
        String string3;
        String string4;
        Properties properties3 = new Properties();
        properties3.setProperty("name", JMS_PREFIX + string);
        String string5 = this.getClass().getName();
        String string6 = new String(string5.substring(0, string5.lastIndexOf(46)));
        properties3.setProperty("managedConnectionFactoryClass", string6 + "." + string2);
        properties3.setProperty("transactionSupport", TransactionSupportKind.NO_TRANSACTION_LITERAL.getName());
        properties3.setProperty("authMechanismPreference", ConnectionFactoryRefBuilder.AUTH_MECH_PREF_BASIC_PASSWORD.toString());
        properties3.setProperty(ConnectionFactoryRefBuilder.SECURITY_BasicPassword, CREDENTIAL_INTERFACE);
        String string7 = properties.getProperty("OptionC_authDataAlias");
        if (string7 != null) {
            properties3.setProperty("OptionC_authDataAlias", string7);
        }
        if ((string4 = properties.getProperty("mappingConfigAlias")) != null) {
            properties3.setProperty("mappingConfigAlias", string4);
        }
        if ((string3 = properties.getProperty("authDataAlias")) != null) {
            properties3.setProperty("authDataAlias", string3);
        }
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            properties3.put(object, properties2.get(object));
        }
        return properties3;
    }

    private static ConnectorProperties createConnectionFactoryConnectorProperties(String string, Properties properties, Properties properties2) throws ResourceBindingException {
        String string2;
        String string3;
        String string4;
        ConnectorProperties connectorProperties = new ConnectorProperties();
        connectorProperties.add((Object)new ConnectorProperty("ConnectorName", STRING_TYPE, JMS_PREFIX + string));
        String string5 = JMSResourceRefBuilderImpl.getProperty(properties, "UserName", false);
        if (string5 != null) {
            connectorProperties.add((Object)new ConnectorProperty("UserName", STRING_TYPE, string5));
        }
        if ((string4 = JMSResourceRefBuilderImpl.getProperty(properties, "Password", false)) != null) {
            connectorProperties.add((Object)new ConnectorProperty("Password", STRING_TYPE, string4));
        }
        if ((string3 = JMSResourceRefBuilderImpl.getProperty(properties, "mappingConfigAlias", false)) != null) {
            connectorProperties.add((Object)new ConnectorProperty("mappingConfigAlias", STRING_TYPE, string3));
        }
        if ((string2 = JMSResourceRefBuilderImpl.getProperty(properties, "authDataAlias", false)) != null) {
            connectorProperties.add((Object)new ConnectorProperty("authDataAlias", STRING_TYPE, string2));
        }
        JMSResourceRefBuilderImpl.addSessionPoolProperty(properties2, "maxConnections", connectorProperties, "SessionPoolMaxConnections");
        JMSResourceRefBuilderImpl.addSessionPoolProperty(properties2, "minConnections", connectorProperties, "SessionPoolMinConnections");
        JMSResourceRefBuilderImpl.addSessionPoolProperty(properties2, "connectionTimeout", connectorProperties, "SessionPoolConnectionTimeout");
        JMSResourceRefBuilderImpl.addSessionPoolProperty(properties2, "reapTime", connectorProperties, "SessionPoolReapTime");
        JMSResourceRefBuilderImpl.addSessionPoolProperty(properties2, "agedTimeout", connectorProperties, "SessionPoolAgedTimeout");
        JMSResourceRefBuilderImpl.addSessionPoolProperty(properties2, "unusedTimeout", connectorProperties, "SessionPoolUnusedTimeout");
        JMSResourceRefBuilderImpl.addSessionPoolProperty(properties2, "purgePolicy", connectorProperties, "SessionPoolPurgePolicy");
        return connectorProperties;
    }

    private static String getAdminObjectName(Properties properties) throws ResourceBindingException {
        return JMSResourceRefBuilderImpl.getProperty(properties, "NAME", false);
    }

    private static void addSessionPoolProperty(Properties properties, String string, ConnectorProperties connectorProperties, String string2) throws ResourceBindingException {
        String string3 = JMSResourceRefBuilderImpl.getProperty(properties, string, false);
        if (string3 != null) {
            connectorProperties.add((Object)new ConnectorProperty(string2, STRING_TYPE, string3));
        }
    }

    private static Integer getPropertyAsInteger(Properties properties, String string, boolean bl) throws ResourceBindingException {
        Integer n = null;
        String string2 = JMSResourceRefBuilderImpl.getProperty(properties, string, bl);
        if (string2 != null) {
            try {
                n = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ResourceBindingException("Failed to convert property " + string + " with value " + string2 + " to Integer");
            }
        }
        return n;
    }

    private static Long getPropertyAsLong(Properties properties, String string, boolean bl) throws ResourceBindingException {
        Long l = null;
        String string2 = JMSResourceRefBuilderImpl.getProperty(properties, string, bl);
        if (string2 != null) {
            try {
                l = new Long(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ResourceBindingException("Failed to convert property " + string + " with value " + string2 + " to Long");
            }
        }
        return l;
    }

    private static Boolean getPropertyAsBoolean(Properties properties, String string, boolean bl) throws ResourceBindingException {
        Boolean bl2 = null;
        String string2 = JMSResourceRefBuilderImpl.getProperty(properties, string, bl);
        if (string2 != null) {
            try {
                bl2 = new Boolean(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ResourceBindingException("Failed to convert property " + string + " with value " + string2 + " to Boolean");
            }
        }
        return bl2;
    }

    private static String getProperty(Properties properties, String string, boolean bl) throws ResourceBindingException {
        String string2 = properties.getProperty(string);
        if (bl && string2 == null) {
            throw new ResourceBindingException("Failed to find required property " + string + " in " + properties);
        }
        return string2;
    }

    private static void convertPropertyToInteger(Properties properties, String string, boolean bl) throws ResourceBindingException {
        Integer n = JMSResourceRefBuilderImpl.getPropertyAsInteger(properties, string, bl);
        if (n != null) {
            properties.put(string, n);
        }
    }

    private static void convertPropertyToLong(Properties properties, String string, boolean bl) throws ResourceBindingException {
        Long l = JMSResourceRefBuilderImpl.getPropertyAsLong(properties, string, bl);
        if (l != null) {
            properties.put(string, l);
        }
    }

    private static String getJMSServerName() {
        if (jmsServerName == null) {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string = adminService.getProcessType();
            jmsServerName = string.equals("UnManagedProcess") ? adminService.getProcessName() : "jmsserver";
        }
        return jmsServerName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            JMSClientInit.setRunningInWebSphere();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            FFDCFilter.processException(noClassDefFoundError, "com.ibm.ejs.jms.JMSResourceRefBuilderImpl", "135");
        }
    }
}

