/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSCloseable;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSManagedSession;
import com.ibm.ejs.jms.JMSSessionHandleInterface;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.j2c.ConnectionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionRolledBackException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public abstract class JMSSessionHandle
implements Session,
JMSSessionHandleInterface,
Serializable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSSessionHandle == null ? (class$com$ibm$ejs$jms$JMSSessionHandle = JMSSessionHandle.class$("com.ibm.ejs.jms.JMSSessionHandle")) : class$com$ibm$ejs$jms$JMSSessionHandle), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private JMSManagedSession managedSession;
    private JMSConnectionHandle connectionHandle;
    private ConnectionRequestInfo sessionRequestInfo;
    private List openChildren = new ArrayList();
    private int state;
    private static final int INACTIVE = 0;
    private static final int ACTIVE = 1;
    private static final int CLOSED = 2;
    private boolean restrictedMethodsEnabled = false;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSSessionHandle;

    JMSSessionHandle(ConnectionRequestInfo connectionRequestInfo, JMSManagedSession jMSManagedSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSSessionHandle", (Object)new Object[]{connectionRequestInfo, jMSManagedSession});
        }
        this.sessionRequestInfo = connectionRequestInfo;
        this.activate(jMSManagedSession);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JMSSessionHandle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BytesMessage createBytesMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createBytesMessage");
        }
        BytesMessage bytesMessage = null;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    bytesMessage = session.createBytesMessage();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createBytesMessage", "136", this);
                JMSCMUtils.trace(tc, "createBytesMessage", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createBytesMessage", (Object)bytesMessage);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return bytesMessage;
        Tr.exit((TraceComponent)tc, (String)"createBytesMessage", (Object)bytesMessage);
        return bytesMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapMessage createMapMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMapMessage");
        }
        MapMessage mapMessage = null;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    mapMessage = session.createMapMessage();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createMapMessage", "176", this);
                JMSCMUtils.trace(tc, "createMapMessage", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createMapMessage", (Object)mapMessage);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return mapMessage;
        Tr.exit((TraceComponent)tc, (String)"createMapMessage", (Object)mapMessage);
        return mapMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message createMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMessage");
        }
        Message message = null;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    message = session.createMessage();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createMessage", "216", this);
                JMSCMUtils.trace(tc, "createMessage", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createMessage", (Object)message);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return message;
        Tr.exit((TraceComponent)tc, (String)"createMessage", (Object)message);
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMessage createObjectMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createObjectMessage");
        }
        ObjectMessage objectMessage = null;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    objectMessage = session.createObjectMessage();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createObjectMessage", "256", this);
                JMSCMUtils.trace(tc, "createObjectMessage", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createObjectMessage", (Object)objectMessage);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return objectMessage;
        Tr.exit((TraceComponent)tc, (String)"createObjectMessage", (Object)objectMessage);
        return objectMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMessage createObjectMessage(Serializable serializable) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createObjectMessage", (Object)serializable);
        }
        ObjectMessage objectMessage = null;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    objectMessage = session.createObjectMessage(serializable);
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var6_6 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createObjectMessage", "297", this);
                JMSCMUtils.trace(tc, "createObjectMessage", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createObjectMessage", (Object)objectMessage);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return objectMessage;
        Tr.exit((TraceComponent)tc, (String)"createObjectMessage", (Object)objectMessage);
        return objectMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamMessage createStreamMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStreamMessage");
        }
        StreamMessage streamMessage = null;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    streamMessage = session.createStreamMessage();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createStreamMessage", "337", this);
                JMSCMUtils.trace(tc, "createStreamMessage", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createStreamMessage", (Object)streamMessage);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return streamMessage;
        Tr.exit((TraceComponent)tc, (String)"createStreamMessage", (Object)streamMessage);
        return streamMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextMessage createTextMessage() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTextMessage");
        }
        TextMessage textMessage = null;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    textMessage = session.createTextMessage();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createTextMessage", "377", this);
                JMSCMUtils.trace(tc, "createTextMessage", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createTextMessage", (Object)textMessage);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return textMessage;
        Tr.exit((TraceComponent)tc, (String)"createTextMessage", (Object)textMessage);
        return textMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextMessage createTextMessage(String string) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTextMessage", (Object)string);
        }
        TextMessage textMessage = null;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    textMessage = session.createTextMessage(string);
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var6_6 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.createTextMessage", "418", this);
                JMSCMUtils.trace(tc, "createTextMessage", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createTextMessage", (Object)textMessage);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return textMessage;
        Tr.exit((TraceComponent)tc, (String)"createTextMessage", (Object)textMessage);
        return textMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getTransacted() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransacted");
        }
        boolean bl = false;
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    bl = session.getTransacted();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.getTransacted", "462", this);
                JMSCMUtils.trace(tc, "getTransacted", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getTransacted", (Object)new Boolean(bl));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return bl;
        Tr.exit((TraceComponent)tc, (String)"getTransacted", (Object)new Boolean(bl));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit");
        }
        try {
            try {
                this.checkNotInGlobalTransaction();
                Session session = this.getOpenSession();
                if (this.managedSession.inContainerLocalTran()) {
                    throw new IllegalStateException("Method not permitted in ContainerAtBoundary local transaction");
                }
                try {
                    session.commit();
                }
                catch (TransactionRolledBackException transactionRolledBackException) {
                    throw transactionRolledBackException;
                }
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                this.managedSession.localTransactionCommitted();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.commit", "505", this);
                JMSCMUtils.trace(tc, "commit", jMSException);
                throw jMSException;
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"commit");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"commit");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback");
        }
        try {
            try {
                this.checkNotInGlobalTransaction();
                Session session = this.getOpenSession();
                if (this.managedSession.inContainerLocalTran()) {
                    throw new IllegalStateException("Method not permitted in ContainerAtBoundary local transaction");
                }
                try {
                    session.rollback();
                }
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                this.managedSession.localTransactionRolledback();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.rollback", "546", this);
                JMSCMUtils.trace(tc, "rollback", jMSException);
                throw jMSException;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"rollback");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"rollback");
    }

    /*
     * Loose catch block
     */
    public void close() throws JMSException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"close");
            }
            try {
                switch (this.state) {
                    case 2: {
                        break;
                    }
                    case 0: {
                        this.closeChildren();
                        if (this.connectionHandle != null) {
                            this.connectionHandle.removeSessionHandle(this);
                            ConnectionManager connectionManager = (ConnectionManager)this.connectionHandle.getSessionManager();
                            connectionManager.inactiveConnectionClosed((Object)this);
                        }
                        this.state = 2;
                        break;
                    }
                    case 1: {
                        this.closeChildren();
                        if (this.connectionHandle != null) {
                            this.connectionHandle.removeSessionHandle(this);
                        }
                        this.managedSession.handleClosed(this);
                        this.managedSession = null;
                        this.state = 2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid state");
                    }
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"close");
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"close");
            }
            break block14;
            {
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.close", "593", this);
                    JMSCMUtils.trace(tc, "close", jMSException);
                    throw jMSException;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recover() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover");
        }
        try {
            try {
                Session session = this.getOpenSession();
                try {
                    session.recover();
                }
                catch (IllegalStateException illegalStateException) {
                    throw illegalStateException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var4_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.recover", "630", this);
                JMSCMUtils.trace(tc, "recover", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"recover");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"recover");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageListener getMessageListener() throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessageListener");
        }
        MessageListener messageListener = null;
        try {
            try {
                this.checkRestrictedMethod("getMessageListener");
                Session session = this.getSession();
                try {
                    messageListener = session.getMessageListener();
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.getMessageListener", "671", this);
                JMSCMUtils.trace(tc, "getMessageListener", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getMessageListener", (Object)messageListener);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return messageListener;
        Tr.exit((TraceComponent)tc, (String)"getMessageListener", (Object)messageListener);
        return messageListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMessageListener(MessageListener messageListener) throws IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMessageListener", (Object)messageListener);
        }
        try {
            try {
                this.checkRestrictedMethod("setMessageListener");
                Session session = this.getSession();
                try {
                    session.setMessageListener(messageListener);
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                Object var5_5 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.setMessageListener", "713", this);
                JMSCMUtils.trace(tc, "setMessageListener", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"setMessageListener");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setMessageListener");
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        try {
            this.checkRestrictedMethod("run");
            this.getSession().run();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSSessionHandle.run", "746", this);
            JMSCMUtils.trace(tc, "run", jMSException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    public void enlist() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlist");
        }
        try {
            this.managedSession.enlist();
        }
        catch (JMSException jMSException) {
            this.markManagedObjectsAsStale(jMSException);
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlist");
        }
    }

    public boolean isPreASFRunEnlist() throws JMSException {
        Class<?> clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isPreASFRunEnlist");
        }
        boolean bl = false;
        try {
            clazz = Class.forName("com.ibm.mq.jms.MQSession");
            if (clazz.isInstance(this.getOpenSession())) {
                bl = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!bl) {
            try {
                clazz = Class.forName("com.ibm.ambi.jms.AMBISession");
                if (clazz.isInstance(this.getOpenSession())) {
                    bl = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isPreASFRunEnlist", (Object)new Boolean(bl));
        }
        return bl;
    }

    public abstract Session getSession() throws IllegalStateException, JMSException;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JMSSessionHandle jMSSessionHandle = (JMSSessionHandle)object;
        if (!JMSCMUtils.objectsEqual(this.managedSession, jMSSessionHandle.managedSession)) {
            return false;
        }
        if (this.state != jMSSessionHandle.state) {
            return false;
        }
        return this.restrictedMethodsEnabled == jMSSessionHandle.restrictedMethodsEnabled;
    }

    public int hashCode() {
        int n = this.state;
        n = n * JMSCMUtils.HASH_CODE_PRIME + (this.restrictedMethodsEnabled ? -1 : 1);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(JMSCMUtils.objectToString(this));
        stringBuffer.append(string + "managed session = " + JMSCMUtils.objectToString(this.managedSession));
        stringBuffer.append(string + "state = " + this.getStateAsString());
        stringBuffer.append(string + "restricted methods enabled = " + this.restrictedMethodsEnabled);
        stringBuffer.append(string + "open children = [");
        Iterator iterator = this.openChildren.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    final void addChild(JMSCloseable jMSCloseable) {
        this.openChildren.add(jMSCloseable);
    }

    final void removeChild(JMSCloseable jMSCloseable) {
        this.openChildren.remove(jMSCloseable);
    }

    void closeChildren() throws JMSException {
        ArrayList arrayList = new ArrayList(this.openChildren);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JMSCloseable jMSCloseable = (JMSCloseable)iterator.next();
            try {
                jMSCloseable.close();
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
    }

    protected Session getOpenSession() throws IllegalStateException, JMSException {
        switch (this.state) {
            case 2: {
                throw new IllegalStateException("Session closed");
            }
            case 1: {
                break;
            }
            case 0: {
                try {
                    ConnectionManager connectionManager = (ConnectionManager)this.connectionHandle.getSessionManager();
                    connectionManager.associateConnection((ManagedConnectionFactory)this.connectionHandle.getManagedSessionFactory(), null, this.sessionRequestInfo, (Object)this);
                    break;
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSSessionHandle.getOpenSession", "982", this);
                    if (resourceException.getLinkedException() instanceof JMSException) {
                        this.markManagedObjectsAsStale((JMSException)((Object)resourceException.getLinkedException()));
                    }
                    throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to re-associate session handle");
                }
            }
        }
        return this.managedSession.getPhysicalSession();
    }

    protected void checkNotInGlobalTransaction() throws IllegalStateException, JMSException {
        if (JMSCMUtils.inGlobalTransaction()) {
            throw new IllegalStateException("Method not permitted in global transaction");
        }
    }

    protected void checkRestrictedMethod(String string) throws JMSException {
        if (!this.restrictedMethodsEnabled) {
            throw JMSCMUtils.methodNotPermittedException(tc, string);
        }
    }

    private String getStateAsString() {
        String string;
        switch (this.state) {
            case 1: {
                string = "ACTIVE";
                break;
            }
            case 0: {
                string = "INACTIVE";
                break;
            }
            case 2: {
                string = "CLOSED";
                break;
            }
            default: {
                throw new RuntimeException("Invalid state");
            }
        }
        return string;
    }

    final JMSManagedSession getManagedSession() {
        return this.managedSession;
    }

    void activate(JMSManagedSession jMSManagedSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activate", (Object)jMSManagedSession);
        }
        this.state = 1;
        this.managedSession = jMSManagedSession;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deactivate");
        }
        this.state = 0;
        Object object = this;
        synchronized (object) {
            this.managedSession = null;
        }
        object = this.openChildren.iterator();
        while (object.hasNext()) {
            JMSCloseable jMSCloseable = (JMSCloseable)object.next();
            jMSCloseable.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deactivate");
        }
    }

    final void setConnectionHandle(JMSConnectionHandle jMSConnectionHandle) {
        this.connectionHandle = jMSConnectionHandle;
        this.restrictedMethodsEnabled = jMSConnectionHandle.getRestrictedMethodsEnabled();
        jMSConnectionHandle.addSessionHandle(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void markManagedObjectsAsStale(JMSException jMSException) {
        JMSSessionHandle jMSSessionHandle = this;
        synchronized (jMSSessionHandle) {
            if (this.managedSession != null) {
                this.managedSession.connectionErrorOccurred((Exception)((Object)jMSException));
            }
        }
        if (this.connectionHandle != null) {
            this.connectionHandle.markManagedConnectionAsStale(jMSException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

