/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSListenerSessionRequestInfo;
import com.ibm.ejs.jms.JMSManagedTopicSessionFactory;
import com.ibm.ejs.jms.JMSSessionRequestInfo;
import com.ibm.ejs.jms.JMSTopicSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.ConnectionConsumer;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public final class JMSTopicConnectionHandle
extends JMSConnectionHandle
implements TopicConnection {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSTopicConnectionHandle == null ? (class$com$ibm$ejs$jms$JMSTopicConnectionHandle = JMSTopicConnectionHandle.class$("com.ibm.ejs.jms.JMSTopicConnectionHandle")) : class$com$ibm$ejs$jms$JMSTopicConnectionHandle), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private List temporaryTopics = new ArrayList();
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSTopicConnectionHandle;

    JMSTopicConnectionHandle(JMSManagedTopicSessionFactory jMSManagedTopicSessionFactory, ConnectionManager connectionManager) {
        super(jMSManagedTopicSessionFactory, connectionManager);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSTopicConnectionHandle", (Object)new Object[]{jMSManagedTopicSessionFactory, connectionManager});
            Tr.exit((TraceComponent)tc, (String)"JMSTopicConnectionHandle");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConnectionConsumer", (Object)new Object[]{topic, string, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        try {
            try {
                this.checkRestrictedMethod("createConnectionConsumer");
                this.checkOpen();
                this.checkValid();
                TopicConnection topicConnection = (TopicConnection)this.connection;
                try {
                    connectionConsumer = topicConnection.createConnectionConsumer(topic, string, serverSessionPool, n);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException) {
                    this.markManagedConnectionAsStale(jMSException);
                    throw jMSException;
                }
                Object var9_11 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createConnectionConsumer", "113", this);
                JMSCMUtils.trace(tc, "createConnectionConsumer", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createConnectionConsumer", connectionConsumer);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return connectionConsumer;
        Tr.exit((TraceComponent)tc, (String)"createConnectionConsumer", (Object)connectionConsumer);
        return connectionConsumer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDurableConnectionConsumer", (Object)new Object[]{topic, string, string2, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        try {
            try {
                this.checkRestrictedMethod("createDurableConnectionConsumer");
                this.checkOpen();
                this.checkValid();
                TopicConnection topicConnection = (TopicConnection)this.connection;
                try {
                    connectionConsumer = topicConnection.createDurableConnectionConsumer(topic, string, string2, serverSessionPool, n);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException) {
                    this.markManagedConnectionAsStale(jMSException);
                    throw jMSException;
                }
                Object var10_12 = null;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createDurableConnectionConsumer", "168", this);
                JMSCMUtils.trace(tc, "createDurableConnectionConsumer", jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createDurableConnectionConsumer", connectionConsumer);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return connectionConsumer;
        Tr.exit((TraceComponent)tc, (String)"createDurableConnectionConsumer", (Object)connectionConsumer);
        return connectionConsumer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTopicSession", (Object)new Object[]{new Boolean(bl), new Integer(n)});
        }
        JMSTopicSessionHandle jMSTopicSessionHandle = null;
        try {
            try {
                this.checkOpen();
                this.checkValid();
                JMSSessionRequestInfo jMSSessionRequestInfo = new JMSSessionRequestInfo(bl, n);
                jMSTopicSessionHandle = (JMSTopicSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSSessionRequestInfo);
                jMSTopicSessionHandle.setTopicConnectionHandle(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSQueueConnectionHandle.createTopicSession", "159", this);
                JMSCMUtils.trace(tc, "createTopicSession", jMSException);
                throw jMSException;
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createTopicSession", "215", this);
                if (!(resourceException.getLinkedException() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic session");
                this.markManagedConnectionAsStale((JMSException)((Object)resourceException.getLinkedException()));
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic session");
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createTopicSession", jMSTopicSessionHandle);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return jMSTopicSessionHandle;
        Tr.exit((TraceComponent)tc, (String)"createTopicSession", (Object)jMSTopicSessionHandle);
        return jMSTopicSessionHandle;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "temporary topics = [");
        Iterator iterator = this.temporaryTopics.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(JMSCMUtils.objectToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized TopicSession createListenerTopicSession(int n, boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createListenerTopicSession", (Object)new Object[]{new Integer(n), new Boolean(bl)});
        }
        JMSTopicSessionHandle jMSTopicSessionHandle = null;
        try {
            try {
                this.checkOpen();
                this.checkValid();
                JMSListenerSessionRequestInfo jMSListenerSessionRequestInfo = new JMSListenerSessionRequestInfo(n, bl);
                jMSTopicSessionHandle = (JMSTopicSessionHandle)this.sessionManager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)jMSListenerSessionRequestInfo);
                jMSTopicSessionHandle.setTopicConnectionHandle(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createListenerTopicSession", "334", this);
                JMSCMUtils.trace(tc, "createListenerTopicSession", jMSException);
                throw jMSException;
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.createListenerTopicSession", "340", this);
                if (!(resourceException.getLinkedException() instanceof JMSException)) throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic session");
                this.markManagedConnectionAsStale((JMSException)((Object)resourceException.getLinkedException()));
                throw JMSCMUtils.mapToJMSException(resourceException, tc, "Failed to create topic session");
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createListenerTopicSession", jMSTopicSessionHandle);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return jMSTopicSessionHandle;
        Tr.exit((TraceComponent)tc, (String)"createListenerTopicSession", (Object)jMSTopicSessionHandle);
        return jMSTopicSessionHandle;
    }

    void addTemporaryTopic(TemporaryTopic temporaryTopic) {
        this.temporaryTopics.add(temporaryTopic);
    }

    void deleteTemporaryDestinations() throws JMSException {
        Iterator iterator = this.temporaryTopics.iterator();
        while (iterator.hasNext()) {
            TemporaryTopic temporaryTopic = (TemporaryTopic)iterator.next();
            try {
                temporaryTopic.delete();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicConnectionHandle.close", "260", this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"JMSException deleting temporary topic", (Object)((Object)jMSException));
                }
                this.markManagedConnectionAsStale(jMSException);
            }
        }
        this.temporaryTopics.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

