/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSMessageConsumerHandle;
import com.ibm.ejs.jms.JMSTopicSessionHandle;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

final class JMSTopicSubscriberHandle
extends JMSMessageConsumerHandle
implements TopicSubscriber {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$JMSTopicSubscriberHandle == null ? (class$com$ibm$ejs$jms$JMSTopicSubscriberHandle = JMSTopicSubscriberHandle.class$("com.ibm.ejs.jms.JMSTopicSubscriberHandle")) : class$com$ibm$ejs$jms$JMSTopicSubscriberHandle), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private final JMSTopicSessionHandle topicSessionHandle;
    private final Topic topic;
    private String durableSubscriptionName = null;
    private Boolean noLocal = null;
    private TopicSubscriber topicSubscriber;
    static /* synthetic */ Class class$com$ibm$ejs$jms$JMSTopicSubscriberHandle;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JMSTopicSubscriberHandle(JMSTopicSessionHandle jMSTopicSessionHandle, Topic topic) throws JMSException {
        super(jMSTopicSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSTopicSubscriberHandle", (Object)new Object[]{jMSTopicSessionHandle, topic});
        }
        try {
            try {
                this.topicSessionHandle = jMSTopicSessionHandle;
                this.topic = topic;
                TopicSession topicSession = jMSTopicSessionHandle.getOpenTopicSession();
                try {
                    this.topicSubscriber = topicSession.createSubscriber(topic);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                jMSTopicSessionHandle.addChild(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.JMSTopicSubscriberHandle", "91", this);
                JMSCMUtils.trace(tc, "JMSTopicSubscriberHandle", jMSException);
                throw jMSException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"JMSTopicSubscriberHandle");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"JMSTopicSubscriberHandle");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JMSTopicSubscriberHandle(JMSTopicSessionHandle jMSTopicSessionHandle, Topic topic, String string, boolean bl) throws JMSException {
        super(jMSTopicSessionHandle, string);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSTopicSubscriberHandle", (Object)new Object[]{jMSTopicSessionHandle, topic, string, new Boolean(bl)});
        }
        try {
            try {
                this.topicSessionHandle = jMSTopicSessionHandle;
                this.topic = topic;
                this.noLocal = new Boolean(bl);
                TopicSession topicSession = jMSTopicSessionHandle.getOpenTopicSession();
                try {
                    this.topicSubscriber = topicSession.createSubscriber(topic, string, bl);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                jMSTopicSessionHandle.addChild(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.JMSTopicSubscriberHandle", "138", this);
                JMSCMUtils.trace(tc, "JMSTopicSubscriberHandle", jMSException);
                throw jMSException;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"JMSTopicSubscriberHandle");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"JMSTopicSubscriberHandle");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JMSTopicSubscriberHandle(JMSTopicSessionHandle jMSTopicSessionHandle, Topic topic, String string) throws JMSException {
        super(jMSTopicSessionHandle);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSTopicSubscriberHandle", (Object)new Object[]{jMSTopicSessionHandle, topic, string});
        }
        try {
            try {
                this.topicSessionHandle = jMSTopicSessionHandle;
                this.topic = topic;
                this.durableSubscriptionName = string;
                TopicSession topicSession = jMSTopicSessionHandle.getOpenTopicSession();
                try {
                    this.topicSubscriber = topicSession.createDurableSubscriber(topic, string);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                jMSTopicSessionHandle.addChild(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.JMSTopicSubscriberHandle", "183", this);
                JMSCMUtils.trace(tc, "JMSTopicSubscriberHandle", jMSException);
                throw jMSException;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"JMSTopicSubscriberHandle");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"JMSTopicSubscriberHandle");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JMSTopicSubscriberHandle(JMSTopicSessionHandle jMSTopicSessionHandle, Topic topic, String string, String string2, boolean bl) throws JMSException {
        super(jMSTopicSessionHandle, string2);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSTopicSubscriberHandle", (Object)new Object[]{jMSTopicSessionHandle, topic, string, string2, new Boolean(bl)});
        }
        try {
            try {
                this.topicSessionHandle = jMSTopicSessionHandle;
                this.topic = topic;
                this.durableSubscriptionName = string;
                this.noLocal = new Boolean(bl);
                TopicSession topicSession = jMSTopicSessionHandle.getOpenTopicSession();
                try {
                    this.topicSubscriber = topicSession.createDurableSubscriber(topic, string, string2, bl);
                }
                catch (InvalidDestinationException invalidDestinationException) {
                    throw invalidDestinationException;
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    throw invalidSelectorException;
                }
                catch (JMSException jMSException) {
                    this.markManagedObjectsAsStale(jMSException);
                    throw jMSException;
                }
                jMSTopicSessionHandle.addChild(this);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.JMSTopicSubscriberHandle", "235", this);
                JMSCMUtils.trace(tc, "JMSTopicSubscriberHandle", jMSException);
                throw jMSException;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"JMSTopicSubscriberHandle");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"JMSTopicSubscriberHandle");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Topic getTopic() throws java.lang.IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTopic");
        }
        Topic topic = null;
        try {
            try {
                TopicSubscriber topicSubscriber = this.getOpenTopicSubscriber();
                topic = topicSubscriber.getTopic();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.getTopic", "271", this);
                JMSCMUtils.trace(tc, "getTopic", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getTopic", (Object)topic);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return topic;
        Tr.exit((TraceComponent)tc, (String)"getTopic", (Object)topic);
        return topic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getNoLocal() throws java.lang.IllegalStateException, JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNoLocal");
        }
        boolean bl = false;
        try {
            try {
                TopicSubscriber topicSubscriber = this.getOpenTopicSubscriber();
                bl = topicSubscriber.getNoLocal();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.getNoLocal", "311", this);
                JMSCMUtils.trace(tc, "getNoLocal", jMSException);
                throw jMSException;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getNoLocal", (Object)new Boolean(bl));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return bl;
        Tr.exit((TraceComponent)tc, (String)"getNoLocal", (Object)new Boolean(bl));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset");
        }
        try {
            block6: {
                try {
                    if (this.topicSubscriber == null) break block6;
                    this.topicSubscriber.close();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.JMSTopicSubscriberHandle.reset", "339", this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Failed to close TopicSubscriber during reset", (Object)((Object)jMSException));
                    }
                    this.markManagedObjectsAsStale(jMSException);
                    Object var3_2 = null;
                    this.topicSubscriber = null;
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit((TraceComponent)tc, (String)"reset");
                    return;
                }
            }
            Object var3_1 = null;
            this.topicSubscriber = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"reset");
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.topicSubscriber = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"reset");
            throw throwable;
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        JMSTopicSubscriberHandle jMSTopicSubscriberHandle = (JMSTopicSubscriberHandle)object;
        if (!JMSCMUtils.objectsEqual(this.topicSessionHandle, jMSTopicSubscriberHandle.topicSessionHandle)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.topic, jMSTopicSubscriberHandle.topic)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.topicSubscriber, jMSTopicSubscriberHandle.topicSubscriber)) {
            return false;
        }
        if (!JMSCMUtils.objectsEqual(this.durableSubscriptionName, jMSTopicSubscriberHandle.durableSubscriptionName)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.noLocal, jMSTopicSubscriberHandle.noLocal);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.topicSessionHandle);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.topic);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.topicSubscriber);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.durableSubscriptionName);
        n = n * JMSCMUtils.HASH_CODE_PRIME + JMSCMUtils.objectHashCode(this.noLocal);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "topic = " + this.topic);
        stringBuffer.append(string + "physical topic subscriber = " + this.topicSubscriber);
        if (this.durableSubscriptionName != null) {
            stringBuffer.append(string + "durable subscription name = " + this.durableSubscriptionName);
        }
        if (this.noLocal != null) {
            stringBuffer.append(string + "no local = " + this.noLocal);
        }
        return stringBuffer.toString();
    }

    protected final MessageConsumer getMessageConsumer() {
        return this.topicSubscriber;
    }

    protected MessageConsumer getOpenMessageConsumer() throws java.lang.IllegalStateException, JMSException {
        return this.getOpenTopicSubscriber();
    }

    private TopicSubscriber getOpenTopicSubscriber() throws java.lang.IllegalStateException, JMSException {
        this.checkOpen();
        if (this.topicSubscriber == null) {
            TopicSession topicSession = this.topicSessionHandle.getOpenTopicSession();
            if (this.durableSubscriptionName == null) {
                throw new IllegalStateException("Non-durable subscriber invalidated on transaction boundary");
            }
            try {
                this.topicSubscriber = this.noLocal == null ? topicSession.createDurableSubscriber(this.topic, this.durableSubscriptionName) : topicSession.createDurableSubscriber(this.topic, this.durableSubscriptionName, this.messageSelector, this.noLocal.booleanValue());
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                this.markManagedObjectsAsStale(jMSException);
                throw jMSException;
            }
        }
        return this.topicSubscriber;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

