/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.jms.admin.AdminObject;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.JMSQueueManagerName;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;

public abstract class WSJMSManagedConnectionFactory
extends JMSManagedConnectionFactory {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$WSJMSManagedConnectionFactory == null ? (class$com$ibm$ejs$jms$WSJMSManagedConnectionFactory = WSJMSManagedConnectionFactory.class$("com.ibm.ejs.jms.WSJMSManagedConnectionFactory")) : class$com$ibm$ejs$jms$WSJMSManagedConnectionFactory), (String)"Messaging", (String)JMSCMUtils.MSG_BUNDLE);
    private Integer objectType;
    private Properties properties;
    private static final long serialVersionUID = 9221193036057649758L;
    static /* synthetic */ Class class$com$ibm$ejs$jms$WSJMSManagedConnectionFactory;

    public String[] introspectSelf() {
        String string = System.getProperty("line.separator") + "\t";
        String[] stringArray = super.introspectSelf();
        String[] stringArray2 = new String[stringArray.length + 2];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string + "objectType = " + this.objectType;
        stringArray2[stringArray.length + 1] = string + "properties = " + this.properties;
        return stringArray2;
    }

    public void setDataSourceProperties(Properties properties) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DataSourceProperties set", (Object)properties);
        }
        this.properties = properties;
    }

    public Properties getDataSourceProperties() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DataSourceProperties get", (Object)this.properties);
        }
        return this.properties;
    }

    public void setObjectType(Integer n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ObjectType set", (Object)n);
        }
        this.objectType = n;
    }

    public final Integer getObjectType() {
        return this.objectType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WSJMSManagedConnectionFactory wSJMSManagedConnectionFactory = (WSJMSManagedConnectionFactory)object;
        if (!JMSCMUtils.objectsEqual(this.objectType, wSJMSManagedConnectionFactory.objectType)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.properties, wSJMSManagedConnectionFactory.properties);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.objectType);
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.properties);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "object type = " + this.objectType);
        stringBuffer.append(string + "properties = " + this.properties);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ConnectionFactory getConnectionFactory() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnectionFactory");
        }
        try {
            block9: {
                try {
                    if (this.connectionFactory != null) break block9;
                    if (this.objectType == null || this.properties == null) {
                        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Object type and data source properties must be set");
                        if (!tc.isEventEnabled()) throw resourceAdapterInternalException;
                        Tr.event((TraceComponent)tc, (String)"Object type and data source properties must be set", (Object)resourceAdapterInternalException);
                        throw resourceAdapterInternalException;
                    }
                    AdminObject adminObject = new AdminObject(this.objectType.intValue(), (Hashtable)this.properties, true);
                    if (adminObject.errorRaised()) {
                        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Error raised constructing AdminObject", (adminObject.getErrorString1() == null ? "" : adminObject.getErrorString1()) + " " + (adminObject.getErrorString2() == null ? "" : adminObject.getErrorString2()));
                        if (!tc.isEventEnabled()) throw resourceAdapterInternalException;
                        Tr.event((TraceComponent)tc, (String)"Error raised constructing AdminObject", (Object)new Object[]{new Integer(adminObject.getErrorType()), adminObject.getErrorString1(), adminObject.getErrorString2()});
                        throw resourceAdapterInternalException;
                    }
                    Object object = adminObject.getObject();
                    if (!(object instanceof ConnectionFactory)) {
                        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("AdminObject did not return ConnectionFactory");
                        if (!tc.isEventEnabled()) throw resourceAdapterInternalException;
                        Tr.event((TraceComponent)tc, (String)"AdminObject did not return ConnectionFactory", (Object)resourceAdapterInternalException);
                        throw resourceAdapterInternalException;
                    }
                    this.connectionFactory = (ConnectionFactory)object;
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.getConnectionFactory", "227", this);
                    throw resourceException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.getConnectionFactory", "232", this);
                    if (!tc.isEventEnabled()) throw JMSCMUtils.mapToResourceException(exception, tc, "Unexpected exception when creating ConnectionFactory");
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception when creating ConnectionFactory", (Object)exception);
                    throw JMSCMUtils.mapToResourceException(exception, tc, "Unexpected exception when creating ConnectionFactory");
                }
            }
            Object var5_8 = null;
            if (!tc.isEntryEnabled()) return this.connectionFactory;
            Tr.exit((TraceComponent)tc, (String)"getConnectionFactory", (Object)this.connectionFactory);
            return this.connectionFactory;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getConnectionFactory", (Object)this.connectionFactory);
            throw throwable;
        }
    }

    protected void setupForRecovery() {
        Integer n;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupForRecovery");
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string2 = adminService.getProcessName();
        String string3 = adminService.getNodeName();
        String string4 = adminService.getCellName();
        String string5 = adminService.getProcessType();
        if (string5.equals("UnManagedProcess") && (string = JMSQueueManagerName.getQueueManagerName((String)string4, (String)string3, (String)string2)).equals(this.properties.get("QMGR")) && (n = (Integer)this.properties.get("TRAN")) == 1) {
            Tr.debug((TraceComponent)tc, (String)"Changing to use server bindings for transactional recovery");
            this.serverRecoveryNoCredentials = true;
            n = new Integer(0);
            this.properties.put("TRAN", n);
            this.properties.remove("HOST");
            this.properties.remove("PORT");
            this.properties.remove("CHAN");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupForRecovery");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

