/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.AsyncMessageLog;
import com.ibm.ejs.jms.listener.AsyncMessageRequest;
import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.ServerSession;
import com.ibm.ejs.jms.listener.ServerSessionPool;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.JMSException;

public class AsyncMessageConsumer
implements Runnable {
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$listener$AsyncMessageConsumer == null ? (class$com$ibm$ejs$jms$listener$AsyncMessageConsumer = AsyncMessageConsumer.class$("com.ibm.ejs.jms.listener.AsyncMessageConsumer")) : class$com$ibm$ejs$jms$listener$AsyncMessageConsumer), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    private boolean started = false;
    private final Object lock = new Object();
    private AsyncMessageLog asyncMessageLog = null;
    private MDBConfigData mdbConfig = null;
    private ServerSessionPool serverSessionPool = null;
    static /* synthetic */ Class class$com$ibm$ejs$jms$listener$AsyncMessageConsumer;

    public AsyncMessageConsumer(AsyncMessageLog asyncMessageLog, MDBConfigData mDBConfigData, ServerSessionPool serverSessionPool) {
        Tr.entry((TraceComponent)tc, (String)"AsyncMessageConsumer");
        this.asyncMessageLog = asyncMessageLog;
        this.mdbConfig = mDBConfigData;
        this.serverSessionPool = serverSessionPool;
        Tr.exit((TraceComponent)tc, (String)"AsyncMessageConsumer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Tr.entry((TraceComponent)tc, (String)"start");
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            this.started = true;
            thread.start();
        }
        Tr.exit((TraceComponent)tc, (String)"start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Tr.entry((TraceComponent)tc, (String)"stop");
        Object object = this.lock;
        synchronized (object) {
            this.started = false;
            this.lock.notify();
        }
        Tr.exit((TraceComponent)tc, (String)"stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Tr.entry((TraceComponent)tc, (String)"run");
        boolean bl = false;
        while (!bl) {
            Object object;
            Iterator iterator = this.asyncMessageLog.getIterator(this.mdbConfig.msgListenerPort.getName());
            while (iterator != null && iterator.hasNext()) {
                Object object2;
                Object object3;
                object = null;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                int n = 0;
                while (iterator.hasNext() && n < this.mdbConfig.msgListenerPort.getMaxMessages()) {
                    object3 = (AsyncMessageRequest)iterator.next();
                    if (!((AsyncMessageRequest)object3).isCommitted()) continue;
                    Tr.event((TraceComponent)tc, (String)"Processing async message request", (Object)object3);
                    object2 = ((AsyncMessageRequest)object3).getRequestID();
                    Iterator iterator2 = ((AsyncMessageRequest)object3).getCorrelIDs().iterator();
                    while (iterator2.hasNext()) {
                        String string = (String)iterator2.next();
                        object = object == null ? "JMSCorrelationID = '" + string + "'" : (String)object + " OR JMSCorrelationID = '" + string + "'";
                        hashtable.put(string, object2);
                    }
                    ++n;
                }
                if (object == null) continue;
                object3 = this.mdbConfig.inputPort.JMSMessageSelector != null && this.mdbConfig.inputPort.JMSMessageSelector.trim().length() > 0 ? this.mdbConfig.inputPort.JMSMessageSelector + " AND (" + (String)object + ")" : object;
                object2 = null;
                try {
                    object2 = (ServerSession)this.serverSessionPool.getServerSession();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.AsyncMessageConsumer.run", "125", this);
                    Tr.event((TraceComponent)tc, (String)"Exception calling getServerSession", (Object)((Object)jMSException));
                    object2 = null;
                }
                if (object2 != null) {
                    try {
                        Tr.event((TraceComponent)tc, (String)"Starting async message consumer request with selector:", (Object)object3);
                        ((ServerSession)object2).startReceiveMsgNoWait((String)object3, hashtable);
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.AsyncMessageConsumer.run", "140", this);
                        Tr.event((TraceComponent)tc, (String)"Exception starting async message consumer ServerSession", (Object)((Object)jMSException));
                    }
                    continue;
                }
                Tr.event((TraceComponent)tc, (String)"No ServerSessions available");
            }
            this.checkForExpiredRequests(this.mdbConfig.msgListenerPort.getAsyncMessageConsumerRequestTimeout());
            try {
                object = this.lock;
                synchronized (object) {
                    if (this.started) {
                        if (tc.isEntryEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"sleeping for duration in milli-seconds: ", (Object)new Integer(this.mdbConfig.msgListenerPort.getAsyncMessageConsumerRequestInterval()));
                        }
                        this.lock.wait(this.mdbConfig.msgListenerPort.getAsyncMessageConsumerRequestInterval());
                    }
                    if (!this.started) {
                        bl = true;
                        Tr.event((TraceComponent)tc, (String)"Terminating AsyncMessageConsumer thread");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.jms.listener.AsyncMessageConsumer.run", "161", this);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"run");
    }

    private void checkForExpiredRequests(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkForExpiredRequests", (Object)new Integer(n));
        }
        if (n > -1) {
            try {
                long l = System.currentTimeMillis();
                Iterator iterator = this.asyncMessageLog.getIterator(this.mdbConfig.msgListenerPort.getName());
                while (iterator != null && iterator.hasNext()) {
                    AsyncMessageRequest asyncMessageRequest = (AsyncMessageRequest)iterator.next();
                    if (!asyncMessageRequest.isCommitted() || l - asyncMessageRequest.getRegisterTime() <= (long)(n * 1000)) continue;
                    Tr.event((TraceComponent)tc, (String)"Async Message Request has expired", (Object)asyncMessageRequest);
                    this.asyncMessageLog.removeRequest(asyncMessageRequest.getRequestID());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.AsyncMessageConsumer.checkForExpiredRequests", "192", this);
                Tr.event((TraceComponent)tc, (String)"Exception checking for expired requests", (Object)exception);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"checkForExpiredRequests");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

