/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.AsyncMessageRepository;
import com.ibm.ejs.jms.listener.AsyncMessageRequest;
import com.ibm.ejs.jms.listener.RequestLog;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;

public class AsyncMessageLog
implements AsyncMessageRepository {
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$listener$AsyncMessageLog == null ? (class$com$ibm$ejs$jms$listener$AsyncMessageLog = AsyncMessageLog.class$("com.ibm.ejs.jms.listener.AsyncMessageLog")) : class$com$ibm$ejs$jms$listener$AsyncMessageLog), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    private String requestLogFile = null;
    private RequestLog requestLog = null;
    static /* synthetic */ Class class$com$ibm$ejs$jms$listener$AsyncMessageLog;

    public AsyncMessageLog(String string) {
        Tr.entry((TraceComponent)tc, (String)"AsyncMessageLog");
        this.requestLogFile = string == null || string.length() == 0 ? ServerName.getDisplayName() + "-AsyncMessageRequestLog.ser" : string + File.separator + ServerName.getDisplayName() + "-AsyncMessageRequestLog.ser";
        this.readRequestLogFile();
        this.requestLog.commitAllRequests();
        Tr.exit((TraceComponent)tc, (String)"AsyncMessageLog");
    }

    public String preRegisterRequest(List list, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preRegisterRequest", (Object)new Object[]{list, string});
        }
        AsyncMessageRequest asyncMessageRequest = new AsyncMessageRequest(list, string);
        asyncMessageRequest.setStatePrepared();
        String string2 = this.requestLog.addRequest(asyncMessageRequest);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                AsyncMessageLog.this.flushLog();
                return null;
            }
        });
        Tr.exit((TraceComponent)tc, (String)"preRegisterRequest", (Object)string2);
        return string2;
    }

    public void cancelRequest(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelRequest", (Object)string);
        }
        this.requestLog.removeRequest(string);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                AsyncMessageLog.this.flushLog();
                return null;
            }
        });
        Tr.exit((TraceComponent)tc, (String)"cancelRequest");
    }

    public void registerRequest(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerRequest", (Object)string);
        }
        this.requestLog.commitRequest(string);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                AsyncMessageLog.this.flushLog();
                return null;
            }
        });
        Tr.exit((TraceComponent)tc, (String)"registerRequest");
    }

    public void registerRequest(List list, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerRequest", (Object)new Object[]{list, string});
        }
        AsyncMessageRequest asyncMessageRequest = new AsyncMessageRequest(list, string);
        this.requestLog.addRequest(asyncMessageRequest);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                AsyncMessageLog.this.flushLog();
                return null;
            }
        });
        Tr.exit((TraceComponent)tc, (String)"registerRequest");
    }

    public Iterator getIterator(String string) {
        Tr.entry((TraceComponent)tc, (String)"getIterator", (Object)string);
        Iterator iterator = null;
        List list = this.requestLog.getListenerPortListClone(string);
        if (list != null) {
            iterator = list.iterator();
        }
        Tr.exit((TraceComponent)tc, (String)"getIterator", iterator);
        return iterator;
    }

    public void removeRequest(String string) {
        Tr.entry((TraceComponent)tc, (String)"removeRequest", (Object)string);
        this.requestLog.removeRequest(string);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                AsyncMessageLog.this.flushLog();
                return null;
            }
        });
        Tr.exit((TraceComponent)tc, (String)"removeRequest");
    }

    public void flushLog() {
        Tr.entry((TraceComponent)tc, (String)"flushLog");
        try {
            this.writeRequestLogFile();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.AsyncMessageLog.flushLog", "101", this);
            Tr.warning((TraceComponent)tc, (String)"WriteRequestLogException", (Object)new Object[]{this.requestLogFile, exception});
        }
        Tr.exit((TraceComponent)tc, (String)"flushLog");
    }

    private void readRequestLogFile() {
        Tr.entry((TraceComponent)tc, (String)"readRequestLogFile");
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.requestLogFile);
            objectInputStream = new ObjectInputStream(fileInputStream);
            this.requestLog = (RequestLog)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.ejs.jms.listener.AsyncMessageLog.readRequestLogFile", "128", this);
            Tr.event((TraceComponent)tc, (String)"Request log file does not exist, creating a new file", (Object)this.requestLogFile);
            this.requestLog = new RequestLog();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.AsyncMessageLog.readRequestLogFile", "134", this);
            Tr.warning((TraceComponent)tc, (String)"ReadRequestLogException", (Object)new Object[]{this.requestLogFile, exception});
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, "com.ibm.ejs.jms.listener.AsyncMessageLog.readRequestLogFile", "137", this);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception3) {
                    FFDCFilter.processException((Throwable)exception3, "com.ibm.ejs.jms.listener.AsyncMessageLog.readRequestLogFile", "140", this);
                }
            }
            this.requestLog = new RequestLog();
        }
        Tr.exit((TraceComponent)tc, (String)"readRequestLogFile");
    }

    private void writeRequestLogFile() throws Exception {
        Tr.entry((TraceComponent)tc, (String)"writeRequestLogFile");
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.requestLogFile);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.requestLog);
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.AsyncMessageLog.writeRequestLogFile", "167", this);
            Tr.event((TraceComponent)tc, (String)"Exception writing request log file", (Object)new Object[]{this.requestLogFile, exception});
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, "com.ibm.ejs.jms.listener.AsyncMessageLog.writeRequestLogFile", "170", this);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception3) {
                    FFDCFilter.processException((Throwable)exception3, "com.ibm.ejs.jms.listener.AsyncMessageLog.writeRequestLogFile", "173", this);
                }
            }
            Tr.exit((TraceComponent)tc, (String)"writeRequestLogFile");
            throw exception;
        }
        Tr.exit((TraceComponent)tc, (String)"writeRequestLogFile");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

