/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ejs.jms.DurableSubscriptionManager;
import com.ibm.ejs.jms.JMSDiagnosticModule;
import com.ibm.ejs.jms.listener.AsyncMessageLog;
import com.ibm.ejs.jms.listener.AsyncMessageRepository;
import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.MDBException;
import com.ibm.ejs.jms.listener.MDBListener;
import com.ibm.ejs.jms.listener.MDBListenerImpl;
import com.ibm.ejs.jms.listener.MDBListenerManager;
import com.ibm.ejs.jms.listener.MDBPool;
import com.ibm.ejs.jms.listener.MDBRuntimeException;
import com.ibm.ejs.jms.listener.MsgListenerPort;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.ejb.MessageDriven;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.MessageListenerService;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.pmi.PmiBeanFactory;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.workloadcontroller.IWorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.util.ThreadPool;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class MDBListenerManagerImpl
implements MDBListenerManager,
DeployedObjectListener,
IWorkloadRegulator {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$listener$MDBListenerManagerImpl == null ? (class$com$ibm$ejs$jms$listener$MDBListenerManagerImpl = MDBListenerManagerImpl.class$("com.ibm.ejs.jms.listener.MDBListenerManagerImpl")) : class$com$ibm$ejs$jms$listener$MDBListenerManagerImpl), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    private int workloadState = 0;
    public static final int WLC_STARTING = 0;
    public static final int WLC_STARTED = 1;
    public static final int WLC_QUIESCING = 2;
    public static final int WLC_QUIESCECOMPLETE = 3;
    MessageListenerService messageListenerServiceCopy = null;
    Object extendedMessaging = null;
    DurableSubscriptionManager durableSubscriptionMgr = null;
    private Hashtable msgListenerPorts = null;
    private Hashtable mdbListenerHT = null;
    private ThreadPool sessionThreadPool = null;
    private PmiBeanFactory pmiFactory = null;
    private String containerName = "";
    private Object MQcm = null;
    private long mqJMSPoolingTimeout;
    private int mqJMSPoolingThreshold;
    private int maxRecoveryRetries;
    private int recoveryRetryInterval;
    private int nonASFReceiveTimeout;
    private AsyncMessageLog asyncMessageLog = null;
    static /* synthetic */ Class class$com$ibm$ejs$jms$listener$MDBListenerManagerImpl;
    static /* synthetic */ Class class$javax$jms$Message;

    public MDBListenerManagerImpl() {
        Tr.entry((TraceComponent)tc, (String)"MDBListenerManagerImpl");
        Tr.exit((TraceComponent)tc, (String)"MDBListenerManagerImpl");
    }

    public void initialize(Object object, Object object2, Object object3, Object object4, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)new Object[]{object, object2, object3, object4, string});
        }
        MessageListenerService messageListenerService = (MessageListenerService)object;
        this.messageListenerServiceCopy = (MessageListenerService)EtoolsCopyUtility.createCopy((EObject)messageListenerService);
        this.extendedMessaging = object2;
        this.sessionThreadPool = (ThreadPool)object3;
        this.durableSubscriptionMgr = (DurableSubscriptionManager)object4;
        JMSDiagnosticModule.register();
        this.initializeProperties((List)messageListenerService.getProperties());
        this.asyncMessageLog = new AsyncMessageLog(string);
        this.msgListenerPorts = new Hashtable();
        EList eList = messageListenerService.getListenerPorts();
        for (int i = 0; i < eList.size(); ++i) {
            String string2;
            ListenerPort listenerPort = (ListenerPort)eList.get(i);
            if (listenerPort == null || listenerPort.getName() == null) continue;
            MsgListenerPort msgListenerPort = new MsgListenerPort(this, this.extendedMessaging, listenerPort);
            this.msgListenerPorts.put(listenerPort.getName(), msgListenerPort);
            String string3 = string2 = listenerPort.getName();
            try {
                string3 = AdminServiceFactory.getMBeanFactory().getConfigId(listenerPort);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initialize", "156", this);
                Tr.warning((TraceComponent)tc, (String)"ListenerPortMBeanActivateException", (Object)new Object[]{string3, exception});
                Tr.event((TraceComponent)tc, (String)("Exception getting MBeanID, using: " + string3), (Object)exception);
            }
            msgListenerPort.setMBeanID(string3);
            try {
                AdminServiceFactory.getMBeanFactory().activateMBean("ListenerPort", new DefaultRuntimeCollaborator(msgListenerPort, string2), string3, null);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initialize", "169", this);
                Tr.warning((TraceComponent)tc, (String)"ListenerPortMBeanActivateException", (Object)new Object[]{string3, exception});
                Tr.event((TraceComponent)tc, (String)("Exception activating ListenerPort MBean " + string3), (Object)exception);
            }
        }
        this.mdbListenerHT = new Hashtable();
        Tr.exit((TraceComponent)tc, (String)"initialize");
    }

    public void startManager() {
        Tr.entry((TraceComponent)tc, (String)"startManager");
        this.initializeMQJMSConnectionPooling();
        WorkloadController.registerRegulator((IWorkloadRegulator)this);
        Tr.exit((TraceComponent)tc, (String)"startManager");
    }

    public MDBListener create(MDBPool mDBPool, Object object) throws MDBException {
        String string;
        MessageDrivenBeanBinding messageDrivenBeanBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create", (Object)new Object[]{mDBPool, object});
        }
        EJBConfigData eJBConfigData = (EJBConfigData)object;
        MDBConfigData mDBConfigData = new MDBConfigData();
        MessageDriven messageDriven = (MessageDriven)eJBConfigData.getDeploymentData();
        mDBConfigData.mdbName = messageDriven.getName();
        mDBConfigData.applicationName = eJBConfigData.getJ2EEName().getApplication();
        mDBConfigData.j2eeName = eJBConfigData.getJ2EEName().toString();
        mDBConfigData.containerName = this.containerName;
        mDBConfigData.pmiFactory = this.pmiFactory;
        mDBConfigData.ejbConfigData = eJBConfigData;
        if (messageDriven.getTransactionType().getValue() == 0) {
            mDBConfigData.transactionType = 0;
        } else {
            mDBConfigData.transactionType = 1;
            mDBConfigData.onMessageTransactionAttr = this.getOnMessageTransactionAttr(eJBConfigData);
        }
        EnterpriseBeanBinding enterpriseBeanBinding = eJBConfigData.getDeploymentBinding();
        if (enterpriseBeanBinding instanceof MessageDrivenBeanBinding) {
            mDBConfigData.msgListenerPort = null;
            messageDrivenBeanBinding = (MessageDrivenBeanBinding)eJBConfigData.getDeploymentBinding();
            string = messageDrivenBeanBinding.getListenerInputPortName();
            if (string != null) {
                mDBConfigData.msgListenerPort = (MsgListenerPort)this.msgListenerPorts.get(string);
            }
            if (mDBConfigData.msgListenerPort == null) {
                Tr.warning((TraceComponent)tc, (String)"MDBListenerPortNotFound", (Object)new Object[]{mDBConfigData.mdbName, string});
                MDBException mDBException = new MDBException("Creation of MDB " + mDBConfigData.mdbName + " unable to find ListenerPort '" + string + "'");
                Tr.exit((TraceComponent)tc, (String)"create");
                throw mDBException;
            }
        } else {
            Tr.warning((TraceComponent)tc, (String)"NoMDBBinding", (Object)new Object[]{mDBConfigData.mdbName});
            MDBException mDBException = new MDBException("MDB " + mDBConfigData.mdbName + " has no MessageDrivenBeanBinding in ibm-ejb-jar-bnd.xmi");
            Tr.exit((TraceComponent)tc, (String)"create");
            throw mDBException;
        }
        messageDrivenBeanBinding = messageDriven.getDestination();
        mDBConfigData.inputPort.JMSDestinationType = messageDrivenBeanBinding != null && messageDrivenBeanBinding.getType().getValue() == 1 ? 1 : 0;
        if (messageDrivenBeanBinding != null) {
            string = messageDrivenBeanBinding.getSubscriptionDurability();
            if (string != null && string.getValue() == 1) {
                mDBConfigData.inputPort.JMSSubscriptionDurability = 1;
                mDBConfigData.inputPort.JMSSubscriptionName = new String(eJBConfigData.getJ2EEName().toString());
            } else {
                mDBConfigData.inputPort.JMSSubscriptionDurability = 0;
            }
        } else {
            mDBConfigData.inputPort.JMSSubscriptionDurability = 0;
        }
        mDBConfigData.inputPort.JMSMessageSelector = messageDriven.getMessageSelector();
        string = messageDriven.getAcknowledgeMode();
        mDBConfigData.inputPort.JMSAcknowledgement = string != null && string.getValue() == 1 ? 1 : 0;
        MDBListener mDBListener = this.createMDBListener(mDBPool, mDBConfigData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"create", (Object)mDBListener);
        }
        return mDBListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MDBListener createMDBListener(MDBPool mDBPool, MDBConfigData mDBConfigData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMDBListener", (Object)new Object[]{mDBPool, mDBConfigData});
        }
        MDBListenerImpl mDBListenerImpl = null;
        try {
            mDBListenerImpl = new MDBListenerImpl(this, this.durableSubscriptionMgr, mDBPool, this.sessionThreadPool, mDBConfigData, this.asyncMessageLog);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.createMDBListener", "328", this);
            Tr.warning((TraceComponent)tc, (String)"MDBListenerCreateError", (Object)new Object[]{mDBConfigData.mdbName, mDBConfigData.msgListenerPort.getJmsDestJNDIName(), exception});
            Tr.exit((TraceComponent)tc, (String)"createMDBListener");
            throw new MDBRuntimeException(MDBListenerManagerImpl.getNestedException(exception).getMessage(), exception);
        }
        Hashtable hashtable = this.mdbListenerHT;
        synchronized (hashtable) {
            if (this.mdbListenerHT.contains(mDBListenerImpl)) {
                MDBRuntimeException mDBRuntimeException = new MDBRuntimeException("MDBListener already defined", null);
                Tr.warning((TraceComponent)tc, (String)"MDBListenerDuplicate", (Object)new Object[]{mDBConfigData.mdbName, mDBConfigData.msgListenerPort.getJmsDestJNDIName()});
                Tr.exit((TraceComponent)tc, (String)"createMDBListener");
                throw mDBRuntimeException;
            }
            this.mdbListenerHT.put(mDBListenerImpl, mDBListenerImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createMDBListener", (Object)mDBListenerImpl);
        }
        return mDBListenerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MDBListener mDBListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)mDBListener);
        }
        MsgListenerPort msgListenerPort = (MsgListenerPort)this.msgListenerPorts.get(((MDBListenerImpl)mDBListener).getListenerPortName());
        msgListenerPort.remove(mDBListener);
        Hashtable hashtable = this.mdbListenerHT;
        synchronized (hashtable) {
            this.mdbListenerHT.remove(mDBListener);
        }
        try {
            ((MDBListenerImpl)mDBListener).close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.remove", "392", this);
            Tr.warning((TraceComponent)tc, (String)"MDBListenerCloseException", (Object)new Object[]{((MDBListenerImpl)mDBListener).getMDBConfig().mdbName, ((MDBListenerImpl)mDBListener).getMDBConfig().msgListenerPort.getJmsDestJNDIName(), exception});
        }
        Tr.exit((TraceComponent)tc, (String)"remove");
    }

    public void start(MDBListener mDBListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object)mDBListener);
        }
        ((MDBListenerImpl)mDBListener).start();
        Tr.exit((TraceComponent)tc, (String)"start");
    }

    public void stop(MDBListener mDBListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop", (Object)mDBListener);
        }
        ((MDBListenerImpl)mDBListener).stop();
        Tr.exit((TraceComponent)tc, (String)"stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object;
        Tr.entry((TraceComponent)tc, (String)"terminate");
        Object object2 = this.mdbListenerHT;
        synchronized (object2) {
            object = this.mdbListenerHT.elements();
            while (object.hasMoreElements()) {
                MDBListenerImpl mDBListenerImpl = null;
                try {
                    mDBListenerImpl = (MDBListenerImpl)object.nextElement();
                    this.remove(mDBListenerImpl);
                }
                catch (NoSuchElementException noSuchElementException) {
                    FFDCFilter.processException((Throwable)noSuchElementException, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminate", "453", this);
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminate", "458", this);
                    Tr.warning((TraceComponent)tc, (String)"MDBListenerTerminateException", (Object)new Object[]{mDBListenerImpl.getMDBConfig().mdbName, mDBListenerImpl.getMDBConfig().msgListenerPort.getJmsDestJNDIName(), MDBListenerManagerImpl.getNestedException(exception).getMessage()});
                    Tr.debug((TraceComponent)tc, (String)"Exception:", (Object)object);
                }
            }
        }
        this.mdbListenerHT = null;
        object2 = this.msgListenerPorts.elements();
        while (object2.hasMoreElements()) {
            object = null;
            try {
                object = ((MsgListenerPort)object2.nextElement()).getMBeanID();
                AdminServiceFactory.getMBeanFactory().deactivateMBean((String)object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminate", "480", this);
                Tr.event((TraceComponent)tc, (String)("Exception deactivating ListenerPortMbean " + (String)object), (Object)exception);
            }
        }
        this.msgListenerPorts = null;
        this.terminateMQJMSConnectionPooling();
        this.durableSubscriptionMgr = null;
        this.sessionThreadPool = null;
        this.messageListenerServiceCopy = null;
        Tr.exit((TraceComponent)tc, (String)"terminate");
    }

    public static Throwable getNestedException(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (true) {
            Exception exception;
            if (throwable2 instanceof RemoteException) {
                exception = (RemoteException)throwable2;
                if (((RemoteException)exception).detail == null) break;
                throwable2 = ((RemoteException)exception).detail;
                continue;
            }
            if (!(throwable2 instanceof NamingException) || ((NamingException)(exception = (NamingException)throwable2)).getRootCause() == null) break;
            throwable2 = ((NamingException)exception).getRootCause();
        }
        return throwable2;
    }

    private int getOnMessageTransactionAttr(EJBConfigData eJBConfigData) throws MDBException {
        int n;
        EJBMethodInfo[] eJBMethodInfoArray;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOnMessageTransactionAttr", (Object)eJBConfigData);
        }
        TransactionAttribute transactionAttribute = null;
        String string = null;
        try {
            object = Class.forName("javax.jms.MessageListener");
            eJBMethodInfoArray = ((Class)object).getMethod("onMessage", class$javax$jms$Message == null ? (class$javax$jms$Message = MDBListenerManagerImpl.class$("javax.jms.Message")) : class$javax$jms$Message);
            string = MethodAttribUtils.methodSignature((Method)eJBMethodInfoArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.getOnMessageTransactionAttr", "548", this);
            Tr.exit((TraceComponent)tc, (String)"getOnMessageTransactionAttr");
            throw new MDBException("Unable to determine onMessage method signature");
        }
        object = eJBConfigData.getEJBComponentMetaData();
        eJBMethodInfoArray = object.getEJBMethodMetaData(MethodInterface.MESSAGE_LISTENER);
        for (n = 0; n < eJBMethodInfoArray.length; ++n) {
            if (!eJBMethodInfoArray[n].getMethodSignature().equals(string)) continue;
            transactionAttribute = eJBMethodInfoArray[n].getTransactionAttribute();
            break;
        }
        if (transactionAttribute == null) {
            n = 0;
        } else if (transactionAttribute.getValue() == TransactionAttribute.TX_NOT_SUPPORTED.getValue()) {
            n = 1;
        } else if (transactionAttribute.getValue() == TransactionAttribute.TX_REQUIRED.getValue()) {
            n = 0;
        } else {
            MDBException mDBException = new MDBException("Invalid MDB onMessage() transaction attribute");
            FFDCFilter.processException((Throwable)mDBException, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.getOnMessageTransactionAttr", "574", this);
            Tr.exit((TraceComponent)tc, (String)"getOnMessageTransactionAttr");
            throw mDBException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOnMessageTransactionAttr", (Object)new Integer(n));
        }
        return n;
    }

    public void setPmiData(Object object, String string) {
        this.pmiFactory = (PmiBeanFactory)object;
        this.containerName = string;
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stateChanged", (Object)deployedObjectEvent);
        }
        if (deployedObjectEvent.getNewValue() == "STARTED") {
            DeployedObject deployedObject2 = (DeployedObject)deployedObjectEvent.getSource();
            if (deployedObject2.getModuleFile().isEARFile()) {
                this.startApplicationMDBs(deployedObject2.getName());
            }
        } else if (deployedObjectEvent.getNewValue() == "STOPPING" && (deployedObject = (DeployedObject)deployedObjectEvent.getSource()).getModuleFile().isEARFile()) {
            this.stopApplicationMDBs(deployedObject.getName());
        }
        Tr.exit((TraceComponent)tc, (String)"stateChanged");
    }

    private void startApplicationMDBs(String string) {
        Tr.entry((TraceComponent)tc, (String)"startApplicationMDBs", (Object)string);
        Enumeration enumeration = this.mdbListenerHT.elements();
        while (enumeration.hasMoreElements()) {
            MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)enumeration.nextElement();
            MDBConfigData mDBConfigData = mDBListenerImpl.getMDBConfig();
            if (!mDBConfigData.applicationName.equals(string)) continue;
            mDBConfigData.msgListenerPort.add(mDBListenerImpl);
        }
        Tr.exit((TraceComponent)tc, (String)"startApplicationMDBs");
    }

    private void stopApplicationMDBs(String string) {
        Tr.entry((TraceComponent)tc, (String)"stopApplicationMDBs", (Object)string);
        Enumeration enumeration = this.mdbListenerHT.elements();
        while (enumeration.hasMoreElements()) {
            MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)enumeration.nextElement();
            MDBConfigData mDBConfigData = mDBListenerImpl.getMDBConfig();
            if (!mDBConfigData.applicationName.equals(string)) continue;
            mDBConfigData.msgListenerPort.remove(mDBListenerImpl);
        }
        Tr.exit((TraceComponent)tc, (String)"stopApplicationMDBs");
    }

    private void initializeMQJMSConnectionPooling() {
        Tr.entry((TraceComponent)tc, (String)"initializeMQJMSConnectionPooling");
        try {
            Class<?> clazz = Class.forName("com.ibm.mq.MQSimpleConnectionManager");
            this.MQcm = clazz.newInstance();
            Method method = clazz.getMethod("setTimeout", Long.TYPE);
            Object[] objectArray = new Object[]{new Long(this.mqJMSPoolingTimeout)};
            method.invoke(this.MQcm, objectArray);
            Method method2 = clazz.getMethod("setHighThreshold", Integer.TYPE);
            Object[] objectArray2 = new Object[]{new Integer(this.mqJMSPoolingThreshold)};
            method2.invoke(this.MQcm, objectArray2);
            Field field = clazz.getField("MODE_ACTIVE");
            Method method3 = clazz.getMethod("setActive", Integer.TYPE);
            Object[] objectArray3 = new Object[]{field.get(this.MQcm)};
            method3.invoke(this.MQcm, objectArray3);
            Class<?> clazz2 = Class.forName("com.ibm.mq.MQEnvironment");
            Method method4 = clazz2.getMethod("setDefaultConnectionManager", Class.forName("com.ibm.mq.MQConnectionManager"));
            Object[] objectArray4 = new Object[]{this.MQcm};
            method4.invoke(null, objectArray4);
            Tr.event((TraceComponent)tc, (String)"MQSeries JMS Connection pooling configured successfully");
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeMQJMSConnectionPooling", "705", this);
            Tr.event((TraceComponent)tc, (String)"Failed to find class for MQSeries JMS connection pooling");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeMQJMSConnectionPooling", "710", this);
            Tr.event((TraceComponent)tc, (String)"Exception initializing MQSeries JMS connection pooling", (Object)throwable);
        }
        Tr.exit((TraceComponent)tc, (String)"initializeMQJMSConnectionPooling");
    }

    private void terminateMQJMSConnectionPooling() {
        Tr.entry((TraceComponent)tc, (String)"terminateMQJMSConnectionPooling");
        try {
            if (this.MQcm != null) {
                Class<?> clazz = Class.forName("com.ibm.mq.MQSimpleConnectionManager");
                Field field = clazz.getField("MODE_INACTIVE");
                Method method = clazz.getMethod("setActive", Integer.TYPE);
                Object[] objectArray = new Object[]{field.get(this.MQcm)};
                method.invoke(this.MQcm, objectArray);
            }
            this.MQcm = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminateMQJMSConnectionPooling", "740", this);
            Tr.event((TraceComponent)tc, (String)"Failed to find class for MQSeries JMS connection pooling");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminateMQJMSConnectionPooling", "745", this);
            Tr.event((TraceComponent)tc, (String)"Exception terminating MQSeries JMS connection pooling", (Object)throwable);
        }
        Tr.exit((TraceComponent)tc, (String)"terminateMQJMSConnectionPooling");
    }

    public AsyncMessageRepository getAsyncMessageLog() {
        return this.asyncMessageLog;
    }

    private void initializeProperties(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeProperties", (Object)list);
        }
        this.mqJMSPoolingTimeout = 300000L;
        this.mqJMSPoolingThreshold = 10;
        this.maxRecoveryRetries = 5;
        this.recoveryRetryInterval = 60;
        this.nonASFReceiveTimeout = 0;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Property property = (Property)list.get(i);
                if (property.getName().equalsIgnoreCase("MQJMS.POOLING.TIMEOUT")) {
                    try {
                        this.mqJMSPoolingTimeout = Long.parseLong(property.getValue());
                        Tr.event((TraceComponent)tc, (String)("Set MQSeries JMS Connection pooling timeout property to " + this.mqJMSPoolingTimeout));
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "793", this);
                        Tr.event((TraceComponent)tc, (String)"Exception parsing MQSeries JMS pooling timeout property, setting to default value", (Object)exception);
                        this.mqJMSPoolingTimeout = 300000L;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("MQJMS.POOLING.THRESHOLD")) {
                    try {
                        this.mqJMSPoolingThreshold = Integer.parseInt(property.getValue());
                        Tr.event((TraceComponent)tc, (String)("Set MQSeries JMS Connection pooling threshold property to " + this.mqJMSPoolingThreshold));
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "807", this);
                        Tr.event((TraceComponent)tc, (String)"Exception parsing MQSeries JMS pooling threshold property, setting to default value", (Object)exception);
                        this.mqJMSPoolingThreshold = 10;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("MAX.RECOVERY.RETRIES")) {
                    try {
                        this.maxRecoveryRetries = Integer.parseInt(property.getValue());
                        Tr.event((TraceComponent)tc, (String)("Set max recovery retries property to " + this.maxRecoveryRetries));
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "821", this);
                        Tr.event((TraceComponent)tc, (String)"Exception parsing max recovery retries property, setting to default value", (Object)exception);
                        this.maxRecoveryRetries = 5;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("RECOVERY.RETRY.INTERVAL")) {
                    try {
                        this.recoveryRetryInterval = Integer.parseInt(property.getValue());
                        Tr.event((TraceComponent)tc, (String)("Set recovery retry interval property to " + this.recoveryRetryInterval));
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "835", this);
                        Tr.event((TraceComponent)tc, (String)"Exception parsing recovery retry interval property, setting to default value", (Object)exception);
                        this.recoveryRetryInterval = 60;
                    }
                    continue;
                }
                if (!property.getName().equalsIgnoreCase("NON.ASF.RECEIVE.TIMEOUT")) continue;
                try {
                    this.nonASFReceiveTimeout = Integer.parseInt(property.getValue());
                    Tr.event((TraceComponent)tc, (String)("Set non-ASF receive timeout property to " + this.nonASFReceiveTimeout));
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "849", this);
                    Tr.event((TraceComponent)tc, (String)"Exception parsing non-ASF receieve timeout property, setting to default value", (Object)exception);
                    this.nonASFReceiveTimeout = 0;
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"initializeProperties");
    }

    public int getMaxRecoveryRetries() {
        return this.maxRecoveryRetries;
    }

    public int getRecoveryRetryInterval() {
        return this.recoveryRetryInterval;
    }

    public int getNonASFReceiveTimeout() {
        return this.nonASFReceiveTimeout;
    }

    public boolean starting() {
        Tr.entry((TraceComponent)tc, (String)"starting");
        this.workloadState = 0;
        Tr.exit((TraceComponent)tc, (String)"starting");
        return true;
    }

    public boolean started() {
        Tr.entry((TraceComponent)tc, (String)"started");
        this.workloadState = 1;
        Tr.exit((TraceComponent)tc, (String)"started");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quiesce() {
        Tr.entry((TraceComponent)tc, (String)"quiesce");
        this.workloadState = 2;
        int n = 0;
        Hashtable hashtable = this.mdbListenerHT;
        synchronized (hashtable) {
            Enumeration enumeration = this.mdbListenerHT.elements();
            while (enumeration.hasMoreElements()) {
                MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)enumeration.nextElement();
                mDBListenerImpl.quiesce();
                n += mDBListenerImpl.getActiveSessionCount();
            }
        }
        boolean bl = n == 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"quiesce", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quiesceComplete() {
        Tr.entry((TraceComponent)tc, (String)"quiesceComplete");
        this.workloadState = 3;
        Hashtable hashtable = this.mdbListenerHT;
        synchronized (hashtable) {
            Enumeration enumeration = this.mdbListenerHT.elements();
            while (enumeration.hasMoreElements()) {
                MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)enumeration.nextElement();
                mDBListenerImpl.quiesceComplete();
            }
        }
        Tr.exit((TraceComponent)tc, (String)"quiesceComplete");
        return true;
    }

    public String getTypeName() {
        return "MSGQ";
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return "MSGQ";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

