/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.AsyncMessageConsumerExtension;
import com.ibm.ejs.jms.listener.AsyncMessageConsumerExtensionAccessor;
import com.ibm.ejs.jms.listener.AsyncMessageConsumerExtensionAccessorFactory;
import com.ibm.ejs.jms.listener.MDBListener;
import com.ibm.ejs.jms.listener.MDBListenerImpl;
import com.ibm.ejs.jms.listener.MDBListenerManager;
import com.ibm.ejs.jms.listener.MDBRuntimeException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.websphere.models.config.process.ExecutionState;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Enumeration;
import java.util.Hashtable;

public class MsgListenerPort {
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$listener$MsgListenerPort == null ? (class$com$ibm$ejs$jms$listener$MsgListenerPort = MsgListenerPort.class$("com.ibm.ejs.jms.listener.MsgListenerPort")) : class$com$ibm$ejs$jms$listener$MsgListenerPort), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    private boolean started = false;
    private MDBListenerManager mdbMgr = null;
    private Object extendedMessaging = null;
    private String name;
    private String mBeanId = "";
    private int maxSessions;
    private int maxRetries;
    private int maxMessages;
    private String jmsConnJNDIName;
    private String jmsDestJNDIName;
    private boolean asyncMessageConsumerEnabled;
    private int asyncMessageConsumerRequestInterval;
    private int asyncMessageConsumerRequestTimeout;
    private int liveMaxSessions = 0;
    private int liveMaxRetries = 0;
    private int liveMaxMessages = 0;
    private String liveJmsConnJNDIName = "";
    private String liveJmsDestJNDIName = "";
    private boolean liveAsyncMessageConsumerEnabled = false;
    private int liveAsyncMessageConsumerRequestInterval = 0;
    private int liveAsyncMessageConsumerRequestTimeout = 0;
    private Hashtable mdbListeners = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ejs$jms$listener$MsgListenerPort;

    public MsgListenerPort(MDBListenerManager mDBListenerManager, Object object, ListenerPort listenerPort) {
        Tr.entry((TraceComponent)tc, (String)"MsgListenerPort");
        this.mdbMgr = mDBListenerManager;
        this.extendedMessaging = object;
        this.mBeanId = this.name = listenerPort.getName();
        this.maxSessions = listenerPort.getMaxSessions();
        this.maxRetries = listenerPort.getMaxRetries();
        this.maxMessages = listenerPort.getMaxMessages();
        this.jmsConnJNDIName = listenerPort.getConnectionFactoryJNDIName();
        this.jmsDestJNDIName = listenerPort.getDestinationJNDIName();
        this.loadAsyncMessageConsumerExtension(listenerPort);
        this.liveMaxSessions = this.maxSessions;
        this.liveMaxRetries = this.maxRetries;
        this.liveMaxMessages = this.maxMessages;
        this.liveJmsConnJNDIName = this.jmsConnJNDIName;
        this.liveJmsDestJNDIName = this.jmsDestJNDIName;
        this.liveAsyncMessageConsumerEnabled = this.asyncMessageConsumerEnabled;
        this.liveAsyncMessageConsumerRequestInterval = this.asyncMessageConsumerRequestInterval;
        this.liveAsyncMessageConsumerRequestTimeout = this.asyncMessageConsumerRequestTimeout;
        StateManageable stateManageable = listenerPort.getStateManagement();
        ExecutionState executionState = stateManageable.getInitialState();
        if (executionState.getValue() == 0) {
            this.start();
        }
        Tr.exit((TraceComponent)tc, (String)"MsgListenerPort");
    }

    public synchronized void add(MDBListener mDBListener) {
        Tr.entry((TraceComponent)tc, (String)"add");
        this.mdbListeners.put(mDBListener, mDBListener);
        if (this.started) {
            try {
                this.mdbMgr.start(mDBListener);
            }
            catch (MDBRuntimeException mDBRuntimeException) {
                FFDCFilter.processException((Throwable)mDBRuntimeException, "com.ibm.ejs.jms.listener.MsgListenerPort.add", "140", this);
                Tr.warning((TraceComponent)tc, (String)"MDBListenerStartFailed", (Object)new Object[]{((MDBListenerImpl)mDBListener).getMDBConfig().mdbName, this.name});
                Tr.debug((TraceComponent)tc, (String)"Exception starting MDB Listener", (Object)mDBRuntimeException);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.jms.listener.MsgListenerPort.add", "146", this);
                Tr.event((TraceComponent)tc, (String)"MDB Listener already started", (Object)illegalStateException);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"add");
    }

    public synchronized void remove(MDBListener mDBListener) {
        Tr.entry((TraceComponent)tc, (String)"remove");
        this.mdbListeners.remove(mDBListener);
        this.mdbMgr.stop(mDBListener);
        Tr.exit((TraceComponent)tc, (String)"remove");
    }

    public Boolean isStarted() {
        Tr.entry((TraceComponent)tc, (String)"isStarted");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isStarted", (Object)new Boolean(this.started));
        }
        return new Boolean(this.started);
    }

    public String getName() {
        Tr.entry((TraceComponent)tc, (String)"getName");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getName", (Object)this.name);
        }
        return this.name;
    }

    public synchronized void start() {
        Tr.entry((TraceComponent)tc, (String)"start");
        this.liveMaxSessions = this.maxSessions;
        this.liveMaxRetries = this.maxRetries;
        this.liveMaxMessages = this.maxMessages;
        this.liveJmsConnJNDIName = this.jmsConnJNDIName;
        this.liveJmsDestJNDIName = this.jmsDestJNDIName;
        this.liveAsyncMessageConsumerEnabled = this.asyncMessageConsumerEnabled;
        this.liveAsyncMessageConsumerRequestInterval = this.asyncMessageConsumerRequestInterval;
        this.liveAsyncMessageConsumerRequestTimeout = this.asyncMessageConsumerRequestTimeout;
        Enumeration enumeration = this.mdbListeners.keys();
        while (enumeration.hasMoreElements()) {
            MDBListener mDBListener = (MDBListener)this.mdbListeners.get(enumeration.nextElement());
            try {
                this.mdbMgr.start(mDBListener);
            }
            catch (MDBRuntimeException mDBRuntimeException) {
                FFDCFilter.processException((Throwable)mDBRuntimeException, "com.ibm.ejs.jms.listener.MsgListenerPort.start", "223", this);
                Tr.warning((TraceComponent)tc, (String)"MDBListenerStartFailed", (Object)new Object[]{((MDBListenerImpl)mDBListener).getMDBConfig().mdbName, this.name});
                Tr.debug((TraceComponent)tc, (String)"Exception starting MDB Listener", (Object)mDBRuntimeException);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.jms.listener.MsgListenerPort.start", "229", this);
                Tr.event((TraceComponent)tc, (String)"MDB Listener already started", (Object)illegalStateException);
            }
        }
        this.started = true;
        Tr.exit((TraceComponent)tc, (String)"start");
    }

    public synchronized void stop() {
        Tr.entry((TraceComponent)tc, (String)"stop");
        this.started = false;
        Enumeration enumeration = this.mdbListeners.keys();
        while (enumeration.hasMoreElements()) {
            MDBListener mDBListener = (MDBListener)this.mdbListeners.get(enumeration.nextElement());
            try {
                this.mdbMgr.stop(mDBListener);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MsgListenerPort.stop", "259", this);
                Tr.event((TraceComponent)tc, (String)"Exception stopping MDB Listener", (Object)exception);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"stop");
    }

    public int getMaxSessions() {
        return this.liveMaxSessions;
    }

    public int getMaxRetries() {
        return this.liveMaxRetries;
    }

    public int getMaxMessages() {
        return this.liveMaxMessages;
    }

    public String getJmsConnJNDIName() {
        return this.liveJmsConnJNDIName;
    }

    public String getJmsDestJNDIName() {
        return this.liveJmsDestJNDIName;
    }

    public boolean getAsyncMessageConsumerEnabled() {
        return this.liveAsyncMessageConsumerEnabled;
    }

    public int getAsyncMessageConsumerRequestInterval() {
        return this.liveAsyncMessageConsumerRequestInterval;
    }

    public int getAsyncMessageConsumerRequestTimeout() {
        return this.liveAsyncMessageConsumerRequestTimeout;
    }

    public void setMaxSessions(int n) {
        this.maxSessions = n;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public void setMaxMessages(int n) {
        this.maxMessages = n;
    }

    public void setJmsConnJNDIName(String string) {
        this.jmsConnJNDIName = string;
    }

    public void setJmsDestJNDIName(String string) {
        this.jmsDestJNDIName = string;
    }

    public void setAsyncMessageConsumerEnabled(boolean bl) {
        this.asyncMessageConsumerEnabled = bl;
    }

    public void setAsyncMessageConsumerRequestInterval(int n) {
        this.asyncMessageConsumerRequestInterval = n;
    }

    public void setAsyncMessageConsumerRequestTimeout(int n) {
        this.asyncMessageConsumerRequestTimeout = n;
    }

    private void loadAsyncMessageConsumerExtension(ListenerPort listenerPort) {
        Tr.entry((TraceComponent)tc, (String)"loadAsyncMessageConsumerExtension", (Object)listenerPort);
        if (this.extendedMessaging == null) {
            Tr.event((TraceComponent)tc, (String)"Extended Messaging not installed");
            this.asyncMessageConsumerEnabled = false;
        } else {
            AsyncMessageConsumerExtensionAccessor asyncMessageConsumerExtensionAccessor = AsyncMessageConsumerExtensionAccessorFactory.create();
            if (asyncMessageConsumerExtensionAccessor == null) {
                Tr.event((TraceComponent)tc, (String)"AsyncMessageConsumerExtension not installed");
                this.asyncMessageConsumerEnabled = false;
            } else {
                Tr.event((TraceComponent)tc, (String)"AsyncMessageConsumerExtension installed");
                AsyncMessageConsumerExtension asyncMessageConsumerExtension = asyncMessageConsumerExtensionAccessor.get(this.extendedMessaging, (Object)listenerPort);
                if (asyncMessageConsumerExtension == null) {
                    Tr.event((TraceComponent)tc, (String)"ListenerPort has no AsyncMessageConsumerExtension");
                    this.asyncMessageConsumerEnabled = false;
                } else {
                    Tr.event((TraceComponent)tc, (String)"ListenerPort AsyncMessageConsumerExtension found", (Object)asyncMessageConsumerExtension);
                    this.asyncMessageConsumerEnabled = asyncMessageConsumerExtension.getAsyncMessageConsumerEnabled();
                    this.asyncMessageConsumerRequestInterval = asyncMessageConsumerExtension.getAsyncMessageConsumerRequestInterval();
                    this.asyncMessageConsumerRequestTimeout = asyncMessageConsumerExtension.getAsyncMessageConsumerRequestTimeout();
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"loadAsyncMessageConsumerExtension");
    }

    void setMBeanID(String string) {
        this.mBeanId = string;
    }

    String getMBeanID() {
        return this.mBeanId;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

