/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.AsyncMessageRequest;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class RequestLog
implements Serializable {
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$listener$RequestLog == null ? (class$com$ibm$ejs$jms$listener$RequestLog = RequestLog.class$("com.ibm.ejs.jms.listener.RequestLog")) : class$com$ibm$ejs$jms$listener$RequestLog), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    private int idCounter = 0;
    private Hashtable requestsByID = new Hashtable();
    private Hashtable requestsByListenerPort = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ejs$jms$listener$RequestLog;

    public RequestLog() {
        Tr.entry((TraceComponent)tc, (String)"RequestLog");
        Tr.exit((TraceComponent)tc, (String)"RequestLog");
    }

    public void commitAllRequests() {
        Tr.entry((TraceComponent)tc, (String)"commitAllRequests");
        Iterator iterator = this.requestsByID.values().iterator();
        while (iterator.hasNext()) {
            AsyncMessageRequest asyncMessageRequest = (AsyncMessageRequest)iterator.next();
            if (asyncMessageRequest.isCommitted()) continue;
            asyncMessageRequest.setRegisterTime();
            asyncMessageRequest.setStateCommitted();
        }
        Tr.exit((TraceComponent)tc, (String)"commitAllRequests");
    }

    public String addRequest(AsyncMessageRequest asyncMessageRequest) {
        Tr.entry((TraceComponent)tc, (String)"addRequest", (Object)asyncMessageRequest);
        String string = this.getUniqueRequestID();
        asyncMessageRequest.setRequestID(string);
        this.requestsByID.put(string, asyncMessageRequest);
        this.addToListenerPortList(asyncMessageRequest);
        Tr.exit((TraceComponent)tc, (String)"addRequest", (Object)string);
        return string;
    }

    public void commitRequest(String string) {
        Tr.entry((TraceComponent)tc, (String)"commitRequest", (Object)string);
        AsyncMessageRequest asyncMessageRequest = (AsyncMessageRequest)this.requestsByID.get(string);
        if (asyncMessageRequest == null) {
            Tr.event((TraceComponent)tc, (String)"Prepared async message request not found", (Object)string);
        } else {
            asyncMessageRequest.setRegisterTime();
            asyncMessageRequest.setStateCommitted();
        }
        Tr.exit((TraceComponent)tc, (String)"commitRequest");
    }

    public void removeRequest(String string) {
        Tr.entry((TraceComponent)tc, (String)"removeRequest", (Object)string);
        Object v = this.requestsByID.remove(string);
        if (v == null) {
            Tr.event((TraceComponent)tc, (String)"request not found in log", (Object)string);
        } else {
            this.removeFromListenerPortList((AsyncMessageRequest)v);
        }
        Tr.exit((TraceComponent)tc, (String)"removeRequest");
    }

    public synchronized List getListenerPortListClone(String string) {
        Tr.entry((TraceComponent)tc, (String)"getListenerPortListClone", (Object)string);
        List list = null;
        Vector vector = (Vector)this.requestsByListenerPort.get(string);
        if (vector != null) {
            list = (List)vector.clone();
        }
        Tr.exit((TraceComponent)tc, (String)"getListenerPortListClone", (Object)list);
        return list;
    }

    private synchronized void addToListenerPortList(AsyncMessageRequest asyncMessageRequest) {
        Tr.entry((TraceComponent)tc, (String)"addToListenerPortList", (Object)asyncMessageRequest);
        Vector<AsyncMessageRequest> vector = (Vector<AsyncMessageRequest>)this.requestsByListenerPort.get(asyncMessageRequest.getListenerPortName());
        if (vector == null) {
            vector = new Vector<AsyncMessageRequest>();
            this.requestsByListenerPort.put(asyncMessageRequest.getListenerPortName(), vector);
        }
        vector.add(asyncMessageRequest);
        Tr.exit((TraceComponent)tc, (String)"addToListenerPortList");
    }

    private synchronized void removeFromListenerPortList(AsyncMessageRequest asyncMessageRequest) {
        Tr.entry((TraceComponent)tc, (String)"removeFromListenerPortList", (Object)asyncMessageRequest);
        List list = (List)this.requestsByListenerPort.get(asyncMessageRequest.getListenerPortName());
        if (list == null) {
            Tr.event((TraceComponent)tc, (String)"no listener port list for request", (Object)asyncMessageRequest.getListenerPortName());
        } else {
            list.remove(asyncMessageRequest);
            if (list.size() == 0) {
                this.requestsByListenerPort.remove(asyncMessageRequest.getListenerPortName());
            }
        }
        Tr.exit((TraceComponent)tc, (String)"removeFromListenerPortList");
    }

    private synchronized String getUniqueRequestID() {
        Tr.entry((TraceComponent)tc, (String)"getUniqueRequestID");
        this.idCounter = (this.idCounter + 1) % Integer.MAX_VALUE;
        String string = Integer.toString(this.idCounter);
        while (this.requestsByID.contains(string)) {
            this.idCounter = (this.idCounter + 1) % Integer.MAX_VALUE;
            string = Integer.toString(this.idCounter);
        }
        Tr.exit((TraceComponent)tc, (String)"getUniqueRequestID", (Object)string);
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

