/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.container.MessageDrivenBeanO;
import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.jms.JMSQueueConnectionHandle;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSTopicConnectionHandle;
import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.MDBException;
import com.ibm.ejs.jms.listener.MDBListenerManagerImpl;
import com.ibm.ejs.jms.listener.MDBWrapper;
import com.ibm.ejs.jms.listener.ServerSessionPool;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.threadContext.ConnectionHandleAccessorImpl;
import com.ibm.ws.util.ThreadPool;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.transaction.Synchronization;

public class ServerSession
implements javax.jms.ServerSession,
Synchronization,
Runnable {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$listener$ServerSession == null ? (class$com$ibm$ejs$jms$listener$ServerSession = ServerSession.class$("com.ibm.ejs.jms.listener.ServerSession")) : class$com$ibm$ejs$jms$listener$ServerSession), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    ServerSessionPool serverSessionPool = null;
    boolean isQueue;
    boolean globalTransRequired;
    int ackMode;
    int maxRetries = 0;
    boolean runException;
    boolean transRolledback;
    Connection jmsConn = null;
    Destination jmsDest = null;
    Session jmsSession = null;
    MDBWrapper mdbWrapper = null;
    MessageListener mdbRef = null;
    MDBConfigData mdbConfig = null;
    ThreadPool sessionThreadPool = null;
    private static ThreadLocal thisServerSession = new ThreadLocal();
    private String msgSelector = null;
    private Hashtable requestIDs = null;
    private boolean nonASFListener = false;
    private int nonASFReceiveTimeout;
    private MessageConsumer nonASFConsumer = null;
    private JMSException nonASFFailure = null;
    private boolean preRunEnlist = true;
    static /* synthetic */ Class class$com$ibm$ejs$jms$listener$ServerSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession(ServerSessionPool serverSessionPool, Connection connection, Destination destination, MessageListener messageListener, MDBConfigData mDBConfigData, int n, ThreadPool threadPool) throws MDBException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ServerSession", (Object)new Object[]{serverSessionPool, connection, destination, messageListener, mDBConfigData, new Integer(n), threadPool});
        }
        this.serverSessionPool = serverSessionPool;
        this.jmsDest = destination;
        this.mdbRef = messageListener;
        this.mdbConfig = mDBConfigData;
        this.maxRetries = n;
        this.sessionThreadPool = threadPool;
        this.jmsConn = connection;
        try {
            LocalTransactionCoordinator localTransactionCoordinator;
            this.nonASFListener = serverSessionPool.getMDBListener().isNonASFListener();
            this.isQueue = connection instanceof QueueConnection && connection instanceof TopicConnection ? this.mdbConfig.inputPort.JMSDestinationType == 0 : connection instanceof QueueConnection;
            if (this.mdbConfig.transactionType == 1) {
                this.globalTransRequired = this.mdbConfig.onMessageTransactionAttr == 0;
                this.ackMode = 1;
            } else {
                this.globalTransRequired = false;
                this.ackMode = this.mdbConfig.inputPort.JMSAcknowledgement == 1 ? 3 : 1;
            }
            LocalTransactionCurrent localTransactionCurrent = null;
            boolean bl = false;
            try {
                localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
                localTransactionCoordinator = localTransactionCurrent.getLocalTranCoord();
                if (localTransactionCoordinator == null) {
                    localTransactionCurrent.begin();
                    bl = true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.createResources", "152", this);
                Tr.event((TraceComponent)tc, (String)"Exception beginning local transaction:", (Object)exception);
                throw exception;
            }
            localTransactionCoordinator = ConnectionHandleAccessorImpl.getConnectionHandleAccessor().getThreadContext();
            localTransactionCoordinator.beginContext((Object)new HandleList());
            try {
                this.jmsSession = this.isQueue ? ((JMSQueueConnectionHandle)connection).createListenerQueueSession(this.ackMode, this.globalTransRequired) : ((JMSTopicConnectionHandle)connection).createListenerTopicSession(this.ackMode, this.globalTransRequired);
                this.preRunEnlist = this.nonASFListener || this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled() ? true : ((JMSSessionHandle)this.jmsSession).isPreASFRunEnlist();
                this.mdbWrapper = new MDBWrapper(this.mdbConfig, this.mdbRef, this.preRunEnlist);
                if (!this.nonASFListener && !this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled()) {
                    this.jmsSession.setMessageListener((MessageListener)this.mdbWrapper);
                }
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    LocalTransactionCoordinator localTransactionCoordinator2;
                    if (bl && (localTransactionCoordinator2 = localTransactionCurrent.getLocalTranCoord()) != null) {
                        localTransactionCoordinator2.complete(0);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession", "216", this);
                    Tr.event((TraceComponent)tc, (String)"Exception completing local transaction:", (Object)exception);
                }
                if (localTransactionCoordinator != null) {
                    localTransactionCoordinator.endContext();
                }
                throw throwable;
            }
            try {
                LocalTransactionCoordinator localTransactionCoordinator3;
                if (bl && (localTransactionCoordinator3 = localTransactionCurrent.getLocalTranCoord()) != null) {
                    localTransactionCoordinator3.complete(0);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession", "216", this);
                Tr.event((TraceComponent)tc, (String)"Exception completing local transaction:", (Object)exception);
            }
            if (localTransactionCoordinator != null) {
                localTransactionCoordinator.endContext();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.ServerSession", "173", this);
            Tr.warning((TraceComponent)tc, (String)"ServerSessionCreateException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), MDBListenerManagerImpl.getNestedException(exception).getMessage()});
            Tr.debug((TraceComponent)tc, (String)"Exception:", (Object)exception);
            MDBException mDBException = new MDBException(MDBListenerManagerImpl.getNestedException(exception).getMessage(), (Throwable)exception);
            Tr.exit((TraceComponent)tc, (String)"ServerSession");
            throw mDBException;
        }
        Tr.exit((TraceComponent)tc, (String)"ServerSession");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Tr.entry((TraceComponent)tc, (String)"close");
        try {
            try {
                if (this.nonASFConsumer != null) {
                    this.nonASFConsumer.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.close", "271", this);
            }
            try {
                if (this.jmsSession != null) {
                    this.jmsSession.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.close", "201", this);
            }
        }
        finally {
            this.nonASFConsumer = null;
            this.jmsSession = null;
        }
        Tr.exit((TraceComponent)tc, (String)"close");
    }

    public Session getSession() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSession");
        }
        Session session = ((JMSSessionHandle)this.jmsSession).getSession();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSession", (Object)session);
        }
        return session;
    }

    public static Session getSessionHandle() {
        Tr.entry((TraceComponent)tc, (String)"getSessionHandle");
        Session session = null;
        ServerSession serverSession = (ServerSession)thisServerSession.get();
        if (serverSession != null) {
            session = serverSession.jmsSession;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSessionHandle", (Object)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Tr.entry((TraceComponent)tc, (String)"run");
        this.runException = false;
        this.nonASFFailure = null;
        this.transRolledback = false;
        this.mdbWrapper.setLastFailedDeliveryCount(0);
        try {
            try {
                thisServerSession.set(this);
                if (this.preRunEnlist) {
                    this.mdbRef.onMessage(null);
                } else {
                    this.connectionConsumerOnMessage(null);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.run", "283", this);
                if (!this.runException) {
                    Tr.warning((TraceComponent)tc, (String)"JMSSessionRunException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), throwable});
                }
                this.runException = true;
            }
            Object var3_4 = null;
            thisServerSession.set(null);
            this.msgSelector = null;
            this.requestIDs = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            thisServerSession.set(null);
            this.msgSelector = null;
            this.requestIDs = null;
            throw throwable;
        }
        if ((this.transRolledback || this.runException) && this.mdbWrapper.getLastFailedDeliveryCount() > this.maxRetries) {
            Tr.warning((TraceComponent)tc, (String)"JMSRetryLimitReached", (Object)new Object[]{new Integer(this.maxRetries), this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName()});
            this.serverSessionPool.markPoolAsClosed();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Stopping listener port on seperate thread");
            }
            object = new Thread(){

                public void run() {
                    try {
                        ServerSession.this.mdbConfig.msgListenerPort.stop();
                    }
                    catch (Throwable throwable) {
                        Tr.debug((TraceComponent)tc, (String)"Exception stopping Listener Port", (Object)throwable);
                    }
                }
            };
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }
        if (this.nonASFFailure != null) {
            try {
                object = this.jmsConn.getExceptionListener();
                if (object != null) {
                    object.onException(this.nonASFFailure);
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.ServerSession.run", "420", this);
                Tr.debug((TraceComponent)tc, (String)"Unable to enter recovery mode", (Object)((Object)this.nonASFFailure));
            }
            finally {
                this.nonASFFailure = null;
            }
        }
        this.serverSessionPool.putServerSession(this);
        Tr.exit((TraceComponent)tc, (String)"run");
    }

    public static void dispatch(Object object) throws Exception {
        Tr.entry((TraceComponent)tc, (String)"Dispatch");
        MessageDrivenBeanO messageDrivenBeanO = (MessageDrivenBeanO)object;
        ServerSession serverSession = (ServerSession)thisServerSession.get();
        serverSession.onMessage(messageDrivenBeanO);
        Tr.exit((TraceComponent)tc, (String)"Dispatch");
    }

    public void onMessage(MessageDrivenBeanO messageDrivenBeanO) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onMessage", (Object)messageDrivenBeanO);
        }
        if (!this.nonASFListener) {
            ((JMSSessionHandle)this.jmsSession).enlist();
        }
        if (this.preRunEnlist) {
            if (this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled()) {
                this.asyncMessageConsumerOnMessage(messageDrivenBeanO);
            } else if (this.nonASFListener) {
                this.nonASFConsumerOnMessage(messageDrivenBeanO);
            } else {
                this.connectionConsumerOnMessage(messageDrivenBeanO);
            }
        } else {
            if (this.globalTransRequired) {
                TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
            }
            this.mdbWrapper.setMessageListener((MessageListener)messageDrivenBeanO.messageDrivenBean);
            this.mdbWrapper.callOnMessage();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onMessage");
        }
    }

    public void asyncMessageConsumerOnMessage(MessageDrivenBeanO messageDrivenBeanO) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"asyncMessageConsumerOnMessage", (Object)messageDrivenBeanO);
        }
        if (!this.isQueue) {
            Tr.event((TraceComponent)tc, (String)"Illegal use of async message consumer for a JMS Topic");
            if (this.globalTransRequired) {
                messageDrivenBeanO.setRollbackOnly();
            }
        } else {
            try {
                QueueReceiver queueReceiver = ((QueueSession)this.jmsSession).createReceiver((Queue)this.jmsDest, this.msgSelector);
                Message message = queueReceiver.receiveNoWait();
                if (message != null) {
                    if (this.globalTransRequired) {
                        TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
                    }
                    this.mdbWrapper.setMessageListener((MessageListener)messageDrivenBeanO.messageDrivenBean);
                    this.mdbWrapper.onMessage(message);
                    this.serverSessionPool.getMDBListener().getAsyncMessageLog().removeRequest((String)this.requestIDs.get(message.getJMSCorrelationID()));
                } else if (this.globalTransRequired) {
                    messageDrivenBeanO.setRollbackOnly();
                }
                queueReceiver.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.asyncMessageConsumerOnMessage", "418", this);
                Tr.warning((TraceComponent)tc, (String)"JMSSessionRunException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                this.runException = true;
                try {
                    if (this.globalTransRequired) {
                        messageDrivenBeanO.setRollbackOnly();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.asyncMessageConsumerOnMessage", "434", this);
                    Tr.warning((TraceComponent)tc, (String)"RollbackException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                }
                Tr.exit((TraceComponent)tc, (String)"asyncMessageConsumerOnMessage");
                throw exception;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"asyncMessageConsumerOnMessage");
    }

    public void nonASFConsumerOnMessage(MessageDrivenBeanO messageDrivenBeanO) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nonASFConsumerOnMessage", (Object)messageDrivenBeanO);
        }
        try {
            Message message;
            if (this.nonASFConsumer == null) {
                this.nonASFConsumer = this.isQueue ? ((QueueSession)this.jmsSession).createReceiver((Queue)this.jmsDest, this.mdbConfig.inputPort.JMSMessageSelector) : (this.mdbConfig.inputPort.JMSSubscriptionDurability == 0 ? ((TopicSession)this.jmsSession).createSubscriber((Topic)this.jmsDest, this.mdbConfig.inputPort.JMSMessageSelector, false) : ((TopicSession)this.jmsSession).createDurableSubscriber((Topic)this.jmsDest, this.mdbConfig.inputPort.JMSSubscriptionName, this.mdbConfig.inputPort.JMSMessageSelector, false));
            }
            if ((message = this.nonASFConsumer.receive((long)this.nonASFReceiveTimeout)) != null) {
                if (this.globalTransRequired) {
                    TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
                }
                this.mdbWrapper.setMessageListener((MessageListener)messageDrivenBeanO.messageDrivenBean);
                this.mdbWrapper.onMessage(message);
            } else if (this.globalTransRequired) {
                messageDrivenBeanO.setRollbackOnly();
            }
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                this.nonASFFailure = (JMSException)((Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.nonASFConsumerOnMessage", "569", this);
            Tr.warning((TraceComponent)tc, (String)"JMSSessionRunException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
            this.runException = true;
            try {
                if (this.globalTransRequired) {
                    messageDrivenBeanO.setRollbackOnly();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.nonASFConsumerOnMessage", "585", this);
                Tr.warning((TraceComponent)tc, (String)"RollbackException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
            }
            Tr.exit((TraceComponent)tc, (String)"nonASFConsumerOnMessage");
            throw exception;
        }
        Tr.exit((TraceComponent)tc, (String)"nonASFConsumerOnMessage");
    }

    public void connectionConsumerOnMessage(MessageDrivenBeanO messageDrivenBeanO) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectionConsumerOnMessage", (Object)messageDrivenBeanO);
        }
        try {
            if (this.preRunEnlist) {
                if (this.globalTransRequired) {
                    TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
                }
                this.mdbWrapper.setMessageListener((MessageListener)messageDrivenBeanO.messageDrivenBean);
            }
            this.jmsSession.run();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.connectionConsumerOnMessage", "450", this);
            Tr.warning((TraceComponent)tc, (String)"JMSSessionRunException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
            this.runException = true;
            if (this.preRunEnlist) {
                try {
                    if (this.globalTransRequired) {
                        messageDrivenBeanO.setRollbackOnly();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.connectionConsumerOnMessage", "466", this);
                    Tr.warning((TraceComponent)tc, (String)"RollbackException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                }
            }
            Tr.exit((TraceComponent)tc, (String)"connectionConsumerOnMessage");
            throw exception;
        }
        Tr.exit((TraceComponent)tc, (String)"connectionConsumerOnMessage");
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Integer(n));
        }
        if (n != 3) {
            this.transRolledback = true;
            if (this.mdbWrapper.getJMSXDeliveryCount() > this.mdbWrapper.getLastFailedDeliveryCount()) {
                this.mdbWrapper.setLastFailedDeliveryCount(this.mdbWrapper.getJMSXDeliveryCount());
            }
            if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
                this.mdbConfig.pmiBean.messageBackedOut();
            }
        }
        Tr.exit((TraceComponent)tc, (String)"afterCompletion");
    }

    public void start() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"start");
        try {
            this.sessionThreadPool.execute((Runnable)this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.start", "521", this);
            Tr.warning((TraceComponent)tc, (String)"JMSServerSessionStartException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), throwable});
            Tr.exit((TraceComponent)tc, (String)"start");
            throw new JMSException(MDBListenerManagerImpl.getNestedException(throwable).getMessage());
        }
        Tr.exit((TraceComponent)tc, (String)"start");
    }

    public void startReceiveMsgNoWait(String string, Hashtable hashtable) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startReceiveMsgNoWait", (Object)new Object[]{string, hashtable});
        }
        try {
            this.msgSelector = string;
            this.requestIDs = hashtable;
            this.sessionThreadPool.execute((Runnable)this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.startReceiveMsgNoWait", "552", this);
            Tr.warning((TraceComponent)tc, (String)"JMSServerSessionStartException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), throwable});
            Tr.exit((TraceComponent)tc, (String)"startReceiveMsgNoWait");
            throw new JMSException(MDBListenerManagerImpl.getNestedException(throwable).getMessage());
        }
        Tr.exit((TraceComponent)tc, (String)"startReceiveMsgNoWait");
    }

    public void startReceiveMsg(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startReceiveMsg", (Object)new Integer(n));
        }
        try {
            this.nonASFReceiveTimeout = n;
            this.sessionThreadPool.execute((Runnable)this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.startReceiveMsg", "787", this);
            Tr.warning((TraceComponent)tc, (String)"JMSServerSessionStartException", (Object)new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), throwable});
            Tr.exit((TraceComponent)tc, (String)"startReceiveMsgNoWait");
            throw new JMSException(MDBListenerManagerImpl.getNestedException(throwable).getMessage());
        }
        Tr.exit((TraceComponent)tc, (String)"startReceiveMsg");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

