/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.MDBException;
import com.ibm.ejs.jms.listener.MDBListenerImpl;
import com.ibm.ejs.jms.listener.MDBPool;
import com.ibm.ejs.jms.listener.ServerSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import java.util.Stack;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageListener;

public class ServerSessionPool
implements javax.jms.ServerSessionPool {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$listener$ServerSessionPool == null ? (class$com$ibm$ejs$jms$listener$ServerSessionPool = ServerSessionPool.class$("com.ibm.ejs.jms.listener.ServerSessionPool")) : class$com$ibm$ejs$jms$listener$ServerSessionPool), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    MDBListenerImpl mdbListener = null;
    boolean closed = false;
    int maxSessions = 0;
    int maxRetries = 0;
    Connection jmsConn = null;
    Destination jmsDest = null;
    MDBPool mdbPool = null;
    MessageListener mdbRef = null;
    MDBConfigData mdbConfig = null;
    ThreadPool sessionThreadPool = null;
    Vector serverSessions = new Vector();
    Stack freeSessions = new Stack();
    static /* synthetic */ Class class$com$ibm$ejs$jms$listener$ServerSessionPool;

    public ServerSessionPool(MDBListenerImpl mDBListenerImpl, Connection connection, Destination destination, MDBPool mDBPool, MDBConfigData mDBConfigData, int n, int n2, ThreadPool threadPool) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ServerSessionPool", (Object)new Object[]{mDBListenerImpl, connection, destination, mDBPool, mDBConfigData, new Integer(n), new Integer(n2), threadPool});
        }
        this.mdbListener = mDBListenerImpl;
        this.closed = false;
        this.jmsConn = connection;
        this.jmsDest = destination;
        this.mdbPool = mDBPool;
        this.mdbRef = mDBPool.getMDB();
        this.mdbConfig = mDBConfigData;
        this.maxSessions = n;
        this.maxRetries = n2;
        this.sessionThreadPool = threadPool;
        Tr.exit((TraceComponent)tc, (String)"ServerSessionPool");
    }

    public synchronized void close() {
        Tr.entry((TraceComponent)tc, (String)"close");
        this.closed = true;
        while (this.serverSessions.size() > 0) {
            while (!this.freeSessions.empty()) {
                ServerSession serverSession = (ServerSession)this.freeSessions.pop();
                serverSession.close();
                this.serverSessions.remove(serverSession);
            }
            if (this.mdbListener.isQuiesceComplete()) break;
            if (this.serverSessions.size() <= 0) continue;
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyAll();
        try {
            if (this.mdbRef != null) {
                this.mdbPool.returnMDB(this.mdbRef);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSessionPool.close", "140", this);
            Tr.event((TraceComponent)tc, (String)"Exception returning MDB reference", (Object)exception);
        }
        this.mdbRef = null;
        Tr.exit((TraceComponent)tc, (String)"close");
    }

    public MDBListenerImpl getMDBListener() {
        Tr.entry((TraceComponent)tc, (String)"getMDBListener");
        Tr.exit((TraceComponent)tc, (String)"getMDBListener");
        return this.mdbListener;
    }

    public synchronized javax.jms.ServerSession getServerSession() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"getServerSession");
        ServerSession serverSession = null;
        long l = 0L;
        if (this.closed) {
            Tr.exit((TraceComponent)tc, (String)"getServerSession");
            throw new IllegalStateException("ServerSessionPool closed");
        }
        if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
            l = this.mdbConfig.pmiBean.waitingForServerSession();
        }
        if (!this.freeSessions.empty()) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting a free ServerSession from the pool");
            }
            serverSession = (ServerSession)this.freeSessions.pop();
        } else if (this.serverSessions.size() < this.maxSessions) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Allocating a new ServerSession");
                }
                serverSession = new ServerSession(this, this.jmsConn, this.jmsDest, this.mdbRef, this.mdbConfig, this.maxRetries, this.sessionThreadPool);
            }
            catch (MDBException mDBException) {
                FFDCFilter.processException((Throwable)mDBException, "com.ibm.ejs.jms.listener.ServerSessionPool.getServerSession", "181", this);
                throw new JMSException(mDBException.getMessage());
            }
            this.serverSessions.add(serverSession);
        } else {
            while (this.freeSessions.empty()) {
                try {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Waiting for a new ServerSession to become available");
                    }
                    this.wait();
                    if (!this.closed) continue;
                    Tr.exit((TraceComponent)tc, (String)"getServerSession");
                    throw new IllegalStateException("ServerSessionPool closed");
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.jms.listener.ServerSessionPool.getServerSession", "203", this);
                }
            }
            serverSession = (ServerSession)this.freeSessions.pop();
        }
        if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
            this.mdbConfig.pmiBean.gotServerSession(l);
            int n = this.serverSessions.size();
            this.mdbConfig.pmiBean.serverSessionRetrieve(n - this.freeSessions.size(), n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerSession", (Object)serverSession);
        }
        return serverSession;
    }

    public synchronized void putServerSession(ServerSession serverSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putServerSession", (Object)serverSession);
        }
        this.freeSessions.push(serverSession);
        if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
            int n = this.serverSessions.size();
            this.mdbConfig.pmiBean.serverSessionReturn(n - this.freeSessions.size(), n);
        }
        this.notifyAll();
        Tr.exit((TraceComponent)tc, (String)"putServerSession");
    }

    public int getActiveSessionCount() {
        Tr.entry((TraceComponent)tc, (String)"getActiveSessionCount");
        int n = this.serverSessions.size() - this.freeSessions.size();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getActiveSessionCount", (Object)new Integer(n));
        }
        return n;
    }

    public void markPoolAsClosed() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"markPoolAsClosed");
        }
        this.closed = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"markPoolAsClosed");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

