/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mbmigrator;

import com.ibm.ejs.jms.mbmigrator.JMSConfigData;
import com.ibm.ejs.jms.mbmigrator.JMSListenerConfig;
import com.ibm.ejs.jms.mbmigrator.JMSXMLConfigHandler;
import com.ibm.ejs.jms.mbmigrator.MBEARHandler;
import com.ibm.ejs.jms.mbmigrator.MBEJBJarBndMigratorHandler;
import com.ibm.ejs.jms.mbmigrator.MBEJBJarExtMigratorHandler;
import com.ibm.ejs.jms.mbmigrator.MBEJBJarMigratorHandler;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.SequenceInputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MigrateMB {
    public static final String COPYRIGHT = "Product 5630-A36 (C) COPYRIGHT International Business Machines Corp. 2002,2003\nAll Rights Reserved * Licensed Materials - Property of IBM\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$jms$mbmigrator$MigrateMB == null ? (class$com$ibm$ejs$jms$mbmigrator$MigrateMB = MigrateMB.class$("com.ibm.ejs.jms.mbmigrator.MigrateMB")) : class$com$ibm$ejs$jms$mbmigrator$MigrateMB), (String)"Messaging", (String)"com.ibm.ejs.jms.messaging");
    private static ResourceBundle msgBundle = null;
    private static final String EJB_DD = "META-INF/ejb-jar.xml";
    private static final String EJB_BND = "META-INF/ibm-ejb-jar-bnd.xmi";
    private static final String EJB_EXT = "META-INF/ibm-ejb-jar-ext.xmi";
    private static final String EAR_DD = "META-INF/application.xml";
    private static final String XML_ENC_UTF8 = "UTF8";
    private String inputMB;
    private String jmsListenerConfigFile;
    private String workingDir;
    private String utilityJARDir;
    private String outputMDB;
    private boolean verbose = false;
    private boolean keep = false;
    private Hashtable mappings = new Hashtable();
    private boolean isEAR = false;
    private JMSListenerConfig jmsConfig = null;
    private Vector jmsListeners;
    private Vector msgBeans = new Vector();
    Vector tempFiles = new Vector();
    Vector tempDirs = new Vector();
    static /* synthetic */ Class class$com$ibm$ejs$jms$mbmigrator$MigrateMB;

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            MigrateMB.help();
            System.exit(-1);
        }
        MigrateMB migrateMB = new MigrateMB(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        for (int i = 4; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-keep")) {
                migrateMB.setKeep(true);
                continue;
            }
            if (stringArray[i].equals("-map") && i != stringArray.length - 1) {
                migrateMB.setMapping(stringArray[i + 1]);
                ++i;
                continue;
            }
            if (stringArray[i].equals("-verbose")) {
                migrateMB.setVerbose(true);
                continue;
            }
            MigrateMB.help();
            System.exit(-1);
        }
        migrateMB.migrate();
        System.exit(0);
    }

    private static void help() {
        System.out.println(MigrateMB.getMessage("MB2MDBHelp01", null));
        System.out.println(MigrateMB.getMessage("MB2MDBHelp02", null));
        System.out.println(" -keep    " + MigrateMB.getMessage("MB2MDBHelp03", null));
        System.out.println(" -map listenerHome=bindingHome " + MigrateMB.getMessage("MB2MDBHelp04", null));
        System.out.println("          " + MigrateMB.getMessage("MB2MDBHelp05", null));
        System.out.println("          " + MigrateMB.getMessage("MB2MDBHelp06", null));
        System.out.println("          " + MigrateMB.getMessage("MB2MDBHelp07", null));
        System.out.println("          " + MigrateMB.getMessage("MB2MDBHelp08", null));
        System.out.println(" -verbose " + MigrateMB.getMessage("MB2MDBHelp09", null));
    }

    public MigrateMB(String string, String string2, String string3, String string4) {
        this.inputMB = string;
        this.jmsListenerConfigFile = string2;
        this.workingDir = string3;
        this.outputMDB = string4;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public void setMapping(String string) {
        int n = string.lastIndexOf("=");
        if (n > 0 && n < string.length() - 1) {
            this.mappings.put(string.substring(0, n), string.substring(n + 1));
        } else {
            this.error(MigrateMB.getMessage("MB2MDBInvalidMappingOption", new Object[]{string}));
            System.exit(-1);
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void migrate() {
        try {
            Object object;
            File file;
            this.isEAR = this.inputMB.toUpperCase().endsWith(".EAR");
            System.out.println(MigrateMB.getMessage("MB2MDBVerbose01", null));
            this.log(MigrateMB.getMessage("MB2MDBVerbose02", null));
            if (this.isEAR) {
                this.log(MigrateMB.getMessage("MB2MDBVerbose03", new Object[]{this.inputMB}));
            } else {
                this.log(MigrateMB.getMessage("MB2MDBVerbose04", new Object[]{this.inputMB}));
            }
            this.log(MigrateMB.getMessage("MB2MDBVerbose05", new Object[]{this.jmsListenerConfigFile}));
            this.log(MigrateMB.getMessage("MB2MDBVerbose06", new Object[]{this.workingDir}));
            if (this.isEAR) {
                this.log(MigrateMB.getMessage("MB2MDBVerbose07", new Object[]{this.outputMDB}));
            } else {
                this.log(MigrateMB.getMessage("MB2MDBVerbose08", new Object[]{this.outputMDB}));
            }
            this.log("");
            File file2 = new File(this.inputMB);
            if (!file2.exists()) {
                this.error(MigrateMB.getMessage("MB2MDBInputFileDoesNotExist", new Object[]{this.inputMB}));
            }
            if (!(file = new File(this.jmsListenerConfigFile)).exists()) {
                this.error(MigrateMB.getMessage("MB2MDBInputFileDoesNotExist", new Object[]{this.jmsListenerConfigFile}));
            }
            if (!file2.exists() || !file.exists()) {
                System.exit(-1);
            }
            this.log(MigrateMB.getMessage("MB2MDBVerbose09", new Object[]{this.jmsListenerConfigFile}));
            this.jmsConfig = this.parseJMSConfiguration(this.jmsListenerConfigFile);
            if (this.jmsConfig == null) {
                this.error(MigrateMB.getMessage("MB2MDBNoDefinitionsFound", new Object[]{this.jmsListenerConfigFile}));
                System.exit(-1);
            } else {
                this.jmsListeners = this.jmsConfig.getJMSListeners();
                for (int i = 0; i < this.jmsListeners.size(); ++i) {
                    object = (JMSConfigData)this.jmsListeners.get(i);
                    if (this.mappings.containsKey(((JMSConfigData)object).EJBHomeJNDIName)) {
                        this.msgBeans.add(this.mappings.get(((JMSConfigData)object).EJBHomeJNDIName));
                        continue;
                    }
                    this.msgBeans.add(((JMSConfigData)object).EJBHomeJNDIName);
                }
            }
            if (this.isEAR) {
                try {
                    int n;
                    byte[] byArray;
                    InputStream inputStream;
                    ZipEntry zipEntry;
                    FileOutputStream fileOutputStream;
                    String string;
                    String string2;
                    this.log(MigrateMB.getMessage("MB2MDBVerbose10", new Object[]{EAR_DD}));
                    Vector vector = new Vector();
                    object = new Vector();
                    JarFile jarFile = new JarFile(this.inputMB);
                    ZipEntry zipEntry2 = jarFile.getEntry(EAR_DD);
                    if (zipEntry2 == null) {
                        this.error(MigrateMB.getMessage("MB2MDBEARMissingDD", new Object[]{this.inputMB, EAR_DD}));
                        System.exit(-1);
                    }
                    InputSource inputSource = new InputSource(jarFile.getInputStream(zipEntry2));
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    MBEARHandler mBEARHandler = new MBEARHandler(vector);
                    sAXParser.parse(inputSource, (DefaultHandler)mBEARHandler);
                    this.utilityJARDir = this.workingDir + File.separator + "utilityJARs";
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        string2 = jarEntry.getName();
                        if (!string2.toUpperCase().endsWith(".JAR") || vector.contains(string2)) continue;
                        string = this.utilityJARDir + File.separator + string2;
                        fileOutputStream = this.getOutputStream(string);
                        zipEntry = jarFile.getEntry(string2);
                        inputStream = jarFile.getInputStream(zipEntry);
                        byArray = new byte[1000];
                        while ((n = inputStream.read(byArray)) > 0) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        inputStream.close();
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        this.tempFiles.add(string);
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        string2 = (String)vector.get(i);
                        this.log(MigrateMB.getMessage("MB2MDBVerbose11", new Object[]{string2}));
                        string = this.workingDir + File.separator + string2 + "Input" + File.separator + string2;
                        fileOutputStream = this.getOutputStream(string);
                        zipEntry = jarFile.getEntry(string2);
                        inputStream = jarFile.getInputStream(zipEntry);
                        byArray = new byte[1000];
                        while ((n = inputStream.read(byArray)) > 0) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        inputStream.close();
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        this.tempFiles.add(string);
                        String string3 = this.workingDir + File.separator + string2;
                        this.migrateMBJar(string2 + "Temp", string, string3);
                        ((Vector)object).add(string3);
                        this.tempFiles.add(string3);
                    }
                    this.log(MigrateMB.getMessage("MB2MDBVerbose12", new Object[]{this.outputMDB}));
                    this.constructEarFile((Vector)object, this.inputMB, this.outputMDB, this.workingDir);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.migrate", "292", this);
                    throw throwable;
                }
            } else {
                this.migrateMBJar("", this.inputMB, this.outputMDB);
            }
            if (!this.keep) {
                this.log(MigrateMB.getMessage("MB2MDBVerbose13", null));
                this.cleanup();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.migrate", "314", this);
            this.error(MigrateMB.getMessage("MB2MDBException", null));
            throwable.printStackTrace();
            System.exit(-1);
        }
        System.out.println(MigrateMB.getMessage("MB2MDBVerbose21", null));
        System.exit(0);
    }

    private void migrateMBJar(String string, String string2, String string3) {
        try {
            int n;
            DefaultHandler defaultHandler;
            SAXParser sAXParser;
            SAXParserFactory sAXParserFactory;
            OutputStreamWriter outputStreamWriter;
            Object object;
            Object object2;
            ZipEntry zipEntry;
            this.log(MigrateMB.getMessage("MB2MDBVerbose14", new Object[]{string2, string3}));
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < this.msgBeans.size(); ++i) {
                hashtable.put((String)this.msgBeans.get(i), "");
            }
            Vector vector = new Vector();
            Vector<String> vector2 = new Vector<String>();
            String string4 = this.workingDir;
            if (!string.equals("")) {
                string4 = string4 + File.separator + string;
            }
            JarFile jarFile = new JarFile(string2);
            this.log(MigrateMB.getMessage("MB2MDBVerbose15", new Object[]{EJB_BND}));
            try {
                zipEntry = jarFile.getEntry(EJB_BND);
                if (zipEntry == null) {
                    this.error(MigrateMB.getMessage("MB2MDBInvalidEJBjar", new Object[]{string2, EJB_BND}));
                    System.exit(-1);
                }
                object2 = new InputSource(jarFile.getInputStream(zipEntry));
                object = string4 + File.separator + EJB_BND;
                outputStreamWriter = new OutputStreamWriter((OutputStream)this.getOutputStream((String)object), XML_ENC_UTF8);
                sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                sAXParser = sAXParserFactory.newSAXParser();
                defaultHandler = new MBEJBJarBndMigratorHandler(hashtable, outputStreamWriter);
                sAXParser.parse((InputSource)object2, defaultHandler);
                vector2.add((String)object);
                this.tempFiles.add(object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.migrateMBJar", "375", this);
                throw throwable;
            }
            try {
                zipEntry = jarFile.getEntry(EJB_EXT);
                if (zipEntry != null) {
                    this.log(MigrateMB.getMessage("MB2MDBVerbose15", new Object[]{EJB_EXT}));
                    object2 = new InputSource(jarFile.getInputStream(zipEntry));
                    object = string4 + File.separator + EJB_EXT;
                    outputStreamWriter = new OutputStreamWriter((OutputStream)this.getOutputStream((String)object), XML_ENC_UTF8);
                    sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                    sAXParser = sAXParserFactory.newSAXParser();
                    defaultHandler = new MBEJBJarExtMigratorHandler(hashtable, outputStreamWriter);
                    sAXParser.parse((InputSource)object2, defaultHandler);
                    vector2.add((String)object);
                    this.tempFiles.add(object);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.migrateMBJar", "407", this);
                throw throwable;
            }
            this.log(MigrateMB.getMessage("MB2MDBVerbose15", new Object[]{EJB_DD}));
            try {
                zipEntry = jarFile.getEntry(EJB_DD);
                if (zipEntry == null) {
                    this.error(MigrateMB.getMessage("MB2MDBInvalidEJBjar", new Object[]{string2, EJB_DD}));
                    System.exit(-1);
                }
                object2 = new InputSource(jarFile.getInputStream(zipEntry));
                object = string4 + File.separator + EJB_DD;
                outputStreamWriter = new OutputStreamWriter((OutputStream)this.getOutputStream((String)object), XML_ENC_UTF8);
                sAXParserFactory = SAXParserFactory.newInstance();
                sAXParser = sAXParserFactory.newSAXParser();
                defaultHandler = new MBEJBJarMigratorHandler(hashtable, this.mappings, this.jmsListeners, vector, outputStreamWriter);
                sAXParser.parse((InputSource)object2, defaultHandler);
                vector2.add((String)object);
                this.tempFiles.add(object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.migrateMBJar", "438", this);
                throw throwable;
            }
            for (n = 0; n < vector.size(); ++n) {
                object2 = string4 + File.separator + this.MBMDBWrapperName((String)vector.get(n)).replace('.', File.separatorChar) + ".java";
                this.log(MigrateMB.getMessage("MB2MDBVerbose16", new Object[]{object2}));
                object = new PrintStream(this.getOutputStream((String)object2));
                this.generateMDBWrapperBean(this.MBMDBWrapperName((String)vector.get(n)), (String)vector.get(n), (PrintStream)object);
                this.tempFiles.add(object2);
            }
            for (n = 0; n < vector.size(); ++n) {
                object2 = string4 + File.separator + this.MBMDBWrapperName((String)vector.get(n)).replace('.', File.separatorChar);
                this.compile((String)object2 + ".java", string4, string2);
                vector2.add((String)object2 + ".class");
                this.tempFiles.add((String)object2 + ".class");
                vector2.add((String)object2 + "$MBSessionContext.class");
                this.tempFiles.add((String)object2 + "$MBSessionContext.class");
            }
            this.log(MigrateMB.getMessage("MB2MDBVerbose17", new Object[]{string3}));
            this.constructJarFile(vector2, string2, string3, string4);
            jarFile.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.migrateMBJar", "475", this);
            this.error(MigrateMB.getMessage("MB2MDBException", null));
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * Loose catch block
     */
    private JMSListenerConfig parseJMSConfiguration(String string) throws Exception {
        JMSListenerConfig jMSListenerConfig;
        block16: {
            int n;
            String string2;
            Vector vector;
            InputSource inputSource;
            FileInputStream fileInputStream;
            Object object;
            jMSListenerConfig = null;
            try {
                object = new FileInputStream(string);
                fileInputStream = object;
                inputSource = new InputSource(fileInputStream);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mbmigrator.MigrateMB.parseJMSConfiguration", "505", this);
                this.error(MigrateMB.getMessage("MB2MDBParsingException", new Object[]{string, exception}));
                throw exception;
            }
            object = SAXParserFactory.newInstance();
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            JMSXMLConfigHandler jMSXMLConfigHandler = new JMSXMLConfigHandler();
            sAXParser.parse(inputSource, (DefaultHandler)jMSXMLConfigHandler);
            if (jMSXMLConfigHandler.getWarnings().size() != 0) {
                vector = jMSXMLConfigHandler.getWarnings();
                string2 = new String("");
                for (n = 0; n < vector.size(); ++n) {
                    string2 = string2 + ", " + vector.get(n);
                }
                this.error(MigrateMB.getMessage("MB2MDBParsingWarnings", new Object[]{string, string2}));
            }
            if (jMSXMLConfigHandler.getErrors().size() != 0) {
                vector = jMSXMLConfigHandler.getErrors();
                string2 = new String("");
                for (n = 0; n < vector.size(); ++n) {
                    string2 = string2 + ", " + vector.get(n);
                }
                this.error(MigrateMB.getMessage("MB2MDBParsingErrors", new Object[]{string, string2}));
            }
            if (jMSXMLConfigHandler.getFatalErrors().size() != 0) {
                vector = jMSXMLConfigHandler.getFatalErrors();
                string2 = new String("");
                for (n = 0; n < vector.size(); ++n) {
                    string2 = string2 + ", " + vector.get(n);
                }
                this.error(MigrateMB.getMessage("MB2MDBParsingFatalErrors", new Object[]{string, string2}));
                throw new Exception(string2);
            }
            jMSListenerConfig = jMSXMLConfigHandler.getJMSConfig();
            Object var12_14 = null;
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mbmigrator.MigrateMB.parseJMSConfiguration", "579", this);
            }
            break block16;
            {
                catch (SAXParseException sAXParseException) {
                    FFDCFilter.processException((Throwable)sAXParseException, "com.ibm.ejs.jms.mbmigrator.MigrateMB.parseJMSConfiguration", "564", this);
                    this.error(MigrateMB.getMessage("MB2MDBSAXParseException", new Object[]{string, Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber()), sAXParseException}));
                    throw sAXParseException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mbmigrator.MigrateMB.parseJMSConfiguration", "571", this);
                    this.error(MigrateMB.getMessage("MB2MDBParseException", new Object[]{string, exception}));
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mbmigrator.MigrateMB.parseJMSConfiguration", "579", this);
                }
                throw throwable;
            }
        }
        return jMSListenerConfig;
    }

    private FileOutputStream getOutputStream(String string) {
        try {
            File file = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator + "/");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 == null ? (string.startsWith(File.separator) || string.startsWith("/") ? File.separator + stringTokenizer.nextToken() : stringTokenizer.nextToken()) : string2 + '/' + stringTokenizer.nextToken();
                file = new File(string2);
                if (file.exists()) continue;
                if (stringTokenizer.hasMoreTokens()) {
                    if (!file.mkdir()) {
                        this.error(MigrateMB.getMessage("MB2MDBCreateDirError", new Object[]{string2}));
                        System.exit(-1);
                    }
                    this.tempDirs.add(0, string2);
                    continue;
                }
                if (file.createNewFile()) continue;
                this.error(MigrateMB.getMessage("MB2MDBCreateFileError", new Object[]{string2}));
                System.exit(-1);
            }
            return new FileOutputStream(file);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.getOutputStream", "641", this);
            this.error(MigrateMB.getMessage("MB2MDBCreateFileError", new Object[]{string}));
            throwable.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private void generateMDBWrapperBean(String string, String string2, PrintStream printStream) {
        String string3 = this.getPackageName(string);
        String string4 = this.getShortName(string);
        printStream.println("package " + string3 + ";");
        printStream.println(" ");
        printStream.println("/* WARNING: this is generated code */");
        printStream.println(" ");
        printStream.println("public class " + string4 + " implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener                                                              ");
        printStream.println("{                                                                                                                                                         ");
        printStream.println(" private javax.ejb.MessageDrivenContext myMessageDrivenCtx = null;                                                                                        ");
        printStream.println(" private " + string2 + " mb = new " + string2 + "();                                                                                                              ");
        printStream.println("                                                                                                                                                          ");
        printStream.println(" public void ejbCreate() throws javax.ejb.CreateException, javax.ejb.EJBException                                                                         ");
        printStream.println(" {                                                                                                                                                        ");
        printStream.println("   try                                                                                                                                                    ");
        printStream.println("   {                                                                                                                                                      ");
        printStream.println("     mb.ejbCreate();                                                                                                                                      ");
        printStream.println("   }                                                                                                                                                      ");
        printStream.println("   catch(javax.ejb.EJBException e) { throw e; }                                                                                                           ");
        printStream.println("   catch(Exception e)                                                                                                                                     ");
        printStream.println("   {                                                                                                                                                      ");
        printStream.println("     if (e instanceof javax.ejb.CreateException)                                                                                                          ");
        printStream.println("       throw (javax.ejb.CreateException)e;                                                                                                                ");
        printStream.println("     else if (e instanceof java.rmi.RemoteException)                                                                                                      ");
        printStream.println("       throw new javax.ejb.EJBException(e);                                                                                                               ");
        printStream.println("     else                                                                                                                                                 ");
        printStream.println("       throw new javax.ejb.CreateException(e.toString());                                                                                                 ");
        printStream.println("   }                                                                                                                                                      ");
        printStream.println(" }                                                                                                                                                        ");
        printStream.println(" public void ejbRemove() throws javax.ejb.EJBException                                                                                                    ");
        printStream.println(" {                                                                                                                                                        ");
        printStream.println("   try                                                                                                                                                    ");
        printStream.println("   {                                                                                                                                                      ");
        printStream.println("     mb.ejbRemove();                                                                                                                                      ");
        printStream.println("   }                                                                                                                                                      ");
        printStream.println("   catch(javax.ejb.EJBException e) { throw e; }                                                                                                           ");
        printStream.println("   catch(Exception e) { throw new javax.ejb.EJBException(e); }                                                                                            ");
        printStream.println(" }                                                                                                                                                        ");
        printStream.println(" public javax.ejb.MessageDrivenContext getMessageDrivenContext()                                                                                          ");
        printStream.println(" {                                                                                                                                                        ");
        printStream.println("   return myMessageDrivenCtx;                                                                                                                             ");
        printStream.println(" }                                                                                                                                                        ");
        printStream.println(" public void onMessage(javax.jms.Message msg)                                                                                                             ");
        printStream.println(" {                                                                                                                                                        ");
        printStream.println("   mb.onMessage(msg);                                                                                                                                     ");
        printStream.println(" }                                                                                                                                                        ");
        printStream.println(" public void setMessageDrivenContext(javax.ejb.MessageDrivenContext ctx) throws javax.ejb.EJBException                                                    ");
        printStream.println(" {                                                                                                                                                        ");
        printStream.println("   MBSessionContext sessCtx = new MBSessionContext(ctx);                                            ");
        printStream.println("   try                                                                                                                                                    ");
        printStream.println("   {                                                                                                                                                      ");
        printStream.println("     mb.setSessionContext(sessCtx);                                                                                                                       ");
        printStream.println("   }                                                                                                                                                      ");
        printStream.println("   catch(Exception e) { throw new javax.ejb.EJBException(e); }                                                                                            ");
        printStream.println("   myMessageDrivenCtx = ctx;                                                                                                                              ");
        printStream.println(" }                                                                                                                                                        ");
        printStream.println("                                                                                                                                                          ");
        printStream.println(" private class MBSessionContext implements javax.ejb.SessionContext                                                                                       ");
        printStream.println(" {                                                                                                                                                        ");
        printStream.println("   private javax.ejb.MessageDrivenContext mdCtx;                                                                                                          ");
        printStream.println("   public MBSessionContext(javax.ejb.MessageDrivenContext mdbCtx) {mdCtx = mdbCtx;}                                                                       ");
        printStream.println("   public java.security.Identity getCallerIdentity() {return mdCtx.getCallerIdentity();}                                                                  ");
        printStream.println("   public java.security.Principal getCallerPrincipal() {return mdCtx.getCallerPrincipal();}                                                               ");
        printStream.println("   public java.util.Properties getEnvironment() {return mdCtx.getEnvironment();}                                                                          ");
        printStream.println("   public javax.ejb.EJBHome getEJBHome() {return mdCtx.getEJBHome();}                                                                                     ");
        printStream.println("   public javax.ejb.EJBLocalHome getEJBLocalHome() {return mdCtx.getEJBLocalHome();}                                                                      ");
        printStream.println("   public boolean isCallerInRole(java.security.Identity role) {return mdCtx.isCallerInRole(role);}                                                        ");
        printStream.println("   public boolean isCallerInRole(java.lang.String roleName) {return mdCtx.isCallerInRole(roleName);}                                                      ");
        printStream.println("   public javax.transaction.UserTransaction getUserTransaction() throws java.lang.IllegalStateException {return mdCtx.getUserTransaction();}              ");
        printStream.println("   public void setRollbackOnly() throws java.lang.IllegalStateException {mdCtx.setRollbackOnly();}                                                        ");
        printStream.println("   public boolean getRollbackOnly() throws java.lang.IllegalStateException {return mdCtx.getRollbackOnly();}                                              ");
        printStream.println("   public javax.ejb.EJBLocalObject getEJBLocalObject() throws java.lang.IllegalStateException {throw new java.lang.IllegalStateException(\"Is an MDB\");} ");
        printStream.println("   public javax.ejb.EJBObject getEJBObject() throws java.lang.IllegalStateException {throw new java.lang.IllegalStateException(\"Is an MDB\");}           ");
        printStream.println(" }                                                                                                                                                        ");
        printStream.println("}                                                                                                                                                         ");
        printStream.flush();
        printStream.close();
    }

    private void compile(String string, String string2, String string3) throws Exception {
        try {
            Object object;
            if (string.startsWith(string2 + File.separator)) {
                string = string.substring(string2.length() + 1);
            }
            File file = new File(string3);
            String string4 = System.getProperty("JAVA_HOME");
            string4 = string4 == null ? "" : string4 + File.separator + "bin" + File.separator;
            String string5 = string4 + "javac";
            String string6 = "-extdirs";
            String string7 = System.getProperty("ws.ext.dirs");
            if (this.utilityJARDir != null) {
                object = new File(this.utilityJARDir);
                string7 = string7 + ((File)object).getCanonicalPath() + ";";
            }
            object = "-classpath";
            String string8 = File.pathSeparator + file.getCanonicalPath();
            String[] stringArray = new String[]{string5, string6, string7, object, string8, string};
            String string9 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string9 = string9 + stringArray[i] + " ";
            }
            this.log(MigrateMB.getMessage("MB2MDBVerbose18", new Object[]{string}));
            this.log(string9);
            File file2 = new File(string2);
            Process process = Runtime.getRuntime().exec(stringArray, null, file2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new SequenceInputStream(process.getErrorStream(), process.getInputStream())));
            String string10 = null;
            while ((string10 = bufferedReader.readLine()) != null) {
                this.log(string10);
            }
            process.waitFor();
            Integer n = new Integer(process.exitValue());
            this.log("rc = " + n);
            if (n != 0) {
                this.error(MigrateMB.getMessage("MB2MDBCompileError", new Object[]{n.toString()}));
                System.exit(n);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mbmigrator.MigrateMB.compile", "766", this);
            throw exception;
        }
    }

    private void constructJarFile(Vector vector, String string, String string2, String string3) throws Exception {
        try {
            Object object;
            Object object2;
            Object object3;
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(string2));
            JarFile jarFile = new JarFile(string);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                object3 = enumeration.nextElement();
                if (((ZipEntry)object3).getName().equals(EJB_DD) || ((ZipEntry)object3).getName().equals(EJB_BND) || ((ZipEntry)object3).getName().equals(EJB_EXT)) continue;
                jarOutputStream.putNextEntry((ZipEntry)object3);
                object2 = jarFile.getInputStream((ZipEntry)object3);
                object = new byte[1000];
                while ((n = ((InputStream)object2).read((byte[])object)) > 0) {
                    jarOutputStream.write((byte[])object, 0, n);
                }
                ((InputStream)object2).close();
                jarOutputStream.closeEntry();
            }
            jarFile.close();
            object3 = vector.iterator();
            while (object3.hasNext()) {
                int n;
                object2 = (String)object3.next();
                Object object4 = object2;
                if (((String)object4).startsWith(string3 + File.separator)) {
                    object4 = ((String)object2).substring(string3.length() + 1);
                }
                object = new FileInputStream((String)object2);
                JarEntry jarEntry = new JarEntry(((String)object4).replace('\\', '/'));
                jarOutputStream.putNextEntry(jarEntry);
                byte[] byArray = new byte[1000];
                while ((n = ((FileInputStream)object).read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n);
                }
                ((FileInputStream)object).close();
                jarOutputStream.closeEntry();
            }
            jarOutputStream.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mbmigrator.MigrateMB.constructJarFile", "838", this);
            throw exception;
        }
    }

    private void constructEarFile(Vector vector, String string, String string2, String string3) throws Exception {
        try {
            Object object;
            Object object2;
            Object object3;
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(string2));
            JarFile jarFile = new JarFile(string);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                object3 = enumeration.nextElement();
                if (vector.contains(string3 + File.separator + ((ZipEntry)object3).getName())) continue;
                jarOutputStream.putNextEntry((ZipEntry)object3);
                object2 = jarFile.getInputStream((ZipEntry)object3);
                object = new byte[1000];
                while ((n = ((InputStream)object2).read((byte[])object)) > 0) {
                    jarOutputStream.write((byte[])object, 0, n);
                }
                ((InputStream)object2).close();
                jarOutputStream.closeEntry();
            }
            jarFile.close();
            object3 = vector.iterator();
            while (object3.hasNext()) {
                int n;
                object2 = (String)object3.next();
                Object object4 = object2;
                if (((String)object4).startsWith(string3 + File.separator)) {
                    object4 = ((String)object2).substring(string3.length() + 1);
                }
                object = new FileInputStream((String)object2);
                JarEntry jarEntry = new JarEntry(((String)object4).replace('\\', '/'));
                jarOutputStream.putNextEntry(jarEntry);
                byte[] byArray = new byte[1000];
                while ((n = ((FileInputStream)object).read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n);
                }
                ((FileInputStream)object).close();
                jarOutputStream.closeEntry();
            }
            jarOutputStream.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mbmigrator.MigrateMB.constructEarFile", "908", this);
            throw exception;
        }
    }

    private void cleanup() {
        File file;
        String string;
        Iterator iterator = this.tempFiles.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            file = new File(string);
            try {
                if (file.delete()) continue;
                this.log(MigrateMB.getMessage("MB2MDBVerbose19", new Object[]{string}));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.cleanup", "937", this);
                this.log(MigrateMB.getMessage("MB2MDBVerbose19", new Object[]{string}));
                throwable.printStackTrace();
            }
        }
        iterator = this.tempDirs.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            file = new File(string);
            try {
                if (file.delete()) continue;
                this.log(MigrateMB.getMessage("MB2MDBVerbose20", new Object[]{string}));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MigrateMB.cleanup", "957", this);
                this.log(MigrateMB.getMessage("MB2MDBVerbose20", new Object[]{string}));
                throwable.printStackTrace();
            }
        }
    }

    private String getPackageName(String string) {
        return string.substring(0, string.lastIndexOf(46));
    }

    private String getShortName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private String MBMDBWrapperName(String string) {
        String string2 = new String(string + "MBMDBWrapper");
        return string2;
    }

    private void log(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    private void error(String string) {
        System.out.println(string);
    }

    private static String getMessage(String string, Object[] objectArray) {
        if (msgBundle == null) {
            msgBundle = ResourceBundle.getBundle("com.ibm.ejs.jms.messaging");
        }
        String string2 = msgBundle.getString(string);
        if (objectArray != null) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

