/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public abstract class JMSWrapMessageConsumer {
    protected MessageConsumer consumer = null;
    protected JMSWrapSession parentSession;
    protected boolean closed = false;
    protected boolean consumerType;
    protected static TraceComponent tc = Tr.register((String)(class$com$ibm$ejs$jms$mq$JMSWrapMessageConsumer == null ? (class$com$ibm$ejs$jms$mq$JMSWrapMessageConsumer = JMSWrapMessageConsumer.class$("com.ibm.ejs.jms.mq.JMSWrapMessageConsumer")) : class$com$ibm$ejs$jms$mq$JMSWrapMessageConsumer).getName(), (String)"Messaging");
    protected String messageSelector = null;
    protected MessageListener messageListener = null;
    static /* synthetic */ Class class$com$ibm$ejs$jms$mq$JMSWrapMessageConsumer;

    JMSWrapMessageConsumer(JMSWrapSession jMSWrapSession) {
        Tr.entry((TraceComponent)tc, (String)"JMSWrapMessageConsumer constructor", (Object)jMSWrapSession);
        this.parentSession = jMSWrapSession;
        Tr.exit((TraceComponent)tc, (String)"JMSWrapMessageConsumer constructor");
    }

    JMSWrapMessageConsumer(JMSWrapSession jMSWrapSession, String string) {
        this(jMSWrapSession);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSWrapMessageConsumer constructor", (Object)new Object[]{jMSWrapSession, string});
        }
        this.messageSelector = string;
        Tr.exit((TraceComponent)tc, (String)"JMSWrapMessageConsumer constructor");
    }

    public void close() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"close");
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageConsumer.close", "115", this);
            Tr.event((TraceComponent)tc, (String)"JMSException in close: ", (Object)((Object)jMSException));
            Exception exception = jMSException.getLinkedException();
            while (exception != null) {
                Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                if (exception instanceof JMSException) {
                    exception = ((JMSException)((Object)exception)).getLinkedException();
                    continue;
                }
                exception = null;
            }
            throw jMSException;
        }
        finally {
            Tr.exit((TraceComponent)tc, (String)"close");
            this.closed = true;
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"setMessageListener");
        IllegalStateException illegalStateException = new IllegalStateException("Method Not Allowed Exception");
        Tr.event((TraceComponent)tc, (String)"JMSException in setMessageListener: ", (Object)((Object)illegalStateException));
        Tr.exit((TraceComponent)tc, (String)"setMessageListener");
        throw illegalStateException;
    }

    public MessageListener getMessageListener() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"getMessageListener");
        IllegalStateException illegalStateException = new IllegalStateException("Method Not Allowed Exception");
        Tr.event((TraceComponent)tc, (String)"JMSException in getMessageListener: ", (Object)((Object)illegalStateException));
        Tr.exit((TraceComponent)tc, (String)"getMessageListener");
        throw illegalStateException;
    }

    public String getMessageSelector() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"getMessageSelector");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in getMessageSelector: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"getMessageSelector");
            throw illegalStateException;
        }
        Tr.exit((TraceComponent)tc, (String)"getMessageSelector", (Object)this.messageSelector);
        return this.messageSelector;
    }

    public MessageListener internalGetMessageListener() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"internalGetMessageListener");
        Tr.exit((TraceComponent)tc, (String)"internalGetMessageListener", (Object)this.messageListener);
        return this.messageListener;
    }

    public void internalSetMessageListener(MessageListener messageListener) throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"internalSetMessageListener", (Object)messageListener);
        if (this.consumer != null) {
            try {
                this.consumer.setMessageListener(messageListener);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageConsumer.internalSetMessageListener", "225", this);
                Tr.event((TraceComponent)tc, (String)"JMSException in internalSetMessageListener: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                Tr.exit((TraceComponent)tc, (String)"internalSetMessageListener");
                throw jMSException;
            }
        }
        this.messageListener = messageListener;
        Tr.exit((TraceComponent)tc, (String)"internalSetMessageListener");
    }

    protected void initialiseConsumer() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"initialiseConsumer", (Object)this.consumer);
        if (this.messageListener != null) {
            try {
                this.consumer.setMessageListener(this.messageListener);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageConsumer.initialiseConsumer", "259", this);
                Tr.event((TraceComponent)tc, (String)"JMSException in initialiseConsumer: ", (Object)((Object)jMSException));
                Tr.exit((TraceComponent)tc, (String)"initialiseConsumer");
                throw jMSException;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"initialiseConsumer");
    }

    protected void setupConsumer() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"setupConsumer");
        try {
            boolean bl;
            if (this.isClosed()) {
                throw new IllegalStateException("Closed");
            }
            int n = JMSWrapSession.getCurrentTransactionType();
            boolean bl2 = bl = n == JMSWrapSession.GLOBAL_TRANSACTION;
            if (this.consumer == null || this.consumerType != bl) {
                if (this.consumer != null) {
                    this.consumer.close();
                    this.consumer = null;
                }
                this.consumer = this.createMessageConsumer(bl);
                this.initialiseConsumer();
                this.consumerType = bl;
            }
            this.parentSession.handleTransaction(n);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageConsumer.setupConsumer", "313", this);
            Tr.event((TraceComponent)tc, (String)"JMSException in setupConsumer: ", (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            Tr.exit((TraceComponent)tc, (String)"setupConsumer");
        }
    }

    boolean isClosed() {
        return this.closed || this.parentSession.isClosed();
    }

    protected abstract MessageConsumer createMessageConsumer(boolean var1) throws JMSException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

