/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageProducer;

public abstract class JMSWrapMessageProducer {
    protected MessageProducer producer = null;
    protected JMSWrapSession parentSession;
    protected boolean closed = false;
    protected boolean producerType;
    protected static int UNSET_DELIVERY_MODE = -1;
    protected int deliveryMode = UNSET_DELIVERY_MODE;
    protected boolean disableMessageID = false;
    protected boolean disableMessageTimestamp = false;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected static TraceComponent tc = Tr.register((String)(class$com$ibm$ejs$jms$mq$JMSWrapMessageProducer == null ? (class$com$ibm$ejs$jms$mq$JMSWrapMessageProducer = JMSWrapMessageProducer.class$("com.ibm.ejs.jms.mq.JMSWrapMessageProducer")) : class$com$ibm$ejs$jms$mq$JMSWrapMessageProducer).getName(), (String)"Messaging");
    static /* synthetic */ Class class$com$ibm$ejs$jms$mq$JMSWrapMessageProducer;

    JMSWrapMessageProducer(JMSWrapSession jMSWrapSession) {
        Tr.entry((TraceComponent)tc, (String)"JMSWrapMessageProducer constructor", (Object)jMSWrapSession);
        this.parentSession = jMSWrapSession;
        Tr.exit((TraceComponent)tc, (String)"JMSWrapMessageProducer constructor");
    }

    public void close() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"close");
        try {
            if (this.producer != null) {
                this.producer.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.close", "110", this);
            Tr.event((TraceComponent)tc, (String)"JMSException in close: ", (Object)((Object)jMSException));
            Exception exception = jMSException.getLinkedException();
            while (exception != null) {
                Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                if (exception instanceof JMSException) {
                    exception = ((JMSException)((Object)exception)).getLinkedException();
                    continue;
                }
                exception = null;
            }
            throw jMSException;
        }
        finally {
            this.closed = true;
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDeliveryMode() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDeliveryMode");
        }
        int n = UNSET_DELIVERY_MODE;
        try {
            try {
                this.setupProducer();
                n = this.producer.getDeliveryMode();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.getDeliveryMode", "146", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in getDeliveryMode: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getDeliveryMode", (Object)new Integer(n));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return n;
        Tr.exit((TraceComponent)tc, (String)"getDeliveryMode", (Object)new Integer(n));
        return n;
    }

    public boolean getDisableMessageID() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"getDisableMessageID");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in getDisableMessageID: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"getDisableMessageID");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDisableMessageID", (Object)new Boolean(this.disableMessageID));
        }
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"getDisableMessageTimestamp");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in getDisableMessageTimestamp: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"getDisableMessageTimestamp");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDisableMessageTimestamp", (Object)new Boolean(this.disableMessageTimestamp));
        }
        return this.disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"getPriority");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in getPriority: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"getPriority");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this.priority));
        }
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"getTimeToLive");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in getTimeToLive: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"getTimeToLive");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTimeToLive", (Object)new Long(this.timeToLive));
        }
        return this.timeToLive;
    }

    public void setDeliveryMode(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDeliveryMode", (Object)new Integer(n));
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in setDeliveryMode: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"setDeliveryMode");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setDeliveryMode(n);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setDeliveryMode", "294", this);
                Tr.event((TraceComponent)tc, (String)"JMSException in setDeliveryMode: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                Tr.exit((TraceComponent)tc, (String)"setDeliveryMode");
                throw jMSException;
            }
        }
        this.deliveryMode = n;
        Tr.exit((TraceComponent)tc, (String)"setDeliveryMode");
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDisableMessageID", (Object)new Boolean(bl));
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in setDisableMessageID: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"setDisableMessageID");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setDisableMessageID(bl);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setDisableMessageID", "339", this);
                Tr.event((TraceComponent)tc, (String)"JMSException in setDisableMessageID: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                Tr.exit((TraceComponent)tc, (String)"setDisableMessageID");
                throw jMSException;
            }
        }
        this.disableMessageID = bl;
        Tr.exit((TraceComponent)tc, (String)"setDisableMessageID");
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"setDissableMessageTimestamp", (Object)new Boolean(bl));
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in setDisableMessageTimestamp: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"setDisableMessageTimestamp");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setDisableMessageTimestamp(bl);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setDisableMessageTimestamp", "383", this);
                Tr.event((TraceComponent)tc, (String)"JMSException in setDisableMessageTimestamp: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                Tr.exit((TraceComponent)tc, (String)"setDisableMessageTimestamp");
                throw jMSException;
            }
        }
        this.disableMessageTimestamp = bl;
        Tr.exit((TraceComponent)tc, (String)"setDisableMessageTimestamp");
    }

    public void setPriority(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPriority", (Object)new Integer(n));
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in setPriority: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"setPriority");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setPriority(n);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setPriority", "427", this);
                Tr.event((TraceComponent)tc, (String)"JMSException in setPriority: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                Tr.exit((TraceComponent)tc, (String)"setPriority");
                throw jMSException;
            }
        }
        this.priority = n;
        Tr.exit((TraceComponent)tc, (String)"setPriority");
    }

    public void setTimeToLive(long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeToLive", (Object)new Long(l));
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event((TraceComponent)tc, (String)"JMSException in setTimeToLive: ", (Object)((Object)illegalStateException));
            Tr.exit((TraceComponent)tc, (String)"setTimeToLive");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setTimeToLive(l);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setTimeToLive", "472", this);
                Tr.event((TraceComponent)tc, (String)"JMSException in setTimeToLive: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                Tr.exit((TraceComponent)tc, (String)"setTimeToLive");
                throw jMSException;
            }
        }
        this.timeToLive = l;
        Tr.exit((TraceComponent)tc, (String)"setTimeToLive");
    }

    protected void initialiseProducer() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"initialiseProducer");
        try {
            if (this.deliveryMode != UNSET_DELIVERY_MODE) {
                this.producer.setDeliveryMode(this.deliveryMode);
            }
            this.producer.setDisableMessageID(this.disableMessageID);
            this.producer.setDisableMessageTimestamp(this.disableMessageTimestamp);
            this.producer.setPriority(this.priority);
            this.producer.setTimeToLive(this.timeToLive);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.initialiseProducer", "511", this);
            Tr.event((TraceComponent)tc, (String)"JMSException in initialiseProducer: ", (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            Tr.exit((TraceComponent)tc, (String)"initialiseProducer");
        }
    }

    protected void setupProducer() throws JMSException {
        Tr.entry((TraceComponent)tc, (String)"setupProducer");
        try {
            boolean bl;
            if (this.isClosed()) {
                throw new IllegalStateException("Closed");
            }
            int n = JMSWrapSession.getCurrentTransactionType();
            boolean bl2 = bl = n == JMSWrapSession.GLOBAL_TRANSACTION;
            if (this.producer == null || this.producerType != bl) {
                if (this.producer != null) {
                    this.producer.close();
                    this.producer = null;
                }
                this.producer = this.createMessageProducer(bl);
                this.initialiseProducer();
                this.producerType = bl;
            }
            this.parentSession.handleTransaction(n);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setupProducer", "565", this);
            Tr.event((TraceComponent)tc, (String)"JMSException in setupProducer: ", (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            Tr.exit((TraceComponent)tc, (String)"setupProducer");
        }
    }

    boolean isClosed() {
        return this.closed || this.parentSession.isClosed();
    }

    protected abstract MessageProducer createMessageProducer(boolean var1) throws JMSException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

