/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.EnlistableResource;
import com.ibm.ejs.jms.mq.JMSWrapConnection;
import com.ibm.ejs.jms.mq.JMSXAResourceInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.MQXAResource;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.ws.LocalTransaction.LTCSystemException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class JMSWrapSession
implements EnlistableResource {
    protected boolean transacted;
    protected int acknowledgeMode;
    protected boolean closed = false;
    protected boolean enlistedOnePhase = false;
    protected OnePhaseXAResource onePhaseXAResource = null;
    protected boolean enlistedTwoPhase = false;
    protected Transaction transaction = null;
    protected boolean registeredTwoPhase = false;
    protected Session transactedSession = null;
    protected Session nonTransactedSession = null;
    protected XASession xaSession = null;
    protected Session sessionFromXASession = null;
    protected JMSWrapConnection parentConnection;
    protected boolean xaCapable;
    protected List temporaryDestinations = new ArrayList();
    protected List messageConsumers = new ArrayList();
    protected List messageProducers = new ArrayList();
    static int NO_TRANSACTION = 0;
    static int LOCAL_TRANSACTION = 1;
    static int GLOBAL_TRANSACTION = 2;
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ejs$jms$mq$JMSWrapSession == null ? (class$com$ibm$ejs$jms$mq$JMSWrapSession = JMSWrapSession.class$("com.ibm.ejs.jms.mq.JMSWrapSession")) : class$com$ibm$ejs$jms$mq$JMSWrapSession).getName(), (String)"Messaging");
    static /* synthetic */ Class class$com$ibm$ejs$jms$mq$JMSWrapSession;

    public JMSWrapSession(JMSWrapConnection jMSWrapConnection, boolean bl, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JMSWrapSession constructor", (Object)new Object[]{jMSWrapConnection, new Boolean(bl), new Integer(n)});
        }
        this.parentConnection = jMSWrapConnection;
        this.transacted = bl;
        this.acknowledgeMode = n;
        this.xaCapable = jMSWrapConnection.isXACapable();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"JMSWrapSession constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        try {
            try {
                if (!this.closed) {
                    if (this.parentConnection.removeSession(this)) {
                        this._close();
                    }
                    this.closed = true;
                }
                this.closeChildren();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.close", "200", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in close: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"close");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"close");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BytesMessage createBytesMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createBytesMessage");
        }
        BytesMessage bytesMessage = null;
        try {
            try {
                bytesMessage = this.getAnySession().createBytesMessage();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createBytesMessage", "236", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in createBytesMessage: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createBytesMessage", (Object)"Message contents not traced");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return bytesMessage;
        Tr.exit((TraceComponent)tc, (String)"createBytesMessage", (Object)"Message contents not traced");
        return bytesMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapMessage createMapMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMapMessage");
        }
        MapMessage mapMessage = null;
        try {
            try {
                mapMessage = this.getAnySession().createMapMessage();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createMapMessage", "274", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in createMapMessage: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createMapMessage", (Object)"Message contents not traced");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return mapMessage;
        Tr.exit((TraceComponent)tc, (String)"createMapMessage", (Object)"Message contents not traced");
        return mapMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message createMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createMessage");
        }
        Message message = null;
        try {
            try {
                message = this.getAnySession().createMessage();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createMessage", "312", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in createMessage: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createMessage", (Object)"Message contents not traced");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return message;
        Tr.exit((TraceComponent)tc, (String)"createMessage", (Object)"Message contents not traced");
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMessage createObjectMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createObjectMessage");
        }
        ObjectMessage objectMessage = null;
        try {
            try {
                objectMessage = this.getAnySession().createObjectMessage();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createObjectMessage", "350", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in createObjectMessage: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createObjectMessage", (Object)"Message contents not traced");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return objectMessage;
        Tr.exit((TraceComponent)tc, (String)"createObjectMessage", (Object)"Message contents not traced");
        return objectMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createObjectMessage", (Object)serializable);
        }
        ObjectMessage objectMessage = null;
        try {
            try {
                objectMessage = this.getAnySession().createObjectMessage(serializable);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createObjectMessage", "389", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in createObjectMessage: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createObjectMessage", (Object)"Message contents not traced");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return objectMessage;
        Tr.exit((TraceComponent)tc, (String)"createObjectMessage", (Object)"Message contents not traced");
        return objectMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamMessage createStreamMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStreamMessage");
        }
        StreamMessage streamMessage = null;
        try {
            try {
                streamMessage = this.getAnySession().createStreamMessage();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createStreamMessage", "428", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in createStreamMessage: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createStreamMessage", (Object)"Message contents not traced");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return streamMessage;
        Tr.exit((TraceComponent)tc, (String)"createStreamMessage", (Object)"Message contents not traced");
        return streamMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextMessage createTextMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTextMessage");
        }
        TextMessage textMessage = null;
        try {
            try {
                textMessage = this.getAnySession().createTextMessage();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createTextMessage", "466", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in createTextMessage: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createTextMessage", (Object)"Message contents not traced");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return textMessage;
        Tr.exit((TraceComponent)tc, (String)"createTextMessage", (Object)"Message contents not traced");
        return textMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextMessage createTextMessage(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTextMessage", (Object)string);
        }
        TextMessage textMessage = null;
        try {
            try {
                textMessage = this.getAnySession().createTextMessage(string);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createTextMessage", "504", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in createTextMessage: ", (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                while (exception != null) {
                    Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
                throw jMSException;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"createTextMessage", (Object)"Message contents not traced");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return textMessage;
        Tr.exit((TraceComponent)tc, (String)"createTextMessage", (Object)"Message contents not traced");
        return textMessage;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessageListener");
        }
        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("Method Not Allowed Exception");
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"JMSException in getMessageListener: ", (Object)((Object)illegalStateException));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMessageListener");
        }
        throw illegalStateException;
    }

    /*
     * Unable to fully structure code
     */
    public boolean getTransacted() throws JMSException {
        if (JMSWrapSession.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)JMSWrapSession.tc, (String)"getTransacted");
        }
        if (this.closed) {
            var1_1 = new javax.jms.IllegalStateException("Closed");
            if (JMSWrapSession.tc.isEventEnabled()) {
                Tr.event((TraceComponent)JMSWrapSession.tc, (String)"JMSException in getTransacted: ", (Object)var1_1);
            }
            if (JMSWrapSession.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)JMSWrapSession.tc, (String)"getTransacted");
            }
            throw var1_1;
        }
        if (!this.transacted) ** GOTO lbl-1000
        if (!this.isGlobalTransactionActive()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_2 = false;
        }
        if (JMSWrapSession.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)JMSWrapSession.tc, (String)"getTransacted", (Object)new Boolean(var1_2));
        }
        return var1_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recover() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover");
        }
        try {
            block9: {
                try {
                    if (this.closed) {
                        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("Closed");
                        throw illegalStateException;
                    }
                    if (this.transacted) throw new javax.jms.IllegalStateException("Method not allowed Exception");
                    if (this.isGlobalTransactionActive()) {
                        throw new javax.jms.IllegalStateException("Method not allowed Exception");
                    }
                    Session session = this.getNonXASession();
                    if (session == null) break block9;
                    session.recover();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.recover", "623", this);
                    if (!tc.isEventEnabled()) throw jMSException;
                    Tr.event((TraceComponent)tc, (String)"JMSException in recover: ", (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    while (exception != null) {
                        Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                        if (exception instanceof JMSException) {
                            exception = ((JMSException)((Object)exception)).getLinkedException();
                            continue;
                        }
                        exception = null;
                    }
                    throw jMSException;
                }
            }
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"recover");
            return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"recover");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit");
        }
        try {
            block10: {
                try {
                    if (this.closed) {
                        throw new javax.jms.IllegalStateException("Closed");
                    }
                    if (this.isGlobalTransactionActive()) {
                        throw new TransactionInProgressException("Attempt to call session.commit() in a global transaction");
                    }
                    if (!this.transacted) {
                        throw new javax.jms.IllegalStateException("Method not allowed exception");
                    }
                    Session session = this.getNonXASession();
                    if (session == null) break block10;
                    session.commit();
                    this.delistFromLocalTransaction();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.commit", "684", this);
                    if (!tc.isEventEnabled()) throw jMSException;
                    Tr.event((TraceComponent)tc, (String)"JMSException in commit: ", (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    while (exception != null) {
                        Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                        if (exception instanceof JMSException) {
                            exception = ((JMSException)((Object)exception)).getLinkedException();
                            continue;
                        }
                        exception = null;
                    }
                    throw jMSException;
                }
            }
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"commit");
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"commit");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback");
        }
        try {
            block10: {
                try {
                    if (this.closed) {
                        throw new javax.jms.IllegalStateException("Closed");
                    }
                    if (this.isGlobalTransactionActive()) {
                        throw new TransactionInProgressException("Attempt to call session.rollback() in a global transaction");
                    }
                    if (!this.transacted) {
                        throw new javax.jms.IllegalStateException("Method not allowed exception");
                    }
                    Session session = this.getNonXASession();
                    if (session == null) break block10;
                    session.rollback();
                    this.delistFromLocalTransaction();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.rollback", "745", this);
                    if (!tc.isEventEnabled()) throw jMSException;
                    Tr.event((TraceComponent)tc, (String)"JMSException in rollback: ", (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    while (exception != null) {
                        Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                        if (exception instanceof JMSException) {
                            exception = ((JMSException)((Object)exception)).getLinkedException();
                            continue;
                        }
                        exception = null;
                    }
                    throw jMSException;
                }
            }
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"rollback");
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"rollback");
            throw throwable;
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("Method not allowed exception");
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"JMSException in run: ", (Object)((Object)illegalStateException));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMessageListener", (Object)messageListener);
        }
        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("Method Not Allowed Exception");
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"JMSException in setMessageListener: ", (Object)((Object)illegalStateException));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMessageListener");
        }
        throw illegalStateException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void internalSetMessageListener(MessageListener messageListener) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalSetMessageListener", (Object)messageListener);
        }
        try {
            block8: {
                try {
                    Session session = this.getNonXASession();
                    if (session != null) {
                        session.setMessageListener(messageListener);
                        break block8;
                    }
                    if (this.sessionFromXASession == null) break block8;
                    this.sessionFromXASession.setMessageListener(messageListener);
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.internalSetMessageListener", "848", this);
                    if (!tc.isEventEnabled()) throw jMSException;
                    Tr.event((TraceComponent)tc, (String)"JMSException in internalSetMessageListener: ", (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    while (exception != null) {
                        Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                        if (exception instanceof JMSException) {
                            exception = ((JMSException)((Object)exception)).getLinkedException();
                            continue;
                        }
                        exception = null;
                    }
                    throw jMSException;
                }
            }
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"internalSetMessageListener");
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"internalSetMessageListener");
            throw throwable;
        }
    }

    public void enlist() throws JMSException {
        this.handleTransaction(this.getCurrentTransactionType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session getSession(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSession", (Object)new Boolean(bl));
        }
        Session session = null;
        try {
            block15: {
                try {
                    if (this.closed) {
                        throw new javax.jms.IllegalStateException("Attempt to use closed session");
                    }
                    if (bl) {
                        Session session2;
                        if (this.enlistedOnePhase && (session2 = this.getNonXASession()) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Committing outstanding local transaction work before starting global transaction work");
                            }
                            session2.commit();
                            this.delistFromLocalTransaction();
                        }
                        if (this.xaCapable) {
                            if (this.xaSession == null) {
                                this.xaSession = this.createXASession();
                                this.sessionFromXASession = this.retrieveSessionFromXASession(this.xaSession);
                            }
                            session = this.sessionFromXASession;
                            break block15;
                        } else {
                            if (this.transactedSession == null) {
                                this.transactedSession = this.createNonXASession(true, this.acknowledgeMode);
                            }
                            session = this.transactedSession;
                        }
                        break block15;
                    }
                    if (this.enlistedTwoPhase) {
                        throw new javax.jms.IllegalStateException("Attempt to use session outside of global transaction with which it is enlisted");
                    }
                    session = this.getNonXASession();
                    if (session != null) break block15;
                    if (this.transacted) {
                        session = this.transactedSession = this.createNonXASession(this.transacted, this.acknowledgeMode);
                        break block15;
                    }
                    session = this.nonTransactedSession = this.createNonXASession(this.transacted, this.acknowledgeMode);
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.getSession", "976", this);
                    if (!tc.isEventEnabled()) throw jMSException;
                    Tr.event((TraceComponent)tc, (String)"JMSException in getSession: ", (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var5_5 = null;
            if (!tc.isEntryEnabled()) return session;
            Tr.exit((TraceComponent)tc, (String)"getSession", (Object)session);
            return session;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getSession", (Object)session);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void _close() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_close");
        }
        boolean bl = true;
        boolean bl2 = true;
        try {
            try {
                if (this.enlistedOnePhase) {
                    if (this.onePhaseXAResource == null) {
                        this.enlistedOnePhase = false;
                        this.getNonXASession().commit();
                    } else {
                        bl2 = false;
                    }
                } else if (this.enlistedTwoPhase) {
                    if (this.xaCapable) {
                        bl = false;
                    } else {
                        bl2 = false;
                    }
                }
                if (bl2 && this.transactedSession != null) {
                    this.transactedSession.close();
                    this.transactedSession = null;
                }
                if (this.nonTransactedSession != null) {
                    this.nonTransactedSession.close();
                    this.nonTransactedSession = null;
                }
                if (this.sessionFromXASession != null) {
                    this.sessionFromXASession.close();
                    this.sessionFromXASession = null;
                }
                if (bl && this.xaSession != null) {
                    this.xaSession.close();
                    this.xaSession = null;
                }
                this.closed = true;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession._close", "1078", this);
                if (!tc.isEventEnabled()) throw jMSException;
                Tr.event((TraceComponent)tc, (String)"JMSException in _close: ", (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"_close");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"_close");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleTransaction(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleTransaction", (Object)new Integer(n));
        }
        try {
            block9: {
                try {
                    if (n == GLOBAL_TRANSACTION) {
                        this.enlistWithGlobalTransaction();
                        break block9;
                    }
                    if (!this.transacted) break block9;
                    if (n == LOCAL_TRANSACTION) {
                        if (ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData() instanceof EJBComponentMetaData) {
                            this.enlistWithLocalTransaction();
                            break block9;
                        } else {
                            this.enlistedOnePhase = true;
                        }
                        break block9;
                    }
                    this.enlistedOnePhase = true;
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.handleTransaction", "1147", this);
                    if (!tc.isEventEnabled()) throw jMSException;
                    Tr.event((TraceComponent)tc, (String)"JMSException in handleTransaction: ", (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var4_2 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"handleTransaction");
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"handleTransaction");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Session getAnySession() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAnySession");
        }
        Session session = null;
        try {
            block7: {
                try {
                    if (this.closed) {
                        throw new javax.jms.IllegalStateException("Attempt to use closed session");
                    }
                    session = this.getNonXASession();
                    if (session != null) break block7;
                    if (this.sessionFromXASession != null) {
                        session = this.sessionFromXASession;
                        break block7;
                    }
                    session = this.getSession(this.isGlobalTransactionActive());
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.getAnySession", "1208", this);
                    if (!tc.isEventEnabled()) throw jMSException;
                    Tr.event((TraceComponent)tc, (String)"JMSException in getAnySession: ", (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var4_2 = null;
            if (!tc.isEntryEnabled()) return session;
            Tr.exit((TraceComponent)tc, (String)"getAnySession", (Object)session);
            return session;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"getAnySession", (Object)session);
            throw throwable;
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    boolean isEnlistedTwoPhase() {
        return this.enlistedTwoPhase;
    }

    Session getNonXASession() {
        Session session = this.transacted ? this.transactedSession : this.nonTransactedSession;
        return session;
    }

    static boolean isGlobalTransactionActive() throws JMSException {
        return JMSWrapSession.getCurrentTransactionType() == GLOBAL_TRANSACTION;
    }

    static int getCurrentTransactionType() throws JMSException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCurrentTransactionType");
        }
        switch (TransactionManagerFactory.getUOWCurrent().getUOWType()) {
            case 2: {
                n = GLOBAL_TRANSACTION;
                break;
            }
            case 1: {
                n = LOCAL_TRANSACTION;
                break;
            }
            default: {
                n = NO_TRANSACTION;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCurrentTransactionType", (Object)new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void enlistWithGlobalTransaction() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlistWithGlobalTransaction");
        }
        WebSphereTransactionManager webSphereTransactionManager = TransactionManagerFactory.getTransactionManager();
        try {
            Transaction transaction;
            try {
                transaction = webSphereTransactionManager.getTransaction();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1377", this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"SystemException from getTransaction", (Object)((Object)systemException));
                }
                javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("SystemException");
                illegalStateException.setLinkedException((Exception)((Object)systemException));
                throw illegalStateException;
            }
            if (this.enlistedTwoPhase) {
                if (!this.transaction.equals(transaction)) {
                    throw new javax.jms.IllegalStateException("Attempt to use JMSWrapSession in global transaction while still active in another global transaction");
                }
            } else {
                if (!this.registeredTwoPhase) {
                    try {
                        transaction.registerSynchronization((javax.transaction.Synchronization)new Synchronization());
                        this.registeredTwoPhase = true;
                    }
                    catch (RollbackException rollbackException) {
                        FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1388", this);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"RollbackException from register", (Object)((Object)rollbackException));
                        }
                        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("RollbackException");
                        illegalStateException.setLinkedException((Exception)((Object)rollbackException));
                        throw illegalStateException;
                    }
                    catch (SystemException systemException) {
                        FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1400", this);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"SystemException from register", (Object)((Object)systemException));
                        }
                        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("SystemException");
                        illegalStateException.setLinkedException((Exception)((Object)systemException));
                        throw illegalStateException;
                    }
                }
                try {
                    Object object;
                    if (this.xaCapable) {
                        object = this.xaSession.getXAResource();
                    } else {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Using OnePhaseXAResource for last agent optimization");
                        }
                        object = new OnePhaseXAResource();
                        this.parentConnection.incrementSessionCount();
                    }
                    if (object instanceof MQXAResource) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Enlisting MQ XAResource");
                        }
                        String string = ((MQXAResource)object).getResourceString();
                        JMSXAResourceInfo jMSXAResourceInfo = new JMSXAResourceInfo(string);
                        webSphereTransactionManager.enlist((XAResource)object, "com.ibm.ejs.jms.mq.JMSXAResourceFactory", (XAResourceInfo)jMSXAResourceInfo);
                    } else {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Enlisting non-MQ XAResource - will not be recoverable");
                        }
                        transaction.enlistResource((XAResource)object);
                    }
                    this.transaction = transaction;
                    this.enlistedTwoPhase = true;
                }
                catch (RollbackException rollbackException) {
                    FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1460", this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"RollbackException in enlistWithGlobalTransaction", (Object)((Object)rollbackException));
                    }
                    javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("RollbackException");
                    illegalStateException.setLinkedException((Exception)((Object)rollbackException));
                    throw illegalStateException;
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1471", this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"SystemException in enlistWithGlobalTransaction", (Object)((Object)systemException));
                    }
                    javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("SystemException");
                    illegalStateException.setLinkedException((Exception)((Object)systemException));
                    throw illegalStateException;
                }
            }
            Object var7_16 = null;
        }
        catch (Throwable throwable) {
            Object var7_17 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistWithGlobalTransaction");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlistWithGlobalTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void enlistWithLocalTransaction() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlistWithLocalTransaction");
        }
        try {
            if (!this.enlistedOnePhase) {
                try {
                    LocalTransactionCoordinator localTransactionCoordinator = TransactionManagerFactory.getLocalTransactionCurrent().getLocalTranCoord();
                    this.onePhaseXAResource = new OnePhaseXAResource();
                    localTransactionCoordinator.enlistForCleanup((com.ibm.ws.Transaction.OnePhaseXAResource)this.onePhaseXAResource);
                    this.parentConnection.incrementSessionCount();
                    this.enlistedOnePhase = true;
                }
                catch (LTCSystemException lTCSystemException) {
                    FFDCFilter.processException((Throwable)lTCSystemException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithLocalTransaction", "1517", this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"LTCSystemException in enlistForCleanup", (Object)((Object)lTCSystemException));
                    }
                    javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("LTCSystemException");
                    illegalStateException.setLinkedException((Exception)((Object)lTCSystemException));
                    throw illegalStateException;
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithLocalTransaction", "1528", this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"IllegalStateException from enlistForCleanup", (Object)illegalStateException);
                    }
                    javax.jms.IllegalStateException illegalStateException2 = new javax.jms.IllegalStateException("IllegalStateException");
                    illegalStateException2.setLinkedException((Exception)illegalStateException);
                    throw illegalStateException2;
                }
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistWithLocalTransaction");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlistWithLocalTransaction");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void delistFromLocalTransaction() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delistFromLocalTransaction");
        }
        try {
            block7: {
                try {
                    if (!this.enlistedOnePhase) break block7;
                    if (this.onePhaseXAResource != null) {
                        LocalTransactionCoordinator localTransactionCoordinator = TransactionManagerFactory.getLocalTransactionCurrent().getLocalTranCoord();
                        localTransactionCoordinator.delistFromCleanup((com.ibm.ws.Transaction.OnePhaseXAResource)this.onePhaseXAResource);
                        this.parentConnection.decrementSessionCount();
                        this.onePhaseXAResource = null;
                    }
                    this.enlistedOnePhase = false;
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.jms.mq.JMSWrapSession.delistFromLocalTransaction", "1577", this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"IllegalStateException from delistFromCleanup", (Object)illegalStateException);
                    }
                    javax.jms.IllegalStateException illegalStateException2 = new javax.jms.IllegalStateException("IllegalStateException");
                    illegalStateException2.setLinkedException((Exception)illegalStateException);
                    throw illegalStateException2;
                }
            }
            Object var4_3 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"delistFromLocalTransaction");
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"delistFromLocalTransaction");
            throw throwable;
        }
    }

    public List getTemporaryDestinations() {
        return this.temporaryDestinations;
    }

    protected void closeChildren() {
        MessageConsumer messageConsumer;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeChildren");
        }
        Iterator iterator = this.messageConsumers.iterator();
        while (iterator.hasNext()) {
            messageConsumer = (MessageConsumer)iterator.next();
            try {
                messageConsumer.close();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.closeChildren", "1626", this);
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)"Caught JMSException when closing consumer", (Object)((Object)jMSException));
            }
        }
        iterator = this.messageProducers.iterator();
        while (iterator.hasNext()) {
            messageConsumer = (MessageProducer)iterator.next();
            try {
                messageConsumer.close();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.closeChildren", "1644", this);
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)"Caught JMSException when closing producer", (Object)((Object)jMSException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeChildren");
        }
    }

    protected abstract Session createNonXASession(boolean var1, int var2) throws JMSException;

    protected abstract XASession createXASession() throws JMSException;

    protected abstract Session retrieveSessionFromXASession(XASession var1) throws JMSException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OnePhaseXAResource
    implements com.ibm.ws.Transaction.OnePhaseXAResource {
        protected Xid xid = null;

        OnePhaseXAResource() {
        }

        public String getResourceName() {
            String string;
            try {
                string = new String("JMSSession, provider: " + JMSWrapSession.this.parentConnection.getMetaData().getJMSProviderName() + " " + JMSWrapSession.this.parentConnection.getMetaData().getJMSVersion());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mq.JMSWrapSession.getResourceName", "1788", this);
                string = new String("JMSSession");
            }
            return string;
        }

        public int prepare(Xid xid) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"prepare", (Object)xid);
            }
            XAException xAException = new XAException(103);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Attempt to prepare one-phase resource", (Object)xAException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw xAException;
        }

        public void commit(Xid xid, boolean bl) throws XAException {
            block21: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"commit", (Object)new Object[]{xid, new Boolean(bl)});
                }
                if (this.xid != null && !xid.equals(this.xid)) {
                    XAException xAException = new XAException(-4);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Xid passed to commit is not valid: ", (Object)xAException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"commit");
                    }
                    throw xAException;
                }
                if (!bl) {
                    XAException xAException = new XAException(-6);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Attempt to perform two-phase commit on one-phase resource", (Object)xAException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"commit");
                    }
                    throw xAException;
                }
                if (JMSWrapSession.this.transactedSession != null) {
                    try {
                        JMSWrapSession.this.transactedSession.commit();
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.commit", "1880", this);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"JMSException in commit: ", (Object)((Object)jMSException));
                            Exception exception = jMSException.getLinkedException();
                            while (exception != null) {
                                Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                                if (exception instanceof JMSException) {
                                    exception = ((JMSException)((Object)exception)).getLinkedException();
                                    continue;
                                }
                                exception = null;
                            }
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"commit");
                        }
                        throw new XAException(100);
                    }
                }
                if (JMSWrapSession.this.enlistedOnePhase) {
                    JMSWrapSession.this.parentConnection.decrementSessionCount();
                    JMSWrapSession.this.enlistedOnePhase = false;
                    JMSWrapSession.this.onePhaseXAResource = null;
                    if (JMSWrapSession.this.closed) {
                        try {
                            JMSWrapSession.this._close();
                        }
                        catch (JMSException jMSException) {
                            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.commit", "1910", this);
                            if (!tc.isEventEnabled()) break block21;
                            Tr.event((TraceComponent)tc, (String)"JMSException in commit: ", (Object)((Object)jMSException));
                            Exception exception = jMSException.getLinkedException();
                            while (exception != null) {
                                Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                                if (exception instanceof JMSException) {
                                    exception = ((JMSException)((Object)exception)).getLinkedException();
                                    continue;
                                }
                                exception = null;
                            }
                        }
                    }
                }
            }
            this.xid = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit");
            }
        }

        public void rollback(Xid xid) throws XAException {
            block17: {
                Exception exception;
                block16: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"rollback", (Object)xid);
                    }
                    if (this.xid != null && !xid.equals(this.xid)) {
                        XAException xAException = new XAException(-4);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Xid passed to rollback is not valid: ", (Object)xAException);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"rollback");
                        }
                        throw xAException;
                    }
                    if (JMSWrapSession.this.transactedSession != null) {
                        try {
                            JMSWrapSession.this.transactedSession.rollback();
                        }
                        catch (JMSException jMSException) {
                            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.rollback", "1967", this);
                            if (!tc.isEventEnabled()) break block16;
                            Tr.event((TraceComponent)tc, (String)"JMSException in rollback: ", (Object)((Object)jMSException));
                            exception = jMSException.getLinkedException();
                            while (exception != null) {
                                Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                                if (exception instanceof JMSException) {
                                    exception = ((JMSException)((Object)exception)).getLinkedException();
                                    continue;
                                }
                                exception = null;
                            }
                        }
                    }
                }
                if (JMSWrapSession.this.enlistedOnePhase) {
                    JMSWrapSession.this.parentConnection.decrementSessionCount();
                    JMSWrapSession.this.enlistedOnePhase = false;
                    JMSWrapSession.this.onePhaseXAResource = null;
                    if (JMSWrapSession.this.closed) {
                        try {
                            JMSWrapSession.this._close();
                        }
                        catch (JMSException jMSException) {
                            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.rollback", "1992", this);
                            if (!tc.isEventEnabled()) break block17;
                            Tr.event((TraceComponent)tc, (String)"JMSException in commit: ", (Object)((Object)jMSException));
                            exception = jMSException.getLinkedException();
                            while (exception != null) {
                                Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                                if (exception instanceof JMSException) {
                                    exception = ((JMSException)((Object)exception)).getLinkedException();
                                    continue;
                                }
                                exception = null;
                            }
                        }
                    }
                }
            }
            this.xid = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback");
            }
        }

        public void start(Xid xid, int n) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"start", (Object)new Object[]{xid, new Integer(n)});
            }
            if (this.xid != null) {
                XAException xAException = new XAException(-6);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Already associated with transaction", (Object)xAException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"start");
                }
                throw xAException;
            }
            this.xid = xid;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start");
            }
        }

        public void end(Xid xid, int n) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"end", (Object)new Object[]{xid, new Integer(n)});
            }
            if (!xid.equals(this.xid)) {
                XAException xAException = new XAException(-6);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Not associated with this transaction", (Object)xAException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"end");
                }
                throw xAException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"end");
            }
        }

        public void forget(Xid xid) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"forget", (Object)xid);
            }
            if (!xid.equals(this.xid)) {
                XAException xAException = new XAException(-6);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Not associated with this transaction", (Object)xAException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"forget");
                }
                throw xAException;
            }
            this.xid = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forget");
            }
        }

        public Xid[] recover(int n) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"recover", (Object)new Integer(n));
            }
            Xid[] xidArray = new Xid[]{};
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)xidArray);
            }
            return xidArray;
        }

        public boolean isSameRM(XAResource xAResource) throws XAException {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isSameRM", (Object)xAResource);
            }
            boolean bl2 = bl = xAResource == this;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isSameRM", (Object)new Boolean(bl));
            }
            return bl;
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean setTransactionTimeout(int n) throws XAException {
            return false;
        }
    }

    class Synchronization
    implements javax.transaction.Synchronization {
        Synchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Integer(n));
                }
                JMSWrapSession.this.enlistedTwoPhase = false;
                JMSWrapSession.this.transaction = null;
                JMSWrapSession.this.registeredTwoPhase = false;
                if (JMSWrapSession.this.closed) {
                    try {
                        JMSWrapSession.this._close();
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.afterCompletion", "1735", this);
                        if (!tc.isEventEnabled()) break block8;
                        Tr.event((TraceComponent)tc, (String)"JMSException in afterCompletion: ", (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        while (exception != null) {
                            Tr.event((TraceComponent)tc, (String)"Linked exception", (Object)exception);
                            if (exception instanceof JMSException) {
                                exception = ((JMSException)((Object)exception)).getLinkedException();
                                continue;
                            }
                            exception = null;
                        }
                    }
                }
            }
            if (!JMSWrapSession.this.xaCapable) {
                JMSWrapSession.this.parentConnection.decrementSessionCount();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"afterCompletion");
            }
        }
    }
}

