/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq.pcf;

import com.ibm.ejs.jms.mq.pcf.InvalidArgumentException;
import com.ibm.ejs.jms.mq.pcf.QueueData;
import com.ibm.ejs.jms.mq.pcf.QueueNameSetException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class PCFQueueData
implements QueueData {
    public static final int QUEUE_NAME_LENGTH = 48;
    public static final int QUEUE_DESCRIPTION_LENGTH = 64;
    public static final int CLUSTER_NAME_LENGTH = 48;
    public static final int CLUSTER_NAMELIST_LENGTH = 48;
    private String queueName;
    private String description = "";
    private int inhibitPut = 0;
    private int defaultPriority = 0;
    private int defaultPersistence = 0;
    private String clusterName = "";
    private String clusterNameList = null;
    private int defaultBind = 0;
    private int inhibitGet = 0;
    private int maxQueueDepth = 5000;
    private int maxMessageLength = 0x400000;
    private int shareability = 1;
    private int defaultInputOpenOption = 2;
    private int mesageDeliverySequence = 0;
    private int backoutThreshold = 0;
    private String backoutRequeueName = "";
    private int hardenGetBackout = 1;
    private Set modified = new TreeSet();
    private boolean newQueue = true;
    private Locale locale = Locale.getDefault();

    public PCFQueueData() {
    }

    public PCFQueueData(String string) throws InvalidArgumentException {
        try {
            this.setQueueName(string);
        }
        catch (QueueNameSetException queueNameSetException) {
            FFDCFilter.processException((Throwable)queueNameSetException, "com.ibm.ejs.jms.mq.pcf.PCFQueueData.PCFQueueData", "111", this);
        }
    }

    PCFQueueData(String string, boolean bl) throws InvalidArgumentException {
        try {
            this.setQueueName(string);
            this.newQueue = bl;
        }
        catch (QueueNameSetException queueNameSetException) {
            FFDCFilter.processException((Throwable)queueNameSetException, "com.ibm.ejs.jms.mq.pcf.PCFQueueData.PCFQueueData", "137", this);
        }
    }

    public PCFQueueData(Locale locale) {
        this.locale = locale;
    }

    public PCFQueueData(String string, Locale locale) throws InvalidArgumentException {
        try {
            this.locale = locale;
            this.setQueueName(string);
        }
        catch (QueueNameSetException queueNameSetException) {
            FFDCFilter.processException((Throwable)queueNameSetException, "com.ibm.ejs.jms.mq.pcf.PCFQueueData.PCFQueueData", "111", this);
        }
    }

    PCFQueueData(String string, boolean bl, Locale locale) throws InvalidArgumentException {
        try {
            this.locale = locale;
            this.setQueueName(string);
            this.newQueue = bl;
        }
        catch (QueueNameSetException queueNameSetException) {
            FFDCFilter.processException((Throwable)queueNameSetException, "com.ibm.ejs.jms.mq.pcf.PCFQueueData.PCFQueueData", "137", this);
        }
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String string) throws QueueNameSetException, InvalidArgumentException {
        if (string == null) {
            throw new InvalidArgumentException("PCFQueueDataValueNull", this.locale);
        }
        if (this.queueName == null) {
            if (string.length() == 0) {
                throw new InvalidArgumentException("PCFQueueDataValueTooShort", this.locale);
            }
            if (string.length() > 48) {
                throw new InvalidArgumentException("PCFQueueDataValueTooLong", this.locale);
            }
        } else {
            throw new QueueNameSetException("PCFQueueDataQueueNameSet", this.locale);
        }
        this.queueName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws InvalidArgumentException {
        if (string == null) {
            throw new InvalidArgumentException("PCFQueueDataValueNull", this.locale);
        }
        if (string.length() > 64) {
            throw new InvalidArgumentException("PCFQueueDataValueTooLong", this.locale);
        }
        if (this.description.equals(string)) {
            return;
        }
        this.description = string;
        this.modified.add("description");
    }

    public int getInhibitPut() {
        return this.inhibitPut;
    }

    public void setInhibitPut(int n) throws InvalidArgumentException {
        if (n != 0 && n != 1) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (this.inhibitPut == n) {
            return;
        }
        this.inhibitPut = n;
        this.modified.add("inhibitPut");
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(int n) throws InvalidArgumentException {
        if (n < 0 || n > 9) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (this.defaultPriority == n) {
            return;
        }
        this.defaultPriority = n;
        this.modified.add("defaultPriority");
    }

    public int getDefaultPersistence() {
        return this.defaultPersistence;
    }

    public void setDefaultPersistence(int n) throws InvalidArgumentException {
        if (n != 0 && n != 1) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (this.defaultPersistence == n) {
            return;
        }
        this.defaultPersistence = n;
        this.modified.add("defaultPersistence");
    }

    public String getClusterName() {
        return this.clusterName == null ? "" : this.clusterName;
    }

    public void setClusterName(String string) throws InvalidArgumentException {
        if (string == null) {
            throw new InvalidArgumentException("PCFQueueDataValueNull", this.locale);
        }
        if (string.length() == 0 && this.clusterNameList != null) {
            return;
        }
        if (string.length() > 48) {
            throw new InvalidArgumentException("PCFQueueDataValueTooLong", this.locale);
        }
        if (string.equals(this.clusterName)) {
            return;
        }
        this.clusterName = string;
        this.clusterNameList = null;
        this.modified.add("clusterName");
        if (this.modified.contains("clusterNameList")) {
            this.modified.remove("clusterNameList");
        }
    }

    public String getClusterNameList() {
        return this.clusterNameList == null ? "" : this.clusterNameList;
    }

    public void setClusterNameList(String string) throws InvalidArgumentException {
        if (string == null) {
            throw new InvalidArgumentException("PCFQueueDataValueNull", this.locale);
        }
        if (string.length() == 0 && this.clusterName != null) {
            return;
        }
        if (string.length() > 48) {
            throw new InvalidArgumentException("PCFQueueDataValueTooLong", this.locale);
        }
        if (string.equals(this.clusterNameList)) {
            return;
        }
        this.clusterNameList = string;
        this.clusterName = null;
        this.modified.add("clusterNameList");
        if (this.modified.contains("clusterName")) {
            this.modified.remove("clusterName");
        }
    }

    public int getDefaultBind() {
        return this.defaultBind;
    }

    public void setDefaultBind(int n) throws InvalidArgumentException {
        if (n != 1 && n != 0) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (n == this.defaultBind) {
            return;
        }
        this.defaultBind = n;
        this.modified.add("defaultBind");
    }

    public int getInhibitGet() {
        return this.inhibitGet;
    }

    public void setInhibitGet(int n) throws InvalidArgumentException {
        if (n != 0 && n != 1) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (this.inhibitGet == n) {
            return;
        }
        this.inhibitGet = n;
        this.modified.add("inhibitGet");
    }

    public int getMaxQueueDepth() {
        return this.maxQueueDepth;
    }

    public void setMaxQueueDepth(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("PCFQueueDataValueLessThanZero", this.locale);
        }
        if (this.maxQueueDepth == n) {
            return;
        }
        this.maxQueueDepth = n;
        this.modified.add("maxQueueDepth");
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("PCFQueueDataValueLessThanZero", this.locale);
        }
        if (this.maxMessageLength == n) {
            return;
        }
        this.maxMessageLength = n;
        this.modified.add("maxMessageLength");
    }

    public int getShareability() {
        return this.shareability;
    }

    public void setShareability(int n) throws InvalidArgumentException {
        if (n != 0 && n != 1) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (this.shareability == n) {
            return;
        }
        this.shareability = n;
        this.modified.add("shareability");
    }

    public int getDefaultInputOpenOption() {
        return this.defaultInputOpenOption;
    }

    public void setDefaultInputOpenOption(int n) throws InvalidArgumentException {
        if (n != 4 && n != 2) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (this.defaultInputOpenOption == n) {
            return;
        }
        this.defaultInputOpenOption = n;
        this.modified.add("defaultInputOpenOptions");
    }

    public int getMessageDeliverySequence() {
        return this.mesageDeliverySequence;
    }

    public void setMessageDeliverySequence(int n) throws InvalidArgumentException {
        if (n != 1 && n != 0) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (this.mesageDeliverySequence == n) {
            return;
        }
        this.mesageDeliverySequence = n;
        this.modified.add("messageDeliverySequence");
    }

    public int getBackoutThreshold() {
        return this.backoutThreshold;
    }

    public void setBackoutThreshold(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("PCFQueueDataValueLessThanZero", this.locale);
        }
        if (this.backoutThreshold == n) {
            return;
        }
        this.backoutThreshold = n;
        this.modified.add("backoutThreshold");
    }

    public String getBackoutReQueueName() {
        return this.backoutRequeueName;
    }

    public void setBackoutReQueueName(String string) throws InvalidArgumentException {
        if (string == null) {
            throw new InvalidArgumentException("PCFQueueDataValueNull", this.locale);
        }
        if (string.length() > 48) {
            throw new InvalidArgumentException("PCFQueueDataValueTooLong", this.locale);
        }
        if (this.backoutRequeueName.equals(string)) {
            return;
        }
        this.backoutRequeueName = string;
        this.modified.add("backoutReQueueName");
    }

    public int getHardenGetBackout() {
        return this.hardenGetBackout;
    }

    public void setHardenGetBackout(int n) throws InvalidArgumentException {
        if (n != 1 && n != 0) {
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        if (this.hardenGetBackout == n) {
            return;
        }
        this.hardenGetBackout = n;
        this.modified.add("hardenGetBackout");
    }

    public boolean isNew() {
        return this.newQueue;
    }

    public boolean isModified() {
        return this.modified.size() != 0;
    }

    void reset() {
        this.modified.clear();
    }

    boolean modifiedField(String string) {
        return this.modified.contains(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Queue Name = ");
        stringBuffer.append(this.queueName);
        stringBuffer.append(string);
        stringBuffer.append("Queue description = ");
        stringBuffer.append(this.description);
        stringBuffer.append(string);
        stringBuffer.append("Inhibit Put = ");
        stringBuffer.append(this.inhibitPut == 0 ? "Allowed" : "Inhibited");
        stringBuffer.append(string);
        stringBuffer.append("Default Persistence = ");
        stringBuffer.append(this.defaultPersistence == 1 ? "Persistent" : "Not Persistent");
        stringBuffer.append(string);
        stringBuffer.append("Cluster Name = ");
        stringBuffer.append(this.clusterName);
        stringBuffer.append(string);
        stringBuffer.append("Cluster Name List = ");
        stringBuffer.append(this.clusterNameList);
        stringBuffer.append(string);
        stringBuffer.append("Default Bind = ");
        stringBuffer.append(this.defaultBind == 0 ? "On Open" : "Not Fixed");
        stringBuffer.append(string);
        stringBuffer.append("Inhibit Get = ");
        stringBuffer.append(this.inhibitGet == 0 ? "Allowed" : "Inhibited");
        stringBuffer.append(string);
        stringBuffer.append("Max Queue Depth = ");
        stringBuffer.append(this.maxQueueDepth);
        stringBuffer.append(string);
        stringBuffer.append("Max Message Length = ");
        stringBuffer.append(this.maxMessageLength);
        stringBuffer.append(string);
        stringBuffer.append("Shareability = ");
        stringBuffer.append(this.shareability == 1 ? "Shareable" : "Not Shareable");
        stringBuffer.append(string);
        stringBuffer.append("Default Input Open Options = ");
        stringBuffer.append(this.defaultInputOpenOption == 2 ? "Shared" : "Exclusive");
        stringBuffer.append(string);
        stringBuffer.append("Message Delivery Sequence = ");
        stringBuffer.append(this.mesageDeliverySequence == 0 ? "Priority" : "FIFO");
        stringBuffer.append(string);
        stringBuffer.append("Backout Threshold = ");
        stringBuffer.append(this.backoutThreshold);
        stringBuffer.append(string);
        stringBuffer.append("Backout Requeue Queue name = ");
        stringBuffer.append(this.backoutRequeueName);
        stringBuffer.append(string);
        stringBuffer.append("Harden Get Backout = ");
        stringBuffer.append(this.hardenGetBackout == 1 ? "Hardened" : "Not Hardened");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

