/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.HelpSystem;

public class HelpPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.help";
    public static boolean DEBUG = false;
    public static boolean DEBUG_CONSOLELOG = false;
    public static boolean DEBUG_CONTEXT = false;
    public static boolean DEBUG_PROTOCOLS = false;
    public static boolean DEBUG_SEARCH = false;
    protected static HelpPlugin plugin;

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpPlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        if (DEBUG) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            HelpPlugin.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public HelpPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static HelpPlugin getDefault() {
        return plugin;
    }

    public void shutdown() throws CoreException {
        HelpSystem.shutdown();
    }

    public void startup() throws CoreException {
        DEBUG = this.isDebugging();
        if (DEBUG) {
            DEBUG_CONSOLELOG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help/debug/consolelog"));
            DEBUG_CONTEXT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help/debug/context"));
            DEBUG_PROTOCOLS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help/debug/protocols"));
            DEBUG_SEARCH = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help/debug/search"));
        }
        HelpSystem.startup();
    }

    protected void initializeDefaultPluginPreferences() {
        boolean isWindows;
        Preferences prefs = this.getPluginPreferences();
        String os = System.getProperty("os.name").toLowerCase();
        boolean bl = isWindows = os.indexOf("windows") != -1;
        if (isWindows) {
            prefs.setDefault("custom_browser_path", "\"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\" %1");
        } else {
            prefs.setDefault("custom_browser_path", "mozilla %1");
        }
    }
}

