/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.util.HashMap;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IHelp;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.DefaultHelpSupport;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.appserver.WebappManager;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.internal.context.ContextManager;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.help.internal.util.IErrorUtil;
import org.eclipse.help.internal.util.Resources;
import org.eclipse.help.internal.workingset.WorkingSetManager;

public final class HelpSystem {
    protected static final HelpSystem instance = new HelpSystem();
    private static final String WEBAPP_EXTENSION_ID = "org.eclipse.help.webapp";
    private static final String WEBAPP_DEFAULT_ATTRIBUTE = "default";
    private static final String HELP_SUPPORT_EXTENSION_ID = "org.eclipse.help.support";
    private static final String HELP_SUPPORT_CLASS_ATTRIBUTE = "class";
    public static final String BANNER_KEY = "banner";
    public static final String BANNER_HEIGHT_KEY = "banner_height";
    public static final String LINKS_VIEW_KEY = "linksView";
    public static final String BASE_TOCS_KEY = "baseTOCS";
    public static final String BOOKMARKS = "bookmarks";
    public static final String WORKING_SETS = "workingSets";
    public static final String WORKING_SET = "workingSet";
    public static final int MODE_WORKBENCH = 0;
    public static final int MODE_INFOCENTER = 1;
    public static final int MODE_STANDALONE = 2;
    protected TocManager tocManager;
    protected ContextManager contextManager;
    protected SearchManager searchManager;
    protected HashMap workingSetManagers;
    private int mode = 0;
    private boolean webappStarted = false;
    private IErrorUtil defaultErrorMessenger;
    private IBrowser browser;
    private IHelp helpSupport = null;
    private boolean webappRunning = false;
    static /* synthetic */ Class class$0;

    private HelpSystem() {
    }

    public static ContextManager getContextManager() {
        if (HelpSystem.getInstance().contextManager == null) {
            HelpSystem.getInstance().contextManager = new ContextManager();
        }
        return HelpSystem.getInstance().contextManager;
    }

    public static HelpSystem getInstance() {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TocManager getTocManager() {
        if (HelpSystem.getInstance().tocManager != null) return HelpSystem.getInstance().tocManager;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.internal.HelpSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (HelpSystem.getInstance().tocManager != null) return HelpSystem.getInstance().tocManager;
            HelpSystem.getInstance().tocManager = new TocManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return HelpSystem.getInstance().tocManager;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchManager getSearchManager() {
        if (HelpSystem.getInstance().searchManager != null) return HelpSystem.getInstance().searchManager;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.internal.HelpSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (HelpSystem.getInstance().searchManager != null) return HelpSystem.getInstance().searchManager;
            HelpSystem.getInstance().searchManager = new SearchManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return HelpSystem.getInstance().searchManager;
        }
    }

    public static WorkingSetManager getWorkingSetManager() {
        return HelpSystem.getWorkingSetManager(BootLoader.getNL());
    }

    public static synchronized WorkingSetManager getWorkingSetManager(String locale) {
        WorkingSetManager wsmgr;
        if (HelpSystem.getInstance().workingSetManagers == null) {
            HelpSystem.getInstance().workingSetManagers = new HashMap();
        }
        if ((wsmgr = (WorkingSetManager)HelpSystem.getInstance().workingSetManagers.get(locale)) == null) {
            wsmgr = new WorkingSetManager(locale);
            HelpSystem.getInstance().workingSetManagers.put(locale, wsmgr);
        }
        return wsmgr;
    }

    public static synchronized IBrowser getHelpBrowser() {
        if (HelpSystem.getInstance().browser == null) {
            HelpSystem.getInstance().browser = BrowserManager.getInstance().createBrowser();
        }
        return HelpSystem.getInstance().browser;
    }

    public static synchronized IHelp getHelpSupport() {
        if (HelpSystem.getInstance().helpSupport == null) {
            HelpSystem.getInstance().helpSupport = HelpSystem.getInstance().initHelpSupport();
        }
        return HelpSystem.getInstance().helpSupport;
    }

    public HelpSystem newInstance() {
        return null;
    }

    public static void shutdown() throws CoreException {
        if (HelpPlugin.DEBUG) {
            System.out.println("Help System is shutting down.");
        }
        if (HelpSystem.getInstance().searchManager != null) {
            HelpSystem.getInstance().searchManager.close();
        }
        WebappManager.stop((String)"help");
        if (HelpSystem.getMode() != 0) {
            WebappManager.stop((String)"helpControl");
        }
        BrowserManager.getInstance().closeAll();
        if (HelpPlugin.DEBUG) {
            System.out.println("Help System is shut down.");
        }
    }

    public static void startup() {
        try {
            HelpSystem.setDefaultErrorUtil(new IErrorUtil(){

                public void displayError(String msg) {
                    System.out.println(msg);
                }

                public void displayError(String msg, Thread uiThread) {
                    System.out.println(msg);
                }
            });
            HelpPlugin.getDefault().getPluginPreferences();
        }
        catch (Exception e) {
            HelpPlugin.getDefault().getLog().log((IStatus)new Status(4, HelpPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, Resources.getString("E005"), (Throwable)e));
        }
        if (HelpPlugin.DEBUG) {
            System.out.println("Help System started.");
        }
    }

    public static boolean ensureWebappRunning() {
        if (!HelpSystem.getInstance().webappStarted) {
            HelpSystem.getInstance().webappStarted = true;
            String webappPlugin = HelpSystem.getWebappPlugin();
            if (HelpSystem.getMode() != 0) {
                try {
                    WebappManager.start((String)"helpControl", (String)webappPlugin, (IPath)Path.EMPTY);
                }
                catch (CoreException e) {
                    HelpPlugin.logError(Resources.getString("E043"), e);
                    return false;
                }
            }
            try {
                WebappManager.start((String)"help", (String)webappPlugin, (IPath)Path.EMPTY);
            }
            catch (CoreException e) {
                HelpPlugin.logError("E042", e);
                return false;
            }
            HelpSystem.getInstance().webappRunning = true;
        }
        return HelpSystem.getInstance().webappRunning;
    }

    public static int getMode() {
        return HelpSystem.getInstance().mode;
    }

    public static void setMode(int mode) {
        HelpSystem.getInstance().mode = mode;
    }

    public static void setDefaultErrorUtil(IErrorUtil em) {
        HelpSystem.getInstance().defaultErrorMessenger = em;
    }

    public static IErrorUtil getDefaultErrorUtil() {
        return HelpSystem.getInstance().defaultErrorMessenger;
    }

    private static String getWebappPlugin() {
        IExtension[] extensions;
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(WEBAPP_EXTENSION_ID);
        if (point != null && (extensions = point.getExtensions()).length != 0) {
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String defaultValue = elements[i].getAttribute(WEBAPP_DEFAULT_ATTRIBUTE);
                if (defaultValue == null || defaultValue.equals("false")) {
                    return elements[i].getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                }
                ++i;
            }
            if (elements.length > 0) {
                return elements[0].getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
            }
        }
        return WEBAPP_EXTENSION_ID;
    }

    private IHelp initHelpSupport() {
        IConfigurationElement[] elements;
        IExtension[] extensions;
        IPluginRegistry pluginRegistry;
        IExtensionPoint point;
        if (this.helpSupport == null && (point = (pluginRegistry = Platform.getPluginRegistry()).getExtensionPoint(HELP_SUPPORT_EXTENSION_ID)) != null && (extensions = point.getExtensions()).length != 0 && (elements = extensions[0].getConfigurationElements()).length != 0) {
            try {
                this.helpSupport = (IHelp)elements[0].createExecutableExtension(HELP_SUPPORT_CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                HelpPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        if (this.helpSupport == null) {
            this.helpSupport = new DefaultHelpSupport();
        }
        return this.helpSupport;
    }
}

