/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserManager;

public class DefaultBrowser
implements IBrowser {
    private IBrowser browserAdapter;
    private String browserAdapterId;
    private IBrowser newBrowserAdapter = null;
    private String newBrowserAdapterId = null;
    private boolean locationSet = false;
    private boolean sizeSet = false;
    private int x;
    private int y;
    private int width;
    private int height;

    public DefaultBrowser(IBrowser browserImpl, String browserAdapterId) {
        this.browserAdapter = browserImpl;
        this.browserAdapterId = browserAdapterId;
    }

    public void close() {
        this.browserAdapter.close();
    }

    public boolean isCloseSupported() {
        return this.browserAdapter.isCloseSupported();
    }

    public void displayURL(String url) throws Exception {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapter != null) {
            this.browserAdapter.close();
            this.browserAdapter = this.newBrowserAdapter;
            this.newBrowserAdapter = null;
            this.browserAdapterId = this.newBrowserAdapterId;
            this.newBrowserAdapterId = null;
            if (this.locationSet) {
                this.browserAdapter.setLocation(this.x, this.y);
            }
            if (this.sizeSet) {
                this.browserAdapter.setSize(this.width, this.height);
            }
        }
        this.browserAdapter.displayURL(url);
    }

    public boolean isSetLocationSupported() {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapterId == null) {
            return this.browserAdapter.isSetLocationSupported();
        }
        return this.browserAdapter.isSetLocationSupported() || this.newBrowserAdapter.isSetLocationSupported();
    }

    public boolean isSetSizeSupported() {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapterId == null) {
            return this.browserAdapter.isSetSizeSupported();
        }
        return this.browserAdapter.isSetSizeSupported() || this.newBrowserAdapter.isSetSizeSupported();
    }

    public void setLocation(int x, int y) {
        this.checkDefaultAdapter();
        this.browserAdapter.setLocation(x, y);
        this.locationSet = true;
        this.x = x;
        this.y = y;
    }

    public void setSize(int width, int height) {
        this.checkDefaultAdapter();
        this.browserAdapter.setSize(width, height);
        this.sizeSet = true;
        this.width = width;
        this.height = height;
    }

    private void checkDefaultAdapter() {
        if (this.browserAdapterId != BrowserManager.getInstance().getDefaultBrowserID()) {
            this.newBrowserAdapter = BrowserManager.getInstance().createBrowser();
            this.newBrowserAdapterId = BrowserManager.getInstance().getDefaultBrowserID();
        }
    }
}

