/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IContext;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.context.ContextsBuilder;
import org.eclipse.help.internal.context.ContextsFile;

public class ContextManager {
    public static final String CONTEXTS_EXTENSION = "org.eclipse.help.contexts";
    Map pluginsContexts = new HashMap();
    Map contextsFiles = new HashMap();

    public ContextManager() {
        this.createContextsFiles();
    }

    public IContext getContext(String contextId) {
        if (HelpPlugin.DEBUG_CONTEXT) {
            System.out.println("ContextManager.getContext(" + contextId + ")");
        }
        if (contextId == null) {
            return null;
        }
        String plugin = contextId;
        String id = contextId;
        int dot = contextId.lastIndexOf(46);
        if (dot <= 0 || dot >= contextId.length() - 1) {
            return null;
        }
        plugin = contextId.substring(0, dot);
        id = contextId.substring(dot + 1);
        Map contexts = (Map)this.pluginsContexts.get(plugin);
        if (contexts == null) {
            contexts = this.loadPluginContexts(plugin);
        }
        return (IContext)contexts.get(id);
    }

    private synchronized Map loadPluginContexts(String plugin) {
        Map contexts = (Map)this.pluginsContexts.get(plugin);
        if (contexts == null) {
            ArrayList pluginContextsFiles = (ArrayList)this.contextsFiles.get(plugin);
            if (pluginContextsFiles == null) {
                pluginContextsFiles = new ArrayList();
            }
            ContextsBuilder builder = new ContextsBuilder();
            builder.build(pluginContextsFiles);
            contexts = builder.getBuiltContexts();
            this.pluginsContexts.put(plugin, contexts);
        }
        return contexts;
    }

    private void createContextsFiles() {
        IExtensionPoint xpt = Platform.getPluginRegistry().getExtensionPoint(CONTEXTS_EXTENSION);
        if (xpt == null) {
            return;
        }
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            String definingPlugin = extensions[i].getDeclaringPluginDescriptor().getUniqueIdentifier();
            IConfigurationElement[] contextContributions = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < contextContributions.length) {
                if ("contexts".equals(contextContributions[j].getName())) {
                    ArrayList<ContextsFile> pluginContextsFiles;
                    String fileName;
                    String plugin = contextContributions[j].getAttribute("plugin");
                    if (plugin == null || "".equals(plugin)) {
                        plugin = definingPlugin;
                    }
                    if ((fileName = contextContributions[j].getAttribute("file")) == null) {
                        fileName = contextContributions[j].getAttribute("name");
                    }
                    if ((pluginContextsFiles = (ArrayList<ContextsFile>)this.contextsFiles.get(plugin)) == null) {
                        pluginContextsFiles = new ArrayList<ContextsFile>();
                        this.contextsFiles.put(plugin, pluginContextsFiles);
                    }
                    pluginContextsFiles.add(new ContextsFile(definingPlugin, fileName, plugin));
                }
                ++j;
            }
            ++i;
        }
    }

    public void addContext(String contextId, IContext context) {
        HashMap<String, IContext> contexts;
        if (contextId == null) {
            return;
        }
        if (this.getContext(contextId) != null) {
            return;
        }
        String plugin = contextId;
        String id = contextId;
        int dot = contextId.lastIndexOf(46);
        if (dot != -1) {
            plugin = contextId.substring(0, dot);
            id = contextId.substring(dot + 1);
        }
        if ((contexts = (HashMap<String, IContext>)this.pluginsContexts.get(plugin)) == null) {
            contexts = new HashMap<String, IContext>();
            this.pluginsContexts.put(plugin, contexts);
        }
        contexts.put(id, context);
    }
}

