/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.context.Contexts;
import org.eclipse.help.internal.context.ContextsBuilder;
import org.eclipse.help.internal.context.ContextsFile;
import org.eclipse.help.internal.context.ContextsNode;
import org.eclipse.help.internal.context.RelatedTopic;
import org.eclipse.help.internal.util.FastStack;
import org.eclipse.help.internal.util.Resources;
import org.eclipse.help.internal.util.RuntimeHelpStatus;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ContextsFileParser
extends DefaultHandler {
    protected FastStack stack = new FastStack();
    StringBuffer buffer = new StringBuffer();
    boolean seenDescription = false;
    ContextsFile contextsFile;
    private ContextsBuilder builder;

    public ContextsFileParser(ContextsBuilder builder) {
        this.builder = builder;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.seenDescription) {
            this.buffer.append(ch, start, length);
        }
        if (HelpPlugin.DEBUG_CONTEXT) {
            System.out.println("ContextsFileParser.characters(): got char from parser= " + new StringBuffer().append(ch, start, length).toString());
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("description")) {
            this.seenDescription = false;
            ((Context)this.stack.peek()).setText(this.buffer.toString());
            this.buffer.setLength(0);
        } else if (qName.equals("b")) {
            this.stack.pop();
            if (!this.stack.peek().equals("<@#$b>")) {
                this.buffer.append("</@#$b>");
            }
        } else {
            ContextsNode node = (ContextsNode)this.stack.pop();
            node.build(this.builder);
        }
    }

    public void error(SAXParseException ex) {
        String message = this.getMessage("E001", ex);
        HelpPlugin.logError(message, null);
        RuntimeHelpStatus.getInstance().addParseError(message, ex.getSystemId());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        String message = this.getMessage("E002", ex);
        HelpPlugin.logError(message, ex);
        RuntimeHelpStatus.getInstance().addParseError(message, ex.getSystemId());
    }

    public String getMessage(String messageID, SAXParseException ex) {
        String param0 = ex.getSystemId();
        Integer param1 = new Integer(ex.getLineNumber());
        Integer param2 = new Integer(ex.getColumnNumber());
        String param3 = ex.getMessage();
        String message = MessageFormat.format(Resources.getString(messageID), param0, param1, param2, param3);
        return message;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("description")) {
            this.seenDescription = true;
        } else if (qName.equals("b")) {
            if (!this.stack.peek().equals("<@#$b>")) {
                this.buffer.append("<@#$b>");
            }
            this.stack.push("<@#$b>");
        } else {
            ContextsNode e = null;
            if (qName.equals("contexts")) {
                e = new Contexts(atts);
            } else if (qName.equals("context")) {
                e = new Context(atts);
            } else if (qName.equals("topic")) {
                e = new RelatedTopic(atts);
            } else {
                return;
            }
            if (!this.stack.empty()) {
                ((ContextsNode)this.stack.peek()).addChild(e);
            }
            this.stack.push(e);
        }
    }

    public void warning(SAXParseException ex) {
        String message = this.getMessage("E003", ex);
        HelpPlugin.logWarning(message);
    }

    public void parse(ContextsFile contextsFile) {
        this.contextsFile = contextsFile;
        InputStream is = contextsFile.getInputStream();
        if (is == null) {
            return;
        }
        InputSource inputSource = new InputSource(is);
        String file = "/" + contextsFile.getDefiningPluginID() + "/" + contextsFile.getHref();
        inputSource.setSystemId(file);
        try {
            SAXParser parser = new SAXParser();
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parser.setErrorHandler((ErrorHandler)this);
            parser.setContentHandler((ContentHandler)this);
            parser.parse(inputSource);
            is.close();
        }
        catch (SAXException se) {
            HelpPlugin.logError("", se);
        }
        catch (IOException ioe) {
            String msg = Resources.getString("E009", file);
            HelpPlugin.logError(msg, ioe);
            RuntimeHelpStatus.getInstance().addParseError(msg, file);
        }
    }
}

