/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.protocols;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.help.internal.util.URLCoder;

public class HelpURL {
    private static final String lang = "lang";
    protected String url;
    protected StringBuffer query;
    protected HashMap arguments = null;
    protected long contentSize;
    protected String locale;

    public HelpURL(String url) {
        this(url, "");
    }

    public HelpURL(String url, String query) {
        this.url = url;
        this.query = new StringBuffer(query);
        this.parseQuery(query);
    }

    public void addQuery(String newQuery) {
        if (newQuery != null && !"".equals(newQuery)) {
            this.query.append('&').append(newQuery);
            this.parseQuery(newQuery);
        }
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public String getContentType() {
        String file = this.url.toLowerCase(Locale.US);
        if (file.endsWith(".html") || file.endsWith(".htm")) {
            return "text/html";
        }
        if (file.endsWith(".css")) {
            return "text/css";
        }
        if (file.endsWith(".gif")) {
            return "image/gif";
        }
        if (file.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (file.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (file.endsWith(".xml")) {
            return "application/xml";
        }
        if (file.endsWith(".xsl")) {
            return "application/xsl";
        }
        return "text/plain";
    }

    public Vector getMultiValue(String name) {
        if (this.arguments != null) {
            Object value = this.arguments.get(name);
            if (value instanceof Vector) {
                return (Vector)value;
            }
            return null;
        }
        return null;
    }

    public String getValue(String name) {
        if (this.arguments == null) {
            return null;
        }
        Object value = this.arguments.get(name);
        String stringValue = null;
        if (value instanceof String) {
            stringValue = (String)value;
        } else if (value instanceof Vector) {
            stringValue = (String)((Vector)value).firstElement();
        } else {
            return null;
        }
        try {
            return URLCoder.decode(stringValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        this.locale = this.getValue(lang);
        if (this.locale == null) {
            this.locale = BootLoader.getNL();
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault().toString();
        }
        return this.locale;
    }

    public boolean isCacheable() {
        return false;
    }

    public InputStream openStream() {
        return null;
    }

    protected void parseQuery(String theQuery) {
        if (theQuery != null && !"".equals(theQuery)) {
            if (this.arguments == null) {
                this.arguments = new HashMap(5);
            }
            StringTokenizer stok = new StringTokenizer(theQuery, "&");
            while (stok.hasMoreTokens()) {
                String aQuery = stok.nextToken();
                int equalsPosition = aQuery.indexOf("=");
                if (equalsPosition <= -1) continue;
                String arg = aQuery.substring(0, equalsPosition);
                String val = aQuery.substring(equalsPosition + 1);
                Object existing = this.arguments.get(arg);
                if (existing == null) {
                    this.arguments.put(arg, val);
                    continue;
                }
                if (existing instanceof Vector) {
                    ((Vector)existing).add(val);
                    this.arguments.put(arg, existing);
                    continue;
                }
                Vector<Object> v = new Vector<Object>(2);
                v.add(existing);
                v.add(val);
                this.arguments.put(arg, v);
            }
        }
    }

    public String toString() {
        return this.url;
    }
}

