/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.protocols.HelpURL;
import org.eclipse.help.internal.protocols.HelpURLFactory;

public class HelpURLConnection
extends URLConnection {
    private HelpURL helpURL = null;

    public HelpURLConnection(URL url) {
        super(url);
        this.helpURL = HelpURLFactory.createHelpURL(url.getFile());
        this.setDefaultUseCaches(this.helpURL.isCacheable());
        if (HelpPlugin.DEBUG_PROTOCOLS) {
            System.out.println("HelpURLConnection: url=" + url);
        }
    }

    public void connect() throws IOException {
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.helpURL.openStream();
        if (is == null) {
            throw new IOException("Resource not found.");
        }
        return is;
    }

    public String getContentType() {
        return this.helpURL.getContentType();
    }

    public long getExpiration() {
        Date now = new Date();
        return now.getTime() + 10000L;
    }
}

